/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.internals.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.channel.framework.impl.InboundVirtualConnectionImpl;
import com.ibm.ws.channel.framework.internals.DiscriminationAlgorithm;
import com.ibm.ws.channel.framework.internals.DiscriminationGroup;
import com.ibm.ws.channel.framework.internals.InboundVirtualConnection;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.framework.exception.DiscriminationProcessException;
import java.util.List;

public class MultiDiscriminatorAlgorithm
implements DiscriminationAlgorithm {
    private static final TraceComponent tc = Tr.register(MultiDiscriminatorAlgorithm.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    private DiscriminationGroup discriminationGroup = null;
    private List discriminators = null;
    private int numDiscriminators = 0;

    MultiDiscriminatorAlgorithm(DiscriminationGroup discriminationGroup, String string) {
        this.discriminationGroup = discriminationGroup;
        this.discriminators = this.discriminationGroup.getDiscriminators();
        this.numDiscriminators = this.discriminators.size();
    }

    public int discriminate(InboundVirtualConnection inboundVirtualConnection, Object object, ConnectionLink connectionLink) throws DiscriminationProcessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discriminate");
        }
        int n = 2;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = inboundVirtualConnection.getDiscriminatorStatus();
        boolean bl2 = false;
        if (nArray == null || (bl2 = 0 != this.discriminationGroup.compareTo(inboundVirtualConnection.getDiscriminationGroup()))) {
            if (bl2) {
                ((InboundVirtualConnectionImpl)inboundVirtualConnection).cleanUpAllDiscriminatorState();
            }
            nArray = new int[this.numDiscriminators];
            bl = true;
        }
        Discriminator discriminator = null;
        block5: for (int i = 0; i < this.numDiscriminators && n == 2; ++i) {
            if (!bl && nArray[i] == 0) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Skipping a discriminator that has a \"NO\" status");
                continue;
            }
            discriminator = (Discriminator)this.discriminators.get(i);
            if (n2 == 0 && i == this.numDiscriminators - 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discrimination has all no's and one last guy");
                }
                n = 1;
                break;
            }
            switch (discriminator.discriminate(inboundVirtualConnection, object)) {
                case 1: {
                    n = 1;
                    nArray[i] = 1;
                    if (!tc.isDebugEnabled()) continue block5;
                    Tr.debug(tc, "discriminator " + discriminator + " reports success");
                    continue block5;
                }
                case 0: {
                    nArray[i] = 0;
                    if (!tc.isDebugEnabled()) continue block5;
                    Tr.debug(tc, "discriminator " + discriminator + " reports no");
                    continue block5;
                }
                case -1: {
                    ++n2;
                    n3 = i;
                    nArray[i] = -1;
                    if (!tc.isDebugEnabled()) continue block5;
                    Tr.debug(tc, "discriminator " + discriminator + " reports maybe");
                    continue block5;
                }
                default: {
                    if (!tc.isDebugEnabled()) continue block5;
                    Tr.debug(tc, "Discriminator " + discriminator + " returned an incorrect status code");
                }
            }
        }
        if (n == 2 && n2 == 1) {
            discriminator = (Discriminator)this.discriminators.get(n3);
            n = 1;
            --n2;
            nArray[n3] = 1;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Discriminator enhancement: single maybe case");
            }
        }
        if (n == 1) {
            if (discriminator == null) {
                DiscriminationProcessException discriminationProcessException = new DiscriminationProcessException("Should not happen!");
                FFDCFilter.processException((Throwable)discriminationProcessException, "com.ibm.ws.channel.framework.internals.impl.MultiDiscriminatorAlgorithm.discriminate", "150", this);
                Tr.debug(tc, "Found null discriminator");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "discriminate");
                }
                throw discriminationProcessException;
            }
            Channel channel = discriminator.getChannel();
            ConnectionLink connectionLink2 = channel.getConnectionLink(inboundVirtualConnection);
            connectionLink.setApplicationCallback(connectionLink2);
            connectionLink2.setDeviceLink(connectionLink);
            if (n2 >= 1) {
                ((InboundVirtualConnectionImpl)inboundVirtualConnection).cleanUpMaybeDiscriminatorState();
            }
            inboundVirtualConnection.setDiscriminatorStatus(null);
            nArray = null;
        } else if (n == 2) {
            inboundVirtualConnection.setDiscriminatorStatus(nArray);
            inboundVirtualConnection.setDiscriminationGroup(this.discriminationGroup);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discriminate");
        }
        return n;
    }
}

