/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.validation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.wsspi.channel.ChannelFactoryTypeValidator;
import com.ibm.wsspi.channel.ChannelTypeValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ChannelTypeValidatorManager {
    private static TraceComponent tc = Tr.register(ChannelTypeValidatorManager.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private static final Class[] SIGNATURE = new Class[]{MOFValidator.class};
    protected MOFValidator _parent;
    protected Map _validatorMap = new HashMap();
    protected final Object[] _arguments;
    protected ChannelTypeManager _typeManager;

    public ChannelTypeValidatorManager(MOFValidator mOFValidator, ChannelTypeManager channelTypeManager) {
        this._parent = mOFValidator;
        this._arguments = new Object[]{mOFValidator};
        this._typeManager = channelTypeManager;
    }

    public ChannelTypeValidator getChannelTypeValidator(Object object) {
        ChannelTypeManager.ChannelMetaData channelMetaData;
        if (object == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getting validator for " + object.getClass().getName());
        }
        if ((channelMetaData = this._typeManager.getChannelType(object)) == null) {
            this._parent.addError("unknown.channel.type", new String[]{object.getClass().getName()}, object);
            return null;
        }
        if (channelMetaData.getValidatorClass() == null) {
            this._parent.addError("validator.unspecified", new String[]{object.getClass().getName()}, object);
            return null;
        }
        try {
            return (ChannelTypeValidator)this.getValidator(channelMetaData.getClass(channelMetaData.getValidatorClass()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._parent.addError("validator.missing", new String[]{channelMetaData.getValidatorClass(), object.getClass().getName()}, object);
            return null;
        }
        catch (ClassCastException classCastException) {
            this._parent.addError("not.a.channel.validator", new String[]{channelMetaData.getValidatorClass(), object.getClass().getName(), ChannelTypeValidator.class.getName()}, object);
            return null;
        }
        catch (Exception exception) {
            this._parent.addError("validator.create.failed", new String[]{channelMetaData.getValidatorClass(), object.getClass().getName()}, object);
            return null;
        }
    }

    public ChannelFactoryTypeValidator getChannelFactoryTypeValidator(Object object) {
        ChannelTypeManager.ChannelFactoryMetaData channelFactoryMetaData;
        if (object == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getting validator for " + object.getClass().getName());
        }
        if ((channelFactoryMetaData = this._typeManager.getChannelFactoryType(object)) == null) {
            this._parent.addError("unknown.factory.type", new String[]{object.getClass().getName()}, object);
            return null;
        }
        if (channelFactoryMetaData.getValidatorClass() == null) {
            this._parent.addError("validator.unspecified", new String[]{object.getClass().getName()}, object);
            return null;
        }
        try {
            return (ChannelFactoryTypeValidator)this.getValidator(channelFactoryMetaData.getClass(channelFactoryMetaData.getValidatorClass()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._parent.addError("validator.missing", new String[]{channelFactoryMetaData.getValidatorClass(), object.getClass().getName()}, object);
            return null;
        }
        catch (ClassCastException classCastException) {
            this._parent.addError("not.a.channel.validator", new String[]{channelFactoryMetaData.getValidatorClass(), object.getClass().getName(), ChannelFactoryTypeValidator.class.getName()}, object);
            return null;
        }
        catch (Exception exception) {
            this._parent.addError("validator.create.failed", new String[]{channelFactoryMetaData.getValidatorClass(), object.getClass().getName()}, object);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MOFValidator getValidator(Class clazz) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Map map = this._validatorMap;
        synchronized (map) {
            MOFValidator mOFValidator = (MOFValidator)this._validatorMap.get(clazz);
            if (mOFValidator == null) {
                Constructor constructor = clazz.getConstructor(SIGNATURE);
                mOFValidator = (MOFValidator)constructor.newInstance(this._arguments);
                this._validatorMap.put(clazz, mOFValidator);
            }
            return mOFValidator;
        }
    }
}

