/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class Compressor {
    private static final TraceComponent tc = Tr.register(Compressor.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final Deflater deflater;
    private static final Inflater inflater;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] byArray, int n) {
        byte[] byArray2;
        int n2 = byArray.length;
        int n3 = n2 - n;
        byte[] byArray3 = new byte[n3];
        Deflater deflater = Compressor.deflater;
        synchronized (deflater) {
            try {
                Compressor.deflater.setInput(byArray, n, n3);
                Compressor.deflater.finish();
                int n4 = Compressor.deflater.deflate(byArray3, 0, n3);
                byArray2 = new byte[n4 + n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                System.arraycopy(byArray3, 0, byArray2, n, n4);
            }
            finally {
                Compressor.deflater.reset();
            }
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] byArray, int n) {
        int n2 = 1024;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        Inflater inflater = Compressor.inflater;
        synchronized (inflater) {
            try {
                Compressor.inflater.setInput(byArray, n, byArray.length - n);
                byte[] byArray3 = new byte[n2];
                int n3 = Compressor.inflater.inflate(byArray3, 0, n2);
                while (n3 != 0) {
                    byte[] byArray4 = new byte[byArray2.length + n3];
                    System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                    System.arraycopy(byArray3, 0, byArray4, byArray2.length, n3);
                    byArray2 = byArray4;
                    n3 = Compressor.inflater.inflate(byArray3, 0, n2);
                }
            }
            catch (DataFormatException dataFormatException) {
                FFDCFilter.processException((Throwable)dataFormatException, Compressor.class.getName() + ".decompress", "126", (Object)byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Problem reading cluster context.", new Object[]{dataFormatException});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decompress returning passed context.", byArray);
                }
                byArray2 = byArray;
            }
            finally {
                Compressor.inflater.reset();
            }
        }
        return byArray2;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.7 ");
        }
        deflater = new Deflater(-1, true);
        inflater = new Inflater(true);
    }
}

