/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.SelectionCriteriaImpl;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.selection.ClusterIdentityResolver;
import com.ibm.wsspi.cluster.selection.ClusterIdentityResolverCoordinator;
import com.ibm.wsspi.cluster.selection.NoApplicableTargetException;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.rule.AttributeRule;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import com.ibm.wsspi.cluster.selection.rule.EndPointRule;
import com.ibm.wsspi.cluster.selection.rule.LocalCellRule;
import com.ibm.wsspi.cluster.selection.rule.LocalHostRule;
import com.ibm.wsspi.cluster.selection.rule.LocalProcessRule;
import com.ibm.wsspi.cluster.selection.rule.LocalServerRule;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class SelectionServiceImpl
implements SelectionService,
ClusterIdentityResolverCoordinator {
    private static final TraceComponent tc = Tr.register(SelectionServiceImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final TraceComponent tc1 = Tr.register(SoftKey.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private static final Map criteriaCache;
    private ClusterIdentityResolver[] resolvers = new ClusterIdentityResolver[0];
    private ReferenceQueue refqueue = new ReferenceQueue();

    public SelectionServiceImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CTOR");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CTOR");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[').append(Arrays.toString(this.resolvers)).append(' ').append(criteriaCache).append(']');
        return stringBuffer.toString();
    }

    public Target select(Identity identity) throws NoAvailableTargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", identity);
        }
        SelectionCriteria selectionCriteria = this.getCriteria(identity, EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select");
        }
        return this.select(selectionCriteria);
    }

    public Target select(SelectionCriteria selectionCriteria) throws NoAvailableTargetException, NoApplicableTargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select");
        }
        Target target = ((SelectionCriteriaImpl)selectionCriteria).select();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select");
        }
        return target;
    }

    public SelectionCriteria getCriteria(Identity identity, boolean bl, boolean bl2, Map map, Set set) {
        if (tc.isEventEnabled()) {
            Tr.entry(tc, "getCriteria", new Object[]{identity, bl, bl2, map, set});
        }
        ArrayList<DefaultRule> arrayList = new ArrayList<DefaultRule>();
        if (bl) {
            arrayList.add(new LocalProcessRule());
        }
        if (bl2) {
            arrayList.add(new LocalHostRule());
        }
        if (set != null) {
            arrayList.add(new AttributeRule(set));
        }
        if (map != null) {
            arrayList.add(new EndPointRule(map));
        }
        HashMap<String, SelectionRule[]> hashMap = new HashMap<String, SelectionRule[]>();
        SelectionRule[] selectionRuleArray = new SelectionRule[arrayList.size()];
        arrayList.toArray(selectionRuleArray);
        hashMap.put("rules.restriction", selectionRuleArray);
        SelectionCriteria selectionCriteria = this.getCriteria(identity, hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCriteria", selectionCriteria);
        }
        return selectionCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionCriteria getCriteria(Identity identity, Map map) {
        SelectionCriteriaImpl selectionCriteriaImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCriteria", identity);
        }
        this.purge();
        if (map.containsKey("affinity.key")) {
            selectionCriteriaImpl = new SelectionCriteriaImpl(identity, map);
        } else {
            Map<SoftKey, SoftReference<SelectionCriteriaImpl>> map2;
            Object object = criteriaCache;
            synchronized (object) {
                map2 = (Map<SoftKey, SoftReference<SelectionCriteriaImpl>>)criteriaCache.get(identity);
                if (map2 == null) {
                    map2 = Collections.synchronizedMap(new HashMap());
                    criteriaCache.put(identity, map2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "criteriaCache size is: " + criteriaCache.size());
                    }
                }
            }
            object = new SoftKey(identity, map, this.refqueue);
            Map<SoftKey, SoftReference<SelectionCriteriaImpl>> map3 = map2;
            synchronized (map3) {
                SoftReference softReference = (SoftReference)map2.get(object);
                SelectionCriteria selectionCriteria = selectionCriteriaImpl = softReference == null ? null : (SelectionCriteria)softReference.get();
                if (selectionCriteriaImpl == null) {
                    TreeMap treeMap = new TreeMap(map);
                    selectionCriteriaImpl = new SelectionCriteriaImpl(identity, treeMap);
                    map2.put(new SoftKey(identity, treeMap, this.refqueue), new SoftReference<SelectionCriteriaImpl>(selectionCriteriaImpl));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCriteria", selectionCriteriaImpl);
        }
        return selectionCriteriaImpl;
    }

    public SelectionRule getRule(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The rule name must not be null.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getRule", string);
        }
        DefaultRule defaultRule = null;
        if (string.equals("rule.default")) {
            defaultRule = new DefaultRule();
        } else if (string.equals("rule.local.cell")) {
            defaultRule = new LocalCellRule();
        } else if (string.equals("rule.local.host")) {
            defaultRule = new LocalHostRule();
        } else if (string.equals("rule.local.server")) {
            defaultRule = new LocalServerRule();
        } else if (string.equals("rule.local.process")) {
            defaultRule = new LocalProcessRule();
        } else {
            throw new IllegalArgumentException("There is no known rule " + string + ".  Specialized rules should be retrieved from the specialized component.");
        }
        return defaultRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResolver(ClusterIdentityResolver clusterIdentityResolver) {
        ClusterIdentityResolver[] clusterIdentityResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            boolean bl = false;
            ClusterIdentityResolver[] clusterIdentityResolverArray2 = new ClusterIdentityResolver[this.resolvers.length + 1];
            for (int i = 0; i < clusterIdentityResolverArray2.length; ++i) {
                if (bl) {
                    clusterIdentityResolverArray2[i] = this.resolvers[i - 1];
                    continue;
                }
                if (this.resolvers.length == i || this.resolvers[i].compareTo(clusterIdentityResolver) < 0) {
                    clusterIdentityResolverArray2[i] = clusterIdentityResolver;
                    bl = true;
                    continue;
                }
                clusterIdentityResolverArray2[i] = this.resolvers[i];
            }
            this.resolvers = clusterIdentityResolverArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResolver(ClusterIdentityResolver clusterIdentityResolver) {
        ClusterIdentityResolver[] clusterIdentityResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            int n = 0;
            ClusterIdentityResolver[] clusterIdentityResolverArray2 = new ClusterIdentityResolver[this.resolvers.length];
            for (int i = 0; i < this.resolvers.length; ++i) {
                if (this.resolvers[i].equals(clusterIdentityResolver)) {
                    ++n;
                    continue;
                }
                clusterIdentityResolverArray2[i - n] = this.resolvers[i];
            }
            this.resolvers = new ClusterIdentityResolver[this.resolvers.length - n];
            System.arraycopy(clusterIdentityResolverArray2, 0, this.resolvers, 0, this.resolvers.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ClusterIdentityResolver[] getOrderedSequence() {
        return this.resolvers;
    }

    private void purge() {
        SoftKey softKey;
        while ((softKey = (SoftKey)this.refqueue.poll()) != null) {
            Identity identity = softKey.getClusterIdentity();
            Map map = (Map)criteriaCache.get(identity);
            if (map == null) continue;
            map.remove(softKey);
            if (!map.isEmpty()) continue;
            criteriaCache.remove(identity);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.31.1.1 ");
        }
        criteriaCache = Collections.synchronizedMap(new WeakHashMap());
    }

    private final class SoftKey
    extends SoftReference {
        private final WeakReference clusterIdentity;
        private final int hash;

        public SoftKey(Identity identity, Map map, ReferenceQueue referenceQueue) {
            super(map, referenceQueue);
            if (tc1.isEntryEnabled()) {
                Tr.entry(tc1, "SoftKey<init>", map);
            }
            this.hash = this.setHashCode(map);
            this.clusterIdentity = new WeakReference<Identity>(identity);
            if (tc1.isEntryEnabled()) {
                Tr.exit(tc1, "SoftKey<init>", String.valueOf(this.hash));
            }
        }

        private int setHashCode(Map map) {
            int n = 0;
            if (map == null) {
                return n;
            }
            Set set = map.entrySet();
            if (set.isEmpty()) {
                return n;
            }
            Iterator iterator = set.iterator();
            Object object = null;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                n += k == null ? 0 : k.hashCode();
                object = entry.getValue();
                if (object instanceof Object[]) {
                    n += Arrays.deepHashCode((Object[])object);
                    continue;
                }
                n += object == null ? 0 : object.hashCode();
            }
            return n;
        }

        private Identity getClusterIdentity() {
            return (Identity)this.clusterIdentity.get();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            Object t = this.get();
            if (t == null) {
                return false;
            }
            if (object.hashCode() != this.hash) {
                return false;
            }
            if (object instanceof SoftKey) {
                SoftKey softKey = (SoftKey)object;
                Object t2 = softKey.get();
                if (t2 == null) {
                    return false;
                }
                if (t instanceof Map) {
                    return this.referentsEqual((Map)t, (Map)t2);
                }
                return t.equals(t2);
            }
            return false;
        }

        boolean referentsEqual(Map map, Map map2) {
            if (map.size() != map.size()) {
                return false;
            }
            boolean bl = true;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = map.get(k);
                Object v2 = map2.get(k);
                if (!(v instanceof Object[] && v2 instanceof Object[] ? !(bl = Arrays.equals((Object[])v, (Object[])v2)) : !(bl = v.equals(v2)))) continue;
                return bl;
            }
            return bl;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

