/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.distribution.ServerClusterContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServerClusterContextImpl
implements ServerClusterContext {
    private static final TraceComponent tc = Tr.register(ServerClusterContextImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final int serverContextVersion = 3;
    protected Set activeClusterSet = Collections.synchronizedSet(new HashSet());
    protected Object acsMutex = this.activeClusterSet;

    public byte[] checkClientContext(byte[] byArray) {
        byte[] byArray2;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkClientContext", byArray);
            }
            byArray2 = null;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                int n = wsObjectInputStream.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "clientVersion " + n);
                }
                HashMap hashMap = new HashMap();
                this.receiveServerContextCluster(wsObjectInputStream, hashMap);
                if (!hashMap.isEmpty()) {
                    objectOutputStream.writeInt(3);
                    DescriptionManagerFactory.getInstance();
                    DescriptionManagerFactory.getDescriptionManager().stream(hashMap, objectOutputStream);
                    objectOutputStream.flush();
                    byArray2 = Compressor.compress(byteArrayOutputStream.toByteArray(), 4);
                    objectOutputStream.close();
                }
                byteArrayOutputStream.close();
                wsObjectInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, ServerClusterContextImpl.class.getName() + ".checkClientContext", "106", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "unexpected exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClientContext", byArray2);
        }
        return byArray2;
    }

    private void receiveServerContextCluster(ObjectInput objectInput, Map map) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveServerContextCluster");
        }
        if (objectInput.readBoolean()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Read cluster available to process true");
            }
            DescriptionKey descriptionKey = KeyRepositoryFactory.getInstance().getKeyRepository().importFromStream(objectInput);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read cluster Key " + descriptionKey);
            }
            long l = objectInput.readLong();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read structural epoch " + l);
            }
            long l2 = objectInput.readLong();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read influential epoch " + l2);
            }
            DescriptionManagerFactory.getInstance();
            ClusterDescription clusterDescription = (ClusterDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(descriptionKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster available to process ", new Object[]{new Long(l), new Long(l2), descriptionKey, clusterDescription});
            }
            if (clusterDescription != null) {
                if (l == -2L) {
                    FormatImpl formatImpl = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), 4);
                    this.addAllClusterKeys(map, clusterDescription, formatImpl);
                } else {
                    ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
                    int n = 0;
                    if (l < memento.getStructuralEpoch()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "structural epoch has changed");
                        }
                        n = 1;
                    } else if (l2 < memento.getInfluentialEpoch()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "influential epoch has changed");
                        }
                        n = 2;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "client is up to date");
                    }
                    if (n != 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "client needs updated cluster information");
                        }
                        FormatImpl formatImpl = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), n);
                        this.addClusterKey(map, clusterDescription, formatImpl);
                    }
                }
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to find cluster " + (descriptionKey == null ? "" : descriptionKey.toString()));
            }
            this.receiveServerContextCluster(objectInput, map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveServerContextCluster");
        }
    }

    protected void addAllClusterKeys(Map map, ClusterDescription clusterDescription, Format format) {
        this.addClusterKey(map, clusterDescription, format);
    }

    protected void addClusterKey(Map map, ClusterDescription clusterDescription, Format format) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addClusterKey");
        }
        Set<DescriptionKey> set = null;
        if (map.containsKey(format)) {
            set = (Set)map.get(format);
            if (!set.contains(clusterDescription.getKey())) {
                set.add(clusterDescription.getKey());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "added key ", clusterDescription.getKey());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set already contains cluster key");
            }
        } else {
            set = new HashSet();
            set.add(clusterDescription.getKey());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "added key ", clusterDescription.getKey());
            }
            map.put(format, set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addClusterKey");
        }
    }

    public boolean validateClusterResidency(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateClusterResidency", identity);
        }
        boolean bl = this.activeClusterSet.contains(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateClusterResidency", String.valueOf(bl));
        }
        return bl;
    }

    public boolean validateClusterProcessResidency(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateClusterProcessResidency", identity);
        }
        boolean bl = this.activeClusterSet.contains(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateClusterProcessResidency", String.valueOf(bl));
        }
        return bl;
    }

    protected void updateActiveClusterSet(Set set, Object object) {
        this.acsMutex = object;
        this.activeClusterSet = set;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.12 ");
        }
    }
}

