/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.BNFHeadersImpl;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import java.nio.BufferUnderflowException;

public class HeaderElement
implements Comparable {
    private static final TraceComponent tc = Tr.register(HeaderElement.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private static final int initHash = 629;
    private static final int ELEM_INIT = 0;
    private static final int ELEM_CHANGED = 1;
    private static final int ELEM_REMOVED = 2;
    private static final int ELEM_ADDED = 3;
    HeaderElement nextInstance = null;
    HeaderElement nextSequence = null;
    HeaderElement prevSequence = null;
    private HeaderKeys keyName = null;
    private String stringName = null;
    private int buffIndex = -1;
    private int offset = 0;
    private int valueLength = 0;
    private byte[] bValue = null;
    private String sValue = null;
    private BNFHeadersImpl myOwner;
    private int myHashCode = -1;
    private int status = 3;
    private int lastCRLFBufferIndex = -1;
    private int lastCRLFPosition = -1;
    private boolean lastCRLFisCR = false;

    HeaderElement(HeaderKeys headerKeys, BNFHeadersImpl bNFHeadersImpl) {
        this.keyName = headerKeys;
        this.myOwner = bNFHeadersImpl;
    }

    HeaderElement(String string, BNFHeadersImpl bNFHeadersImpl) {
        this.stringName = string;
        this.myOwner = bNFHeadersImpl;
    }

    public HeaderKeys getHeaderKey() {
        return this.keyName;
    }

    public String getHeaderString() {
        return this.stringName;
    }

    public void setParseInformation(int n, int n2) {
        this.buffIndex = n;
        this.offset = n2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Set parse information " + this.buffIndex + " " + this.offset);
        }
    }

    public void setValueLength(int n) {
        this.valueLength = n;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public int getOffset() {
        return this.offset;
    }

    private boolean extractInitialValue() {
        if (-1 == this.buffIndex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Extract: -1 index");
            }
            return false;
        }
        this.bValue = new byte[this.valueLength];
        WsByteBuffer wsByteBuffer = this.myOwner.getParseBuffer(this.buffIndex);
        int n = wsByteBuffer.position();
        try {
            wsByteBuffer.position(this.offset);
            wsByteBuffer.get(this.bValue, 0, this.valueLength);
            wsByteBuffer.position(n);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header value straddled buffers");
            }
            int n2 = this.valueLength;
            int n3 = 0;
            wsByteBuffer.position(this.offset);
            int n4 = wsByteBuffer.remaining();
            int n5 = this.buffIndex + 1;
            while (null != wsByteBuffer) {
                if (n2 <= n4) {
                    wsByteBuffer.get(this.bValue, n3, n2);
                    wsByteBuffer.position(n);
                    break;
                }
                wsByteBuffer.get(this.bValue, n3, n4);
                wsByteBuffer.position(n);
                n2 -= n4;
                n3 += n4;
                wsByteBuffer = this.myOwner.getParseBuffer(n5);
                ++n5;
                n = wsByteBuffer.position();
                wsByteBuffer.position(0);
                n4 = wsByteBuffer.limit();
            }
        }
        this.offset = 0;
        this.buffIndex = -1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.sValue = GenericUtils.getEnglishString(this.bValue);
            Tr.debug(tc, "extractInitialValue parsed [" + this.getDebugValue() + "]");
        }
        return true;
    }

    public byte[] getByteArrayValue() {
        if (null == this.bValue) {
            if (null != this.sValue) {
                this.bValue = GenericUtils.getEnglishBytes(this.sValue);
            } else if (!this.extractInitialValue() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "byte[] value requested from empty structure");
            }
        } else if (this.valueLength != this.bValue.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracting value from larger input array");
            }
            byte[] byArray = new byte[this.valueLength];
            System.arraycopy(this.bValue, this.offset, byArray, 0, byArray.length);
            this.bValue = byArray;
            this.offset = 0;
            this.valueLength = byArray.length;
        }
        return this.bValue;
    }

    public byte[] getRawByteArrayValue() {
        if (null == this.bValue) {
            if (null != this.sValue) {
                this.bValue = GenericUtils.getEnglishBytes(this.sValue);
            } else if (!this.extractInitialValue() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "no byte[] value present");
            }
        }
        return this.bValue;
    }

    public String getStringValue() {
        if (null == this.sValue) {
            if (null == this.bValue && !this.extractInitialValue()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "String value requested from empty structure");
                }
                return null;
            }
            this.sValue = GenericUtils.getEnglishString(this.bValue, this.offset, this.offset + this.valueLength);
        }
        return this.sValue;
    }

    public String getDebugValue() {
        if (null == this.keyName || this.keyName.shouldLogValue()) {
            return this.getStringValue();
        }
        return GenericUtils.blockContents(this.getStringValue());
    }

    public void setByteArrayValue(byte[] byArray) {
        this.sValue = null;
        this.bValue = byArray;
        this.offset = 0;
        this.valueLength = byArray.length;
        if (3 != this.status) {
            this.status = 1;
        }
    }

    public void setByteArrayValue(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid length: " + n + "+" + n2 + " > " + byArray.length);
        }
        this.sValue = null;
        this.bValue = byArray;
        this.offset = n;
        this.valueLength = n2;
        if (3 != this.status) {
            this.status = 1;
        }
    }

    public void setStringValue(String string) {
        this.bValue = null;
        this.sValue = string;
        this.offset = 0;
        int n = this.valueLength = null == string ? 0 : string.length();
        if (3 != this.status) {
            this.status = 1;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HeaderElement)) {
            return false;
        }
        return this.isSameName((HeaderElement)object);
    }

    public boolean isSameName(HeaderElement headerElement) {
        if (null != this.keyName && null != headerElement.keyName) {
            return this.keyName.getOrdinal() == headerElement.keyName.getOrdinal();
        }
        if (null != this.stringName && null != headerElement.stringName) {
            return this.stringName.equalsIgnoreCase(headerElement.stringName);
        }
        return false;
    }

    public boolean isSameValue(HeaderElement headerElement) {
        return this.getStringValue().equals(headerElement.getStringValue());
    }

    public boolean isSameValueIgnoreCase(HeaderElement headerElement) {
        return this.getStringValue().equalsIgnoreCase(headerElement.getStringValue());
    }

    public int hashCode() {
        if (-1 == this.myHashCode) {
            int n = 629;
            n = null == this.stringName ? (n += this.keyName.hashCode()) : (n += this.stringName.toLowerCase().hashCode());
            this.myHashCode = n;
        }
        return this.myHashCode;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        return this.hashCode() - object.hashCode();
    }

    public boolean wasRemoved() {
        return 2 == this.status;
    }

    public boolean wasChanged() {
        return 1 == this.status;
    }

    public boolean wasAdded() {
        return 3 == this.status;
    }

    public void remove() {
        if (2 != this.status) {
            this.status = 2;
            this.myOwner.decrementHeaderCounter();
        }
    }

    public void startTracking() {
        this.status = 0;
    }

    protected void updateLastCRLFInfo(int n, int n2, boolean bl) {
        this.lastCRLFBufferIndex = n;
        this.lastCRLFPosition = n2;
        this.lastCRLFisCR = bl;
    }

    protected int getLastCRLFPosition() {
        return this.lastCRLFPosition;
    }

    protected int getLastCRLFBufferIndex() {
        return this.lastCRLFBufferIndex;
    }

    protected boolean isLastCRLFaCR() {
        return this.lastCRLFisCR;
    }

    public String getName() {
        return null != this.keyName ? this.keyName.getName() : this.stringName;
    }

    public void destroy() {
        this.nextSequence = null;
        this.prevSequence = null;
        this.bValue = null;
        this.sValue = null;
        this.buffIndex = -1;
        this.offset = 0;
        this.valueLength = 0;
        this.myHashCode = -1;
        this.lastCRLFBufferIndex = -1;
        this.lastCRLFisCR = false;
        this.lastCRLFPosition = -1;
        this.status = 3;
        this.myOwner.freeElement(this);
    }

    public void init(HeaderKeys headerKeys) {
        this.keyName = headerKeys;
        this.stringName = null;
    }

    public void init(String string) {
        this.keyName = null;
        this.stringName = string;
    }

    public String toString() {
        return "HeaderElement name=" + this.getName() + " status=" + this.status;
    }
}

