/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ws.genericbnf.impl.BinaryHeaderNode;
import com.ibm.ws.genericbnf.impl.GenericConstants;
import com.ibm.ws.genericbnf.impl.QuickCaseInsensitiveMatcher;
import com.ibm.wsspi.genericbnf.HeaderKeys;

public class QuickHeaderMatcher
extends QuickCaseInsensitiveMatcher {
    private static final boolean MAKE_LOWER = true;
    private BinaryHeaderNode dollarNode = new BinaryHeaderNode('$', true);
    private BinaryHeaderNode underscoreNode = new BinaryHeaderNode('_', true);

    public QuickHeaderMatcher() {
        super(true);
    }

    public void init() {
        super.init();
        this.dollarNode.init();
        this.underscoreNode.init();
    }

    protected BinaryHeaderNode getNode(int n, boolean bl) {
        BinaryHeaderNode binaryHeaderNode = super.getNode(n, bl);
        if (null == binaryHeaderNode) {
            if (36 == n) {
                binaryHeaderNode = this.dollarNode;
            } else if (95 == n) {
                binaryHeaderNode = this.underscoreNode;
            }
        }
        return binaryHeaderNode;
    }

    public HeaderKeys matchHeader(String string) {
        HeaderKeys headerKeys = (HeaderKeys)this.match(string);
        if (null == headerKeys) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if ('\r' != c && '\n' != c) continue;
                throw new IllegalArgumentException("Invalid CRLF in name: " + i);
            }
            return GenericConstants.NO_MATCH;
        }
        return headerKeys;
    }

    public HeaderKeys matchHeader(StringBuffer stringBuffer) {
        HeaderKeys headerKeys = (HeaderKeys)this.match(stringBuffer);
        if (null == headerKeys) {
            int n = stringBuffer.length();
            for (int i = 0; i < n; ++i) {
                char c = stringBuffer.charAt(i);
                if ('\r' != c && '\n' != c) continue;
                throw new IllegalArgumentException("Invalid CRLF in name: " + i);
            }
            return GenericConstants.NO_MATCH;
        }
        return headerKeys;
    }

    public HeaderKeys matchHeader(byte[] byArray) {
        HeaderKeys headerKeys = (HeaderKeys)this.match(byArray);
        if (null == headerKeys) {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[i];
                if (13 != by && 10 != by) continue;
                throw new IllegalArgumentException("Invalid CRLF in name: " + i);
            }
            return GenericConstants.NO_MATCH;
        }
        return headerKeys;
    }
}

