/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.cookies.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.HTTPChannelDM;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.Cookie;

public class CookieCacheData
implements Cloneable {
    private List parsedList;
    private int hdrIndex = 0;
    private HeaderKeys headerType;
    private boolean isDirty = false;

    public CookieCacheData(HeaderKeys headerKeys) {
        this.setHeaderType(headerKeys);
        this.setParsedCookieList(new LinkedList());
    }

    public final HeaderKeys getHeaderType() {
        return this.headerType;
    }

    private final void setHeaderType(HeaderKeys headerKeys) {
        if (!(headerKeys.equals(HttpConstants.HDR_COOKIE) || headerKeys.equals(HttpConstants.HDR_COOKIE2) || headerKeys.equals(HttpConstants.HDR_SET_COOKIE) || headerKeys.equals(HttpConstants.HDR_SET_COOKIE2))) {
            throw new IllegalArgumentException("Invalid key: " + headerKeys.getName());
        }
        this.headerType = headerKeys;
    }

    public final int getHeaderIndex() {
        return this.hdrIndex;
    }

    public final int incrementHeaderIndex() {
        return ++this.hdrIndex;
    }

    private final void setHeaderIndex(int n) {
        this.hdrIndex = n;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setIsDirty(boolean bl) {
        this.isDirty = bl;
    }

    public Cookie getCookie(String string) {
        if (null == string) {
            return null;
        }
        Cookie cookie = null;
        int n = this.getParsedList().size();
        for (int i = 0; i < n; ++i) {
            cookie = (Cookie)this.getParsedList().get(i);
            if (!cookie.getName().equals(string)) continue;
            return cookie;
        }
        return null;
    }

    public final List getParsedList() {
        return this.parsedList;
    }

    private final void setParsedCookieList(List list) {
        this.parsedList = list;
    }

    public void addParsedCookie(Cookie cookie) {
        this.getParsedList().add(cookie);
    }

    public void addParsedCookies(List list) {
        this.getParsedList().addAll(list);
    }

    public void addNewCookie(Cookie cookie) {
        this.setIsDirty(true);
        this.getParsedList().add(cookie);
    }

    public void addNewCookies(List list) {
        this.setIsDirty(true);
        this.getParsedList().add(list);
    }

    public boolean removeCookie(Cookie cookie) {
        this.setIsDirty(true);
        return this.getParsedList().remove(cookie);
    }

    public CookieCacheData duplicate() {
        try {
            CookieCacheData cookieCacheData = (CookieCacheData)this.clone();
            cookieCacheData.setParsedCookieList(this.copyList(this.getParsedList()));
            cookieCacheData.setIsDirty(this.isDirty());
            cookieCacheData.setHeaderIndex(this.getHeaderIndex());
            cookieCacheData.setHeaderType(this.getHeaderType());
            return cookieCacheData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FFDCFilter.processException((Throwable)cloneNotSupportedException, this.getClass().getName() + ".duplicate", "250", this);
            return null;
        }
    }

    private List copyList(List list) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((Cookie)iterator.next()).clone());
        }
        return linkedList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(HTTPChannelDM.LINE_SEPARATOR);
        stringBuffer.append("headerType=");
        stringBuffer.append(this.getHeaderType().getName());
        stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
        stringBuffer.append("headerIndex=");
        stringBuffer.append(this.getHeaderIndex());
        stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
        stringBuffer.append("isDirty =");
        stringBuffer.append(this.isDirty());
        stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
        stringBuffer.append("parsedList=");
        stringBuffer.append(this.printCookieList(this.getParsedList()));
        stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    private String printCookieList(List list) {
        if (null == list) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Cookie cookie = (Cookie)list.get(i);
            stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
            stringBuffer.append(" Name: ");
            stringBuffer.append(cookie.getName());
            stringBuffer.append(" Value: ");
            stringBuffer.append(cookie.getValue());
            stringBuffer.append(" Path: ");
            stringBuffer.append(cookie.getPath());
            stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
            stringBuffer.append(" Version: ");
            stringBuffer.append(cookie.getVersion());
            stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
            stringBuffer.append(" Domain: ");
            stringBuffer.append(cookie.getDomain());
            stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
            stringBuffer.append(" Max-Age: ");
            stringBuffer.append(cookie.getMaxAge());
            stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
            stringBuffer.append(" Comment: ");
            stringBuffer.append(cookie.getComment());
            stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }
}

