/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Map;

public class HttpFactoryConfig {
    private static final TraceComponent tc = Tr.register(HttpFactoryConfig.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private int msgSizeLimit = 0;
    private int msgSizeLargeBuffer = 0;

    public HttpFactoryConfig(Map map) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing config for factory");
        }
        if (null == map) {
            return;
        }
        this.parseMsgSize(map);
        this.parseMsgLargeBuffer(map);
    }

    private void parseMsgSize(Map map) {
        String string = (String)map.get("MessageSizeLimit");
        if (null != string) {
            this.setMessageSize(string);
        }
    }

    public int getMessageSize() {
        return this.msgSizeLimit;
    }

    public void setMessageSize(String string) {
        block4: {
            if (null != string) {
                try {
                    this.msgSizeLimit = Integer.parseInt(string);
                    if (0 > this.getMessageSize() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Config: Invalid size, setting to unlimited: " + this.getMessageSize());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".setMessageSize", "72", this);
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Config: Maximum message size of [" + string + "] is incorrect");
                }
            }
        }
    }

    public boolean areMessagesLimited() {
        return 0 != this.getMessageSize();
    }

    private void parseMsgLargeBuffer(Map map) {
        if (!this.areMessagesLimited()) {
            return;
        }
        String string = (String)map.get("LargeMessageSize");
        if (null != string) {
            this.setLargerBufferSize(string);
        }
    }

    public int getLargerBufferSize() {
        return this.msgSizeLargeBuffer;
    }

    public void setLargerBufferSize(String string) {
        block5: {
            if (null != string) {
                try {
                    this.msgSizeLargeBuffer = Integer.parseInt(string);
                    if (this.getLargerBufferSize() < this.getMessageSize()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Config: large buffer size is too small: " + this.getLargerBufferSize());
                        }
                        this.msgSizeLargeBuffer = this.getMessageSize();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, this.getClass().getName() + ".setLargerBufferSize", "98", this);
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Config: Large buffer size of [" + string + "] is incorrect");
                }
            }
        }
    }
}

