/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.HTTPChannelDM;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpTrailersImpl;
import com.ibm.ws.util.objectpool.TwoTierObjectPool;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;

public class HttpObjectFactory {
    private static final TraceComponent tc = Tr.register(HttpObjectFactory.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int SIZE_THREAD = 50;
    private static final int SIZE_MAIN = 50;
    private final TwoTierObjectPool reqPool = new TwoTierObjectPool(50, 50);
    private final TwoTierObjectPool respPool = new TwoTierObjectPool(50, 50);
    private final TwoTierObjectPool hdrPool = new TwoTierObjectPool(50, 50);

    public HttpObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "New HTTP object factory created: " + this);
        }
        HTTPChannelDM.getRef();
    }

    public HttpRequestMessageImpl getRequest(HttpInboundServiceContext httpInboundServiceContext) {
        HttpRequestMessageImpl httpRequestMessageImpl = null;
        Object object = this.reqPool.get();
        if (null == object) {
            httpRequestMessageImpl = new HttpRequestMessageImpl(httpInboundServiceContext);
        } else {
            httpRequestMessageImpl = (HttpRequestMessageImpl)object;
            httpRequestMessageImpl.init(httpInboundServiceContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRequest(isc): " + httpRequestMessageImpl);
        }
        return httpRequestMessageImpl;
    }

    public HttpRequestMessageImpl getRequest(HttpOutboundServiceContext httpOutboundServiceContext) {
        HttpRequestMessageImpl httpRequestMessageImpl = null;
        Object object = this.reqPool.get();
        if (null == object) {
            httpRequestMessageImpl = new HttpRequestMessageImpl(httpOutboundServiceContext);
        } else {
            httpRequestMessageImpl = (HttpRequestMessageImpl)object;
            httpRequestMessageImpl.init(httpOutboundServiceContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRequest(osc): " + httpRequestMessageImpl);
        }
        return httpRequestMessageImpl;
    }

    public void releaseRequest(HttpRequestMessageImpl httpRequestMessageImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseRequest: " + httpRequestMessageImpl);
        }
        this.reqPool.put(httpRequestMessageImpl);
    }

    public HttpResponseMessageImpl getResponse(HttpInboundServiceContext httpInboundServiceContext) {
        HttpResponseMessageImpl httpResponseMessageImpl = null;
        Object object = this.respPool.get();
        if (null == object) {
            httpResponseMessageImpl = new HttpResponseMessageImpl(httpInboundServiceContext);
        } else {
            httpResponseMessageImpl = (HttpResponseMessageImpl)object;
            httpResponseMessageImpl.init(httpInboundServiceContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getResponse(isc): " + httpResponseMessageImpl);
        }
        return httpResponseMessageImpl;
    }

    public HttpResponseMessageImpl getResponse(HttpOutboundServiceContext httpOutboundServiceContext) {
        HttpResponseMessageImpl httpResponseMessageImpl = null;
        Object object = this.respPool.get();
        if (null == object) {
            httpResponseMessageImpl = new HttpResponseMessageImpl(httpOutboundServiceContext);
        } else {
            httpResponseMessageImpl = (HttpResponseMessageImpl)object;
            httpResponseMessageImpl.init(httpOutboundServiceContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getResponse(osc): " + httpResponseMessageImpl);
        }
        return httpResponseMessageImpl;
    }

    public void releaseResponse(HttpResponseMessageImpl httpResponseMessageImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseResponse: " + httpResponseMessageImpl);
        }
        this.respPool.put(httpResponseMessageImpl);
    }

    public HttpTrailersImpl getTrailers() {
        Object object = this.hdrPool.get();
        HttpTrailersImpl httpTrailersImpl = null == object ? new HttpTrailersImpl() : (HttpTrailersImpl)object;
        httpTrailersImpl.setFactory(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTrailers: " + httpTrailersImpl);
        }
        return httpTrailersImpl;
    }

    public void releaseTrailers(HttpTrailersImpl httpTrailersImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseTrailers: " + httpTrailersImpl);
        }
        this.hdrPool.put(httpTrailersImpl);
    }
}

