/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.genericbnf.impl.HeaderHandler;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.HeaderStorage;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import javax.servlet.http.Cookie;

public class HttpResponseMessageImpl
extends HttpBaseMessageImpl
implements HttpResponseMessage {
    private static final TraceComponent tc = Tr.register(HttpResponseMessageImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final long serialVersionUID = 7629585068712704258L;
    private static final byte[] NOCACHE_VALUE = GenericUtils.getEnglishBytes("no-cache=\"set-cookie, set-cookie2\"");
    private static final byte[] LONG_AGO = GenericUtils.getEnglishBytes("Thu, 01 Dec 1994 16:00:00 GMT");
    private StatusCodes myStatusCode = HttpConstants.STATUS_OK;
    private byte[] myReasonBytes = null;
    private transient String myReason = null;

    public HttpResponseMessageImpl() {
        this.setOwner(null);
        this.setBinaryParseState(14);
    }

    public HttpResponseMessageImpl(HttpInboundServiceContext httpInboundServiceContext) {
        this.setOwner(httpInboundServiceContext);
        this.setBinaryParseState(14);
        this.initVersion();
    }

    public HttpResponseMessageImpl(HttpOutboundServiceContext httpOutboundServiceContext) {
        this.setOwner(httpOutboundServiceContext);
        this.setBinaryParseState(14);
    }

    public void init(HttpInboundServiceContext httpInboundServiceContext) {
        this.setOwner(httpInboundServiceContext);
        this.setBinaryParseState(14);
        this.initVersion();
    }

    public void init(HttpOutboundServiceContext httpOutboundServiceContext) {
        this.setOwner(httpOutboundServiceContext);
        this.setBinaryParseState(14);
    }

    public void init(HttpInboundServiceContext httpInboundServiceContext, BNFHeaders bNFHeaders) {
        this.setOwner(httpInboundServiceContext);
        this.setBinaryParseState(14);
        if (null != bNFHeaders) {
            bNFHeaders.duplicate(this);
        }
        this.initVersion();
    }

    public void init(HttpOutboundServiceContext httpOutboundServiceContext, BNFHeaders bNFHeaders) {
        this.setOwner(httpOutboundServiceContext);
        this.setBinaryParseState(14);
        if (null != bNFHeaders) {
            bNFHeaders.duplicate(this);
        }
    }

    private void initVersion() {
        VersionValues versionValues = this.getServiceContext().getRequestVersion();
        VersionValues versionValues2 = this.getServiceContext().getHttpConfig().getOutgoingVersion();
        if (HttpConstants.HTTP_VERSION_10.equals(versionValues2) && HttpConstants.HTTP_VERSION_11.equals(versionValues)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Configuration forcing 1.0 instead of 1.1");
            }
            this.setVersion(versionValues2);
        } else {
            this.setVersion(versionValues);
        }
    }

    public void setOwner(HttpServiceContext httpServiceContext) {
        if (null != this.getServiceContext()) {
            this.getServiceContext().setResponseOwner(false);
        }
        if (null != httpServiceContext) {
            super.init(httpServiceContext);
            this.getServiceContext().setResponseOwner(true);
            this.setIncoming(!this.getServiceContext().isInboundConnection());
            if (!this.isIncoming()) {
                this.setHeaderValidation(this.getServiceContext().getHttpConfig().isHeaderValidationEnabled());
            }
        }
    }

    public boolean isBodyExpected() {
        if (HttpConstants.HTTP_VERSION_10.equals(this.getVersionValue())) {
            return this.isBodyAllowed();
        }
        if (super.isBodyExpected() || this.containsHeader(HttpConstants.HDR_CONTENT_RANGE)) {
            if (this.getServiceContext().getRequestMethod().equals(HttpConstants.METHOD_HEAD)) {
                return false;
            }
            return this.myStatusCode.isBodyAllowed();
        }
        return false;
    }

    public boolean isBodyAllowed() {
        if (super.isBodyAllowed()) {
            if (this.getServiceContext().getRequestMethod().equals(HttpConstants.METHOD_HEAD)) {
                return false;
            }
            return this.myStatusCode.isBodyAllowed();
        }
        return false;
    }

    public boolean shouldUpdateBodyHeaders() {
        return !HttpConstants.METHOD_HEAD.equals(this.getServiceContext().getRequestMethod());
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing this response: " + this);
        }
        super.clear();
        this.myStatusCode = HttpConstants.STATUS_OK;
        this.myReason = null;
        this.myReasonBytes = null;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying this response: " + this);
        }
        HttpObjectFactory httpObjectFactory = this.getObjectFactory();
        super.destroy();
        if (null != httpObjectFactory) {
            httpObjectFactory.releaseResponse(this);
        }
    }

    protected void setParsedFirstToken(byte[] byArray) throws Exception {
        this.setVersion(byArray);
    }

    protected void setParsedSecondToken(byte[] byArray) throws Exception {
        this.setStatusCode(GenericUtils.asIntValue(byArray));
    }

    protected void setParsedThirdToken(byte[] byArray) throws Exception {
        this.setReasonPhrase(byArray);
    }

    protected byte[] getMarshalledFirstToken() {
        return this.getVersionValue().getByteArray();
    }

    protected byte[] getMarshalledSecondToken() {
        return this.myStatusCode.getByteArray();
    }

    protected byte[] getMarshalledThirdToken() {
        return this.getReasonPhraseBytes();
    }

    public boolean parseBinaryFirstLine(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        byte by;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseBinaryFirstLine for " + this);
            Tr.debug(tc, "Buffer: " + wsByteBuffer);
        }
        if (this.getBinaryParseState() == 14) {
            if (!wsByteBuffer.hasRemaining()) {
                return false;
            }
            by = wsByteBuffer.get();
            if (by != 49) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unsupported binary version in message: " + by);
                }
                throw new MalformedMessageException("Invalid binary message");
            }
            this.setBinaryParseState(5);
            this.resetCacheToken(4);
        }
        by = 0;
        block7: while (by == 0) {
            if (!this.fillCacheToken(wsByteBuffer)) {
                return false;
            }
            switch (this.getBinaryParseState()) {
                case 5: {
                    int n = GenericUtils.asInt(this.getParsedToken());
                    if (0 == (n & 0x20000)) {
                        this.setVersion(VersionValues.getByOrdinal(n));
                        this.setBinaryParseState(11);
                        this.resetCacheToken(4);
                        continue block7;
                    }
                    this.setBinaryParseState(6);
                    this.resetCacheToken(n & 0x1FFFF);
                    continue block7;
                }
                case 6: {
                    this.setVersion(VersionValues.makeUndefinedValue(this.getParsedToken()));
                    this.setBinaryParseState(11);
                    this.createCacheToken(4);
                    continue block7;
                }
                case 11: {
                    this.setStatusCode(GenericUtils.asInt(this.getParsedToken()));
                    this.setBinaryParseState(12);
                    this.resetCacheToken(4);
                    continue block7;
                }
                case 12: {
                    int n = GenericUtils.asInt(this.getParsedToken());
                    if (0 == n) {
                        this.setBinaryParseState(1);
                        this.resetCacheToken(4);
                        by = 1;
                        continue block7;
                    }
                    this.setBinaryParseState(13);
                    this.resetCacheToken(n);
                    continue block7;
                }
                case 13: {
                    this.setReasonPhrase(this.getParsedToken());
                    this.setBinaryParseState(1);
                    this.createCacheToken(4);
                    by = 1;
                    continue block7;
                }
            }
            throw new MalformedMessageException("Invalid state in line: " + this.getBinaryParseState());
        }
        this.setFirstLineComplete(true);
        return true;
    }

    public WsByteBuffer[] marshallLine() {
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        wsByteBufferArray = this.putBytes(this.getVersionValue().getVersionSpace(), wsByteBufferArray);
        if (null == this.myReasonBytes) {
            wsByteBufferArray = this.putBytes(this.myStatusCode.getStatusWithPhrase(), wsByteBufferArray);
        } else {
            wsByteBufferArray = this.putBytes(this.myStatusCode.getStatusSpace(), wsByteBufferArray);
            wsByteBufferArray = this.putBytes(this.getReasonPhraseBytes(), wsByteBufferArray);
        }
        wsByteBufferArray = this.putBytes(BNFHeaders.EOL, wsByteBufferArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Marshalling first line: " + this.getVersion() + " " + this.getStatusCodeAsInt() + " " + this.getReasonPhrase());
        }
        return wsByteBufferArray;
    }

    public WsByteBuffer[] marshallBinaryFirstLine() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallBinaryFirstLine");
        }
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        wsByteBufferArray = this.putByte((byte)49, wsByteBufferArray);
        if (this.getVersionValue().isUndefined()) {
            byte[] byArray = this.getVersionValue().getByteArray();
            wsByteBufferArray = this.putInt(byArray.length | 0x20000, wsByteBufferArray);
            wsByteBufferArray = this.putBytes(byArray, wsByteBufferArray);
        } else {
            wsByteBufferArray = this.putInt(this.getVersionValue().getOrdinal(), wsByteBufferArray);
        }
        wsByteBufferArray = this.putInt(this.myStatusCode.getIntCode(), wsByteBufferArray);
        if (null != this.myReasonBytes) {
            wsByteBufferArray = this.putInt(this.myReasonBytes.length, wsByteBufferArray);
            wsByteBufferArray = this.putBytes(this.myReasonBytes, wsByteBufferArray);
        } else {
            wsByteBufferArray = this.putInt(0, wsByteBufferArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Marshalling first line: " + this.getVersion() + " " + this.getStatusCodeAsInt() + " " + this.getReasonPhrase());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallBinaryFirstLine");
        }
        return wsByteBufferArray;
    }

    protected void parsingComplete() throws MalformedMessageException {
        int n = this.getNumberFirstLineTokens();
        if (3 != n && 2 != n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "numFirstLineTokensRead is " + this.getNumberFirstLineTokens());
            }
            if (this.getServiceContext().getHttpConfig().isErrorLoggingEnabled()) {
                this.getServiceContext().getHttpConfig().getHttpLogger().log(HttpConstants.LOG_WARN, "Invalid number of first line tokens", (HttpServiceContext)this.getServiceContext());
            }
            throw new MalformedMessageException("Received " + this.getNumberFirstLineTokens() + " first line tokens");
        }
    }

    public void headerComplianceCheck() throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "headerComplianceCheck");
        }
        super.headerComplianceCheck();
        if (!this.containsHeader(HttpConstants.HDR_DATE)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a missing Date header");
            }
            this.setCurrentDate();
        }
        if (this.getServiceContext().getHttpConfig().removeServerHeader()) {
            if (this.containsHeader(HttpConstants.HDR_SERVER)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Configuration forcing removal of Server header");
                }
                this.removeSpecialHeader(HttpConstants.HDR_SERVER);
            }
        } else if (!this.containsHeader(HttpConstants.HDR_SERVER)) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_SERVER, this.getServiceContext().getHttpConfig().getServerHeaderValue());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding default Server header value: " + this.getHeaderAsString(HttpConstants.HDR_SERVER));
            }
        }
        if (this.getServiceContext().getHttpConfig().shouldCookiesConfigureNoCache()) {
            this.updateCacheControl();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "headerComplianceCheck");
        }
    }

    private void updateCacheControl() {
        boolean bl;
        boolean bl2 = this.containsHeader(HttpConstants.HDR_SET_COOKIE) || this.isCookieCacheDirty(HttpConstants.HDR_SET_COOKIE);
        boolean bl3 = bl = this.containsHeader(HttpConstants.HDR_SET_COOKIE2) || this.isCookieCacheDirty(HttpConstants.HDR_SET_COOKIE2);
        if (!bl2 && !bl) {
            return;
        }
        if (!this.containsHeader(HttpConstants.HDR_EXPIRES)) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_EXPIRES, LONG_AGO);
        }
        if (this.containsHeader(HttpConstants.HDR_CACHE_CONTROL)) {
            HeaderHandler headerHandler = new HeaderHandler((HeaderStorage)this, ',', HttpConstants.HDR_CACHE_CONTROL);
            if (!headerHandler.contains("no-cache")) {
                boolean bl4 = false;
                if (bl2) {
                    bl4 = headerHandler.add("no-cache", "set-cookie");
                }
                if (bl) {
                    bl4 = headerHandler.add("no-cache", "set-cookie2") | bl4;
                }
                if (bl4) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Updating Cache-Control for Set-Cookie");
                    }
                    this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CACHE_CONTROL, headerHandler.marshall());
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Cache-Control due to Set-Cookie");
            }
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CACHE_CONTROL, NOCACHE_VALUE);
        }
    }

    public final int getStatusCodeAsInt() {
        return this.myStatusCode.getIntCode();
    }

    public final StatusCodes getStatusCode() {
        return this.myStatusCode;
    }

    public void setStatusCode(int n) {
        StatusCodes statusCodes = null;
        try {
            statusCodes = StatusCodes.getByOrdinal(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (null == statusCodes) {
            statusCodes = StatusCodes.makeUndefinedValue(n);
        }
        this.setStatusCode(statusCodes);
    }

    public void setStatusCode(StatusCodes statusCodes) {
        if (!statusCodes.equals(this.myStatusCode)) {
            this.myStatusCode = statusCodes;
            this.myReason = null;
            this.myReasonBytes = null;
            super.setFirstLineChanged();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setStatusCode(sc): set to " + statusCodes);
        }
    }

    public boolean isTemporaryStatusCode() {
        int n = this.myStatusCode.getIntCode();
        return 100 <= n && 200 > n;
    }

    public String getReasonPhrase() {
        if (null == this.myReason) {
            this.myReason = GenericUtils.getEnglishString(this.getReasonPhraseBytes());
        }
        return this.myReason;
    }

    public byte[] getReasonPhraseBytes() {
        if (null == this.myReasonBytes) {
            return this.myStatusCode.getDefaultPhraseBytes();
        }
        return this.myReasonBytes;
    }

    public void setReasonPhrase(String string) {
        this.myReason = string;
        this.myReasonBytes = GenericUtils.getEnglishBytes(string);
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setReasonPhrase(String): set to [" + this.myReason + "]");
        }
    }

    public void setReasonPhrase(byte[] byArray) {
        this.myReasonBytes = byArray;
        this.myReason = null;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.myReason = GenericUtils.getEnglishString(byArray);
            Tr.debug(tc, "setReasonPhrase(byte[]): set to [" + this.myReason + "]");
        }
    }

    public byte[] getCookieValue(String string) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        byte[] byArray = this.getCookieValue(string, HttpConstants.HDR_SET_COOKIE);
        if (null == byArray) {
            byArray = this.getCookieValue(string, HttpConstants.HDR_SET_COOKIE2);
        }
        return byArray;
    }

    public List getAllCookieValues(String string) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        return super.getAllCookieValues(string, HttpConstants.HDR_SET_COOKIE, HttpConstants.HDR_SET_COOKIE2);
    }

    public Cookie getCookie(String string) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        Cookie cookie = this.getCookie(string, HttpConstants.HDR_SET_COOKIE);
        if (null == cookie) {
            cookie = this.getCookie(string, HttpConstants.HDR_SET_COOKIE2);
        }
        return null == cookie ? null : (Cookie)cookie.clone();
    }

    public List getAllCookies() {
        return this.getAllCookies(HttpConstants.HDR_SET_COOKIE, HttpConstants.HDR_SET_COOKIE2);
    }

    public List getAllCookies(String string) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        return super.getAllCookies(string, HttpConstants.HDR_SET_COOKIE, HttpConstants.HDR_SET_COOKIE2);
    }

    public boolean setCookie(Cookie cookie, HeaderKeys headerKeys) {
        if (null == cookie) {
            throw new NullPointerException("Cookie");
        }
        if (1 < cookie.getVersion()) {
            throw new IllegalArgumentException("Cookie version is invalid: " + cookie.getVersion());
        }
        if (headerKeys.equals(HttpConstants.HDR_SET_COOKIE) || headerKeys.equals(HttpConstants.HDR_SET_COOKIE2)) {
            return this.addCookie(cookie, headerKeys);
        }
        return false;
    }

    public boolean setCookie(String string, String string2, HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new NullPointerException("HeaderKeys");
        }
        return this.setCookie(new Cookie(string, string2), headerKeys);
    }

    public boolean removeCookie(String string, HeaderKeys headerKeys) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        if (headerKeys.equals(HttpConstants.HDR_SET_COOKIE) || headerKeys.equals(HttpConstants.HDR_SET_COOKIE2)) {
            return this.deleteCookie(string, headerKeys);
        }
        return false;
    }

    public void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Response Message: " + this);
            Tr.debug(tc, "Status: " + this.getStatusCodeAsInt());
            Tr.debug(tc, "Reason: " + this.getReasonPhrase());
            super.debug();
        }
    }

    public HttpResponseMessage duplicate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Duplicating the response message: " + this);
        }
        HttpResponseMessageImpl httpResponseMessageImpl = null;
        HttpObjectFactory httpObjectFactory = this.getObjectFactory();
        if (null == httpObjectFactory) {
            httpResponseMessageImpl = new HttpResponseMessageImpl();
            httpResponseMessageImpl.setIncoming(this.isIncoming());
        } else {
            httpResponseMessageImpl = this.isIncoming() ? httpObjectFactory.getResponse(this.getOutboundSC()) : httpObjectFactory.getResponse(this.getInboundSC());
        }
        httpResponseMessageImpl.setStatusCode(this.myStatusCode);
        httpResponseMessageImpl.setReasonPhrase(this.myReasonBytes);
        super.duplicate(httpResponseMessageImpl);
        return httpResponseMessageImpl;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "De-serializing into: " + this);
        }
        super.readExternal(objectInput);
        this.setStatusCode(objectInput.readInt());
        int n = objectInput.readInt();
        if (-1 != n) {
            this.setReasonPhrase(GenericUtils.readValue(objectInput, n));
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Serializing: " + this);
        }
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.getStatusCodeAsInt());
        if (null != this.myReasonBytes) {
            objectOutput.writeInt(this.myReasonBytes.length);
            objectOutput.write(this.myReasonBytes);
        } else {
            objectOutput.writeInt(-1);
        }
    }
}

