/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.j2ee;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ObjectNotRunningException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class J2EEDeployedObjectProxy
extends J2EEManagedObjectCollaborator {
    private String deploymentDescriptor;
    private String fullServerName;
    private ObjectName websphereMBeanObjectName;

    public J2EEDeployedObjectProxy(String string, int n) {
        super(n);
        this.deploymentDescriptor = string;
    }

    public String getDeploymentDescriptor() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.deploymentDescriptor));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, J2EEDeployedObjectProxy.class.getName() + ".getDeploymentDescriptor", "77", this);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, J2EEDeployedObjectProxy.class.getName() + ".getDeploymentDescriptor", "81", this);
        }
        return stringBuffer.toString();
    }

    public String getServer() {
        if (this.fullServerName == null) {
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("WebSphere:*,j2eeType=J2EEServer," + this.getLocationKeyProperties());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
            if (!set.isEmpty()) {
                this.fullServerName = set.iterator().next().toString();
            }
        }
        return this.fullServerName;
    }

    public String getName() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        return (String)this.getAttributeIfRunning("name");
    }

    public String getJavaVendor() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        return (String)this.getAttributeIfRunning("javaVendor");
    }

    public String getJavaVersion() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        return (String)this.getAttributeIfRunning("javaVersion");
    }

    protected Object getAttributeIfRunning(String string) throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        if (this.getJ2EEState() != 1) {
            throw new ObjectNotRunningException();
        }
        return (String)AdminServiceFactory.getAdminService().getAttribute(this.getWebSphereMBeanObjectName(), string);
    }

    protected String getJ2EEName() {
        return this.getObjectName().getKeyProperty("name");
    }

    protected String getJ2EEType() {
        return this.getObjectName().getKeyProperty("j2eeType");
    }

    protected abstract ObjectName getWebSphereMBeanQueryName();

    protected ObjectName getWebSphereMBeanObjectName() {
        if (this.websphereMBeanObjectName == null) {
            this.websphereMBeanObjectName = this.getFirstObjectName(this.getWebSphereMBeanQueryName());
        }
        return this.websphereMBeanObjectName;
    }

    protected ObjectName getFirstObjectName(ObjectName objectName) {
        Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
        if (!set.isEmpty()) {
            return (ObjectName)set.iterator().next();
        }
        return null;
    }

    protected String getLocationKeyProperties() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cell=");
        stringBuffer.append(adminService.getCellName());
        stringBuffer.append(",node=");
        stringBuffer.append(adminService.getNodeName());
        stringBuffer.append(",process=");
        stringBuffer.append(adminService.getProcessName());
        return stringBuffer.toString();
    }

    protected String getDeploymentDescriptorPath() {
        return this.deploymentDescriptor;
    }
}

