/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.util;

import com.ibm.ejs.models.base.resources.url.URLProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import com.ibm.ws.runtime.util.utilHandlerClass;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;

public class URLHandlerFactory
implements URLStreamHandlerFactory {
    private static final TraceComponent tc = Tr.register(URLHandlerFactory.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private Map streamHandlerTable;

    public URLHandlerFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "URLHandlerFactory ctor");
        }
        this.streamHandlerTable = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "URLHandlerFactory ctor");
        }
    }

    public void registerProvider(URLProvider uRLProvider) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerProvider " + uRLProvider);
        }
        String string = uRLProvider.getProtocol();
        String string2 = uRLProvider.getStreamHandlerClassName();
        String string3 = StreamHandlerUtils.getProviderClasspath(uRLProvider.getClasspath());
        if (string != null && string2 != null) {
            this.streamHandlerTable.put(string, new utilHandlerClass(string2, string3));
        } else {
            Tr.warning(tc, "WSVR0051W", uRLProvider.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerProvider");
        }
    }

    public void registerProvider(URLProvider uRLProvider, String string) {
        String string2 = uRLProvider.getProtocol();
        String string3 = uRLProvider.getStreamHandlerClassName();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerProvider " + string2 + " : " + string3);
        }
        if (string2 != null && string3 != null) {
            this.streamHandlerTable.put(string2, new utilHandlerClass(string3, string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerProvider(provider,class)");
        }
    }

    public void registerProvider(String string, String string2) {
        String string3 = StreamHandlerUtils.getClassName(string2);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerProvider " + string + " : " + string3);
        }
        if (string != null && string3 != null) {
            this.streamHandlerTable.put(string, new utilHandlerClass(string3, string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerProvider(provider,class)");
        }
    }

    public void deregisterProvider(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterProvider");
        }
        if (string != null) {
            this.streamHandlerTable.remove(string);
        } else {
            Tr.info(tc, "WSVR0052");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterProvider");
        }
    }

    public boolean queryProvider(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryProvider");
        }
        boolean bl = false;
        if (string != null) {
            bl = this.streamHandlerTable.containsKey(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryProvider");
        }
        return bl;
    }

    public URLStreamHandler createURLStreamHandler(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createURLStreamHandler for protocol=" + string);
        }
        URLStreamHandler uRLStreamHandler = null;
        if (string != null && string.length() > 0) {
            string = string.toLowerCase();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "streamHandlerTable=" + this.streamHandlerTable);
            }
            utilHandlerClass utilHandlerClass2 = (utilHandlerClass)this.streamHandlerTable.get(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handler class " + utilHandlerClass2 + " retrieved from streamHandlerTable");
            }
            if (utilHandlerClass2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found a handlerClass object for " + string);
                }
                if (utilHandlerClass2.getClassname() != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "attempting to get a class loader for " + utilHandlerClass2.getClasspath());
                        }
                        ClassLoader classLoader = StreamHandlerUtils.getResourceClassLoader(utilHandlerClass2.getClasspath(), null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempting to load " + utilHandlerClass2.getClassname());
                        }
                        Class<?> clazz = classLoader.loadClass(utilHandlerClass2.getClassname());
                        uRLStreamHandler = (URLStreamHandler)clazz.newInstance();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found streamHandlerClass " + utilHandlerClass2.getClassname() + " for protocol " + string);
                        }
                    }
                    catch (Throwable throwable) {
                        String[] stringArray = new String[]{utilHandlerClass2.getClassname(), string};
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "URLStreamHandlerError " + throwable.toString() + " " + utilHandlerClass2.getClassname() + " " + string);
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find streamHandlerClass for: " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createURLStreamHandler returning handler:" + uRLStreamHandler);
        }
        return uRLStreamHandler;
    }
}

