/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSLoginHelperImpl;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSLoginModuleImpl
implements LoginModule {
    private Subject subject;
    private Subject login_subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    protected boolean debug = false;
    protected boolean use_realm_callback = false;
    protected boolean use_appcontext_callback = false;
    private static final TraceComponent tc = Tr.register(WSLoginModuleImpl.class, null, "com.ibm.ejs.resources.security");

    public WSLoginModuleImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSLoginModuleImpl()");
            Tr.exit(tc, "WSLoginModuleImpl()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")");
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.use_realm_callback = "true".equalsIgnoreCase((String)this.options.get("use_realm_callback"));
        this.use_appcontext_callback = "true".equalsIgnoreCase((String)this.options.get("use_appcontext_callback"));
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        block60: {
            Object object;
            Map map;
            String string;
            byte[] byArray;
            char[] cArray;
            String string2;
            block59: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "login()");
                }
                WSLoginModuleImpl.disableAuthRetryForThread();
                this.succeeded = false;
                this.login_subject = null;
                if (this.commitSucceeded) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
                    }
                    this.cleanup();
                }
                if (this.callbackHandler == null) {
                    throw new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                }
                if (this.callbackHandler instanceof WSCallbackHandlerImpl) {
                    this.use_realm_callback = true;
                    this.use_appcontext_callback = true;
                }
                Callback[] callbackArray = null;
                callbackArray = this.use_realm_callback && this.use_appcontext_callback ? new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSRealmNameCallbackImpl("Realm Name: "), new WSAppContextCallback("App Context: ")} : (this.use_realm_callback ? new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSRealmNameCallbackImpl("Realm Name: ")} : (this.use_appcontext_callback ? new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSAppContextCallback("App Context: ")} : new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: ")}));
                string2 = null;
                cArray = null;
                byArray = null;
                string = null;
                map = null;
                try {
                    byte[] byArray2;
                    this.callbackHandler.handle(callbackArray);
                    string2 = ((NameCallback)callbackArray[0]).getName();
                    object = ((PasswordCallback)callbackArray[1]).getPassword();
                    if (object != null) {
                        cArray = new char[((char[])object).length];
                        System.arraycopy(object, 0, cArray, 0, ((char[])object).length);
                        ((PasswordCallback)callbackArray[1]).clearPassword();
                    }
                    if ((byArray2 = ((WSCredTokenCallbackImpl)callbackArray[2]).getCredToken()) != null) {
                        byArray = CredentialsHelper.copyCredToken((byte[])byArray2);
                    }
                    if (this.use_realm_callback) {
                        string = ((WSRealmNameCallbackImpl)callbackArray[3]).getRealmName();
                    }
                    if (this.use_appcontext_callback && this.use_realm_callback) {
                        map = ((WSAppContextCallback)callbackArray[4]).getContext();
                        break block59;
                    }
                    if (this.use_appcontext_callback) {
                        map = ((WSAppContextCallback)callbackArray[3]).getContext();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "291", this);
                    Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), iOException});
                    throw new WSLoginFailedException("java.io.IOException from CallbackHandler.handle()", (Throwable)iOException);
                }
                catch (UnsupportedCallbackException unsupportedCallbackException) {
                    FFDCFilter.processException((Throwable)unsupportedCallbackException, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "298", this);
                    Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
                    throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user", (Throwable)unsupportedCallbackException);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uid = " + string2);
                Tr.debug(tc, "password = " + (cArray == null ? "<null>" : "XXXXXXXX"));
                Tr.debug(tc, "cred token = " + Util.toString(byArray));
                Tr.debug(tc, "realm = " + string);
                Tr.debug(tc, "app context map = " + map);
            }
            if (string2 == null && cArray == null && (byArray == null || byArray.length == 0)) {
                throw new WSLoginFailedException("No authentication data.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Successfully gathered authentication information");
            }
            if (string2 != null || cArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using uid and password for authentication");
                    object = new StringBuffer("Authenticating \"");
                    ((StringBuffer)object).append(WSLoginHelperImpl.getDefaultRealmName()).append('/').append(string2).append("\"");
                    Tr.debug(tc, ((StringBuffer)object).toString());
                }
                try {
                    if (cArray == null) {
                        cArray = new char[]{};
                    }
                    if (string == null || string.equalsIgnoreCase(WSLoginHelperImpl.getDefaultRealmName())) {
                        this.login_subject = ContextManagerFactory.getInstance().login(WSLoginHelperImpl.getDefaultRealmName(), string2, new String(cArray));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Subject after authentication: " + this.login_subject);
                        }
                        break block60;
                    }
                    this.login_subject = SubjectHelper.createBasicAuthSubject((String)string, (String)string2, (String)new String(cArray));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Target realm does not match current realm, creating BasicAuth subject: " + this.login_subject);
                    }
                    if (map != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AppContext found, validating basic auth");
                        }
                        object = (String)map.get("java.naming.factory.initial");
                        String string3 = (String)map.get("java.naming.provider.url");
                        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                        hashtable.put("java.naming.factory.initial", object);
                        hashtable.put("java.naming.provider.url", string3);
                        hashtable.put("com.ibm.websphere.naming.jndicache.cacheobject", "cleared");
                        InitialContext initialContext = new InitialContext(hashtable);
                        try {
                            Object object2 = initialContext.lookup("SecurityServer");
                            SecurityServer securityServer = (SecurityServer)PortableRemoteObject.narrow((Object)object2, (Class)SecurityServer.class);
                            if (securityServer == null) {
                                throw new WSLoginFailedException("Could not find WebSphere security server at provider URL " + string3);
                            }
                            BasicAuthData basicAuthData = new BasicAuthData(string2, new String(cArray), string);
                            boolean bl = securityServer.simple_authenticate(basicAuthData);
                            if (!bl) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "simple_authenticate returned false.");
                                }
                                throw new WSLoginFailedException("Userid and/or password is invalid.");
                            }
                            this.succeeded = true;
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "login(): status = " + this.succeeded);
                            }
                            return this.succeeded;
                        }
                        catch (NameNotFoundException nameNotFoundException) {
                            FFDCFilter.processException(nameNotFoundException, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl", "401");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Can not find security server, security is not enabled");
                            }
                            Tr.error(tc, "security.getting.remote.server.error", new Object[]{nameNotFoundException});
                            throw new WSLoginFailedException(nameNotFoundException.getMessage(), (Throwable)nameNotFoundException);
                        }
                        catch (NamingException namingException) {
                            FFDCFilter.processException(namingException, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl", "408");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to lookup security server");
                            }
                            Tr.error(tc, "security.getting.remote.server.error", new Object[]{namingException});
                            throw new WSLoginFailedException(namingException.getMessage(), (Throwable)namingException);
                        }
                        catch (WSLoginFailedException wSLoginFailedException) {
                            FFDCFilter.processException(wSLoginFailedException, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl", "415");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to lookup security server");
                            }
                            Tr.error(tc, "security.getting.remote.server.error", new Object[]{wSLoginFailedException});
                            throw wSLoginFailedException;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException(exception, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl", "422");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed with general exception while getting remote security server");
                            }
                            Tr.error(tc, "security.getting.remote.server.ex", new Object[]{exception});
                            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                        }
                    }
                    break block60;
                }
                catch (WSLoginFailedException wSLoginFailedException) {
                    FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "432", this);
                    if (SecurityContext.isServerProcess()) {
                        throw wSLoginFailedException;
                    }
                    Throwable throwable = ContextManagerFactory.getInstance().getRootException();
                    if (throwable != null && !(throwable instanceof WSLoginFailedException)) {
                        throw new WSLoginFailedException(wSLoginFailedException.getMessage(), throwable);
                    }
                    if (throwable != null && throwable instanceof WSLoginFailedException) {
                        throw (WSLoginFailedException)throwable;
                    }
                    throw wSLoginFailedException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "450", this);
                    if (SecurityContext.isServerProcess()) {
                        throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                    }
                    Throwable throwable = ContextManagerFactory.getInstance().getRootException();
                    if (throwable != null && !(throwable instanceof WSLoginFailedException)) {
                        throw new WSLoginFailedException(exception.getMessage(), throwable);
                    }
                    if (throwable != null && throwable instanceof WSLoginFailedException) {
                        throw (WSLoginFailedException)throwable;
                    }
                    throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                }
            }
            if (byArray == null) {
                throw new WSLoginFailedException("No authentication data");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using credential token for authentication");
            }
            try {
                this.login_subject = ContextManagerFactory.getInstance().login(WSLoginHelperImpl.getDefaultRealmName(), byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject after authentication: " + this.login_subject);
                }
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "482", this);
                if (SecurityContext.isServerProcess()) {
                    throw wSLoginFailedException;
                }
                Throwable throwable = ContextManagerFactory.getInstance().getRootException();
                if (throwable != null && !(throwable instanceof WSLoginFailedException)) {
                    throw new WSLoginFailedException(wSLoginFailedException.getMessage(), throwable);
                }
                if (throwable != null && throwable instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)throwable;
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "500", this);
                if (SecurityContext.isServerProcess()) {
                    throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                }
                Throwable throwable = ContextManagerFactory.getInstance().getRootException();
                if (throwable != null && !(throwable instanceof WSLoginFailedException)) {
                    throw new WSLoginFailedException(exception.getMessage(), throwable);
                }
                if (throwable != null && throwable instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)throwable;
                }
                throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
            }
        }
        this.succeeded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(): status = " + this.succeeded);
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    if (this.login_subject != null) {
                        this.credential = SubjectHelper.getWSCredentialFromSubject((Subject)this.login_subject);
                        this.principal = SubjectHelper.getPrincipalFromSubject((Subject)this.login_subject);
                    }
                    if (this.credential != null && this.principal != null) {
                        final Subject subject = this.login_subject;
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                Iterator<Principal> iterator;
                                Iterator<Object> iterator2;
                                Iterator<Object> iterator3 = subject.getPublicCredentials().iterator();
                                while (iterator3.hasNext()) {
                                    iterator2 = iterator3.next();
                                    if (iterator2 == null || WSLoginModuleImpl.this.subject.getPublicCredentials().contains(iterator2)) continue;
                                    if (!WSLoginModuleImpl.this.subject.getPublicCredentials().contains(iterator2)) {
                                        if (WSLoginModuleImpl.this.debug || tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding public object to Subject: " + iterator2);
                                        }
                                        WSLoginModuleImpl.this.subject.getPublicCredentials().add(iterator2);
                                    }
                                    if (!(iterator2 instanceof WSCredential)) continue;
                                    WSLoginModuleImpl.this.sharedState.put("WSCredential", iterator2);
                                }
                                iterator2 = subject.getPrivateCredentials().iterator();
                                while (iterator2.hasNext()) {
                                    iterator = iterator2.next();
                                    if (iterator == null || WSLoginModuleImpl.this.subject.getPrivateCredentials().contains(iterator) || WSLoginModuleImpl.this.subject.getPrivateCredentials().contains(iterator)) continue;
                                    if (WSLoginModuleImpl.this.debug || tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding private object to Subject: " + iterator);
                                    }
                                    WSLoginModuleImpl.this.subject.getPrivateCredentials().add(iterator);
                                }
                                iterator = subject.getPrincipals().iterator();
                                while (iterator.hasNext()) {
                                    Principal principal = iterator.next();
                                    if (principal == null || WSLoginModuleImpl.this.subject.getPrincipals().contains(principal)) continue;
                                    if (!WSLoginModuleImpl.this.subject.getPrincipals().contains(principal)) {
                                        if (WSLoginModuleImpl.this.debug || tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding principal object to Subject: " + principal);
                                        }
                                        WSLoginModuleImpl.this.subject.getPrincipals().add(principal);
                                    }
                                    if (!(principal instanceof WSPrincipal)) continue;
                                    WSLoginModuleImpl.this.sharedState.put("WSPrincipal", principal);
                                }
                                return null;
                            }
                        });
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.commit", "673", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit(): status = " + bl);
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        if (!this.subject.isReadOnly()) {
            this.cleanup();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block9: {
                    try {
                        if (WSLoginModuleImpl.this.principal != null && WSLoginModuleImpl.this.subject.getPrincipals().contains(WSLoginModuleImpl.this.principal)) {
                            WSLoginModuleImpl.this.subject.getPrincipals().remove(WSLoginModuleImpl.this.principal);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.run", "814", this);
                        Tr.error(tc, "security.jaas.removePrinException", new Object[]{this.getClass().getName(), WSLoginModuleImpl.this.principal.getName(), exception});
                    }
                    if (WSLoginModuleImpl.this.credential != null) {
                        try {
                            if (WSLoginModuleImpl.this.subject.getPublicCredentials().contains(WSLoginModuleImpl.this.credential)) {
                                WSLoginModuleImpl.this.subject.getPublicCredentials().remove(WSLoginModuleImpl.this.credential);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.run", "830", this);
                            Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                        }
                        try {
                            WSLoginModuleImpl.this.credential.destroy();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.run", "840", this);
                            if (!tc.isDebugEnabled()) break block9;
                            Tr.debug(tc, "Credential destroy failed");
                            Tr.debug(tc, Util.toString(exception));
                        }
                    }
                }
                return null;
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.principal = null;
        this.credential = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private static void disableAuthRetryForThread() {
        ContextManagerFactory.getInstance().put("wssecurity.disableauthretry", (Object)new Boolean(true));
    }

    private static void enableAuthRetryForThread() {
        ContextManagerFactory.getInstance().put("wssecurity.disableauthretry", (Object)new Boolean(false));
    }
}

