/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.ssl.KeyManager;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.ipc.ssl.ManagementScope;
import com.ibm.websphere.models.config.ipc.ssl.SSLSecurityLevel;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.ipc.ssl.TrustManager;
import com.ibm.websphere.models.config.orb.securityprotocol.CommonSecureInterop;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocol;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPTransport;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportQOP;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.DynamicSSLConfigSelection;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.DynamicSSLCacheMissComparator;
import com.ibm.ws.ssl.config.FIPSManager;
import com.ibm.ws.ssl.config.KeyManagerData;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.TrustManagerData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.Constants;
import com.ibm.ws.util.PlatformHelperFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.eclipse.emf.common.util.EList;

public class SSLConfigManager {
    private static final TraceComponent tc = Tr.register(SSLConfigManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static SSLConfigManager thisClass = null;
    private boolean isServerProcess = false;
    private boolean clientSSLInitializedOnce = false;
    private KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
    private Properties globalConfigProperties = new Properties();
    private HashMap sslConfigMap = new HashMap();
    private ArrayList keyManagerArrayList = new ArrayList();
    private ArrayList trustManagerArrayList = new ArrayList();
    private HashMap sslConfigDynamicSelectionMap = new HashMap();
    private TreeSet sslConfigDynamicSelectionCacheMissTreeSet = new TreeSet(new DynamicSSLCacheMissComparator());
    private HashMap sslConfigDynamicLookupCache = new HashMap();
    private HashSet clientFilesAlreadyProcessed = new HashSet();
    private HashMap sslConfigListenerMap = new HashMap();
    private HashMap sslConfigListenerEventMap = new HashMap();
    private static String[][] SystemSSLCiphers = new String[][]{{"05", "SSL_RSA_WITH_RC4_128_SHA"}, {"04", "SSL_RSA_WITH_RC4_128_MD5"}, {"35", "SSL_RSA_WITH_AES_256_CBC_SHA"}, {"36", "SSL_DH_DSS_WITH_AES_256_CBC_SHA"}, {"37", "SSL_DH_RSA_WITH_AES_256_CBC_SHA"}, {"38", "SSL_DHE_DSS_WITH_AES_256_CBC_SHA"}, {"39", "SSL_DHE_RSA_WITH_AES_256_CBC_SHA"}, {"2F", "SSL_RSA_WITH_AES_128_CBC_SHA"}, {"30", "SSL_DH_DSS_WITH_AES_128_CBC_SHA"}, {"31", "SSL_DH_RSA_WITH_AES_128_CBC_SHA"}, {"32", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA"}, {"33", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA"}, {"0A", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"}, {"16", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA"}, {"13", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA"}, {"10", "SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA"}, {"0D", "SSL_HD_DSS_WITH_3DES_EDE_CBC_SHA"}, {"09", "SSL_RSA_WITH_DES_CBC_SHA"}, {"15", "SSL_DHE_RSA_WITH_DES_CBC_SHA"}, {"12", "SSL_DHE_DSS_WITH_DES_CBC_SHA"}, {"0F", "SSL_DH_RSA_WITH_DES_CBC_SHA"}, {"0C", "SSL_DH_DSS_WITH_DES_CBC_SHA"}, {"03", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"}, {"06", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5"}, {"02", "SSL_RSA_NULL_SHA"}, {"01", "SSL_RSA_NULL_MD5"}, {"00", "SSL_NULL_WITH_NULL_NULL"}};

    private SSLConfigManager() {
        JSSEProviderFactory.getInstance();
    }

    public static SSLConfigManager getInstance() {
        if (thisClass == null) {
            thisClass = new SSLConfigManager();
        }
        return thisClass;
    }

    public synchronized void initializeServerSSL(Security security2, boolean bl) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeServerSSL");
        }
        if (security2 == null) {
            throw new SSLException("Cannot get security object from WCCM.");
        }
        try {
            Object object;
            Object object2;
            Object object3;
            int n;
            this.isServerProcess = true;
            this.loadGlobalProperties(security2);
            FIPSManager.getInstance().initializeFIPS();
            KeyStoreManager.getInstance().loadKeyStores(security2);
            this.loadKeyManagers(security2);
            this.loadTrustManagers(security2);
            String[] stringArray = null;
            HashSet<Object> hashSet = null;
            if (bl) {
                hashSet = new HashSet<Object>();
                stringArray = this.sslConfigMap.keySet().toArray(new String[0]);
            }
            for (n = 0; n < security2.getRepertoire().size(); ++n) {
                object3 = (com.ibm.websphere.models.config.security.SSLConfig)security2.getRepertoire().get(n);
                if (object3 == null) continue;
                object2 = object3.getAlias();
                object = this.parseSSLConfig((com.ibm.websphere.models.config.security.SSLConfig)object3, bl);
                if (object == null || !((SSLConfig)object).requiredPropertiesArePresent()) continue;
                ((Properties)object).setProperty("com.ibm.ssl.alias", (String)object2);
                ((Properties)object).setProperty("com.ibm.ssl.configURLLoadedFrom", "security.xml");
                ((SSLConfig)object).decodePasswords();
                if (bl) {
                    hashSet.add(object2);
                    SSLConfig sSLConfig = (SSLConfig)this.sslConfigMap.get(object2);
                    if (sSLConfig == null) {
                        this.addSSLConfigToMap((String)object2, (SSLConfig)object);
                        continue;
                    }
                    if (!sSLConfig.equals(object)) {
                        this.removeSSLConfigFromMap((String)object2, sSLConfig);
                        this.addSSLConfigToMap((String)object2, (SSLConfig)object);
                        this.notifySSLConfigChangeListener((String)object2, "changed");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "New SSL config equals old SSL config for alias: " + (String)object2);
                    continue;
                }
                this.addSSLConfigToMap((String)object2, (SSLConfig)object);
            }
            if (bl) {
                for (n = 0; n < stringArray.length; ++n) {
                    object3 = stringArray[n];
                    object2 = (SSLConfig)this.sslConfigMap.get(object3);
                    object = ((Properties)object2).getProperty("com.ibm.ssl.configURLLoadedFrom");
                    if (object2 == null || hashSet.contains(object3) || object != null && !((String)object).equals("security.xml")) continue;
                    this.removeSSLConfigFromMap((String)object3, (SSLConfig)object2);
                    this.notifySSLConfigChangeListener((String)object3, "deleted");
                }
            }
            this.getDefaultSystemProperties(bl);
            this.loadDynamicSSLSelectionInfo(security2);
            ManagementScopeManager.getInstance().loadSSLConfigGroups(security2, bl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLConfigManager.initializeServerSSL", "235", this);
            throw new SSLException(exception);
        }
        this.checkURLHostNameVerificationProperty(bl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total Number of SSLConfigs: " + this.sslConfigMap.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeServerSSL");
        }
    }

    public void initializeClientSSL() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeClientSSL");
        }
        try {
            if (!this.isServerProcess() && !this.clientSSLInitializedOnce) {
                String string;
                FIPSManager.getInstance().initializeFIPS();
                String string2 = System.getProperty("com.ibm.CORBA.ConfigURL");
                if (string2 != null) {
                    this.parseConfigURL("IIOP", string2, false);
                }
                if ((string = System.getProperty("com.ibm.SOAP.ConfigURL")) != null) {
                    this.parseConfigURL("ADMIN_SOAP", string, false);
                }
                String string3 = System.getProperty("com.ibm.SSL.ConfigURL");
                this.parseSSLConfigURL(string3, false);
                this.getDefaultSystemProperties(false);
                this.checkURLHostNameVerificationProperty(false);
                this.clientSSLInitializedOnce = true;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception initializing SSL properties from ConfigURL.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLConfigManager.reinitializeClientSSL", "287", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeClientSSL");
        }
    }

    public void reinitializeClientSSL() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reinitializeClientSSL");
        }
        try {
            if (!this.isServerProcess()) {
                String string;
                FIPSManager.getInstance().initializeFIPS();
                String string2 = System.getProperty("com.ibm.CORBA.ConfigURL");
                if (string2 != null) {
                    this.parseConfigURL("IIOP", string2, true);
                }
                if ((string = System.getProperty("com.ibm.SOAP.ConfigURL")) != null) {
                    this.parseConfigURL("ADMIN_SOAP", string, true);
                }
                String string3 = System.getProperty("com.ibm.SSL.ConfigURL");
                this.parseSSLConfigURL(string3, true);
                this.getDefaultSystemProperties(true);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception reinitializing SSL properties from ConfigURL.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLConfigManager.reinitializeClientSSL", "332", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reinitializeClientSSL");
        }
    }

    public void loadTrustManagers(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadTrustManagers");
        }
        this.trustManagerArrayList.clear();
        EList eList = security2.getTrustManagers();
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                TrustManager trustManager = (TrustManager)iterator.next();
                ManagementScope managementScope = trustManager.getManagementScope();
                String string = null;
                string = managementScope != null ? managementScope.getScopeName() : ManagementScopeManager.getInstance().getCellScopeName();
                if (!ManagementScopeManager.getInstance().currentScopeContained(string)) continue;
                String string2 = trustManager.getName();
                String string3 = trustManager.getAlgorithm();
                String string4 = trustManager.getProvider();
                String string5 = trustManager.getTrustManagerClass();
                EList eList2 = trustManager.getAdditionalTrustManagerAttrs();
                TrustManagerData trustManagerData = new TrustManagerData(string2, string4, string3, string5, eList2, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding trustManager name: " + string2 + " with values: " + trustManagerData);
                }
                this.trustManagerArrayList.add(trustManagerData);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadTrustManagers");
        }
    }

    public void loadKeyManagers(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadKeyManagers");
        }
        this.keyManagerArrayList.clear();
        EList eList = security2.getKeyManagers();
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                KeyManager keyManager = (KeyManager)iterator.next();
                ManagementScope managementScope = keyManager.getManagementScope();
                String string = null;
                string = managementScope != null ? managementScope.getScopeName() : ManagementScopeManager.getInstance().getCellScopeName();
                if (!ManagementScopeManager.getInstance().currentScopeContained(string)) continue;
                String string2 = keyManager.getName();
                String string3 = keyManager.getAlgorithm();
                String string4 = keyManager.getProvider();
                String string5 = keyManager.getKeyManagerClass();
                EList eList2 = keyManager.getAdditionalKeyManagerAttrs();
                KeyManagerData keyManagerData = new KeyManagerData(string2, string4, string3, string5, eList2, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding KeyManager name: " + string2 + " with values: " + keyManagerData);
                }
                this.keyManagerArrayList.add(keyManagerData);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadKeyManagers");
        }
    }

    public TrustManagerData getTrustManagerData(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustManagerData", new Object[]{string});
        }
        for (int i = 0; i < this.trustManagerArrayList.size(); ++i) {
            TrustManagerData trustManagerData = (TrustManagerData)this.trustManagerArrayList.get(i);
            if (trustManagerData == null || !trustManagerData.getName().equalsIgnoreCase(string) || !ManagementScopeManager.getInstance().currentScopeContained(trustManagerData.getManagementScope())) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustManagerData (" + string + ")");
            }
            return trustManagerData;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustManagerData (null)");
        }
        return null;
    }

    public KeyManagerData getKeyManagerData(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyManagerData", new Object[]{string});
        }
        for (int i = 0; i < this.keyManagerArrayList.size(); ++i) {
            KeyManagerData keyManagerData = (KeyManagerData)this.keyManagerArrayList.get(i);
            if (keyManagerData == null || !keyManagerData.getName().equalsIgnoreCase(string) || !ManagementScopeManager.getInstance().currentScopeContained(keyManagerData.getManagementScope())) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKeyManagerData (" + string + ")");
            }
            return keyManagerData;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyManagerData (null)");
        }
        return null;
    }

    public synchronized void loadDynamicSSLSelectionInfo(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDynamicSSLSelectionInfo");
        }
        this.sslConfigDynamicSelectionMap.clear();
        this.sslConfigDynamicSelectionCacheMissTreeSet.clear();
        this.sslConfigDynamicLookupCache.clear();
        EList eList = security2.getDynamicSSLConfigSelections();
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                String string;
                DynamicSSLConfigSelection dynamicSSLConfigSelection = (DynamicSSLConfigSelection)iterator.next();
                if (dynamicSSLConfigSelection == null) continue;
                if (dynamicSSLConfigSelection.getManagementScope() != null && (string = dynamicSSLConfigSelection.getManagementScope().getScopeName()) != null && !string.equals("") && !ManagementScopeManager.getInstance().currentScopeContained(string)) {
                    if (!tc.isEntryEnabled()) continue;
                    Tr.exit(tc, "Scope \"" + string + "\" is out of scope for this process.");
                    continue;
                }
                string = dynamicSSLConfigSelection.getDynamicSelectionInfo();
                String string2 = dynamicSSLConfigSelection.getSslConfig().getAlias();
                String string3 = dynamicSSLConfigSelection.getCertificateAlias();
                if (string == null || string2 == null) continue;
                if (string3 != null) {
                    String string4 = string2 + ":" + string3;
                    this.sslConfigDynamicSelectionMap.put(string, string4);
                    continue;
                }
                this.sslConfigDynamicSelectionMap.put(string, string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadDynamicSSLSelectionInfo", new Object[]{this.sslConfigDynamicSelectionMap});
        }
    }

    public SSLConfig parseSSLConfig(com.ibm.websphere.models.config.security.SSLConfig sSLConfig, boolean bl) throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSSLConfig");
        }
        if (sSLConfig == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "parseSSLConfig -> null");
            }
            return null;
        }
        String string2 = sSLConfig.getAlias();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing SSLConfig with alias: " + string2);
        }
        if (sSLConfig.getManagementScope() != null && (string = sSLConfig.getManagementScope().getScopeName()) != null && !string.equals("") && !ManagementScopeManager.getInstance().currentScopeContained(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLConfig with alias \"" + string2 + "\" and scope (\"" + string + "\") is not in the current process scope");
            }
            return null;
        }
        string = null;
        if (null != sSLConfig.getType()) {
            string = sSLConfig.getType().getName();
        }
        SSLConfig sSLConfig2 = this.parseSecureSocketLayer(string2, string, sSLConfig.getSetting(), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSSLConfig");
        }
        return sSLConfig2;
    }

    public SSLConfig parseSecureSocketLayer(String string, String string2, SecureSocketLayer secureSocketLayer, boolean bl) throws Exception {
        String string3;
        Object object;
        Object object2;
        Object object3;
        WSKeyStore[] wSKeyStoreArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSecureSocketLayer");
        }
        SSLConfig sSLConfig = new SSLConfig();
        if (secureSocketLayer != null) {
            wSKeyStoreArray = secureSocketLayer.getKeyStore();
            WSKeyStore wSKeyStore = null;
            object3 = null;
            if (wSKeyStoreArray != null) {
                object3 = wSKeyStoreArray.getName();
                wSKeyStore = KeyStoreManager.getInstance().getKeyStore((String)object3);
            }
            object2 = null;
            if (wSKeyStore != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding keystore properties from KeyStore object.");
                }
                sSLConfig.setProperty("com.ibm.ssl.keyStoreName", (String)object3);
                this.addSSLPropertiesFromKeyStore(wSKeyStore, sSLConfig);
                object2 = KeyStoreManager.getInstance().checkIfKeyStoreExistsAndCreateIfNot(wSKeyStore, sSLConfig);
                wSKeyStore.initializeKeyStore(bl);
            }
            KeyStore keyStore = secureSocketLayer.getTrustStore();
            object = null;
            string3 = null;
            if (keyStore != null) {
                string3 = keyStore.getName();
                object = KeyStoreManager.getInstance().getKeyStore(string3);
            }
            if (object != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding truststore properties from KeyStore object.");
                }
                sSLConfig.setProperty("com.ibm.ssl.trustStoreName", string3);
                this.addSSLPropertiesFromTrustStore((WSKeyStore)object, sSLConfig);
                KeyStoreManager.getInstance().checkIfTrustStoreExistsAndCreateIfNot((WSKeyStore)object, sSLConfig, (Certificate)object2);
                ((WSKeyStore)object).initializeKeyStore(bl);
            }
        }
        if ((wSKeyStoreArray = KeyStoreManager.getInstance().loadOldWCCMKeyStores(string, string2, secureSocketLayer)) != null) {
            for (int i = 0; i < wSKeyStoreArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key/trust store properties from old attributes.");
                }
                if ((object3 = wSKeyStoreArray[i]) != null) {
                    object2 = ((Properties)object3).getProperty("com.ibm.ssl.keyStoreName");
                    if (((String)object2).endsWith("_trust")) {
                        sSLConfig.setProperty("com.ibm.ssl.trustStoreName", (String)object2);
                        this.addSSLPropertiesFromTrustStore((WSKeyStore)object3, sSLConfig);
                    }
                    if (((String)object2).endsWith("_key")) {
                        sSLConfig.setProperty("com.ibm.ssl.keyStoreName", (String)object2);
                        this.addSSLPropertiesFromKeyStore((WSKeyStore)object3, sSLConfig);
                    }
                }
                wSKeyStoreArray[i].initializeKeyStore(bl);
            }
        }
        KeyManager keyManager = null;
        if (secureSocketLayer != null) {
            keyManager = secureSocketLayer.getKeyManager();
        }
        if (keyManager != null) {
            if (keyManager.getAlgorithm() != null && (keyManager.getAlgorithm().equalsIgnoreCase("IbmPKIX") || keyManager.getAlgorithm().equalsIgnoreCase("IbmX509"))) {
                object3 = null;
                object3 = keyManager.getAlgorithm() != null && keyManager.getProvider() != null ? keyManager.getAlgorithm() + "|" + keyManager.getProvider() : keyManager.getAlgorithm();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting KeyManager: " + (String)object3);
                }
                sSLConfig.setProperty("com.ibm.ssl.keyManager", (String)object3);
            } else if (keyManager.getAlgorithm() != null && keyManager.getProvider() != null || keyManager.getKeyManagerClass() != null) {
                object3 = keyManager.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting custom KeyManager: " + (String)object3);
                }
                sSLConfig.setProperty("com.ibm.ssl.customKeyManager", (String)object3);
                object2 = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
                if (object2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting default KeyManager: " + (String)object2);
                    }
                    sSLConfig.setProperty("com.ibm.ssl.keyManager", (String)object2);
                }
            } else {
                object3 = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
                if (object3 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting default KeyManager: " + (String)object3);
                    }
                    sSLConfig.setProperty("com.ibm.ssl.keyManager", (String)object3);
                }
            }
        } else {
            object3 = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
            if (object3 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting default KeyManager: " + (String)object3);
                }
                sSLConfig.setProperty("com.ibm.ssl.keyManager", (String)object3);
            }
        }
        object3 = null;
        if (secureSocketLayer != null) {
            object3 = secureSocketLayer.getTrustManager();
        }
        if (object3 != null && object3.size() > 0) {
            object2 = null;
            for (int i = 0; i < object3.size(); ++i) {
                object = (TrustManager)object3.get(i);
                if (i == 0 && object != null && object.getAlgorithm() != null && (object.getAlgorithm().equalsIgnoreCase("IbmX509") || object.getAlgorithm().equalsIgnoreCase("IbmPKIX"))) {
                    string3 = null;
                    string3 = object.getProvider() != null ? object.getAlgorithm() + "|" + object.getProvider() : object.getAlgorithm();
                    if (object.getAlgorithm().equalsIgnoreCase("IbmPKIX")) {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                System.setProperty("com.ibm.jsse2.checkRevocation", "true");
                                System.setProperty("com.ibm.security.enableCRLDP", "true");
                                return null;
                            }
                        });
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting TrustManager: " + string3);
                    }
                    sSLConfig.setProperty("com.ibm.ssl.trustManager", string3);
                    continue;
                }
                if (i <= 0 || object == null) continue;
                object2 = object2 != null ? (String)object2 + "," + object.getName() : object.getName();
            }
            if (object2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting custom TrustManager(s): " + (String)object2);
                }
                sSLConfig.setProperty("com.ibm.ssl.customTrustManagers", (String)object2);
            }
        } else {
            object2 = JSSEProviderFactory.getTrustManagerFactoryAlgorithm();
            if (object2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting default TrustManager: " + (String)object2);
                }
                sSLConfig.setProperty("com.ibm.ssl.trustManager", (String)object2);
            }
        }
        if (secureSocketLayer != null) {
            String string4;
            String string5;
            String string6;
            object2 = secureSocketLayer.getSslProtocol();
            if (object2 != null && !((String)object2).equals("")) {
                sSLConfig.setProperty("com.ibm.ssl.protocol", (String)object2);
            }
            if ((string6 = secureSocketLayer.getJsseProvider()) != null && !string6.equals("")) {
                if (string6.equalsIgnoreCase("IBMJSSE") || string6.equalsIgnoreCase("IBMJSSEFIPS")) {
                    string6 = "IBMJSSE2";
                }
                sSLConfig.setProperty("com.ibm.ssl.contextProvider", string6);
            }
            if (secureSocketLayer.isSetClientAuthentication() && (object = Boolean.toString(secureSocketLayer.isClientAuthentication())) != null) {
                sSLConfig.setProperty("com.ibm.ssl.clientAuthentication", (String)object);
            }
            if ((object = Boolean.toString(secureSocketLayer.isClientAuthenticationSupported())) != null) {
                sSLConfig.setProperty("com.ibm.ssl.clientAuthenticationSupported", (String)object);
            }
            if (secureSocketLayer.isSetSecurityLevel() && (string3 = this.getSecurityLevel(secureSocketLayer.getSecurityLevel())) != null && !string3.equals("")) {
                sSLConfig.setProperty("com.ibm.ssl.securityLevel", string3);
            }
            if ((string3 = secureSocketLayer.getClientKeyAlias()) != null && !string3.equals("")) {
                sSLConfig.setProperty("com.ibm.ssl.keyStoreClientAlias", string3);
            }
            if ((string5 = secureSocketLayer.getServerKeyAlias()) != null && !string5.equals("")) {
                sSLConfig.setProperty("com.ibm.ssl.keyStoreServerAlias", string5);
            }
            if ((string4 = secureSocketLayer.getEnabledCiphers()) != null && !string4.equals("")) {
                sSLConfig.setProperty("com.ibm.ssl.enabledCipherSuites", string4);
            }
            for (int i = 0; i < secureSocketLayer.getProperties().size(); ++i) {
                Property property = (Property)secureSocketLayer.getProperties().get(i);
                if (property == null || property.getValue() == null || property.getValue().equals("")) continue;
                String string7 = property.getValue();
                if (property.getName().equals("com.ibm.ssl.contextProvider") && (string7.equalsIgnoreCase("IBMJSSE") || string7.equalsIgnoreCase("IBMJSSEFIPS"))) {
                    string7 = "IBMJSSE2";
                }
                sSLConfig.setProperty(property.getName(), string7);
            }
        }
        if (FIPSManager.getInstance().isFIPSEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "FIPS enabled, setting SSL protocol to TLS.");
            }
            sSLConfig.put("com.ibm.ssl.protocol", "TLS");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Saving SSLConfig.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, sSLConfig.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSecureSocketLayer");
        }
        return sSLConfig;
    }

    public void addSSLPropertiesFromKeyStore(WSKeyStore wSKeyStore, SSLConfig sSLConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSSLPropertiesFromKeyStore");
        }
        Enumeration<?> enumeration = wSKeyStore.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = wSKeyStore.getProperty(string);
            sSLConfig.setProperty(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSSLPropertiesFromKeyStore");
        }
    }

    public void addSSLPropertiesFromTrustStore(WSKeyStore wSKeyStore, SSLConfig sSLConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSSLPropertiesFromTrustStore");
        }
        Enumeration<?> enumeration = wSKeyStore.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = wSKeyStore.getProperty(string);
            String string3 = null;
            if (string.startsWith("com.ibm.ssl.keyStore")) {
                int n = string.indexOf("com.ibm.ssl.keyStore");
                String string4 = null;
                if (n + "com.ibm.ssl.keyStore".length() < string.length()) {
                    string4 = string.substring(n + "com.ibm.ssl.keyStore".length());
                }
                string3 = string4 != null ? "com.ibm.ssl.trustStore" + string4 : "com.ibm.ssl.trustStore";
            }
            if (string3 == null || string2 == null) continue;
            sSLConfig.setProperty(string3, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSSLPropertiesFromKeyStore");
        }
    }

    public String[] getSSLConfigAliases() {
        return this.sslConfigMap.keySet().toArray(new String[0]);
    }

    public SSLConfig getSSLConfig(String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLConfig", string);
        }
        if (string == null || string.equals("")) {
            return this.getDefaultSSLConfig();
        }
        SSLConfig sSLConfig = (SSLConfig)this.sslConfigMap.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLConfig");
        }
        return sSLConfig;
    }

    public void loadGlobalProperties(Security security2) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadGlobalProperties");
        }
        this.globalConfigProperties.clear();
        EList eList = security2.getProperties();
        if (this.globalConfigProperties != null && eList != null) {
            for (int i = 0; i < eList.size(); ++i) {
                Property property = (Property)eList.get(i);
                if (!property.getName().startsWith("com.ibm.ssl") && !property.getName().startsWith("com.ibm.security") && !property.getName().startsWith("was.com.ibm.websphere.security.zos.csiv2")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting global property: " + property.getName() + "=" + property.getValue());
                }
                this.globalConfigProperties.setProperty(property.getName(), property.getValue());
            }
        }
        this.loadCSIv2SSLProperties(security2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadGlobalProperties");
        }
    }

    public void loadCSIv2SSLProperties(Security security2) {
        IIOPSecurityProtocol iIOPSecurityProtocol;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCSIv2SSLProperties");
        }
        if ((iIOPSecurityProtocol = security2.getCSI()) != null) {
            Object object;
            TransportLayer transportLayer;
            CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getClaims();
            TransportLayer transportLayer2 = null;
            for (int i = 0; i < commonSecureInterop.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop.getLayers().get(i) instanceof TransportLayer)) continue;
                transportLayer2 = (TransportLayer)commonSecureInterop.getLayers().get(i);
                break;
            }
            if (transportLayer2 != null) {
                TransportQOP transportQOP = (TransportQOP)transportLayer2.getSupportedQOP();
                if (transportQOP.isEnableProtection()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTransportAssocSSLTLSSupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTransportAssocSSLTLSSupported", "false");
                }
                if (transportQOP.isEstablishTrustInClient()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTLClientAuthenticationSupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTLClientAuthenticationSupported", "false");
                }
                if (transportQOP.isIntegrity()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageIntegritySupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageIntegritySupported", "false");
                }
                if (transportQOP.isConfidentiality()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageConfidentialitySupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageConfidentialitySupported", "false");
                }
                transportLayer = (TransportQOP)transportLayer2.getRequiredQOP();
                if (transportLayer.isEnableProtection()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTransportAssocSSLTLSRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTransportAssocSSLTLSRequired", "false");
                }
                if (transportLayer.isEstablishTrustInClient()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTLClientAuthenticationRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimTLClientAuthenticationRequired", "false");
                }
                if (transportLayer.isIntegrity()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageIntegrityRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageIntegrityRequired", "false");
                }
                if (transportLayer.isConfidentiality()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageConfidentialityRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.claimMessageConfidentialityRequired", "false");
                }
                IIOPTransport iIOPTransport = transportLayer2.getServerAuthentication();
                object = null;
                if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    object = this.globalConfigProperties.getProperty("was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig");
                }
                if (object == null) {
                    object = iIOPTransport.getSslConfig();
                }
                if (object != null) {
                    this.globalConfigProperties.setProperty("com.ibm.ssl.csi.inbound.alias", (String)object);
                }
            }
            CommonSecureInterop commonSecureInterop2 = (CommonSecureInterop)iIOPSecurityProtocol.getClaims();
            transportLayer = null;
            for (int i = 0; i < commonSecureInterop2.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop2.getLayers().get(i) instanceof TransportLayer)) continue;
                transportLayer = (TransportLayer)commonSecureInterop2.getLayers().get(i);
                break;
            }
            if (transportLayer != null) {
                TransportQOP transportQOP = (TransportQOP)transportLayer.getSupportedQOP();
                if (transportQOP.isEnableProtection()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTransportAssocSSLTLSSupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTransportAssocSSLTLSSupported", "false");
                }
                if (transportQOP.isIntegrity()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageIntegritySupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageIntegritySupported", "false");
                }
                if (transportQOP.isConfidentiality()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageConfidentialitySupported", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageConfidentialitySupported", "false");
                }
                object = (TransportQOP)transportLayer.getRequiredQOP();
                if (object.isEnableProtection()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTransportAssocSSLTLSRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performTransportAssocSSLTLSRequired", "false");
                }
                if (object.isIntegrity()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageIntegrityRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageIntegrityRequired", "false");
                }
                if (object.isConfidentiality()) {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageConfidentialityRequired", "true");
                } else {
                    this.globalConfigProperties.setProperty("com.ibm.CSI.performMessageConfidentialityRequired", "false");
                }
                IIOPTransport iIOPTransport = transportLayer.getServerAuthentication();
                String string = null;
                if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    string = this.globalConfigProperties.getProperty("was.com.ibm.websphere.security.zos.csiv2.outbound.transport.sslconfig");
                }
                if (string == null) {
                    string = iIOPTransport.getSslConfig();
                }
                if (string != null) {
                    this.globalConfigProperties.setProperty("com.ibm.ssl.csi.outbound.alias", string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCSIv2SSLProperties");
        }
    }

    public Properties determineIfCSIv2SettingsApply(Properties properties, Map map) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineIfCSIv2SettingsApply", new Object[]{map});
        }
        Properties properties2 = null;
        if (map != null) {
            String string = (String)map.get("com.ibm.ssl.endPointName");
            String string2 = (String)map.get("com.ibm.ssl.direction");
            if (string != null && (string.equals("ORB_SSL_LISTENER_ADDRESS") || string.equals("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS") || string.equals("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS")) && string2 != null && string2.equals("inbound")) {
                String string3 = this.globalConfigProperties.getProperty("com.ibm.ssl.csi.inbound.alias");
                if (string3 != null && string3.length() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting inbound SSL config with alias: " + string3);
                    }
                    properties2 = this.getProperties(string3);
                }
                if (properties2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cloning CSIv2 alias reference configuration.");
                    }
                    properties2 = (Properties)properties2.clone();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cloning JSSEHelper configuration.");
                    }
                    properties2 = (Properties)properties.clone();
                }
                if (properties2 != null) {
                    String string4 = this.globalConfigProperties.getProperty("com.ibm.CSI.claimTLClientAuthenticationSupported");
                    String string5 = this.globalConfigProperties.getProperty("com.ibm.CSI.claimTLClientAuthenticationRequired");
                    if (string4 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting client auth supported: " + string4);
                        }
                        properties2.setProperty("com.ibm.ssl.clientAuthenticationSupported", string4);
                    }
                    if (string5 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting client auth required: " + string5);
                        }
                        properties2.setProperty("com.ibm.ssl.clientAuthentication", string5);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "determineIfCSIv2SettingsApply (settings applied)");
                    }
                    return properties2;
                }
            } else if ("IIOP".equals(string) && "outbound".equals(string2)) {
                String string6 = this.globalConfigProperties.getProperty("com.ibm.ssl.csi.outbound.alias");
                if (string6 != null && string6.length() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting outbound SSL config with alias: " + string6);
                    }
                    properties2 = this.getProperties(string6);
                }
                if (properties2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cloning CSIv2 alias reference configuration.");
                    }
                    properties2 = (Properties)properties2.clone();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cloning JSSEHelper configuration.");
                    }
                    properties2 = (Properties)properties.clone();
                }
                if (properties2 != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "determineIfCSIv2SettingsApply (settings applied)");
                    }
                    return properties2;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineIfCSIv2SettingsApply (original settings)");
        }
        return properties;
    }

    public Properties getDefaultSystemProperties(boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultSystemProperties");
        }
        if (!bl && this.sslConfigMap.get("DefaultSystemProperties") != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultSystemProperties -> already present.");
            }
            return (Properties)this.sslConfigMap.get("DefaultSystemProperties");
        }
        SSLConfig sSLConfig = this.parseSecureSocketLayer("DefaultSystemProperties", "JSSE", null, bl);
        if (sSLConfig != null && sSLConfig.requiredPropertiesArePresent()) {
            sSLConfig.setProperty("com.ibm.ssl.alias", "DefaultSystemProperties");
            sSLConfig.setProperty("com.ibm.ssl.configURLLoadedFrom", "System Properties");
            sSLConfig.decodePasswords();
            SSLConfig sSLConfig2 = (SSLConfig)this.sslConfigMap.get("DefaultSystemProperties");
            if (sSLConfig2 == null) {
                this.addSSLConfigToMap("DefaultSystemProperties", sSLConfig);
            } else if (!sSLConfig2.equals(sSLConfig)) {
                this.removeSSLConfigFromMap("DefaultSystemProperties", sSLConfig2);
                this.addSSLConfigToMap("DefaultSystemProperties", sSLConfig);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New SSL config equals old SSL config for alias: DefaultSystemProperties");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultSystemProperties -> found valid system properties");
            }
            return sSLConfig;
        }
        this.setDefaultSystemPropertiesIfNecessary();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultSystemProperties -> null");
        }
        return null;
    }

    public void setDefaultSystemPropertiesIfNecessary() {
        SSLConfig sSLConfig;
        String string = JSSEProviderFactory.getDefaultSSLSocketFactory();
        String string2 = JSSEProviderFactory.getDefaultSSLServerSocketFactory();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultSystemPropertiesIfNecessary", new Object[]{string, string2});
        }
        if ((string != null && string.equals("com.ibm.jsse2.SSLSocketFactoryImpl") || string2 != null && string2.equals("com.ibm.jsse2.SSLServerSocketFactoryImpl")) && (sSLConfig = (SSLConfig)this.sslConfigMap.get("DefaultSystemProperties")) == null && (sSLConfig = this.getDefaultSSLConfig()) != null) {
            final SSLConfig sSLConfig2 = sSLConfig;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = sSLConfig2.getProperty("com.ibm.ssl.keyStoreName");
                    WSKeyStore wSKeyStore = null;
                    if (string != null) {
                        wSKeyStore = KeyStoreManager.getInstance().getKeyStore(string);
                    }
                    if (wSKeyStore != null && wSKeyStore.getProperty("com.ibm.ssl.keyStore") != null || sSLConfig2.getProperty("com.ibm.ssl.keyStore") != null) {
                        System.setProperty("javax.net.ssl.keyStore", wSKeyStore != null ? wSKeyStore.getProperty("com.ibm.ssl.keyStore") : sSLConfig2.getProperty("com.ibm.ssl.keyStore"));
                    }
                    if (wSKeyStore != null && wSKeyStore.getProperty("com.ibm.ssl.keyStorePassword") != null || sSLConfig2.getProperty("com.ibm.ssl.keyStorePassword") != null) {
                        System.setProperty("javax.net.ssl.keyStorePassword", wSKeyStore != null ? wSKeyStore.getProperty("com.ibm.ssl.keyStorePassword") : sSLConfig2.getProperty("com.ibm.ssl.keyStorePassword"));
                    }
                    if (wSKeyStore != null && wSKeyStore.getProperty("com.ibm.ssl.keyStoreType") != null || sSLConfig2.getProperty("com.ibm.ssl.keyStoreType") != null) {
                        System.setProperty("javax.net.ssl.keyStoreType", wSKeyStore != null ? wSKeyStore.getProperty("com.ibm.ssl.keyStoreType") : sSLConfig2.getProperty("com.ibm.ssl.keyStoreType"));
                    }
                    if (wSKeyStore != null && wSKeyStore.getProperty("com.ibm.ssl.keyStoreProvider") != null || sSLConfig2.getProperty("com.ibm.ssl.keyStoreProvider") != null) {
                        System.setProperty("javax.net.ssl.keyStoreProvider", wSKeyStore != null ? wSKeyStore.getProperty("com.ibm.ssl.keyStoreProvider") : sSLConfig2.getProperty("com.ibm.ssl.keyStoreProvider"));
                    }
                    String string2 = sSLConfig2.getProperty("com.ibm.ssl.trustStoreName");
                    WSKeyStore wSKeyStore2 = null;
                    if (string2 != null) {
                        wSKeyStore2 = KeyStoreManager.getInstance().getKeyStore(string2);
                    }
                    if (wSKeyStore2 != null && wSKeyStore2.getProperty("com.ibm.ssl.keyStore") != null || sSLConfig2.getProperty("com.ibm.ssl.trustStore") != null) {
                        System.setProperty("javax.net.ssl.trustStore", wSKeyStore2 != null ? wSKeyStore2.getProperty("com.ibm.ssl.keyStore") : sSLConfig2.getProperty("com.ibm.ssl.trustStore"));
                    }
                    if (wSKeyStore2 != null && wSKeyStore2.getProperty("com.ibm.ssl.keyStorePassword") != null || sSLConfig2.getProperty("com.ibm.ssl.trustStorePassword") != null) {
                        System.setProperty("javax.net.ssl.trustStorePassword", wSKeyStore2 != null ? wSKeyStore2.getProperty("com.ibm.ssl.keyStorePassword") : sSLConfig2.getProperty("com.ibm.ssl.trustStorePassword"));
                    }
                    if (wSKeyStore2 != null && wSKeyStore2.getProperty("com.ibm.ssl.keyStoreType") != null || sSLConfig2.getProperty("com.ibm.ssl.trustStoreType") != null) {
                        System.setProperty("javax.net.ssl.trustStoreType", wSKeyStore2 != null ? wSKeyStore2.getProperty("com.ibm.ssl.keyStoreType") : sSLConfig2.getProperty("com.ibm.ssl.trustStoreType"));
                    }
                    if (wSKeyStore2 != null && wSKeyStore2.getProperty("com.ibm.ssl.keyStoreProvider") != null || sSLConfig2.getProperty("com.ibm.ssl.trustStoreProvider") != null) {
                        System.setProperty("javax.net.ssl.trustStoreProvider", wSKeyStore2 != null ? wSKeyStore2.getProperty("com.ibm.ssl.keyStoreProvider") : sSLConfig2.getProperty("com.ibm.ssl.trustStoreProvider"));
                    }
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set System JSSE properties using the following SSL config: " + sSLConfig.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultSystemPropertiesIfNecessary");
        }
    }

    public SSLConfig getDefaultSSLConfig() throws IllegalArgumentException {
        String string;
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultSSLConfig");
        }
        SSLConfig sSLConfig = null;
        String string2 = this.getGlobalProperty("com.ibm.ssl.defaultAlias");
        if (string2 != null && (sSLConfig = (SSLConfig)this.sslConfigMap.get(string2)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultSSLConfig: " + string2);
            }
            return sSLConfig;
        }
        if (sSLConfig == null) {
            object3 = this.sslConfigMap.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = (SSLConfig)object2.getValue();
                string = (String)object2.getKey();
                if (object == null) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDefaultSSLConfig: " + string);
                }
                return object;
            }
        }
        if (sSLConfig == null) {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            object3 = "DefaultSystemProperties";
            object2 = new SSLConfig();
            ((Properties)object2).setProperty("com.ibm.ssl.alias", (String)object3);
            object = System.getProperty("javax.net.ssl.keyStore");
            if (object != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.keyStore", (String)object);
            }
            if ((string = System.getProperty("javax.net.ssl.keyStorePassword")) != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.keyStorePassword", string);
            }
            if ((string8 = System.getProperty("javax.net.ssl.keyStoreType")) != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreType", string8);
            }
            if ((string7 = System.getProperty("javax.net.ssl.keyStoreProvider")) != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.keyStoreProvider", string7);
            }
            if ((string6 = System.getProperty("javax.net.ssl.trustStore")) != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.trustStore", string6);
            }
            if ((string5 = System.getProperty("javax.net.ssl.trustStorePassword")) != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.trustStorePassword", string5);
            }
            if ((string4 = System.getProperty("javax.net.ssl.trustStoreType")) != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.trustStoreType", string4);
            }
            if ((string3 = System.getProperty("javax.net.ssl.trustStoreProvider")) != null) {
                ((Properties)object2).setProperty("com.ibm.ssl.trustStoreProvider", string3);
            }
            try {
                if (((SSLConfig)object2).requiredPropertiesArePresent()) {
                    this.addSSLConfigToMap((String)object3, (SSLConfig)object2);
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception adding default System properties to configuration.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLConfigManager.getDefaultSSLConfig", "1206", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultSSLConfig -> null");
        }
        return null;
    }

    public Properties getPropertiesFromDynamicSelectionInfo(Map map) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesFromDynamicSelectionInfo", new Object[]{map});
        }
        if (map == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> null (no connection info)");
            }
            return null;
        }
        if (this.sslConfigDynamicSelectionMap.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> null (no dynamic selections configured)");
            }
            return null;
        }
        if (this.sslConfigDynamicSelectionCacheMissTreeSet.contains(map)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> previous cache miss.");
            }
            return null;
        }
        SSLConfig sSLConfig = (SSLConfig)this.sslConfigDynamicLookupCache.get(map);
        if (sSLConfig != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> cached.");
            }
            return sSLConfig;
        }
        String string = (String)map.get("com.ibm.ssl.direction");
        if (string != null && string.equals("inbound")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> null (direction inbound).");
            }
            return null;
        }
        String string2 = (String)map.get("com.ibm.ssl.endPointName");
        String string3 = (String)map.get("com.ibm.ssl.remoteHost");
        String string4 = (String)map.get("com.ibm.ssl.remotePort");
        if (string2 != null && string2.equals("ADMIN_SOAP") && (object = this.getSSLConfig("ADMIN_SOAP")) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> returning old soap config.");
            }
            this.sslConfigDynamicLookupCache.put(map, object);
            return object;
        }
        object = this.sslConfigDynamicSelectionMap.keySet();
        Iterator iterator = null;
        if (object != null && object.size() > 0) {
            iterator = object.iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String[] stringArray;
                String string5 = (String)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLConfig dynamic selection info: " + string5);
                }
                if (string5 == null || (stringArray = string5.split("\\|")) == null || stringArray.length <= 0) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Parsing entry " + i + " of " + stringArray.length + ": " + stringArray[i]);
                    }
                    String[] stringArray2 = stringArray[i].split(",");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This entry has " + stringArray2.length + " attributes.");
                    }
                    if (stringArray2 == null || stringArray2.length != 3) continue;
                    String string6 = stringArray2[0];
                    String string7 = stringArray2[1];
                    String string8 = stringArray2[2];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Protocol: " + string6 + ", Host: " + string7 + ", Port: " + string8);
                    }
                    if (string6 == null || string7 == null || string8 == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Ending evaluation, one of the values is null.");
                        continue;
                    }
                    if (!(string6.equals("*") || string2 != null && string6.equalsIgnoreCase(string2))) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Protocol does not match.");
                        continue;
                    }
                    if (!(string7.equals("*") || string3 != null && string3.equalsIgnoreCase(string7) && string3.endsWith(string7))) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Host does not match.");
                        continue;
                    }
                    if (!(string8.equals("*") || string4 != null && string8.equalsIgnoreCase(string4))) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Port does not match.");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found a dynamic selection match!");
                    }
                    String string9 = (String)this.sslConfigDynamicSelectionMap.get(string5);
                    String string10 = null;
                    String string11 = null;
                    if (string9 != null && string9.indexOf(":") != -1) {
                        object2 = string9.split(":");
                        if (object2 != null && ((String[])object2).length == 2) {
                            string10 = object2[0];
                            string11 = object2[1];
                        }
                    } else if (string9 != null) {
                        string10 = string9;
                    }
                    object2 = (String[])this.sslConfigMap.get(string10);
                    if (object2 != null) {
                        String string12;
                        if (!(string11 == null || (string12 = ((Properties)object2).getProperty("com.ibm.ssl.keyStoreClientAlias")) != null && string12.equals(string10))) {
                            object2 = new SSLConfig((Properties)object2);
                            ((Properties)object2).setProperty("com.ibm.ssl.keyStoreClientAlias", string11);
                        }
                        this.sslConfigDynamicLookupCache.put(map, object2);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> found.");
                        }
                        return object2;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Could not find the associated SSL configuration.");
                }
            }
        }
        if (this.sslConfigDynamicSelectionCacheMissTreeSet.size() > 50) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cache miss tree set size is > 50, clearing the TreeSet.");
            }
            this.sslConfigDynamicSelectionCacheMissTreeSet.clear();
        }
        this.sslConfigDynamicSelectionCacheMissTreeSet.add(map);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cache miss tree set size is " + this.sslConfigDynamicSelectionCacheMissTreeSet.size() + " entries.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesFromDynamicSelectionInfo -> null (not found).");
        }
        return null;
    }

    public Properties getProperties(String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties");
        }
        return this.getSSLConfig(string);
    }

    public String getGlobalProperty(String string) {
        String string2 = null;
        if (this.globalConfigProperties != null) {
            string2 = System.getProperty(string);
            if (string2 == null) {
                string2 = this.globalConfigProperties.getProperty(string);
            }
            if (tc.isDebugEnabled() && string2 != null) {
                Tr.debug(tc, "getGlobalProperties -> " + string2);
            }
            return string2;
        }
        string2 = System.getProperty(string);
        if (tc.isDebugEnabled() && string2 != null) {
            Tr.debug(tc, "getGlobalProperties -> " + string2);
        }
        return string2;
    }

    public String getGlobalProperty(String string, String string2) {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalProperty", new Object[]{string, string2});
        }
        if ((string3 = this.getGlobalProperty(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGlobalProperty -> " + string2);
            }
            return string2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalProperty -> " + string3);
        }
        return string3;
    }

    public String[] parseEnabledCiphers(String string) {
        if (string != null) {
            return string.split("\\s");
        }
        return null;
    }

    public String[] adjustSupportedCiphersToSecurityLevel(String[] stringArray, String string) {
        return Constants.adjustSupportedCiphersToSecurityLevel(stringArray, string);
    }

    public String convertCipherListToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public String getSecurityLevel(SSLSecurityLevel sSLSecurityLevel) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityLevel");
        }
        int n = sSLSecurityLevel.getValue();
        String string = null;
        switch (n) {
            case 2: {
                string = "LOW";
                break;
            }
            case 1: {
                string = "MEDIUM";
                break;
            }
            case 3: {
                string = "CUSTOM";
                break;
            }
            default: {
                string = "HIGH";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityLevel -> " + string);
        }
        return string;
    }

    public static String mask(String string) {
        String string2 = null;
        if (string != null) {
            char[] cArray = new char[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                cArray[i] = 42;
            }
            string2 = new String(cArray);
        }
        return string2;
    }

    public void parseConfigURL(String string, String string2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseConfigURL", new Object[]{string2});
        }
        if (string2 != null && (!this.clientFilesAlreadyProcessed.contains(string2) || bl)) {
            try {
                SSLConfig sSLConfig;
                SSLConfig sSLConfig2 = new SSLConfig(string2);
                String string3 = sSLConfig2.getProperty("com.ibm.ssl.alias");
                if (string3 == null) {
                    string3 = string;
                    sSLConfig2.setProperty("com.ibm.ssl.alias", string3);
                }
                if (string2.indexOf("soap.client.props") != -1) {
                    if (sSLConfig2.getProperty("com.ibm.ssl.keyStoreType") == null) {
                        sSLConfig2.setProperty("com.ibm.ssl.keyStoreType", "JKS");
                    }
                    if (sSLConfig2.getProperty("com.ibm.ssl.trustStoreType") == null) {
                        sSLConfig2.setProperty("com.ibm.ssl.trustStoreType", "JKS");
                    }
                }
                if (sSLConfig2.requiredPropertiesArePresent()) {
                    sSLConfig2.setProperty("com.ibm.ssl.configURLLoadedFrom", string2);
                    sSLConfig2.decodePasswords();
                    if (bl) {
                        SSLConfig sSLConfig3 = (SSLConfig)this.sslConfigMap.get(string3);
                        if (sSLConfig3 == null) {
                            this.addSSLConfigToMap(string3, sSLConfig2);
                        } else if (!sSLConfig3.equals(sSLConfig2)) {
                            this.removeSSLConfigFromMap(string3, sSLConfig2);
                            this.addSSLConfigToMap(string3, sSLConfig2);
                            this.notifySSLConfigChangeListener(string3, "changed");
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New SSL config equals old SSL config for alias: " + string3);
                        }
                    } else {
                        this.addSSLConfigToMap(string3, sSLConfig2);
                    }
                } else if (bl && (sSLConfig = (SSLConfig)this.sslConfigMap.get(string3)) != null) {
                    this.removeSSLConfigFromMap(string3, sSLConfig);
                    this.notifySSLConfigChangeListener(string3, "deleted");
                }
                this.clientFilesAlreadyProcessed.add(string2);
            }
            catch (Exception exception) {
                Tr.error(tc, "ssl.client.config.parse.CWPKI0019E", new Object[]{string2, exception.getMessage()});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception parsing SSL properties from ConfigURL.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLConfigManager.parseConfigURL", "1737", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseConfigURL");
        }
    }

    public void parseSSLConfigURL(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSSLConfigURL", new Object[]{string, new Boolean(bl)});
        }
        if (string != null && (!this.clientFilesAlreadyProcessed.contains(string) || bl)) {
            try {
                Object object;
                Object object2;
                Object object3;
                int n;
                String[] stringArray = null;
                HashSet<Object> hashSet = null;
                if (bl) {
                    hashSet = new HashSet<Object>();
                    stringArray = this.sslConfigMap.keySet().toArray(new String[0]);
                }
                SSLConfig sSLConfig = new SSLConfig();
                SSLConfig[] sSLConfigArray = sSLConfig.loadPropertiesFile(string, true);
                for (n = 0; n < sSLConfigArray.length; ++n) {
                    if (n == 0 && sSLConfigArray[0] != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Getting global SSL properties.");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, sSLConfigArray[n].toString());
                        }
                        this.globalConfigProperties.putAll(sSLConfigArray[0]);
                        continue;
                    }
                    if (sSLConfigArray[n] == null || !sSLConfigArray[n].requiredPropertiesArePresent()) continue;
                    object3 = sSLConfigArray[n];
                    object2 = ((Properties)object3).getProperty("com.ibm.ssl.alias");
                    ((Properties)object3).setProperty("com.ibm.ssl.configURLLoadedFrom", string);
                    ((SSLConfig)object3).decodePasswords();
                    if (bl) {
                        hashSet.add(object2);
                        object = (SSLConfig)this.sslConfigMap.get(object2);
                        if (object == null) {
                            this.addSSLConfigToMap((String)object2, (SSLConfig)object3);
                            continue;
                        }
                        if (!((SSLConfig)object).equals(object3)) {
                            this.removeSSLConfigFromMap((String)object2, (SSLConfig)object3);
                            this.addSSLConfigToMap((String)object2, (SSLConfig)object3);
                            this.notifySSLConfigChangeListener((String)object2, "changed");
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "New SSL config equals old SSL config for alias: " + (String)object2);
                        continue;
                    }
                    this.addSSLConfigToMap((String)object2, (SSLConfig)object3);
                }
                this.clientFilesAlreadyProcessed.add(string);
                if (bl) {
                    for (n = 0; n < stringArray.length; ++n) {
                        object3 = stringArray[n];
                        object2 = (SSLConfig)this.sslConfigMap.get(object3);
                        object = ((Properties)object2).getProperty("com.ibm.ssl.configURLLoadedFrom");
                        if (object2 == null || hashSet.contains(object3) || !((String)object).equals(string)) continue;
                        this.removeSSLConfigFromMap((String)object3, (SSLConfig)object2);
                        this.notifySSLConfigChangeListener((String)object3, "deleted");
                    }
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "ssl.client.config.parse.CWPKI0019E", new Object[]{string, exception.getMessage()});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception parsing SSL properties from ssl.client.props.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLConfigManager.parseSSLConfigURL", "1868", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSSLConfigURL");
        }
    }

    private void removeSSLConfigFromMap(String string, SSLConfig sSLConfig) throws Exception {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSSLConfigFromMap", new Object[]{string});
        }
        if ((string2 = sSLConfig.getDynamicSelectionProperty()) != null && !string2.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing old SSL properties from dynamic selection info list.");
            }
            this.sslConfigDynamicSelectionMap.remove(string2);
        }
        this.sslConfigMap.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeSSLConfigFromMap");
        }
    }

    public void addSSLConfigToMap(String string, SSLConfig sSLConfig) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSSLConfigToMap");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding SSL properties for alias: " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, sSLConfig.toString());
        }
        sSLConfig.expandPaths();
        if (this.validationEnabled()) {
            sSLConfig.validateSSLConfig();
        }
        if (!this.isServerProcess) {
            KeyStoreManager.getInstance().checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot(sSLConfig);
        }
        this.sslConfigMap.put(string, sSLConfig);
        String string2 = sSLConfig.getDynamicSelectionProperty();
        if (string2 != null && !string2.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding SSL properties to dynamic selection list with value: " + string2);
            }
            this.sslConfigDynamicSelectionMap.put(string2, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSSLConfigToMap");
        }
    }

    public String toString() {
        if (this.sslConfigMap.size() > 0) {
            Iterator iterator = this.sslConfigMap.entrySet().iterator();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SSLConfigManager configuration: \n");
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SSLConfig sSLConfig = (SSLConfig)entry.getValue();
                String string = (String)entry.getKey();
                stringBuffer.append(string);
                stringBuffer.append("===");
                stringBuffer.append(sSLConfig.toString());
            }
            return stringBuffer.toString();
        }
        return "SSLConfigManager does not contain any SSL configurations.";
    }

    public boolean validationEnabled() {
        String string = this.getGlobalProperty("com.ibm.ssl.validationEnabled");
        return string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"));
    }

    public void checkURLHostNameVerificationProperty(boolean bl) {
        String string = this.getGlobalProperty("com.ibm.ssl.performURLHostNameVerification");
        if (string == null || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no")) {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            if (!bl) {
                Tr.info(tc, "ssl.disable.url.hostname.verification.CWPKI0027I");
            }
        }
    }

    public synchronized void notifySSLConfigChangeListener(String string, String string2) {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifySSLConfigChangeListener", new Object[]{string, string2});
        }
        if (string != null && (list = (List)this.sslConfigListenerMap.get(string)) != null && list.size() > 0) {
            SSLConfigChangeListener[] sSLConfigChangeListenerArray = list.toArray(new SSLConfigChangeListener[list.size()]);
            for (int i = 0; i < sSLConfigChangeListenerArray.length; ++i) {
                SSLConfigChangeEvent sSLConfigChangeEvent = null;
                sSLConfigChangeEvent = (SSLConfigChangeEvent)this.sslConfigListenerEventMap.get(sSLConfigChangeListenerArray[i]);
                if (sSLConfigChangeEvent == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Notifying listener[" + i + "]: " + sSLConfigChangeListenerArray[i].getClass().getName());
                }
                sSLConfigChangeEvent.setState(string2);
                SSLConfig sSLConfig = (SSLConfig)this.sslConfigMap.get(string);
                sSLConfigChangeEvent.setChangedSSLConfig(sSLConfig);
                sSLConfigChangeListenerArray[i].stateChanged(sSLConfigChangeEvent);
                if (!string2.equals("deleted")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deregistering event for listener.");
                }
                this.sslConfigListenerEventMap.remove(sSLConfigChangeListenerArray[i]);
            }
            if (string2.equals("deleted")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deregistering all listeners for this alias due to alias deletion.");
                }
                this.sslConfigListenerMap.remove(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifySSLConfigChangeListener");
        }
    }

    public synchronized void registerSSLConfigChangeListener(SSLConfigChangeListener sSLConfigChangeListener, SSLConfigChangeEvent sSLConfigChangeEvent) {
        ArrayList<SSLConfigChangeListener> arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSSLConfigChangeListener", new Object[]{sSLConfigChangeListener, sSLConfigChangeEvent});
        }
        if ((arrayList = (ArrayList<SSLConfigChangeListener>)this.sslConfigListenerMap.get(sSLConfigChangeEvent.getAlias())) != null) {
            arrayList.add(sSLConfigChangeListener);
            this.sslConfigListenerMap.put(sSLConfigChangeEvent.getAlias(), arrayList);
        } else {
            arrayList = new ArrayList<SSLConfigChangeListener>();
            arrayList.add(sSLConfigChangeListener);
            this.sslConfigListenerMap.put(sSLConfigChangeEvent.getAlias(), arrayList);
        }
        this.sslConfigListenerEventMap.put(sSLConfigChangeListener, sSLConfigChangeEvent);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSSLConfigChangeListener");
        }
    }

    public synchronized void deregisterSSLConfigChangeListener(SSLConfigChangeListener sSLConfigChangeListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterSSLConfigChangeListener", new Object[]{sSLConfigChangeListener});
        }
        SSLConfigChangeEvent sSLConfigChangeEvent = null;
        if (sSLConfigChangeListener != null && this.sslConfigListenerEventMap.containsKey(sSLConfigChangeListener)) {
            sSLConfigChangeEvent = (SSLConfigChangeEvent)this.sslConfigListenerEventMap.get(sSLConfigChangeListener);
        }
        if (sSLConfigChangeEvent != null) {
            int n;
            List list;
            String string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing listener: " + sSLConfigChangeListener.getClass().getName());
            }
            if (this.sslConfigListenerMap.containsKey(string = sSLConfigChangeEvent.getAlias()) && (list = (List)this.sslConfigListenerMap.get(string)) != null && (n = list.indexOf(sSLConfigChangeListener)) != -1) {
                list.remove(n);
            }
            this.sslConfigListenerEventMap.remove(sSLConfigChangeListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterSSLConfigChangeListener");
        }
    }

    public boolean isServerProcess() {
        return this.isServerProcess;
    }

    public String[] getSystemSSLCiphers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemSSLCiphers");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        if (this.isExtendedPolicy()) {
            bl = true;
        }
        for (int i = 0; i < SystemSSLCiphers.length; ++i) {
            if (SystemSSLCiphers[i][1].indexOf("AES_256") != -1) {
                if (!bl) continue;
                arrayList.add(SystemSSLCiphers[i][1]);
                continue;
            }
            arrayList.add(SystemSSLCiphers[i][1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemSSLCiphers");
        }
        return arrayList.toArray(new String[0]);
    }

    public String convertCiphersList(String string) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertCiphersList", new Object[]{string});
        }
        String[] stringArray = new String[SystemSSLCiphers.length];
        String[] stringArray2 = string.split(" ");
        block0: for (int i = 0; i < stringArray2.length; ++i) {
            for (n = 0; n < SystemSSLCiphers.length; ++n) {
                if (!SystemSSLCiphers[n][1].equals(stringArray2[i])) continue;
                stringArray[n] = SystemSSLCiphers[n][0];
                continue block0;
            }
        }
        String string2 = "";
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            string2 = string2 + stringArray[n];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertCiphersList");
        }
        return string2;
    }

    public String getSystemSSLList(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemSSLList", new Object[]{string});
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); i += 2) {
            String string2 = string.substring(i, i + 2);
            for (int j = 0; j < SystemSSLCiphers.length; ++j) {
                if (!SystemSSLCiphers[j][0].equals(string2)) continue;
                stringBuffer.append(SystemSSLCiphers[i][1]);
                stringBuffer.append(" ");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemSSLList");
        }
        return stringBuffer.toString();
    }

    private boolean isExtendedPolicy() {
        boolean bl;
        block2: {
            bl = false;
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("AES");
                keyPairGenerator.initialize(256);
                bl = true;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Extened policy is not availible");
            }
        }
        return bl;
    }

    public SSLSocket setCipherListOnSocket(Properties properties, SSLSocket sSLSocket) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setCipherListOnSocket");
            }
            String[] stringArray = null;
            String string = properties.getProperty("com.ibm.ssl.enabledCipherSuites");
            if (sSLSocket != null) {
                try {
                    if (string != null) {
                        stringArray = string.split("\\s");
                    } else {
                        String string2 = properties.getProperty("com.ibm.ssl.securityLevel");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "securityLevel from properties is " + string2);
                        }
                        if (string2 == null) {
                            string2 = "HIGH";
                        }
                        String[] stringArray2 = sSLSocket.getSupportedCipherSuites();
                        stringArray = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(stringArray2, string2);
                    }
                    if (stringArray != null) {
                        sSLSocket.setEnabledCipherSuites(stringArray);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Exception setting ciphers in SSL Socket Factory.", new Object[]{exception});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCipherListOnSocket");
        }
        return sSLSocket;
    }

    public SSLServerSocket setCipherListOnServerSocket(Properties properties, SSLServerSocket sSLServerSocket) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setCipherListOnServerSocket");
            }
            String[] stringArray = null;
            String string = properties.getProperty("com.ibm.ssl.enabledCipherSuites");
            if (sSLServerSocket != null) {
                try {
                    Object object;
                    String string2;
                    if (string != null) {
                        stringArray = string.split("\\s");
                    } else {
                        string2 = properties.getProperty("com.ibm.ssl.securityLevel");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "securityLevel from properties is " + string2);
                        }
                        if (string2 == null) {
                            string2 = "HIGH";
                        }
                        object = sSLServerSocket.getSupportedCipherSuites();
                        stringArray = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel((String[])object, string2);
                    }
                    if (stringArray != null) {
                        sSLServerSocket.setEnabledCipherSuites(stringArray);
                    }
                    if ((string2 = properties.getProperty("com.ibm.ssl.clientAuthenticationSupported")) != null && string2.equals("true")) {
                        sSLServerSocket.setWantClientAuth(true);
                    }
                    if ((object = properties.getProperty("com.ibm.ssl.clientAuthentication")) != null && ((String)object).equals("true")) {
                        sSLServerSocket.setNeedClientAuth(true);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Exception setting ciphers in SSL Socket Factory.", new Object[]{exception});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCipherListOnServerSocket");
        }
        return sSLServerSocket;
    }
}

