/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferImpl;
import com.ibm.ws.tcp.channel.impl.CancelRequest;
import com.ibm.ws.tcp.channel.impl.ChannelSelector;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

public class NioSocketIOChannel
extends SocketIOChannel {
    private static final TraceComponent tc = Tr.register(NioSocketIOChannel.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    protected ChannelSelector channelSelectorRead = null;
    protected ChannelSelector channelSelectorWrite = null;
    protected Selector selectorRead = null;
    protected Selector selectorWrite = null;

    protected NioSocketIOChannel(Socket socket, TCPChannel tCPChannel) {
        super(socket, tCPChannel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "NioSocketIOChannel");
        }
        this.checkCancel = TCPFactoryConfiguration.getCancelKeyOnClose() != 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "NioSocketIOChannel");
        }
    }

    protected static SocketIOChannel createIOChannel(Socket socket, TCPChannel tCPChannel) {
        NioSocketIOChannel nioSocketIOChannel = new NioSocketIOChannel(socket, tCPChannel);
        return nioSocketIOChannel;
    }

    protected SelectionKey register(Selector selector, int n, Object object) throws ClosedChannelException {
        return this.channel.register(selector, n, object);
    }

    protected void setSelectorRead(Selector selector) {
        this.selectorRead = selector;
    }

    protected void setSelectorWrite(Selector selector) {
        this.selectorWrite = selector;
    }

    protected void setChannelSelectorRead(ChannelSelector channelSelector) {
        this.channelSelectorRead = channelSelector;
    }

    protected void setChannelSelectorWrite(ChannelSelector channelSelector) {
        this.channelSelectorWrite = channelSelector;
    }

    protected ChannelSelector getChannelSelectorRead() {
        return this.channelSelectorRead;
    }

    protected ChannelSelector getChannelSelectorWrite() {
        return this.channelSelectorWrite;
    }

    protected long attemptReadFromSocketUsingNIO(TCPReadRequestContextImpl tCPReadRequestContextImpl, WsByteBuffer[] wsByteBufferArray) throws IOException {
        long l = 0L;
        if (wsByteBufferArray.length == 1) {
            if (!wsByteBufferArray[0].isDirect() && wsByteBufferArray[0].hasArray()) {
                try {
                    WsByteBufferImpl wsByteBufferImpl = (WsByteBufferImpl)wsByteBufferArray[0];
                    wsByteBufferImpl.setParmsToDirectBuffer();
                    l = this.read(wsByteBufferImpl.oWsBBDirect);
                    wsByteBufferImpl.copyFromDirectBuffer((int)l);
                }
                catch (ClassCastException classCastException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Reading with a Buffer which is not a WsByteBufferImpl, may hurt performance");
                    }
                    l = this.read(wsByteBufferArray[0].getWrappedByteBuffer());
                }
            } else {
                l = this.read(wsByteBufferArray[0].getWrappedByteBuffer());
            }
        } else {
            ByteBuffer[] byteBufferArray = tCPReadRequestContextImpl.preProcessReadBuffers();
            l = this.read(byteBufferArray);
            tCPReadRequestContextImpl.postProcessReadBuffers(l);
        }
        return l;
    }

    protected long attemptWriteToSocketUsingNIO(TCPBaseRequestContext tCPBaseRequestContext, WsByteBuffer[] wsByteBufferArray) throws IOException {
        long l = 0L;
        if (wsByteBufferArray.length == 1) {
            if (!wsByteBufferArray[0].isDirect() && wsByteBufferArray[0].hasArray()) {
                WsByteBufferImpl wsByteBufferImpl = null;
                try {
                    wsByteBufferImpl = (WsByteBufferImpl)wsByteBufferArray[0];
                    wsByteBufferImpl.copyToDirectBuffer();
                    l = this.write(wsByteBufferImpl.oWsBBDirect);
                    wsByteBufferImpl.setParmsFromDirectBuffer();
                }
                catch (ClassCastException classCastException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Writing with a buffer which is not a WsByteBufferImpl, may hurt performance");
                    }
                    l = this.write(wsByteBufferArray[0].getWrappedByteBuffer());
                }
            } else {
                l = this.write(wsByteBufferArray[0].getWrappedByteBuffer());
            }
        } else {
            int n;
            boolean bl = false;
            for (n = 0; n < wsByteBufferArray.length && wsByteBufferArray[n] != null; ++n) {
                if (wsByteBufferArray[n].isDirect() || !wsByteBufferArray[n].hasArray()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                l = this.write(tCPBaseRequestContext.getByteBufferArray());
            } else {
                try {
                    for (n = 0; n < wsByteBufferArray.length && wsByteBufferArray[n] != null; ++n) {
                        ((WsByteBufferImpl)wsByteBufferArray[n]).copyToDirectBuffer();
                    }
                    tCPBaseRequestContext.setBuffersToDirect(wsByteBufferArray);
                    l = this.write(tCPBaseRequestContext.getByteBufferArrayDirect());
                    for (n = 0; n < wsByteBufferArray.length && wsByteBufferArray[n] != null; ++n) {
                        ((WsByteBufferImpl)wsByteBufferArray[n]).setParmsFromDirectBuffer();
                    }
                }
                catch (ClassCastException classCastException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Writing with Buffers which are not WsByteBufferImpl, may hurt performance");
                    }
                    l = this.write(tCPBaseRequestContext.getByteBufferArray());
                }
            }
        }
        return l;
    }

    protected int read(ByteBuffer byteBuffer) throws IOException {
        return this.channel.read(byteBuffer);
    }

    protected long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.channel.read(byteBufferArray);
    }

    protected int write(ByteBuffer byteBuffer) throws IOException {
        return this.channel.write(byteBuffer);
    }

    protected long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.channel.write(byteBufferArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block33: {
            super.close();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "close");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SocketChannel close starting, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress());
            }
            Object object = this;
            synchronized (object) {
                if (this.closed) {
                    this.processClose = false;
                }
                this.closed = true;
            }
            if (this.processClose && !this.blockingChannel) {
                if (this.checkCancel && this.cc.isDispatchWorkToThreads()) {
                    Object object2;
                    CancelRequest cancelRequest;
                    Object object3;
                    if (this.selectorRead != null && (object = this.channel.keyFor(this.selectorRead)) != null) {
                        object3 = new Object();
                        cancelRequest = new CancelRequest((SelectionKey)object, object3);
                        object2 = object3;
                        synchronized (object2) {
                            block31: {
                                this.channelSelectorRead.addCancelRequest(cancelRequest);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "waiting for key to be canceled, key is " + object);
                                }
                                try {
                                    object3.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block31;
                                    Tr.debug(tc, "Interrupted while waiting for read cancel request to complete...InterruptedException caught");
                                }
                            }
                        }
                    }
                    if (this.selectorWrite != null && (object = this.channel.keyFor(this.selectorWrite)) != null) {
                        object3 = new Object();
                        cancelRequest = new CancelRequest((SelectionKey)object, object3);
                        object2 = object3;
                        synchronized (object2) {
                            block32: {
                                this.channelSelectorWrite.addCancelRequest(cancelRequest);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "waiting for key to be canceled, key is " + object);
                                }
                                try {
                                    object3.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block32;
                                    Tr.debug(tc, "Interrupted while waiting for read cancel request to complete...InterruptedException caught");
                                }
                            }
                        }
                    }
                }
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "SocketChannel close, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress());
                    }
                    if (this.channel != null) {
                        this.channel.close();
                    }
                    if (this.selectorRead != null) {
                        this.selectorRead.wakeup();
                    }
                    if (this.selectorWrite != null) {
                        this.selectorWrite.wakeup();
                    }
                    break block33;
                }
                catch (IOException iOException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "IOException while closing channel");
                    }
                    break block33;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "close called on channel already closed, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    protected Object[] buildDumpList() {
        Object[] objectArray = new Object[2];
        if (this.channelSelectorRead != null) {
            objectArray[0] = this.channelSelectorRead;
        } else if (this.channelSelectorWrite != null) {
            objectArray[0] = this.channelSelectorWrite;
        }
        return objectArray;
    }

    protected String getFFDCDumpData() {
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = new StringBuffer("SocketIOChannel Data");
            stringBuffer.append("\nSocket: " + this.getSocket().toString());
            stringBuffer.append("\nSocketChannel: " + this.getChannel().toString());
            stringBuffer.append("\nRemote InetAddress: " + this.getSocket().getInetAddress());
            stringBuffer.append("\nRemote Port: " + this.getSocket().getPort());
            stringBuffer.append("\nLocal InetAddress: " + this.getSocket().getLocalAddress());
            stringBuffer.append("\nLocal Port: " + this.getSocket().getLocalPort());
        }
        catch (Exception exception) {
            stringBuffer.append("\nException Occurred Gathering Dump Data: " + exception);
        }
        return stringBuffer.toString();
    }
}

