/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.ChannelSelector;
import com.ibm.ws.tcp.channel.impl.NioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPChannelLinkedList;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.ws.tcp.channel.impl.WorkQueueManager;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Set;

public class SocketRWChannelSelector
extends ChannelSelector
implements Runnable {
    private static final TraceComponent tc = Tr.register(SocketRWChannelSelector.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    WorkQueueManager wqm = null;
    int countIndex = -1;
    int channelType;
    int wakeupOption;
    int pruningThreshold = 1;
    static int BATCH_SIZE = 50;
    TCPBaseRequestContext[] batchedWork = new TCPBaseRequestContext[BATCH_SIZE];

    protected SocketRWChannelSelector(boolean bl, int n, WorkQueueManager workQueueManager, int n2, int n3, boolean bl2, int n4) throws IOException {
        super(bl, bl2);
        this.wqm = workQueueManager;
        this.countIndex = n2;
        this.channelType = n3;
        this.wakeupOption = n;
        this.pruningThreshold = n4;
    }

    protected SocketRWChannelSelector(boolean bl, int n, WorkQueueManager workQueueManager, int n2, int n3, boolean bl2) throws IOException {
        this(bl, n, workQueueManager, n2, n3, bl2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWork(Object object) {
        TCPChannelLinkedList tCPChannelLinkedList = this.ourWorkQueue;
        synchronized (tCPChannelLinkedList) {
            this.ourWorkQueue.add(object);
        }
        if ((this.wakeupOption == ValidateUtils.SELECTOR_WAKEUP_WHEN_NEEDED || this.wakeupOption == ValidateUtils.SELECTOR_WAKEUP_IF_NO_FORCE_QUEUE && !((TCPBaseRequestContext)object).isForceQueue()) && !this.wakeupPending) {
            this.wakeupPending = true;
            this.selector.wakeup();
        }
    }

    protected boolean performRequest() {
        VirtualConnection virtualConnection = null;
        boolean bl = true;
        Set<SelectionKey> set = this.selector.selectedKeys();
        Iterator<SelectionKey> iterator = set.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "performRequest - processing " + set.size() + " items");
        }
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            iterator.remove();
            TCPBaseRequestContext tCPBaseRequestContext = (TCPBaseRequestContext)selectionKey.attachment();
            virtualConnection = tCPBaseRequestContext.oTCPConnLink.getVirtualConnection();
            bl = true;
            if (virtualConnection == null) {
                bl = false;
            } else if (virtualConnection.isInputStateTrackingOperational() && !tCPBaseRequestContext.blockedThread) {
                bl = false;
                if (tCPBaseRequestContext.isRequestTypeRead()) {
                    if (virtualConnection.requestPermissionToFinishRead()) {
                        bl = true;
                    }
                } else if (virtualConnection.requestPermissionToFinishWrite()) {
                    bl = true;
                }
            }
            if (bl) {
                if (!this.wqm.dispatcher(tCPBaseRequestContext, null)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "set interestOps to 0 for key " + selectionKey);
                }
                try {
                    selectionKey.interestOps(0);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
                tCPBaseRequestContext.setWaitingForIO(false);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "read or write cancelled because Close has been detected, key " + selectionKey);
            }
            try {
                selectionKey.interestOps(0);
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelector() {
        VirtualConnection virtualConnection = null;
        int n = 0;
        boolean bl = true;
        while (bl) {
            n = 0;
            TCPChannelLinkedList tCPChannelLinkedList = this.ourWorkQueue;
            synchronized (tCPChannelLinkedList) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateSelector - processing " + this.ourWorkQueue.size() + " items");
                }
                while (bl && !this.ourWorkQueue.isEmpty()) {
                    this.batchedWork[n] = (TCPBaseRequestContext)this.ourWorkQueue.removeFirst();
                    if (++n < BATCH_SIZE) continue;
                }
            }
            if (n == 0) break;
            this.waitingToQuit = false;
            this.quit = false;
            for (int i = 0; i < n; ++i) {
                block43: {
                    Object object;
                    TCPConnLink tCPConnLink = this.batchedWork[i].getTCPConnLink();
                    int n2 = 0;
                    NioSocketIOChannel nioSocketIOChannel = (NioSocketIOChannel)tCPConnLink.getSocketIOChannel();
                    virtualConnection = tCPConnLink.getVirtualConnection();
                    if (virtualConnection == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                        Tr.event(tc, "update of selector cancelled for channel  " + nioSocketIOChannel.getChannel());
                        continue;
                    }
                    n2 = this.batchedWork[i].isRequestTypeRead() ? 1 : 4;
                    SelectionKey selectionKey = nioSocketIOChannel.getChannel().keyFor(this.selector);
                    if (selectionKey != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "changing interest ops for channel " + nioSocketIOChannel.getChannel() + "to " + n2 + " for key " + selectionKey);
                        }
                        if (virtualConnection.isInputStateTrackingOperational()) {
                            object = virtualConnection.getLockObject();
                            synchronized (object) {
                                selectionKey.interestOps(n2);
                                if (this.batchedWork[i].isRequestTypeRead()) {
                                    if (((TCPReadRequestContextImpl)this.batchedWork[i]).getReadCompletedCallback() != null) {
                                        virtualConnection.setReadStatetoCloseAllowedNoSync();
                                    }
                                } else if (((TCPWriteRequestContextImpl)this.batchedWork[i]).getWriteCompletedCallback() != null) {
                                    virtualConnection.setWriteStatetoCloseAllowedNoSync();
                                }
                                if (virtualConnection.getCloseWaiting()) {
                                    virtualConnection.getLockObject().notify();
                                }
                            }
                        } else {
                            selectionKey.interestOps(n2);
                        }
                    } else {
                        if (this.batchedWork[i].isRequestTypeRead()) {
                            nioSocketIOChannel.setChannelSelectorRead(this);
                            nioSocketIOChannel.setSelectorRead(this.selector);
                        } else {
                            nioSocketIOChannel.setChannelSelectorWrite(this);
                            nioSocketIOChannel.setSelectorWrite(this.selector);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "register with channel");
                        }
                        try {
                            if (virtualConnection.isInputStateTrackingOperational()) {
                                object = virtualConnection.getLockObject();
                                synchronized (object) {
                                    SelectionKey selectionKey2 = nioSocketIOChannel.register(this.selector, n2, this.batchedWork[i]);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                        Tr.event(tc, "registered channel " + nioSocketIOChannel.getChannel() + " with selector, key is " + selectionKey2);
                                    }
                                    this.updateCount();
                                    if (this.batchedWork[i].isRequestTypeRead()) {
                                        if (((TCPReadRequestContextImpl)this.batchedWork[i]).getReadCompletedCallback() != null) {
                                            virtualConnection.setReadStatetoCloseAllowedNoSync();
                                        }
                                    } else if (((TCPWriteRequestContextImpl)this.batchedWork[i]).getWriteCompletedCallback() != null) {
                                        virtualConnection.setWriteStatetoCloseAllowedNoSync();
                                    }
                                    if (virtualConnection.getCloseWaiting()) {
                                        virtualConnection.getLockObject().notify();
                                    }
                                    break block43;
                                }
                            }
                            object = nioSocketIOChannel.register(this.selector, n2, this.batchedWork[i]);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "registered channel " + nioSocketIOChannel.getChannel() + " with selector, key is " + object);
                            }
                            this.updateCount();
                        }
                        catch (ClosedChannelException closedChannelException) {
                            boolean bl2 = true;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "SocketChannel register for channel: " + nioSocketIOChannel + " failed, exception is: " + closedChannelException);
                            }
                            if (virtualConnection.isInputStateTrackingOperational() && !this.batchedWork[i].blockedThread) {
                                bl2 = false;
                                if (this.batchedWork[i].isRequestTypeRead()) {
                                    if (virtualConnection.requestPermissionToFinishRead()) {
                                        bl2 = true;
                                    }
                                } else if (virtualConnection.requestPermissionToFinishWrite()) {
                                    bl2 = true;
                                }
                            }
                            if (!bl2 || this.wqm.dispatcher(this.batchedWork[i], closedChannelException)) continue;
                            this.addWork(this.batchedWork[i]);
                            continue;
                        }
                    }
                }
                this.batchedWork[i].setWaitingForIO(true);
                if (!this.batchedWork[i].hasTimeout()) continue;
                this.selectorContainsRequestsWithTimeouts = true;
                if (this.batchedWork[i].getTimeoutTime() >= this.nextTimeoutTime) continue;
                this.nextTimeoutTime = this.batchedWork[i].getTimeoutTime();
            }
        }
    }

    protected void updateCount() {
        int n = this.selector.keys().size();
        if (n > 0) {
            this.waitingToQuit = false;
        }
        this.wqm.updateCount(this.countIndex, n, this.channelType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelSelectorClose() {
        Object object = this.wqm.shutdownSync;
        synchronized (object) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.wqm.updateCount(this.countIndex, WorkQueueManager.CS_NULL, this.channelType);
        }
    }

    protected void checkForTimeouts() {
        if (this.currentTime >= this.nextTimeoutTime) {
            Set<SelectionKey> set = this.selector.keys();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "checkForTimeouts - checking " + set.size() + " keys for timeouts");
            }
            if (set.isEmpty()) {
                if (this.countIndex >= this.pruningThreshold) {
                    if (this.waitingToQuit) {
                        this.quit = true;
                    } else {
                        this.wqm.updateCount(this.countIndex, WorkQueueManager.CS_DELETE_IN_PROGRESS, this.channelType);
                        this.waitingToQuit = true;
                        this.nextTimeoutTime = this.currentTime + (long)TCPFactoryConfiguration.getChannelSelectorWaitToTerminate();
                    }
                } else {
                    this.nextTimeoutTime = this.currentTime + (long)TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
                }
            } else {
                this.waitingToQuit = false;
                Iterator<SelectionKey> iterator = set.iterator();
                this.nextTimeoutTime = this.currentTime + (long)TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
                SelectionKey selectionKey = null;
                while (iterator.hasNext()) {
                    selectionKey = iterator.next();
                    try {
                        TCPBaseRequestContext tCPBaseRequestContext;
                        int n = selectionKey.interestOps();
                        if (n <= 0 || !(tCPBaseRequestContext = (TCPBaseRequestContext)selectionKey.attachment()).hasTimeout()) continue;
                        if (tCPBaseRequestContext.getTimeoutTime() <= this.currentTime) {
                            SocketTimeoutException socketTimeoutException;
                            TCPConnLink tCPConnLink = tCPBaseRequestContext.getTCPConnLink();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "Inactivity timeout on channel " + tCPConnLink.getSocketIOChannel().getChannel());
                            }
                            if (this.wqm.dispatcher(tCPBaseRequestContext, socketTimeoutException = new SocketTimeoutException("Socket operation timed out before it could be completed"))) {
                                selectionKey.interestOps(0);
                                continue;
                            }
                            this.nextTimeoutTime = this.currentTime;
                            continue;
                        }
                        if (tCPBaseRequestContext.getTimeoutTime() >= this.nextTimeoutTime) continue;
                        this.nextTimeoutTime = tCPBaseRequestContext.getTimeoutTime();
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "checkForTimeouts bypassing timeout processing");
        }
    }
}

