/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ImplFactory {
    private static TraceComponent tc = Tr.register(ImplFactory.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static final String IF_PLUGIN_PATH = "META-INF/impl-factory.xml";
    private static Map _map;
    private static boolean _inEclipseEnvironment;
    static final String DISTRIBUTED = "distributed";
    static final String ZSERIES = "zos";
    static final String ISERIES = "os400";
    static final String ALL = "all";
    static final String PLATFORM = "platform";
    private static String actualPlatformString;

    private static boolean equivalent(String string, Object object) {
        if (object instanceof IConfigurationElement) {
            return string.equals(((IConfigurationElement)object).getAttribute("impl"));
        }
        if (object instanceof String) {
            return object.equals(string);
        }
        return false;
    }

    private static List parseExtensionPoint(List list) {
        _inEclipseEnvironment = ExtensionRegistryFactory.instance().isEclipse();
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry == null) {
            return list;
        }
        String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".impl-factory";
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        if (iExtensionPoint == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "extension point: " + string + " is null");
            }
            return list;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            IExtension iExtension = iExtensionArray[i];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                if (!iConfigurationElementArray[j].getName().equals("factories")) continue;
                FactoryList factoryList = new FactoryList();
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[j].getChildren();
                for (int k = 0; k < iConfigurationElementArray2.length; ++k) {
                    Object object;
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray2[k];
                    String string2 = iConfigurationElement.getName();
                    if (string2.equals("rank")) {
                        object = iConfigurationElement.getAttribute("value");
                        try {
                            factoryList.rank = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            FFDCFilter.processException(numberFormatException, "com.ibm.ws.util.ImplFactory.parseExtensionPoint", "229");
                            if (!tc.isEventEnabled()) continue;
                            Tr.event(tc, "Problem converting rank to number: " + (String)object, numberFormatException);
                        }
                        continue;
                    }
                    if (string2.equals("factory")) {
                        if (!ImplFactoryParsingHandler.validOn(iConfigurationElement.getAttribute(PLATFORM))) continue;
                        object = new Factory();
                        ((Factory)object).interfaceName = iConfigurationElement.getAttribute("interface");
                        ((Factory)object).implName = iConfigurationElement.getAttribute("impl");
                        ((Factory)object).configElement = iConfigurationElement;
                        if (((Factory)object).interfaceName == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "interface is null");
                            continue;
                        }
                        if (((Factory)object).implName == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "implementation is null");
                            continue;
                        }
                        String string3 = iConfigurationElement.getAttribute("override");
                        ((Factory)object).isOverride = string3 != null && string3.equalsIgnoreCase("true");
                        factoryList.factories.add(object);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "expecting <rank> or <factory>, but got <" + string2 + ">");
                }
                list.add(factoryList);
            }
        }
        return list;
    }

    private static List parseLegacyXmlFile(List list) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enumeration = classLoader.getResources(IF_PLUGIN_PATH);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        ImplFactoryParsingHandler implFactoryParsingHandler = new ImplFactoryParsingHandler();
        xMLReader.setContentHandler(implFactoryParsingHandler);
        xMLReader.setDTDHandler(implFactoryParsingHandler);
        xMLReader.setEntityResolver(implFactoryParsingHandler);
        xMLReader.setErrorHandler(implFactoryParsingHandler);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            try {
                xMLReader.parse(new InputSource(uRL.openStream()));
                FactoryList factoryList = new FactoryList();
                factoryList.rank = implFactoryParsingHandler.rank;
                factoryList.factories.addAll(implFactoryParsingHandler.getFactories());
                list.add(factoryList);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.util.ImplFactory.parseLegacyXmlFile", "308");
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Exception caught parsing " + uRL, exception);
            }
        }
        return list;
    }

    public static Object loadImplFromKey(String string) {
        Class clazz = ImplFactory.loadClassFromKey(string);
        return ImplFactory.loadImplFromClass(clazz);
    }

    public static Object loadImplFromKey(Class clazz) {
        return ImplFactory.loadImplFromKey(clazz.getName());
    }

    public static Object loadImplFromClass(String string) {
        try {
            Class clazz = ImplFactory.loadClass(string);
            return ImplFactory.loadImplFromClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.util.ImplFactory.loadImplFromClass", "334");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "ClassNotFoundException caught loading class " + string, classNotFoundException);
            }
            throw new IllegalStateException(classNotFoundException.getMessage());
        }
    }

    public static Object loadImplFromClass(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.util.ImplFactory.loadImplFromClass", "345");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Exception caught creating new instance of " + clazz, throwable);
            }
            throw new IllegalStateException(clazz.getName() + " is not a valid class.");
        }
    }

    public static Class loadClassFromKey(Class clazz) {
        return ImplFactory.loadClassFromKey(clazz.getName());
    }

    public static Class loadClassFromKey(String string) {
        Object v = _map.get(string);
        Class clazz = null;
        if (v == null) {
            throw new NoClassDefFoundError("Invalid Implementation Key, " + string);
        }
        try {
            clazz = ImplFactory.loadClass(v);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.util.ImplFactory.loadClassFromKey", "377");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Exception caught loading class for key " + string, exception);
            }
            throw new IllegalStateException(exception.getMessage());
        }
        return clazz;
    }

    private static Class loadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return ImplFactory.class.getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                FFDCFilter.processException(classNotFoundException2, "com.ibm.ws.util.ImplFactory.loadClass", "581");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "ClassNotFoundException caught loading class " + string, classNotFoundException2);
                }
                throw classNotFoundException;
            }
        }
    }

    private static Class loadClass(Object object) throws ClassNotFoundException {
        if (object instanceof IConfigurationElement) {
            IConfigurationElement iConfigurationElement = (IConfigurationElement)object;
            final String string = iConfigurationElement.getAttribute("impl");
            if (_inEclipseEnvironment) {
                try {
                    String string2 = iConfigurationElement.getNamespace();
                    final Bundle bundle = Platform.getBundle((String)string2);
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(string);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException(privilegedActionException, "com.ibm.ws.util.ImplFactory.loadClass", "610");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught loading class " + string, privilegedActionException);
                    }
                    if (privilegedActionException.getCause() instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)privilegedActionException.getCause();
                    }
                    throw new ClassNotFoundException(string, privilegedActionException);
                }
            }
            try {
                Object object2 = ((IConfigurationElement)object).createExecutableExtension("impl");
                return object2.getClass();
            }
            catch (Throwable throwable) {
                try {
                    Class clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return Thread.currentThread().getContextClassLoader().loadClass(string);
                        }
                    });
                    return clazz;
                }
                catch (Throwable throwable2) {
                    throw new ClassNotFoundException(string, throwable);
                }
            }
        }
        return ImplFactory.loadClass((String)object);
    }

    static {
        actualPlatformString = null;
        try {
            FactoryList factoryList;
            int n;
            _map = new HashMap();
            List list = (List)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ParserConfigurationException, SAXException, Exception {
                    ArrayList arrayList = new ArrayList();
                    ImplFactory.parseExtensionPoint(arrayList);
                    ImplFactory.parseLegacyXmlFile(arrayList);
                    return arrayList;
                }
            });
            Collections.sort(list, new RankComparator());
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                factoryList = (FactoryList)list.get(n);
                int n3 = factoryList.factories.size();
                for (int i = 0; i < n3; ++i) {
                    Factory factory = (Factory)factoryList.factories.get(i);
                    if (!_map.containsKey(factory.interfaceName)) {
                        if (factory.isOverride) {
                            Tr.warning(tc, "WSVR0071W", (Object)new Object[]{factory.interfaceName, factory.implName});
                        }
                        if (factory.configElement != null) {
                            _map.put(factory.interfaceName, factory.configElement);
                            continue;
                        }
                        _map.put(factory.interfaceName, factory.implName);
                        continue;
                    }
                    if (factory.isOverride) {
                        if (factory.configElement != null) {
                            _map.put(factory.interfaceName, factory.configElement);
                            continue;
                        }
                        _map.put(factory.interfaceName, factory.implName);
                        continue;
                    }
                    if (ImplFactory.equivalent(factory.implName, _map.get(factory.interfaceName))) continue;
                    Tr.warning(tc, "WSVR0072W", (Object)new Object[]{factory.interfaceName, factory.implName});
                }
            }
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                factoryList = (FactoryList)list.get(n);
                factoryList.factories.clear();
            }
            list.clear();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.util.ImplFactory.<clinit>", "170");
            Tr.warning(tc, "WSVR0073W", IF_PLUGIN_PATH);
        }
    }

    private static class RankComparator
    implements Comparator {
        private RankComparator() {
        }

        public int compare(Object object, Object object2) {
            FactoryList factoryList = (FactoryList)object;
            FactoryList factoryList2 = (FactoryList)object2;
            return factoryList.rank - factoryList2.rank;
        }
    }

    private static class ImplFactoryParsingHandler
    extends DefaultHandler {
        Locator locator;
        int rank = 0;
        List factories = new ArrayList();
        Factory factory;
        StringBuffer value = new StringBuffer();

        public List getFactories() {
            return this.factories;
        }

        public void startDocument() throws SAXException {
            this.factories.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.value.setLength(0);
            if (!string3.equals("factories")) {
                if (string3.equals("factory")) {
                    this.factory = new Factory();
                    this.factory.isOverride = false;
                    int n = attributes.getLength();
                    for (int i = 0; i < n; ++i) {
                        String string4 = attributes.getQName(i);
                        String string5 = attributes.getValue(i);
                        if (string4.equals("interface")) {
                            this.factory.interfaceName = string5;
                            continue;
                        }
                        if (string4.equals("impl")) {
                            this.factory.implName = string5;
                            continue;
                        }
                        if (string4.equals("override")) {
                            this.factory.isOverride = string5 != null && string5.equalsIgnoreCase("true");
                            continue;
                        }
                        if (string4.equals(ImplFactory.PLATFORM)) {
                            this.factory.platforms = string5;
                            continue;
                        }
                        throw new SAXParseException("Invalid attribute: " + string4, this.locator);
                    }
                } else if (!string3.equals("rank")) {
                    throw new SAXParseException("Invalid tag: " + string3, this.locator);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("rank")) {
                try {
                    this.rank = Integer.parseInt(this.value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXParseException("Problem converting rank to number: " + this.value.toString(), this.locator);
                }
            } else if (string3.equals("factory") && this.factory != null) {
                if (ImplFactoryParsingHandler.validOn(this.factory.platforms)) {
                    this.factories.add(this.factory);
                } else {
                    this.factory = null;
                }
            }
            this.value.setLength(0);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.factory = null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.factory = null;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.factories.clear();
            this.factory = null;
            throw sAXParseException;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.value.append(cArray, n, n2);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private static boolean validOn(String string) {
            if (string == null) {
                return true;
            }
            String[] stringArray = string.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.equalsIgnoreCase(ImplFactory.ALL)) {
                    return true;
                }
                if (!string2.equalsIgnoreCase(actualPlatformString)) continue;
                return true;
            }
            return false;
        }

        static {
            actualPlatformString = ImplFactory.DISTRIBUTED;
            if (WSLauncher.isZOS()) {
                actualPlatformString = ImplFactory.ZSERIES;
            } else if (WSLauncher.isISeries()) {
                actualPlatformString = ImplFactory.ISERIES;
            }
        }
    }

    private static class FactoryList {
        public int rank;
        public List factories = new ArrayList();

        private FactoryList() {
        }

        public String toString() {
            return "[ rank = " + this.rank + ',' + this.factories + ']';
        }
    }

    private static class Factory {
        public String interfaceName;
        public String implName;
        public IConfigurationElement configElement;
        public boolean isOverride = false;
        public String platforms = null;

        private Factory() {
        }

        public String toString() {
            return '[' + this.interfaceName + '=' + this.implName + ',' + this.isOverride + ',' + this.platforms + ']';
        }
    }
}

