/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.webservice.wsbnd.DefaultEndpointURIPrefix;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBContainer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.ListenerPort;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.MessageListenerService;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.webservices.WebModels;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.MetaDataChannelHelper;
import com.ibm.ws.webservices.deploy.ModuleData;
import com.ibm.ws.webservices.deploy.WebserviceDescriptionInfo;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.File;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class MetaDataLoader {
    private static TraceComponent tc = Tr.register(MetaDataLoader.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static final String SERVLET_URL_PATTERN_ROOT = "services/";
    private Map nodeHostNames;
    private RepositoryContext appDeployCtx;
    private RepositoryContext applicationContext;
    private RepositoryContext cellContext;
    private List moduleDataList;
    private String earFileLocation;
    private EARFile earFile;
    private ApplicationDeployment appDeployment = null;
    private WebModels webModels = null;
    private List deployedModules;

    public MetaDataLoader(RepositoryContext repositoryContext, String string) {
        this.appDeployCtx = repositoryContext;
        this.earFileLocation = string;
        this.nodeHostNames = new HashMap();
        this.moduleDataList = new LinkedList();
    }

    public List getModuleDataList() {
        return this.moduleDataList;
    }

    public boolean isWebServiceEnabled() {
        if (tc.isEntryEnabled()) {
            String string = this.appDeployCtx != null ? this.appDeployCtx.getURI() : "unknown";
            Tr.entry(tc, "isWebServiceEnabled for application URI: " + string);
        }
        boolean bl = false;
        EARFile eARFile = this.getEAR(this.getApplicationContext());
        Application application = null;
        if (eARFile != null) {
            application = eARFile.getDeploymentDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isWebServiceEnabled on app: " + (application != null ? application.getDisplayName() : "unknown"));
            }
            List list = this.getDeployedModules();
            for (int i = 0; i < list.size(); ++i) {
                Module module;
                ModuleDeployment moduleDeployment = (ModuleDeployment)list.get(i);
                Module module2 = module = moduleDeployment.getAltDD() != null ? application.getModuleHavingAltDD(moduleDeployment.getAltDD()) : application.getModule(moduleDeployment.getUri(), null);
                if (module == null) continue;
                String string = module.isWebModule() ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
                ModuleFile moduleFile = eARFile.getModuleRef(module).getModuleFile();
                try {
                    LoadStrategy loadStrategy = moduleFile.getLoadStrategy();
                    bl = loadStrategy.getContainer().containsFile(string);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.isWebServiceEnabled", "229");
                }
                if (bl) break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isWebServiceEnabled:  Application " + (application != null ? application.getDisplayName() : "unknown") + " is " + (bl ? "enabled." : "not enabled."));
        }
        return bl;
    }

    public boolean isModuleEnabled(ModuleDeployment moduleDeployment, boolean bl) {
        if (tc.isEntryEnabled()) {
            String string = moduleDeployment != null ? moduleDeployment.getUri() : "Module Is Null.";
            Tr.entry(tc, "isModuleEnabled for module URI " + string);
        }
        boolean bl2 = false;
        String string = moduleDeployment.getUri();
        EARFile eARFile = this.getEAR(this.getApplicationContext());
        if (eARFile != null) {
            Application application = eARFile.getDeploymentDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isModuleEnabled on app: " + (application != null ? application.getDisplayName() : "unknown"));
            }
            List list = this.getDeployedModules();
            if (tc.isDebugEnabled()) {
                if (moduleDeployment != null) {
                    Tr.debug(tc, "isModuleEnabled on app: " + application.getDisplayName() + " for module " + moduleDeployment.getUri());
                } else {
                    Tr.debug(tc, "isModuleEnabled on app: " + application.getDisplayName());
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                Module module;
                ModuleDeployment moduleDeployment2 = (ModuleDeployment)list.get(i);
                String string2 = moduleDeployment2.getUri();
                if (!string2.equals(string)) continue;
                Module module2 = module = moduleDeployment2.getAltDD() != null ? application.getModuleHavingAltDD(moduleDeployment2.getAltDD()) : application.getModule(moduleDeployment2.getUri(), null);
                if (module == null) continue;
                String string3 = null;
                string3 = bl ? (module.isWebModule() ? "WEB-INF/ibm-webservicesclient-bnd.xmi" : "META-INF/ibm-webservicesclient-bnd.xmi") : (module.isWebModule() ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi");
                ModuleFile moduleFile = eARFile.getModuleRef(module).getModuleFile();
                try {
                    LoadStrategy loadStrategy = moduleFile.getLoadStrategy();
                    bl2 = loadStrategy.getContainer().containsFile(string3);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.isModuleEnabled", "320");
                }
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isModuleEnabled:  Module " + string + (bl2 ? " is enabled" : " is not enabled."));
        }
        return bl2;
    }

    public void cleanup() {
        this.nodeHostNames.clear();
        this.moduleDataList.clear();
        this.deployedModules = null;
        this.appDeployCtx = null;
        this.applicationContext = null;
        this.appDeployment = null;
        this.cellContext = null;
        if (this.earFile != null) {
            this.earFile.close();
        }
    }

    public void load() throws Exception {
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ObjectName objectName = (ObjectName)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    MetaDataLoader.this._load();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.deploy.MetaDataLoader.load", "402", this);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.load", "408", this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _load() throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load");
        }
        if (!(bl = this.isWebServiceEnabled())) {
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "load: no webservices information found");
            return;
        }
        RepositoryContext repositoryContext = this.getCellContext();
        List list = this.getDeployedModules();
        EARFile eARFile = this.getEAR(this.applicationContext);
        if (eARFile == null) {
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "load: no EARFile found");
            return;
        }
        Application application = eARFile.getDeploymentDescriptor();
        for (int i = 0; i < list.size(); ++i) {
            WebModule webModule;
            WebServices webServices;
            ModuleFile moduleFile;
            Module module;
            String string = null;
            boolean bl2 = false;
            ModuleDeployment moduleDeployment = (ModuleDeployment)list.get(i);
            Module module2 = module = moduleDeployment.getAltDD() != null ? application.getModuleHavingAltDD(moduleDeployment.getAltDD()) : application.getModule(moduleDeployment.getUri(), null);
            if (module == null) continue;
            ModuleData moduleData = null;
            if (module.isWebModule()) {
                moduleFile = eARFile.getModuleRef(module).getModuleFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load: starting to process WEB module " + moduleFile.getName());
                }
                if ((webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), "WEB-INF/webservices.xml")) == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "load: loadWebServicesXML returned null");
                    continue;
                }
                webModule = (WebModule)module;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load: calling loadModuleData for module " + moduleFile.getName());
                }
                moduleData = this.loadModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, webModule, webServices, false);
            } else if (module.isEjbModule()) {
                String string2;
                RouterModule routerModule;
                Object object;
                moduleFile = eARFile.getModuleRef(module).getModuleFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load: starting to process EJB module " + moduleFile.getName());
                }
                if ((webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), "META-INF/webservices.xml")) == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "load: loadWebServicesXML returned null");
                    continue;
                }
                webModule = WSModels.getWSBinding(moduleFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                if (webModule != null) {
                    object = webModule.getRouterModules().iterator();
                    while (object.hasNext()) {
                        routerModule = (RouterModule)object.next();
                        string2 = routerModule.getTransport();
                        if (string2 == null || !string2.equals("http")) continue;
                        string = routerModule.getName();
                        bl2 = true;
                        break;
                    }
                }
                if (string != null) {
                    object = null;
                    for (int j = 0; j < list.size(); ++j) {
                        string2 = (ModuleDeployment)list.get(j);
                        if (!string2.getUri().equals(string)) continue;
                        object = string2;
                        break;
                    }
                    if (object == null) {
                        throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{moduleDeployment.getUri()}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    }
                    routerModule = application.getModule(string, null);
                    if (routerModule == null) {
                        throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{moduleDeployment.getUri()}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    }
                    if (!routerModule.isWebModule()) throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{moduleDeployment.getUri()}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "load: calling loadModuleData for module " + moduleFile.getName());
                    }
                    moduleData = this.loadModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, (WebModule)routerModule, webServices, bl2);
                } else {
                    moduleData = this.loadModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, null, webServices, bl2);
                }
            }
            if (moduleData == null) continue;
            this.moduleDataList.add(moduleData);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "load");
    }

    private RepositoryContext getApplicationContext() {
        if (this.applicationContext == null) {
            this.applicationContext = this.appDeployCtx.getParent();
        }
        return this.applicationContext;
    }

    private RepositoryContext getCellContext() {
        if (this.cellContext == null) {
            this.cellContext = this.getApplicationContext().getParent();
        }
        return this.cellContext;
    }

    private ApplicationDeployment getApplicationDeploymentFromContext() {
        block4: {
            if (this.appDeployment == null) {
                try {
                    Deployment deployment;
                    Resource resource;
                    ResourceSet resourceSet;
                    if (this.appDeployCtx != null && (resourceSet = this.appDeployCtx.getResourceSet()) != null && (resource = resourceSet.getResource(URI.createURI("deployment.xml"), true)) != null && (deployment = (Deployment)resource.getContents().get(0)) != null) {
                        this.appDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.getApplicationDeploymentFromContext", "689");
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "getApplicationDeploymentFromContext: caught exception ", exception);
                }
            }
        }
        return this.appDeployment;
    }

    private List getDeployedModules() {
        if (this.deployedModules == null) {
            block6: {
                try {
                    ApplicationDeployment applicationDeployment = this.getApplicationDeploymentFromContext();
                    if (applicationDeployment != null) {
                        this.deployedModules = applicationDeployment.getModules();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.getDeployedModules", "649");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "getDeploymentModules: caught exception ", exception);
                }
            }
            if (this.deployedModules == null) {
                this.deployedModules = new ArrayList();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDeploymentModules: no modules found");
                }
            }
        }
        return this.deployedModules;
    }

    private EARFile getEAR(RepositoryContext repositoryContext) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEAR");
            }
            if (this.earFile == null) {
                ApplicationDeployment applicationDeployment = this.getApplicationDeploymentFromContext();
                if (applicationDeployment == null) {
                    return this.earFile;
                }
                boolean bl = applicationDeployment.isZeroBinaryCopy();
                boolean bl2 = applicationDeployment.isZeroEarCopy();
                if (bl || bl2) {
                    return this.earFile;
                }
                if (this.earFileLocation == null) {
                    String string = repositoryContext.getName();
                    String string2 = repositoryContext.getURI();
                    Properties properties = ConfigRepositoryFactory.getConfigRepository().getConfig();
                    String string3 = (String)properties.get("was.repository.root");
                    this.earFileLocation = string3 + File.separator + string2 + File.separator + string;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear file location: ", this.earFileLocation);
                }
                try {
                    CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
                    ArchiveOptions archiveOptions = new ArchiveOptions();
                    archiveOptions.setIsReadOnly(true);
                    archiveOptions.setUseJavaReflection(false);
                    this.earFile = commonarchiveFactory.openEARFile(archiveOptions, this.earFileLocation);
                    this.earFile.getDeploymentDescriptor();
                    this.earFile.getBindings();
                    this.earFile.getExtensions();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.webservices.deploy.MetaDataLoader.getEAR", "534");
                    if (this.earFile == null) break block9;
                    this.earFile.close();
                    this.earFile = null;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEAR");
        }
        return this.earFile;
    }

    private String findServletUrl(WebApp webApp, String string) {
        String string2 = null;
        Servlet servlet = webApp.getServletNamed(string);
        ServletMapping servletMapping = webApp.getServletMapping(servlet);
        if (servletMapping != null) {
            string2 = servletMapping.getUrlPattern();
        }
        return string2;
    }

    private static String getHostName(RepositoryContext repositoryContext) {
        String string = null;
        try {
            ResourceSet resourceSet = repositoryContext.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createURI("serverindex.xml"), true);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            string = serverIndex.getHostName();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.getHostName", "586");
            Tr.error(tc, "internal.error", exception);
        }
        return string;
    }

    private ModuleData loadModuleData(RepositoryContext repositoryContext, EARFile eARFile, ModuleFile moduleFile, ModuleDeployment moduleDeployment, WebModule webModule, WebServices webServices, boolean bl) throws Exception {
        String string;
        String string2;
        Object object;
        Object object2;
        QName qName;
        Object object3;
        String string3;
        String string4;
        String string5;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        ServerTarget serverTarget;
        Object object9;
        Object object10;
        Object object11;
        String string6;
        Object object12;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadModuleData for ", moduleDeployment.getUri() + ", application: " + eARFile.getName());
        }
        boolean bl2 = moduleFile.isWARFile();
        ModuleData moduleData = new ModuleData();
        moduleData.setApplicationName(eARFile.getName());
        moduleData.setIsWebModule(bl2);
        moduleData.setHasHTTPRouter(bl);
        moduleData.setName(moduleDeployment.getUri());
        if (webModule == null) {
            moduleData.setVirtualHost(null);
        } else {
            if (this.webModels == null) {
                this.webModels = new WebModels();
            }
            object12 = this.webModels.getWebAppBinding(this.appDeployCtx, eARFile, webModule);
            string6 = object12.getVirtualHostName();
            object11 = repositoryContext.getResourceSet().getResource(URI.createURI("virtualhosts.xml"), true);
            object10 = object11.getContents();
            object9 = object10.iterator();
            while (object9.hasNext()) {
                serverTarget = (VirtualHost)object9.next();
                if (!serverTarget.getName().equals(string6)) continue;
                moduleData.setVirtualHost((VirtualHost)serverTarget);
                break;
            }
        }
        object11 = moduleDeployment.getTargetMappings();
        if (object11.isEmpty()) {
            throw new Exception(nls.getFormattedMessage("WSWS0044E", new Object[]{moduleDeployment.getUri()}, "WSWS0044E: Can not locate the deploy target for module: {0}"));
        }
        object10 = (DeploymentTargetMapping)object11.get(0);
        object9 = object10.getTarget();
        if (object9 instanceof ServerTarget) {
            serverTarget = (ServerTarget)object9;
            object12 = serverTarget.getNodeName();
            string6 = serverTarget.getName();
            object8 = (String)this.nodeHostNames.get(object12);
            object7 = repositoryContext.findContext("nodes/" + (String)object12);
            if (object8 == null) {
                object8 = MetaDataLoader.getHostName((RepositoryContext)object7);
                this.nodeHostNames.put(object12, object8);
            }
            object6 = object7.findContext("servers/" + string6);
            object5 = MetaDataLoader.loadWebContainerPorts((RepositoryContext)object7, (RepositoryContext)object6);
            moduleData.setNode((String)object12);
            moduleData.setHost((String)object8);
            moduleData.setServer(string6);
            object4 = object5.keySet().iterator();
            while (object4.hasNext()) {
                string5 = (String)object4.next();
                string4 = (String)object5.get(string5);
                moduleData.addPrefix(string4, string5);
            }
        } else {
            block57: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deployment Target (server)" + object9.getName() + " is a cluster");
                }
                try {
                    serverTarget = repositoryContext.findContext("clusters/" + object9.getName());
                    object8 = serverTarget.getResourceSet();
                    object7 = object8.getResource(URI.createURI("cluster.xml"), true);
                    object6 = (ServerCluster)object7.getContents().get(0);
                    object5 = object6.getMembers().iterator();
                    while (object5.hasNext()) {
                        object4 = (ClusterMember)object5.next();
                        string5 = object4.getNodeName();
                        string4 = object4.getMemberName();
                        string3 = (String)this.nodeHostNames.get(string5);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "find nodeContext for nodes/" + string5);
                        }
                        object3 = repositoryContext.findContext("nodes/" + string5);
                        if (string3 == null) {
                            string3 = MetaDataLoader.getHostName((RepositoryContext)object3);
                            this.nodeHostNames.put(string5, string3);
                        }
                        qName = null;
                        if (object3 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "find serverContext for servers/" + string4);
                            }
                            qName = object3.findContext("servers/" + string4);
                        }
                        object2 = MetaDataLoader.loadWebContainerPorts((RepositoryContext)object3, qName);
                        moduleData.setNode(string5);
                        moduleData.setHost(string3);
                        moduleData.setServer(string4);
                        object = object2.keySet().iterator();
                        while (object.hasNext()) {
                            string2 = (String)object.next();
                            string = (String)object2.get(string2);
                            moduleData.addPrefix(string, string3, string2);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.loadModuleData", "985", this);
                    if (!tc.isDebugEnabled()) break block57;
                    Tr.debug(tc, "Failed to load cluster context while determining application status: {0}", exception);
                }
            }
            moduleData.setServer("MODULE_ASSIGNED_TO_CLUSTER_TAG");
        }
        if (webModule == null) {
            moduleData.setContextRoot("");
        } else {
            object10 = webModule.getContextRoot();
            moduleData.setContextRoot((String)object10);
        }
        object10 = null;
        if (webModule != null) {
            object10 = eARFile.getDeploymentDescriptor(webModule);
        }
        int n = webServices.getWebServiceDescriptions().size();
        for (int i = 0; i < n; ++i) {
            object8 = (WebServiceDescription)webServices.getWebServiceDescriptions().get(i);
            object7 = object8.getWebServiceDescriptionName();
            object6 = object7;
            object5 = object8.getWsdlFile();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadModuleData: webServicesDescriptionName=" + (String)object6);
                Tr.debug(tc, "loadModuleData: theWSDLFileName=" + (String)object5);
            }
            object4 = new WebserviceDescriptionInfo((String)object5, (String)object6);
            int n2 = object8.getPortComponents().size();
            for (int j = 0; j < n2; ++j) {
                EJBJarBinding eJBJarBinding;
                Object object13;
                Module module;
                EJBJarFile eJBJarFile;
                string3 = (PortComponent)object8.getPortComponents().get(j);
                object3 = string3.getWsdlPort();
                qName = new QName(object3.getNamespaceURI(), object3.getLocalPart());
                object2 = string3.getServiceImplBean().getEServletLink();
                object = object2 != null ? object2.getServletLink() : string3.getPortComponentName();
                string2 = null;
                if (object10 != null) {
                    string2 = this.findServletUrl((WebApp)object10, (String)object);
                }
                if (string2 != null) {
                    string2 = DeployUtils.trimSlash(string2);
                }
                if (bl2) {
                    if (string2 != null) {
                        ((WebserviceDescriptionInfo)object4).addQnameToUrlPattern(qName, string2);
                    } else {
                        string = SERVLET_URL_PATTERN_ROOT + string3.getPortComponentName();
                        ((WebserviceDescriptionInfo)object4).addQnameToUrlPattern(qName, string);
                    }
                } else if (string2 != null) {
                    ((WebserviceDescriptionInfo)object4).addQnameToUrlPattern(qName, string2);
                } else {
                    string = "null";
                    if (webModule != null) {
                        string = webModule.getUri();
                    }
                    Tr.error(tc, "WSWS0045E", new Object[]{moduleDeployment.getUri(), string, string3.getPortComponentName()});
                }
                ((WebserviceDescriptionInfo)object4).addQnameToPortComponentName(qName, string3.getPortComponentName());
                if (bl2) continue;
                string = string3.getServiceImplBean();
                EJBLink eJBLink = string.getEEJBLink();
                String string7 = eJBLink.getEjbLink();
                String string8 = null;
                List list = eARFile.getEJBJarFiles();
                Object object14 = list.iterator();
                while (object14.hasNext()) {
                    eJBJarFile = (EJBJarFile)object14.next();
                    module = null;
                    if (eJBJarFile.getName().equals(moduleData.getName())) {
                        module = eJBJarFile.getDeploymentDescriptor();
                    }
                    if (module == null) continue;
                    object13 = module.getEnterpriseBeans().iterator();
                    while (object13.hasNext()) {
                        eJBJarBinding = (EnterpriseBean)object13.next();
                        if (!eJBJarBinding.getName().equals(string7)) continue;
                        string8 = eJBJarBinding.getHomeInterfaceName();
                    }
                }
                object14 = null;
                eJBJarFile = eARFile.getDeploymentDescriptor();
                module = moduleDeployment.getAltDD() != null ? eJBJarFile.getModuleHavingAltDD(moduleDeployment.getAltDD()) : eJBJarFile.getModule(moduleDeployment.getUri(), null);
                object13 = (EjbModule)module;
                eJBJarBinding = eARFile.getBindings((EjbModule)object13);
                EList eList = eJBJarBinding.getEjbBindings();
                Object object15 = eList.iterator();
                while (object15.hasNext()) {
                    String string9;
                    EnterpriseBean enterpriseBean;
                    EnterpriseBeanBinding enterpriseBeanBinding = (EnterpriseBeanBinding)object15.next();
                    if (enterpriseBeanBinding == null || (enterpriseBean = enterpriseBeanBinding.getEnterpriseBean()) == null || (string9 = enterpriseBean.getName()) == null || !string9.equals(string7)) continue;
                    object14 = enterpriseBeanBinding.getJndiName();
                }
                object15 = new StringBuffer();
                ((StringBuffer)object15).append("wsejb:/");
                ((StringBuffer)object15).append(string8);
                ((StringBuffer)object15).append('?');
                ((StringBuffer)object15).append("jndiName=").append((String)object14);
                ((WebserviceDescriptionInfo)object4).addQNameToEJBUrlPrefix(qName, ((StringBuffer)object15).toString());
            }
            moduleData.addWebservicesDescription((WebserviceDescriptionInfo)object4);
        }
        List list = bl2 ? moduleFile.getLoadStrategy().getFiles("WEB-INF/wsdl") : moduleFile.getLoadStrategy().getFiles("META-INF/wsdl");
        moduleData.setModulesWsdlFiles(list);
        moduleData.setDefaultJMSPrefix("");
        moduleData.setDefaultEJBPrefix("");
        moduleData.setHasJMSRouter(false);
        object8 = new StringBuffer(moduleData.getName());
        ((StringBuffer)object8).append("/");
        if (bl2) {
            ((StringBuffer)object8).append("WEB-INF/ibm-webservices-bnd.xmi");
        } else {
            ((StringBuffer)object8).append("META-INF/ibm-webservices-bnd.xmi");
        }
        object7 = WSModels.getWSBindingFromResourceSet(this.appDeployCtx.getResourceSet(), ((StringBuffer)object8).toString());
        if (object7 == null) {
            object6 = null;
            object6 = bl2 ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi";
            object7 = WSModels.getWSBinding(moduleFile.getLoadStrategy(), (String)object6);
        }
        if (object7 != null) {
            boolean bl3 = false;
            object5 = object7.getWsdescBindings();
            if (object5.size() > 0) {
                DefaultEndpointURIPrefix defaultEndpointURIPrefix;
                DefaultEndpointURIPrefix defaultEndpointURIPrefix2;
                object4 = (WSDescBinding)object5.get(0);
                EList eList = object4.getDefaultEndpointURIPrefixes();
                if (eList.size() >= 3) {
                    DefaultEndpointURIPrefix defaultEndpointURIPrefix3 = (DefaultEndpointURIPrefix)eList.get(2);
                    string3 = defaultEndpointURIPrefix3.getText();
                    if (string3 == null) {
                        string3 = "";
                    }
                    moduleData.setDefaultEJBPrefix(string3);
                }
                if (eList.size() >= 2 && (string3 = (defaultEndpointURIPrefix2 = (DefaultEndpointURIPrefix)eList.get(1)).getText()) != null && string3.length() != 0) {
                    bl3 = true;
                    moduleData.setDefaultJMSPrefix(string3);
                }
                if (eList.size() >= 1 && (string3 = (defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)eList.get(0)).getText()) != null && string3.length() != 0) {
                    moduleData.setDefaultPrefix(string3);
                }
                EList eList2 = object7.getRouterModules();
                string3 = null;
                object3 = eList2.iterator();
                while (object3.hasNext()) {
                    qName = (RouterModule)object3.next();
                    object2 = qName.getTransport();
                    if (!((String)object2).equals("jms")) continue;
                    string3 = qName.getName();
                    break;
                }
                if (string3 != null) {
                    moduleData.setHasJMSRouter(true);
                    if (!bl3) {
                        object3 = this.buildDefaultJMSUrlFromconfig(repositoryContext, eARFile, (List)object11, string3);
                        moduleData.setDefaultJMSPrefix((String)object3);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadModuleData: did not find a JMS router module name from the bindings file of module " + moduleDeployment.getUri());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadModuleData: The module " + moduleFile.getName() + " contains a  Web Services bindings file, but the bindings file " + "contains no WSDescBindings");
            }
        } else if (!bl2) {
            Tr.error(tc, "WSWS0018E", new Object[]{moduleFile.getName(), "ibm-webservices-bnd.xmi"});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadModuleData");
        }
        return moduleData;
    }

    private String buildDefaultJMSUrlFromconfig(RepositoryContext repositoryContext, EARFile eARFile, List list, String string) {
        Object object;
        EJBJarBinding eJBJarBinding;
        EJBJarFile eJBJarFile;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        ListenerPort listenerPort = null;
        List list2 = eARFile.getEJBJarFiles();
        String string8 = null;
        DeploymentTargetMapping deploymentTargetMapping = list2.iterator();
        while (deploymentTargetMapping.hasNext()) {
            eJBJarFile = (EJBJarFile)deploymentTargetMapping.next();
            if (!eJBJarFile.getName().equals(string)) continue;
            eJBJarBinding = eJBJarFile.getBindings();
            object = eJBJarBinding.getEjbBindings();
            if (object.size() > 0 && object.get(0) instanceof MessageDrivenBeanBinding) {
                MessageDrivenBeanBinding messageDrivenBeanBinding = (MessageDrivenBeanBinding)object.get(0);
                string5 = messageDrivenBeanBinding.getActivationSpecJndiName();
                if (string5 != null) continue;
                string8 = messageDrivenBeanBinding.getListenerInputPortName();
                continue;
            }
            Tr.error(tc, "WSWS0046E", string);
        }
        deploymentTargetMapping = (DeploymentTargetMapping)list.get(0);
        eJBJarFile = deploymentTargetMapping.getTarget();
        if (eJBJarFile instanceof ServerTarget) {
            eJBJarBinding = (ServerTarget)eJBJarFile;
            String string9 = eJBJarBinding.getNodeName();
            String string10 = eJBJarBinding.getName();
            if (string5 != null) {
                object = this.getActivationSpecFromCellConfig(string5, repositoryContext, string9);
                string6 = object[0];
                string7 = object[1];
            } else {
                listenerPort = this.getListenerPortFromCellConfig(string8, repositoryContext, string9, string10);
            }
            if (string5 != null) {
                string2 = string6;
            } else if (listenerPort != null) {
                string2 = listenerPort.getDestinationJNDIName();
                string3 = listenerPort.getConnectionFactoryJNDIName();
            }
            if (string2 == null) {
                string2 = "??undefinedDestinationJndiName??";
            }
            if (string3 == null) {
                string3 = "??connectionFactoryJndiName??";
            }
            object = new StringBuffer();
            ((StringBuffer)object).append("jms");
            ((StringBuffer)object).append(':');
            ((StringBuffer)object).append("/");
            if (string7 == null) {
                ((StringBuffer)object).append("??undefinedDestinationType??");
            } else if (string7.equalsIgnoreCase("queue")) {
                ((StringBuffer)object).append("queue");
            } else {
                ((StringBuffer)object).append("topic");
            }
            ((StringBuffer)object).append('?');
            ((StringBuffer)object).append("destination");
            ((StringBuffer)object).append("=");
            ((StringBuffer)object).append(string2);
            ((StringBuffer)object).append('&');
            ((StringBuffer)object).append("connectionFactory");
            ((StringBuffer)object).append("=");
            ((StringBuffer)object).append(string3);
            string4 = ((StringBuffer)object).toString();
        }
        return string4;
    }

    private String[] getActivationSpecFromCellConfig(String string, RepositoryContext repositoryContext, String string2) {
        String[] stringArray;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getActivationSpecFromCellConfig");
            }
            Object var4_4 = null;
            String string3 = null;
            stringArray = new String[3];
            try {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = new Session();
                ObjectName objectName = configService.resolve(session, "Node=" + string2)[0];
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "J2CResourceAdapter", "SIB JMS Resource Adapter");
                ObjectName objectName3 = configService.queryConfigObjects(session, objectName, objectName2, null)[0];
                if (objectName3 != null) {
                    ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, "J2CActivationSpec");
                    ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName3, objectName4, null);
                    for (int i = 0; i < objectNameArray.length; ++i) {
                        ObjectName objectName5 = objectNameArray[i];
                        string3 = (String)configService.getAttribute(session, objectName5, "jndiName");
                        if (!string3.equals(string)) continue;
                        stringArray[0] = (String)configService.getAttribute(session, objectName5, "destinationJndiName");
                        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, "J2EEResourceProperty", "destinationType");
                        ObjectName objectName7 = configService.queryConfigObjects(session, objectName5, objectName6, null)[0];
                        if (objectName7 == null) break;
                        String string4 = (String)configService.getAttribute(session, objectName7, "value");
                        int n = string4.lastIndexOf(".");
                        stringArray[1] = string4.substring(n + 1);
                        break;
                    }
                }
                configService.discard(session);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.getActivationSpecFromCellConfig", "1271");
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "loadModuleData caught while trying to create the default JMS  URL prefix from activationSpec", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivationSpecFromCellConfig");
        }
        return stringArray;
    }

    private ListenerPort getListenerPortFromCellConfig(String string, RepositoryContext repositoryContext, String string2, String string3) {
        ListenerPort listenerPort;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getListenerPortFromCellConfig");
            }
            listenerPort = null;
            try {
                RepositoryContext repositoryContext2 = repositoryContext.findContext("nodes/" + string2 + "/servers/" + string3);
                ResourceSet resourceSet = repositoryContext2.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI("server.xml"), true);
                Server server2 = (Server)resource.getContents().get(0);
                EList eList = server2.getComponents();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    Component component = (Component)iterator.next();
                    if (!(component instanceof ApplicationServer)) continue;
                    ApplicationServer applicationServer = (ApplicationServer)component;
                    EList eList2 = applicationServer.getComponents();
                    Iterator iterator2 = eList2.iterator();
                    while (iterator2.hasNext()) {
                        Component component2 = (Component)iterator2.next();
                        if (!(component2 instanceof EJBContainer)) continue;
                        EJBContainer eJBContainer = (EJBContainer)component2;
                        EList eList3 = eJBContainer.getServices();
                        Iterator iterator3 = eList3.iterator();
                        while (iterator3.hasNext()) {
                            Object e = iterator3.next();
                            if (!(e instanceof MessageListenerService)) continue;
                            MessageListenerService messageListenerService = (MessageListenerService)e;
                            EList eList4 = messageListenerService.getListenerPorts();
                            Iterator iterator4 = eList4.iterator();
                            while (iterator4.hasNext()) {
                                ListenerPort listenerPort2 = (ListenerPort)iterator4.next();
                                String string4 = listenerPort2.getName();
                                if (!string4.equals(string)) continue;
                                listenerPort = listenerPort2;
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "found listenerInputPortName: " + string);
                            }
                        }
                    }
                }
            }
            catch (WorkSpaceException workSpaceException) {
                FFDCFilter.processException(workSpaceException, "com.ibm.ws.webservices.deploy.MetaDataLoader.getListenerPortFromCellConfig", "1345");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "loadModuleData caught while trying to create the default JMS  URL prefix", (Object)workSpaceException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getListenerPortFromCellConfig");
        }
        return listenerPort;
    }

    private static Map loadWebContainerPorts(RepositoryContext repositoryContext, RepositoryContext repositoryContext2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadWebContainerPorts");
        }
        Map map = new HashMap();
        if (repositoryContext2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadWebContainerPorts: no ports mapped");
            }
        } else {
            try {
                Service service;
                ResourceSet resourceSet = repositoryContext2.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI("server.xml"), true);
                Server server2 = (Server)resource.getContents().get(0);
                String string = server2.getName();
                EList eList = server2.getServices();
                TransportChannelService transportChannelService = null;
                Object var9_10 = null;
                HashMap hashMap = new HashMap();
                boolean bl = false;
                Object object = eList.iterator();
                while (object.hasNext() && !bl) {
                    service = (Service)object.next();
                    if (!(service instanceof TransportChannelService)) continue;
                    transportChannelService = (TransportChannelService)service;
                    EList eList2 = transportChannelService.getTransportChannels();
                    if (eList2.isEmpty()) break;
                    bl = true;
                    break;
                }
                object = server2.getComponents();
                service = null;
                boolean bl2 = false;
                Iterator iterator = object.iterator();
                block3: while (iterator.hasNext() && !bl2) {
                    Component component = (Component)iterator.next();
                    if (!(component instanceof ApplicationServer)) continue;
                    ApplicationServer applicationServer = (ApplicationServer)component;
                    EList eList3 = applicationServer.getComponents();
                    Iterator iterator2 = eList3.iterator();
                    while (iterator2.hasNext()) {
                        Component component2 = (Component)iterator2.next();
                        if (!(component2 instanceof WebContainer)) continue;
                        service = (WebContainer)component2;
                        bl2 = true;
                        continue block3;
                    }
                }
                if (service != null && bl2) {
                    map = MetaDataLoader.loadHTTPPortsFromV5Template(server2, (List)object, (WebContainer)service, map);
                }
                if (transportChannelService != null && bl) {
                    map = MetaDataLoader.loadHTTPPortsFromV6Template(transportChannelService, repositoryContext, server2, string, map);
                } else {
                    Tr.error(tc, "loadWebContainerPorts could not find any http or https ports");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.loadWebContainerPorts", "1523");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadWebContainerPorts");
        }
        return map;
    }

    private static Map loadHTTPPortsFromV6Template(TransportChannelService transportChannelService, RepositoryContext repositoryContext, Server server2, String string, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadHTTPPortsFromV6Template");
        }
        MetaDataChannelHelper metaDataChannelHelper = new MetaDataChannelHelper(transportChannelService);
        Map map2 = metaDataChannelHelper.getEndPointMap();
        map = MetaDataLoader.mapV6EndPoints2Ports(map2, repositoryContext, server2, string, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadHTTPPortsFromV6Template");
        }
        return map;
    }

    private static Map mapV6EndPoints2Ports(Map map, RepositoryContext repositoryContext, Server server2, String string, Map map2) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "mapV6EndPoints2Ports");
            }
            try {
                String string2;
                ResourceSet resourceSet = repositoryContext.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI("serverindex.xml"), true);
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                EList eList = serverIndex.getServerEntries();
                boolean bl = false;
                ServerEntry serverEntry = null;
                Object object = eList.iterator();
                while (object.hasNext()) {
                    serverEntry = (ServerEntry)object.next();
                    string2 = serverEntry.getServerName();
                    if (string2 == null || !(serverEntry instanceof ServerEntry) || !string2.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    object = serverEntry.getSpecialEndpoints();
                    string2 = null;
                    String string3 = null;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        string2 = (NamedEndPoint)iterator.next();
                        string3 = string2.getEndPointName();
                        EndPoint endPoint = null;
                        String string4 = null;
                        String string5 = (String)map.get(string3);
                        if (string5 == null || string5.length() <= 0) continue;
                        endPoint = string2.getEndPoint();
                        string4 = new Integer(endPoint.getPort()).toString();
                        map2.put(string4, string5);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.mapV6EndPoints2Ports", "1866");
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "mapV6EndPoints2Ports caught exeption ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapV6EndPoints2Ports");
        }
        return map2;
    }

    private static Map loadHTTPPortsFromV5Template(Server server2, List list, WebContainer webContainer, Map map) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadHTTPPortsFromV5Template");
            }
            try {
                Object object;
                Object object2;
                EList eList = webContainer.getTransports();
                Iterator<Object> iterator = eList.iterator();
                while (iterator.hasNext()) {
                    EndPoint endPoint;
                    object2 = (Transport)iterator.next();
                    if (!(object2 instanceof HTTPTransport) || (endPoint = (object = (HTTPTransport)object2).getAddress()) == null) continue;
                    String string = new Integer(endPoint.getPort()).toString();
                    String string2 = object.isSslEnabled() ? "https" : "http";
                    map.put(string, string2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadHTTPPortsFromV5Template: for server \"" + server2.getName() + "\" the container is [" + webContainer.toString() + "} and the portMap being returned has " + map.size() + " elements, which are:\n");
                    iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        object = (String)map.get(object2);
                        Tr.debug(tc, "\tport=" + (String)object2 + " protocol=" + (String)object);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.MetaDataLoader.loadHTTPPortsFromV5Template", "1694");
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "loadHTTPPortsFromV5Template caught exeption ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadHTTPPortsfromV5Template");
        }
        return map;
    }
}

