/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.SessionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;

public class AttachmentPart
extends javax.xml.soap.AttachmentPart
implements Part {
    protected static Log log = LogFactory.getLog(AttachmentPart.class.getName());
    DataHandler datahandler = null;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private String contentId;
    private String contentLocation;
    private Object contentObject;
    private String contentIdPartName;

    public AttachmentPart() {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
    }

    public AttachmentPart(DataHandler dataHandler) {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
        this.datahandler = dataHandler;
        if (dataHandler != null) {
            this.setMimeHeader("Content-Type", dataHandler.getContentType());
        }
    }

    public AttachmentPart(DataHandler dataHandler, String string) {
        this.setMimeHeader("Content-Id", (string == null ? "" : string + "=") + SessionUtils.generateSessionId());
        this.contentIdPartName = string;
        this.datahandler = dataHandler;
        if (dataHandler != null) {
            this.setMimeHeader("Content-Type", dataHandler.getContentType());
        }
    }

    public AttachmentPart(DataHandler dataHandler, String string, String string2) {
        this.setMimeHeader("Content-Id", (string == null ? "" : string + "=") + (string2 == null ? SessionUtils.generateSessionId() : string2));
        this.contentIdPartName = string;
        this.datahandler = dataHandler;
        if (dataHandler != null) {
            this.setMimeHeader("Content-Type", dataHandler.getContentType());
        }
    }

    public DataHandler getActivationDataHandler() {
        return this.datahandler;
    }

    public String getContentType() {
        return this.getFirstMimeHeader("Content-Type");
    }

    public void addMimeHeader(String string, String string2) {
        this.mimeHeaders.addHeader(string, string2);
    }

    public String getFirstMimeHeader(String string) {
        String[] stringArray = this.mimeHeaders.getHeader(string.toLowerCase());
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public boolean matches(MimeHeaders mimeHeaders) {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            String[] stringArray = this.mimeHeaders.getHeader(mimeHeader.getName());
            boolean bl = false;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!mimeHeader.getValue().equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String string) {
        this.setMimeHeader("Content-Location", string);
    }

    public void setContentId(String string) {
        this.setMimeHeader("Content-Id", string);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public String getContentIdPartName() {
        String string;
        int n;
        if (this.contentIdPartName == null && (n = (string = this.getContentId()).indexOf("=")) >= 0) {
            this.contentIdPartName = string.substring(0, n);
        }
        return this.contentIdPartName;
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getMatchingHeaders(stringArray);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getNonMatchingHeaders(stringArray);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String string, String string2) {
        this.mimeHeaders.setHeader(string, string2);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this.mimeHeaders.removeHeader(string);
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        return this.datahandler;
    }

    public void setDataHandler(DataHandler dataHandler) {
        if (dataHandler == null) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        this.datahandler = dataHandler;
        this.setMimeHeader("Content-Type", dataHandler.getContentType());
    }

    public Object getContent() throws SOAPException {
        if (this.contentObject != null) {
            return this.contentObject;
        }
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        DataSource dataSource = this.datahandler.getDataSource();
        if (dataSource instanceof ManagedMemoryDataSource) {
            ManagedMemoryDataSource managedMemoryDataSource = (ManagedMemoryDataSource)dataSource;
            if (dataSource.getContentType().equals("text/plain")) {
                try {
                    InputStream inputStream = null;
                    final DataSource dataSource2 = dataSource;
                    inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return dataSource2.getInputStream();
                        }
                    });
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    byte[] byArray = new byte[dataInputStream.available()];
                    dataInputStream.read(byArray);
                    return new String(byArray);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getContent", "406", this);
                    log.error(Messages.getMessage("javaIOException00"), privilegedActionException.getException());
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getContent", "409", this);
                    log.error(Messages.getMessage("javaIOException00"), iOException);
                }
            }
        }
        return null;
    }

    public void setContent(Object object, String string) {
        InputStream inputStream = null;
        if (object instanceof String) {
            String string2 = (String)object;
            inputStream = new ByteArrayInputStream(string2.getBytes());
        } else if (object instanceof InputStream) {
            inputStream = (InputStream)object;
        } else if (object instanceof StreamSource) {
            inputStream = ((StreamSource)object).getInputStream();
        }
        if (inputStream != null) {
            try {
                this.datahandler = new DataHandler(new ManagedMemoryDataSource(inputStream, string));
                this.contentObject = object;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.setContent", "414", this);
                log.error(Messages.getMessage("javaIOException00"), iOException);
                throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
            }
        } else {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
    }

    public void clearContent() {
        this.datahandler = null;
        this.contentObject = null;
    }

    public int getSize() throws SOAPException {
        if (this.datahandler == null) {
            return 0;
        }
        ByteBuffer byteBuffer = new ByteBuffer();
        try {
            this.datahandler.writeTo(byteBuffer);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getSize", "463", this);
            log.error(Messages.getMessage("javaIOException00"), iOException);
            throw new SOAPException(Messages.getMessage("javaIOException01", iOException.getMessage()), iOException);
        }
        byte[] byArray = byteBuffer.getBytes();
        if (byArray != null) {
            return byArray.length;
        }
        return -1;
    }

    public String[] getMimeHeader(String string) {
        return this.mimeHeaders.getHeader(string);
    }

    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }

    private class ByteBuffer
    extends ByteArrayOutputStream {
        private ByteBuffer() {
        }

        byte[] getBytes() {
            return super.toByteArray();
        }
    }
}

