/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configurable;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.configurable.Configured;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.LockableHashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class ConfigurableImpl
implements Configurable {
    protected static Log log = LogFactory.getLog(ConfigurableImpl.class.getName());
    protected LockableHashtable options;

    public final void setOptionsDefault(Configured configured) {
        this.setOptionsDefault(configured.getOptions());
    }

    public final void setOptionsDefault(Map map) {
        if (this.options == null) {
            this.initOptions();
        }
        this.options.setParent(map);
    }

    public final void setOption(String string, Object object) {
        this.setOption(string, object, false);
    }

    public final void setOption(String string, Object object, boolean bl) {
        if (this.options == null) {
            this.initOptions();
        }
        if (this.isOptionBoolean(string)) {
            object = this.normalize(object);
        }
        this.options.put(string, object, bl);
    }

    public final void removeOption(String string) {
        if (this.options != null) {
            this.options.remove(string);
        }
    }

    public final boolean setOptionDefault(String string, Object object) {
        return this.setOptionDefault(string, object, false);
    }

    public final boolean setOptionDefault(String string, Object object, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.options == null || this.options.get(string) == null) && object != null;
        if (bl2) {
            this.setOption(string, object, bl);
        }
        return bl2;
    }

    public final void setOptions(Map map) {
        if (map == null) {
            this.options = null;
        } else if (map != this.options) {
            this.options = new LockableHashtable(map);
            Set set = this.getOptionsBooleanNames();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object object = this.options.get(e);
                    if (object == null) {
                        this.options.put(e, Boolean.TRUE);
                        continue;
                    }
                    if (object instanceof Boolean) continue;
                    this.options.put(e, this.normalize(object));
                }
            }
        }
    }

    public final Object getOption(String string) {
        return this.options == null ? null : this.options.get(string);
    }

    public final Map getOptions() {
        return this.options;
    }

    public Set getOptionsBooleanNames() {
        return null;
    }

    private final boolean isOptionBoolean(String string) {
        Set set = this.getOptionsBooleanNames();
        return set == null ? false : set.contains(string);
    }

    protected final void initOptions() {
        this.options = new LockableHashtable();
        Set set = this.getOptionsBooleanNames();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.options.put(iterator.next(), Boolean.TRUE);
            }
        }
    }

    private final Boolean normalize(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return new Boolean(JavaUtils.isTrue(object));
    }
}

