/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.dispatchers.Processor;
import com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.lang.reflect.InvocationTargetException;

public abstract class BasicDispatcher
extends BasicHandler {
    private static final String D_OPTION_PROCESSOR = "processor";

    public static final void setProcessor(Configurable configurable, Processor processor) {
        configurable.setOption(D_OPTION_PROCESSOR, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Processor getProcessor(Configurable configurable) {
        Processor processor;
        Configurable configurable2 = configurable;
        synchronized (configurable2) {
            processor = (Processor)configurable.getOption(D_OPTION_PROCESSOR);
            if (processor == null) {
                processor = SoapRPCProcessor.getProcessor();
                BasicDispatcher.setProcessor(configurable, processor);
            }
        }
        return processor;
    }

    protected void processMessage(MessageContext messageContext, Object object) throws Exception, WebServicesFault {
        SOAPPort sOAPPort = messageContext.getPort();
        Processor processor = BasicDispatcher.getProcessor(messageContext.getPort());
        if (processor == null) {
            throw new WebServicesFault(Messages.getMessage("NoProcessor00", sOAPPort.getName()));
        }
        processor.processMessage(messageContext, this, object);
    }

    protected void resolveOperation(MessageContext messageContext) throws Exception, WebServicesFault {
        SOAPPort sOAPPort = messageContext.getPort();
        Processor processor = BasicDispatcher.getProcessor(messageContext.getPort());
        if (processor == null) {
            throw new WebServicesFault(Messages.getMessage("NoProcessor00", sOAPPort.getName()));
        }
        processor.resolveOperation(messageContext);
    }

    public abstract void bindPortToDispatcher(SOAPPort var1) throws WebServicesFault;

    public abstract void invoke(MessageContext var1) throws WebServicesFault;

    public abstract Object invokeOperation(OperationDesc var1, Object var2, Object[] var3, MessageContext var4) throws WebServicesFault, InvocationTargetException;
}

