/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.security.AuthenticatedUser;
import com.ibm.ws.webservices.engine.security.SecurityProvider;
import com.ibm.ws.webservices.engine.security.simple.SimpleSecurityProvider;
import org.apache.commons.logging.Log;

public class SimpleAuthenticationHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(SimpleAuthenticationHandler.class.getName());

    public void invoke(MessageContext messageContext) throws WebServicesFault {
        SecurityProvider securityProvider;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SimpleAuthenticationHandler::invoke");
        }
        if ((securityProvider = (SecurityProvider)messageContext.getProperty("securityProvider")) == null) {
            securityProvider = new SimpleSecurityProvider();
            messageContext.setProperty("securityProvider", securityProvider);
        }
        if (securityProvider != null) {
            String string = messageContext.getUsername();
            if (string == null || string.equals("")) {
                throw new WebServicesFault("Server.Unauthenticated", Messages.getMessage("cantAuth00", string), null, null);
            }
            String string2 = messageContext.getPassword();
            AuthenticatedUser authenticatedUser = securityProvider.authenticate(messageContext);
            if (authenticatedUser == null) {
                throw new WebServicesFault("Server.Unauthenticated", Messages.getMessage("cantAuth01", string), null, null);
            }
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("auth00", string));
            }
            messageContext.setProperty(MessageContext.AUTHUSER, authenticatedUser);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SimpleAuthenticationHandler::invoke");
        }
    }
}

