/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.GuardedMessageContext;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.logging.Log;

public class SOAPHandlerChain
extends JAXRPCHandlerChain {
    protected static Log log = LogFactory.getLog(SOAPHandlerChain.class.getName());

    public SOAPHandlerChain(List list, Collection collection) {
        super(list, collection);
    }

    public boolean handleRequest(MessageContext messageContext) throws WebServicesFault {
        SOAPPart sOAPPart;
        SOAPMessage sOAPMessage;
        if (messageContext.isServer() && (sOAPMessage = messageContext.getMessage()) != null && (sOAPPart = sOAPMessage.getSOAPPart()) != null) {
            try {
                OperationDesc operationDesc;
                SOAPBody sOAPBody = (SOAPBody)sOAPPart.getEnvelope().getBody();
                if (sOAPBody != null) {
                    sOAPBody.setProtect(true);
                    sOAPBody.getSOAPFactory().setProtectState(true);
                }
                if ((operationDesc = messageContext.getOperation()) != null) {
                    Set set = operationDesc.getHeaderParamQNames();
                    SOAPHeader sOAPHeader = (SOAPHeader)sOAPPart.getEnvelope().getHeader();
                    if (set != null && !set.isEmpty()) {
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            QName qName = (QName)iterator.next();
                            SOAPElement sOAPElement = sOAPHeader.getChildElement(qName.getNamespaceURI(), qName.getLocalPart());
                            if (sOAPElement == null) continue;
                            sOAPElement.setProtect(true);
                        }
                    }
                }
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.handlers.soap.SOAPHandlerChain.handleRequest", "128", this);
                throw new WebServicesFault(Messages.getMessage("jaxRpcHandlerSetProtectState00"), sOAPException);
            }
        }
        return super.handleRequest(messageContext);
    }

    protected void checkProtectedStateViolation(MessageContext messageContext, String string) throws SOAPFaultException {
        SOAPMessage sOAPMessage = messageContext.getMessage();
        if (sOAPMessage == null) {
            throw new SOAPFaultException(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Server"), Messages.getMessage("jaxRpcHandlerProtectedStateViolation02", string), string, null);
        }
        SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
        if (sOAPPart == null) {
            throw new SOAPFaultException(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Server"), Messages.getMessage("jaxRpcHandlerProtectedStateViolation01", string), string, null);
        }
        try {
            SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)sOAPPart.getEnvelope();
            if (sOAPEnvelope.getSOAPFactory().getProtectionViolation()) {
                throw new SOAPFaultException(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Server"), Messages.getMessage("jaxRpcHandlerProtectedStateViolation00", string), string, null);
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.handlers.soap.SOAPHandlerChain.checkProtectedStateViolation", "134", this);
            log.error(Messages.getMessage("jaxRpcHandlerProtectedStateViolation03", string), sOAPException);
            throw new SOAPFaultException(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Server"), Messages.getMessage("jaxRpcHandlerProtectedStateViolation03", string), string, null);
        }
    }

    public void preHandleIncoming(MessageContext messageContext) {
        if (!messageContext.isHighFidelity() && this.isSOAPBodyAccessRequired(this)) {
            messageContext.setHighFidelity(true);
        }
        super.preHandleIncoming(messageContext);
    }

    protected com.ibm.wsspi.webservices.rpc.handler.MessageContext getHandlerMC(MessageContext messageContext) {
        return new GuardedMessageContext(messageContext);
    }

    private boolean isSOAPBodyAccessRequired(SOAPHandlerChain sOAPHandlerChain) {
        Boolean bl = new Boolean(System.getProperty("com.ibm.websphere.webservices.saaj.accessSOAPBody", "false"));
        boolean bl2 = false;
        Iterator iterator = sOAPHandlerChain.iterator();
        while (iterator.hasNext() && !bl2) {
            HandlerInfo handlerInfo = (HandlerInfo)iterator.next();
            bl2 = this.isSOAPBodyAccessRequiredForHandler(handlerInfo, bl);
        }
        return bl2;
    }

    private boolean isSOAPBodyAccessRequiredForHandler(HandlerInfo handlerInfo, Boolean bl) {
        String string;
        boolean bl2 = bl;
        Map map = handlerInfo.getHandlerConfig();
        if (map != null && (string = (String)map.get("saaj.accessSOAPBody")) != null) {
            bl2 = JavaUtils.isTrueExplicitly(string);
        }
        return bl2;
    }
}

