/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.Config;
import com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache;
import com.ibm.ws.webservices.engine.transport.channel.OutboundOutputStream;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSCFEndPointCriteriaImpl;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPSessionContext;
import com.ibm.ws.webservices.engine.transport.http.HttpChannelAddress;
import com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection;
import com.ibm.ws.webservices.engine.transport.security.ConfigSSL;
import com.ibm.ws.webservices.engine.transport.security.ConfigSSLProvider;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPrompt;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPromptFactory;
import com.ibm.ws.webservices.engine.transport.security.WSConfigSSLChangeListener;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.rule.AttributeRule;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;

public class HTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog(HTTPSender.class.getName());
    private static String IN_PROCESS_ENABLED = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        block101: {
            Object object;
            Object object2;
            Object object3;
            OutboundConnectionCache outboundConnectionCache;
            WSOutboundConnection wSOutboundConnection;
            block93: {
                block100: {
                    block92: {
                        if (log.isDebugEnabled()) {
                            log.debug(Messages.getMessage("enter00", "HTTPSender::invoke"));
                        }
                        wSOutboundConnection = null;
                        outboundConnectionCache = (OutboundConnectionCache)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return OutboundConnectionCache.getInstance();
                            }
                        });
                        WSChannelManager wSChannelManager = WSChannelManager.getInstance();
                        Object object4 = null;
                        MessageContext messageContext2 = MessageContext.getCurrentThreadsContext();
                        object3 = messageContext2.getProperty("com.ibm.ws.wsaddressing.RedirectRequired");
                        object2 = messageContext2.getProperty(HTTPConstants.MC_HTTP_OUTBOUND_ASYNC_RESPONSE);
                        if (log.isDebugEnabled()) {
                            log.debug("com.ibm.ws.wsaddressing.RedirectRequired: " + (object3 == null ? "" : object3));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(HTTPConstants.MC_HTTP_OUTBOUND_ASYNC_RESPONSE + ": " + (object2 == null ? "" : object2));
                        }
                        object = null;
                        try {
                            try {
                                Object object5;
                                int n;
                                Object object6;
                                Object object7;
                                HashMap<String, SelectionRule[]> hashMap;
                                Object object8;
                                block99: {
                                    block97: {
                                        Identity identity;
                                        block98: {
                                            Object object9;
                                            WSCFEndPointCriteriaImpl wSCFEndPointCriteriaImpl;
                                            URL uRL;
                                            block96: {
                                                block95: {
                                                    block90: {
                                                        uRL = messageContext.getTargetEndpointAddressAsURL();
                                                        wSCFEndPointCriteriaImpl = null;
                                                        wSCFEndPointCriteriaImpl = uRL.getProtocol().equalsIgnoreCase("http") ? new WSCFEndPointCriteriaImpl(1) : new WSCFEndPointCriteriaImpl(2);
                                                        if (log.isDebugEnabled()) {
                                                            log.debug("javax.xml.rpc.service.endpoint.address: " + uRL.toString());
                                                        }
                                                        object4 = WSAddress.getAddress(uRL);
                                                        identity = wSChannelManager.clusterIdenFromEPR(wSCFEndPointCriteriaImpl);
                                                        if (identity != null) break block95;
                                                        if (log.isDebugEnabled()) {
                                                            log.debug(Messages.getMessage("clusterFromWsAddr", String.valueOf(identity)));
                                                        }
                                                        if ((object4 = HttpChannelAddress.getProxyAddress(uRL, (TransportClientProperties)(object8 = TransportClientPropertiesFactory.create(uRL.getProtocol())))) == null) {
                                                            object4 = WSAddress.getAddress(uRL);
                                                        } else if (log.isDebugEnabled()) {
                                                            log.debug(Messages.getMessage("targetAddress01", object4.toString()));
                                                        }
                                                        if (wSChannelManager.getRuntime() == 3 || wSChannelManager.isEPRFragile()) break block96;
                                                        try {
                                                            if (IN_PROCESS_ENABLED == null) {
                                                                if (log.isDebugEnabled()) {
                                                                    log.debug(Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.webcontainer.WebContainer"));
                                                                }
                                                                if ((hashMap = ClassUtils.forName("com.ibm.wsspi.webcontainer.WebContainer")) != null) {
                                                                    if (log.isDebugEnabled()) {
                                                                        log.debug(Messages.getMessage("invokeMethod00", "getWebContainerProperties", "com.ibm.wsspi.webcontainer.WebContainer"));
                                                                    }
                                                                    if ((object9 = (Properties)((Method)(object7 = ((Class)((Object)hashMap)).getMethod("getWebContainerProperties", null))).invoke(null, null)) != null) {
                                                                        IN_PROCESS_ENABLED = ((Properties)object9).getProperty("enableinprocessconnections");
                                                                    }
                                                                }
                                                            }
                                                            if (log.isDebugEnabled()) {
                                                                log.debug("enableInProcessConnections : " + (IN_PROCESS_ENABLED == null ? "" : IN_PROCESS_ENABLED));
                                                            }
                                                            if (IN_PROCESS_ENABLED == null) {
                                                                IN_PROCESS_ENABLED = "null";
                                                            }
                                                        }
                                                        catch (Exception exception) {
                                                            if (IN_PROCESS_ENABLED == null) {
                                                                IN_PROCESS_ENABLED = "null";
                                                            }
                                                            if (!log.isDebugEnabled()) break block90;
                                                            log.debug(exception.toString() + " is caught. Failed to read WebContainer properties. Proceed with HTTP in-process connection disabled.");
                                                        }
                                                    }
                                                    hashMap = MessageContext.getCurrentThreadsContext().getStrProp("com.ibm.ws.webservices.rrdEnabled");
                                                    if (log.isDebugEnabled()) {
                                                        log.debug("com.ibm.ws.webservices.rrdEnabled: " + (String)(hashMap == null ? "" : hashMap));
                                                    }
                                                    if (IN_PROCESS_ENABLED != null && IN_PROCESS_ENABLED.equalsIgnoreCase("true") || Boolean.valueOf((String)((Object)hashMap)).booleanValue()) {
                                                        identity = wSChannelManager.clusterIdenFromDWLMClient((WSAddress)object4, wSCFEndPointCriteriaImpl);
                                                        if (log.isDebugEnabled()) {
                                                            log.debug(Messages.getMessage("clusterFromRequestMapper", String.valueOf(identity), object4.toString()));
                                                        }
                                                    }
                                                    break block96;
                                                }
                                                if (log.isDebugEnabled()) {
                                                    log.debug(Messages.getMessage("clusterFromWsAddr", String.valueOf(identity)));
                                                }
                                            }
                                            if (identity == null) break block97;
                                            object8 = null;
                                            hashMap = (Map)messageContext.getProperty("com.ibm.ws.webservices.wlmselectioncriteria");
                                            if (log.isDebugEnabled()) {
                                                log.debug("com.ibm.ws.webservices.wlmselectioncriteria: " + (hashMap == null ? "" : ((Object)hashMap).toString()));
                                            }
                                            if (wSCFEndPointCriteriaImpl.getEPRtype() == 1) {
                                                if (log.isDebugEnabled()) {
                                                    log.debug("Encountered WLM EPR. Check for session affinity information.");
                                                }
                                                if ((object7 = this.getCookieValue("SSLJSESSION", messageContext2)) == null) {
                                                    object7 = this.getCookieValue("JSESSIONID", messageContext2);
                                                    if (object7 != null && log.isDebugEnabled()) {
                                                        log.debug("JSESSIONID=" + (String)object7);
                                                    }
                                                } else if (log.isDebugEnabled()) {
                                                    log.debug("SSLJSESSION=" + (String)object7);
                                                }
                                                if (object7 != null && (object9 = ((String)object7).split(":")) != null && ((String[])object9).length > 1) {
                                                    int n2 = ((String[])object9).length;
                                                    object6 = new SelectionRule[n2];
                                                    for (n = 1; n < n2; ++n) {
                                                        object5 = new HashSet();
                                                        object5.add(object9[n]);
                                                        object6[n2 - n - 1] = new AttributeRule((Set)object5);
                                                    }
                                                    object6[n2 - 1] = new DefaultRule();
                                                    if (hashMap == null) {
                                                        hashMap = new HashMap<String, SelectionRule[]>();
                                                    }
                                                    if (log.isDebugEnabled()) {
                                                        log.debug("Setting rules.precedence");
                                                    }
                                                    hashMap.put("rules.precedence", (SelectionRule[])object6);
                                                }
                                            }
                                            if ((object8 = wSChannelManager.identityToCFEndPoint(identity, wSCFEndPointCriteriaImpl, hashMap)) == null) break block98;
                                            object7 = uRL.getProtocol() + "://" + object8.getAddress().getHostName() + ":" + object8.getPort() + uRL.getFile();
                                            object4 = WSAddress.getAddress(new URL((String)object7));
                                            ((WSAddress)object4).setCFEndPoint((CFEndPoint)object8);
                                            if (object8.isLocal()) {
                                                if (log.isDebugEnabled()) {
                                                    log.debug(Messages.getMessage("usedHttpChannelType", "In-process"));
                                                }
                                                break block99;
                                            } else if (log.isDebugEnabled()) {
                                                log.debug(Messages.getMessage("usedHttpChannelType", "Network"));
                                            }
                                            break block99;
                                        }
                                        if (log.isDebugEnabled()) {
                                            log.debug(Messages.getMessage("cannotConvertCFEndPt", String.valueOf(identity)));
                                        }
                                        break block99;
                                    }
                                    if (log.isDebugEnabled()) {
                                        log.debug(Messages.getMessage("usedHttpChannelType", "Network"));
                                    }
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug(Messages.getMessage("targetAddress00", object4.toString()));
                                }
                                if (((WSAddress)object4).getSchema() == 2) {
                                    this.setupEffectiveSSLConfiguration((WSAddress)object4);
                                }
                                object8 = messageContext2.getRequestMessage();
                                hashMap = ((Message)object8).getContentType(messageContext2.getSOAPConstants());
                                if (log.isDebugEnabled()) {
                                    log.debug("HTTP Content-Type: " + (String)((Object)hashMap));
                                }
                                object7 = new OutboundOutputStream((String)((Object)hashMap));
                                ((Message)object8).writeTo((OutputStream)object7);
                                ((Message)object8).removeAllAttachments();
                                int n3 = 0;
                                Integer n4 = null;
                                object6 = null;
                                n = 0;
                                while (n == 0) {
                                    boolean bl;
                                    wSOutboundConnection = outboundConnectionCache.findGroupAndGetConnection((WSAddress)object4);
                                    try {
                                        if (wSOutboundConnection == null) throw new WebServicesFault("No WSOutboundConnection object returned from outbound connection pool.");
                                        if (MessageTrace.isTraceEnabled() && hashMap != null && object7 != null) {
                                            MessageTrace.log(MessageTrace.OUTBOUND_HTTP_REQUEST, (String)((Object)hashMap), ((ByteArrayOutputStream)object7).toByteArray());
                                        }
                                        if (object3 != null && object2 != null) {
                                            if (log.isDebugEnabled()) {
                                                log.debug(Messages.getMessage("redirectedAsyncDelivery", wSOutboundConnection.toString()));
                                            }
                                            object = wSOutboundConnection.sendSOAPRequestAsync((OutboundOutputStream)object7);
                                        } else {
                                            wSOutboundConnection.sendSOAPRequest((OutboundOutputStream)object7);
                                        }
                                    }
                                    catch (SocketTimeoutException socketTimeoutException) {
                                        FFDCFilter.processException((Throwable)socketTimeoutException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "546", this);
                                        TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create(((WSAddress)object4).getSchemaInString());
                                        bl = false;
                                        bl = ((DefaultHTTPTransportClientProperties)transportClientProperties).isResendEnabled();
                                        if (!wSOutboundConnection.hasbeenUsed()) throw WebServicesFault.makeFault(socketTimeoutException);
                                        if (wSOutboundConnection.isMessageSent()) throw WebServicesFault.makeFault(socketTimeoutException);
                                        if (bl) throw WebServicesFault.makeFault(socketTimeoutException);
                                        if (log.isDebugEnabled()) {
                                            log.debug("SOAP message has not been sent and messageResend is disabled. Use another connection object.");
                                        }
                                        wSOutboundConnection.disconnect(socketTimeoutException);
                                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                        continue;
                                    }
                                    catch (SocketException socketException) {
                                        FFDCFilter.processException((Throwable)socketException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "575", this);
                                        TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create(((WSAddress)object4).getSchemaInString());
                                        bl = false;
                                        bl = ((DefaultHTTPTransportClientProperties)transportClientProperties).isResendEnabled();
                                        if (!wSOutboundConnection.hasbeenUsed()) throw WebServicesFault.makeFault(socketException);
                                        if (wSOutboundConnection.isMessageSent()) throw WebServicesFault.makeFault(socketException);
                                        if (bl) throw WebServicesFault.makeFault(socketException);
                                        if (log.isDebugEnabled()) {
                                            log.debug("SOAP message has not been sent and messageResend is disabled. Use another connection object.");
                                        }
                                        wSOutboundConnection.disconnect(socketException);
                                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                        continue;
                                    }
                                    if (object3 != null && object2 != null) {
                                        n = 1;
                                        continue;
                                    }
                                    wSOutboundConnection.receiveSOAPResponse();
                                    n4 = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                                    object6 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                                    if (n4 != null) {
                                        if (log.isDebugEnabled()) {
                                            log.debug(Messages.getMessage("httpStatusInResponse00", n4.toString(), (String)object6));
                                        }
                                        if ((n3 = n4.intValue()) == HttpConstants.STATUS_FOUND.getIntCode()) {
                                            if (!HTTPSender.isHttpRedirectEnabled()) {
                                                n = 1;
                                                throw new WebServicesFault(Messages.getMessage("http302StatusCode", object4.toString()));
                                            }
                                            object6 = messageContext.getStrProp(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                                            if (JavaUtils.hasValue((String)object6)) {
                                                object4 = WSAddress.getAddress(new URL((String)object6));
                                                if (log.isDebugEnabled()) {
                                                    log.debug(Messages.getMessage("http302StatusCode", object4.toString()));
                                                }
                                                if (wSOutboundConnection.getTargetAddress().getSchema() == 2) {
                                                    this.restoreSSLConfiguration(wSOutboundConnection);
                                                }
                                                wSOutboundConnection.disconnect(null);
                                                outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                                wSOutboundConnection = null;
                                                if (((WSAddress)object4).getSchema() == 2) {
                                                    this.setupEffectiveSSLConfiguration((WSAddress)object4);
                                                }
                                            } else {
                                                if (log.isDebugEnabled()) {
                                                    log.debug(Messages.getMessage("http302StatusCode", ""));
                                                }
                                                n = 1;
                                            }
                                            messageContext.removeProperty(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                                            continue;
                                        }
                                        if (n3 == HttpConstants.STATUS_UNAUTHORIZED.getIntCode()) {
                                            if (wSChannelManager.getRuntime() != 1) {
                                                object5 = messageContext.getStrProp("WWW-Authenticate");
                                                boolean bl2 = (Boolean)messageContext.getProperty("com.ibm.ws.webservices.spnegoUsed");
                                                if (bl2 && object5 != null && ((String)object5).indexOf("Negotiate") == 0) {
                                                    log.debug("WWW-Authenticate: " + (String)object5);
                                                    n = 1;
                                                    continue;
                                                }
                                                if (this.receivedHTTPBasicAuth()) {
                                                    log.debug(Messages.getMessage("challengeStatus01"));
                                                    wSOutboundConnection.reset();
                                                    outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                                    wSOutboundConnection = null;
                                                    continue;
                                                }
                                                log.debug(Messages.getMessage("challengeStatus02"));
                                                n = 1;
                                                continue;
                                            }
                                            n = 1;
                                            continue;
                                        }
                                        n = 1;
                                        continue;
                                    }
                                    n = 1;
                                }
                                if (object3 != null && object2 != null) {
                                    Object var24_31 = null;
                                    break block92;
                                }
                                if (n3 == 0) throw new WebServicesFault(Messages.getMessage("httpStatusInResponse01"));
                                object5 = ((HttpOutboundChannelConnection)wSOutboundConnection).getHeaderFromResponse(HttpConstants.HDR_CONTENT_TYPE);
                                this.processStatusCode(n3, (String)object5, (WSAddress)object4);
                                break block93;
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "740", this);
                                if (log.isDebugEnabled()) {
                                    log.debug(Messages.getMessage("exception01", exception.toString()));
                                    if (JavaUtils.hasValue(object4.toString())) {
                                        log.debug("URL = " + object4.toString());
                                    } else {
                                        log.debug("URL = " + messageContext.getTargetEndpointAddress());
                                    }
                                }
                                if (wSOutboundConnection == null) throw WebServicesFault.makeFault(exception);
                                wSOutboundConnection.disconnect(exception);
                                throw WebServicesFault.makeFault(exception);
                            }
                        }
                        catch (Throwable throwable) {
                            block94: {
                                Object var24_33 = null;
                                try {
                                    if (wSOutboundConnection == null) break block94;
                                    if (wSOutboundConnection.getTargetAddress().getSchema() == 2) {
                                        this.restoreSSLConfiguration(wSOutboundConnection);
                                    }
                                    if (object3 != null && object2 != null) {
                                        if (log.isDebugEnabled()) {
                                            log.debug(Messages.getMessage("returnOCforAsyncDelivery", wSOutboundConnection.toString(), object.toString()));
                                        }
                                        break block94;
                                    }
                                    wSOutboundConnection.reset();
                                    outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                                    wSOutboundConnection = null;
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "786", this);
                                    if (!log.isDebugEnabled()) throw WebServicesFault.makeFault(exception);
                                    log.debug(Messages.getMessage("exception01", exception.toString()));
                                    throw WebServicesFault.makeFault(exception);
                                }
                            }
                            if (!log.isDebugEnabled()) throw throwable;
                            log.debug(Messages.getMessage("exit00", "HTTPSender::invoke"));
                            throw throwable;
                        }
                    }
                    try {}
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "786", this);
                        if (!log.isDebugEnabled()) throw WebServicesFault.makeFault(exception);
                        log.debug(Messages.getMessage("exception01", exception.toString()));
                        throw WebServicesFault.makeFault(exception);
                    }
                    if (wSOutboundConnection == null) break block100;
                    if (wSOutboundConnection.getTargetAddress().getSchema() == 2) {
                        this.restoreSSLConfiguration(wSOutboundConnection);
                    }
                    if (object3 != null && object2 != null) {
                        if (log.isDebugEnabled()) {
                            log.debug(Messages.getMessage("returnOCforAsyncDelivery", wSOutboundConnection.toString(), object.toString()));
                        }
                    } else {
                        wSOutboundConnection.reset();
                        outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                        wSOutboundConnection = null;
                    }
                }
                if (!log.isDebugEnabled()) return;
                log.debug(Messages.getMessage("exit00", "HTTPSender::invoke"));
                return;
            }
            Object var24_32 = null;
            try {}
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "786", this);
                if (!log.isDebugEnabled()) throw WebServicesFault.makeFault(exception);
                log.debug(Messages.getMessage("exception01", exception.toString()));
                throw WebServicesFault.makeFault(exception);
            }
            if (wSOutboundConnection == null) break block101;
            if (wSOutboundConnection.getTargetAddress().getSchema() == 2) {
                this.restoreSSLConfiguration(wSOutboundConnection);
            }
            if (object3 != null && object2 != null) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("returnOCforAsyncDelivery", wSOutboundConnection.toString(), object.toString()));
                }
            } else {
                wSOutboundConnection.reset();
                outboundConnectionCache.findGroupAndReturnConnection(wSOutboundConnection);
                wSOutboundConnection = null;
            }
        }
        if (!log.isDebugEnabled()) return;
        log.debug(Messages.getMessage("exit00", "HTTPSender::invoke"));
    }

    private String getCookieValue(String string, MessageContext messageContext) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "HTTPSender::getCookieValue"));
        }
        String string2 = null;
        String string3 = null;
        if (log.isDebugEnabled()) {
            log.debug("Get value of cookie: " + string);
        }
        if (messageContext.getMaintainSession()) {
            if (log.isDebugEnabled()) {
                log.debug("javax.xml.rpc.session.maintain:  TRUE");
            }
            object = messageContext.getProperty("com.ibm.ws.webservices.engine.session.context");
            if (log.isDebugEnabled()) {
                log.debug("HTTPSessionContext object: " + object);
            }
            if (object != null) {
                string3 = ((HTTPSessionContext)object).getCookie();
                if (string3 != null) {
                    string2 = this.parseCookieString(string3, string);
                }
                if ((string3 == null || string2 == null) && (string3 = ((HTTPSessionContext)object).getCookie2()) != null) {
                    string2 = this.parseCookieString(string3, string);
                }
            }
        }
        if (string2 == null) {
            object = (HashMap)messageContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
            if (log.isDebugEnabled()) {
                log.debug("com.ibm.websphere.webservices.requestTransportProperties: " + object);
            }
            if (object != null) {
                string3 = (String)((HashMap)object).get("Cookie");
                if (string3 != null) {
                    string2 = this.parseCookieString(string3, string);
                }
                if ((string3 == null || string2 == null) && (string3 = (String)((HashMap)object).get("Cookie2")) != null) {
                    string2 = this.parseCookieString(string3, string);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("exit00", "HTTPSender::getCookieValue"));
        }
        return string2;
    }

    private String parseCookieString(String string, String string2) {
        String[] stringArray = null;
        stringArray = string.split(";");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringArray[i].indexOf(string2) != 0) continue;
                return stringArray[i].split("=")[1];
            }
        }
        return null;
    }

    private void setupEffectiveSSLConfiguration(final WSAddress wSAddress) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "HTTPSender::setupEffectiveSSLConfiguration"));
        }
        Config config = null;
        final MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        try {
            config = (Config)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WebServicesFault {
                    return ConfigSSLProvider.getInstance().getConfig(messageContext, wSAddress);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "%C", this);
            log.debug(privilegedActionException);
            throw (WebServicesFault)privilegedActionException.getException();
        }
        if (log.isDebugEnabled()) {
            log.debug("Effective SSL configuration: " + (config == null ? null : config.toString()));
        }
        if (config == null) {
            throw new WebServicesFault(Messages.getMessage("sslConfigResolveFailed01", wSAddress.toString()));
        }
        wSAddress.setTransportConfiguration(config);
        config.addTargetAddress(wSAddress);
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("exit00", "HTTPSender::setupEffectiveSSLConfiguration"));
        }
    }

    private void restoreSSLConfiguration(final WSOutboundConnection wSOutboundConnection) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "HTTPSender::restoreSSLConfiguration"));
        }
        final Log log = HTTPSender.log;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WebServicesFault {
                    JSSEHelper jSSEHelper = JSSEHelper.getInstance();
                    ConfigSSL configSSL = (ConfigSSL)wSOutboundConnection.getTargetAddress().transportConfiguration();
                    if (configSSL != null) {
                        WSConfigSSLChangeListener wSConfigSSLChangeListener = configSSL.getlistener();
                        if (wSConfigSSLChangeListener != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("De-registering WSConfigSSLChangeListener: " + wSConfigSSLChangeListener);
                            }
                            wSConfigSSLChangeListener.deRegister();
                        }
                        Properties properties = configSSL.getPreCfg();
                        if (log.isDebugEnabled()) {
                            if (properties != null) {
                                log.debug("Restoring previously saved SSL configuration: " + properties);
                            } else {
                                log.debug("No previously saved SSL configuration to be restored.");
                            }
                        }
                        jSSEHelper.setSSLPropertiesOnThread(properties);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.restoreSSLConfiguration", "1059", this);
            if (log.isDebugEnabled()) {
                HTTPSender.log.debug(privilegedActionException);
            }
            throw WebServicesFault.makeFault(privilegedActionException.getException());
        }
        if (HTTPSender.log.isDebugEnabled()) {
            HTTPSender.log.debug(Messages.getMessage("exit00", "HTTPSender::restoreSSLConfiguration"));
        }
    }

    private void processStatusCode(int n, String string, WSAddress wSAddress) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "HTTPSender::processStatusCode"));
        }
        MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        String string2 = string = null == string ? null : string.trim();
        if (!(n > 199 && n < 300 || string != null && !string.startsWith("text/html") && n > 499 && n < 600)) {
            String string3 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            String string4 = wSAddress.getSchemaInString().toLowerCase() + "://" + wSAddress.getHostname() + ":" + wSAddress.getPort();
            WebServicesFault webServicesFault = new WebServicesFault("HTTP", "( " + n + " ) " + string3, string4, null);
            String string5 = messageContext.getResponseMessage() == null ? "" : messageContext.getResponseMessage().getSOAPPartAsString();
            webServicesFault.setFaultDetailString(Messages.getMessage("return01", "( " + n + " ) " + string3, string5));
            throw webServicesFault;
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("exit00", "HTTPSender::processStatusCode"));
        }
    }

    public String getCookieFromHeaders(String string, String string2, Hashtable hashtable) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "HTTPSender::getCookieFromHeaders"));
        }
        String string3 = null;
        if (hashtable.containsKey(string2.toLowerCase())) {
            string3 = (String)hashtable.get(string2.toLowerCase());
            int n = (string3 = string3.trim()).indexOf(59);
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("exit00", "HTTPSender::getCookieFromHeaders"));
        }
        return string3;
    }

    public static boolean isHttpRedirectEnabled() {
        boolean bl = false;
        MessageContext messageContext = MessageContext.getCurrentThreadsContext();
        Boolean bl2 = (Boolean)messageContext.getProperty("http.redirect.enabled");
        if (bl2 != null) {
            if (log.isDebugEnabled()) {
                log.debug("Programmatic value of http.redirect.enabled: " + bl2);
            }
            return bl2;
        }
        bl2 = (Boolean)messageContext.getProperty("com.ibm.ws.webservices.HttpRedirectEnabled");
        if (bl2 != null) {
            if (log.isDebugEnabled()) {
                log.debug("Programmatic value of com.ibm.ws.webservices.HttpRedirectEnabled: " + bl2);
            }
            return bl2;
        }
        String string = System.getProperty("http.redirect.enabled");
        if (string != null) {
            bl = Boolean.valueOf(string);
            if (log.isDebugEnabled()) {
                log.debug("System property value of http.redirect.enabled: " + string);
            }
            return bl;
        }
        string = System.getProperty("com.ibm.ws.webservices.HttpRedirectEnabled");
        if (string != null) {
            bl = Boolean.valueOf(string);
            if (log.isDebugEnabled()) {
                log.debug("System property value of com.ibm.ws.webservices.HttpRedirectEnabled: " + string);
            }
            return bl;
        }
        if (log.isDebugEnabled()) {
            log.debug("http.redirect.enabled: " + bl2);
            log.debug("com.ibm.ws.webservices.HttpRedirectEnabled: " + string);
        }
        return bl;
    }

    private boolean receivedHTTPBasicAuth() {
        MessageContext messageContext;
        boolean bl;
        block10: {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("enter00", "HTTPSender::receiveHTTPBasicAuth"));
            }
            bl = false;
            messageContext = MessageContext.getCurrentThreadsContext();
            if (!JavaUtils.hasValue(messageContext.getUsername()) && !JavaUtils.hasValue(messageContext.getPassword())) {
                String string = System.getProperty("com.ibm.ws.webservices.loginSource");
                if (log.isDebugEnabled()) {
                    log.debug("com.ibm.ws.webservices.loginSource: " + string);
                }
                try {
                    if (!JavaUtils.hasValue(string) || "prompt".compareToIgnoreCase(string) != 0 && "stdin".compareToIgnoreCase(string) != 0) break block10;
                    SecurityDataPrompt securityDataPrompt = SecurityDataPromptFactory.getPrompt(string);
                    String[] stringArray = null;
                    try {
                        final String string2 = messageContext.getStrProp("WWW-Authenticate");
                        final SecurityDataPrompt securityDataPrompt2 = securityDataPrompt;
                        if (log.isDebugEnabled()) {
                            log.debug(Messages.getMessage("challengeRealmInfo", string2));
                        }
                        stringArray = (String[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return securityDataPrompt2.launch(string2 == null ? "" : string2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.receivedHTTPBasicAuth", "1275", this);
                        log.debug(privilegedActionException);
                        throw privilegedActionException.getException();
                    }
                    if (stringArray != null && JavaUtils.hasValue(stringArray[0]) && JavaUtils.hasValue(stringArray[1])) {
                        messageContext.setUsername(stringArray[0]);
                        messageContext.setPassword(stringArray[1]);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.receivedHTTPBasicAuth", "1290", this);
                    if (!log.isDebugEnabled()) break block10;
                    log.debug(Messages.getMessage("exception01", exception.toString()));
                }
            }
        }
        messageContext.removeProperty("WWW-Authenticate");
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("exit00", "HTTPSender::receiveHTTPBasicAuth"));
        }
        return bl;
    }
}

