/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.http.WebServicesServlet;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;

public class WebServicesServletBase
extends HttpServlet {
    protected ServerEngine webServicesServer = null;
    private static Log log = LogFactory.getLog(WebServicesServlet.class.getName());
    private static boolean isDebug = false;
    private static int loadCounter = 0;
    private static Object loadCounterLock = new Object();
    protected static final String ATTR_WEBSERVICES_ENGINE = "WebServicesEngine";
    private String webInfPath = null;
    private String homeDir = null;
    private boolean isDevelopment;
    private static final String INIT_PROPERTY_DEVELOPMENT_SYSTEM = "webservices.development.system";

    public void init() {
        ServletContext servletContext = this.getServletConfig().getServletContext();
        this.webInfPath = servletContext.getRealPath("/WEB-INF");
        this.homeDir = servletContext.getRealPath("/");
        isDebug = log.isDebugEnabled();
        if (log.isDebugEnabled()) {
            log.debug("In WebServicesServletBase init");
        }
        this.isDevelopment = JavaUtils.isTrueExplicitly(this.getOption(servletContext, INIT_PROPERTY_DEVELOPMENT_SYSTEM, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        super.destroy();
        if (this.webServicesServer != null) {
            ServerEngine serverEngine = this.webServicesServer;
            synchronized (serverEngine) {
                if (this.webServicesServer != null) {
                    this.webServicesServer.destroy();
                    this.webServicesServer = null;
                    WebServicesServletBase.storeEngine(this.getServletContext(), null);
                }
            }
        }
    }

    public ServerEngine getEngine() throws WebServicesFault {
        if (this.webServicesServer == null) {
            this.webServicesServer = WebServicesServletBase.getEngine(this);
        }
        return this.webServicesServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerEngine getEngine(HttpServlet httpServlet) throws WebServicesFault {
        ServletContext servletContext;
        ServerEngine serverEngine = null;
        if (isDebug) {
            log.debug("Enter: getEngine()");
        }
        ServletContext servletContext2 = servletContext = httpServlet.getServletContext();
        synchronized (servletContext2) {
            serverEngine = WebServicesServletBase.retrieveEngine(servletContext);
            if (serverEngine == null) {
                Map map = WebServicesServletBase.getEngineEnvironment(httpServlet);
                serverEngine = ServerEngine.getServer(servletContext, map);
                WebServicesServletBase.storeEngine(servletContext, serverEngine);
            }
        }
        if (isDebug) {
            log.debug("Exit: getEngine()");
        }
        return serverEngine;
    }

    private static void storeEngine(ServletContext servletContext, ServerEngine serverEngine) {
        servletContext.setAttribute(ATTR_WEBSERVICES_ENGINE, serverEngine);
    }

    private static ServerEngine retrieveEngine(ServletContext servletContext) {
        Object object = servletContext.getAttribute(ATTR_WEBSERVICES_ENGINE);
        if (object instanceof ServerEngine) {
            return (ServerEngine)object;
        }
        return null;
    }

    private static Map getEngineEnvironment(HttpServlet httpServlet) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = httpServlet.getInitParameter("webservices.attachments.Directory");
        if (string != null) {
            hashMap.put("webservices.attachments.Directory", string);
        }
        ServletContext servletContext = httpServlet.getServletContext();
        hashMap.put("servletContext", servletContext);
        String string2 = servletContext.getRealPath("/WEB-INF");
        if (string2 != null) {
            hashMap.put("servlet.realpath", string2 + File.separator + "attachments");
        }
        return hashMap;
    }

    public static int getLoadCounter() {
        return loadCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void incLockCounter() {
        Object object = loadCounterLock;
        synchronized (object) {
            ++loadCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void decLockCounter() {
        Object object = loadCounterLock;
        synchronized (object) {
            --loadCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        WebServicesServletBase.incLockCounter();
        try {
            super.service(httpServletRequest, httpServletResponse);
        }
        finally {
            WebServicesServletBase.decLockCounter();
        }
    }

    protected String getWebappBase(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(httpServletRequest.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (httpServletRequest.getServerPort() != 80) {
            stringBuffer.append(":");
            stringBuffer.append(httpServletRequest.getServerPort());
        }
        stringBuffer.append(httpServletRequest.getContextPath());
        return stringBuffer.toString();
    }

    public ServletContext getServletContext() {
        return this.getServletConfig().getServletContext();
    }

    protected String getWebInfPath() {
        return this.webInfPath;
    }

    protected String getHomeDir() {
        return this.homeDir;
    }

    protected String getOption(ServletContext servletContext, String string, String string2) {
        String string3 = WebServicesProperties.getProperty(string);
        if (string3 == null) {
            string3 = this.getInitParameter(string);
        }
        if (string3 == null) {
            string3 = servletContext.getInitParameter(string);
        }
        return string3 != null ? string3 : string2;
    }

    public boolean isDevelopment() {
        return this.isDevelopment;
    }
}

