/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.internal.impl.FieldImpl;

public class BeanPropertyDescriptor {
    protected static Log log = LogFactory.getLog(BeanPropertyDescriptor.class.getName());
    private FieldImpl field = null;
    private String name = null;
    private Method readMethod = null;
    private Method writeMethod = null;
    private Method indexedReadMethod = null;
    private Method indexedWriteMethod = null;
    private JavaHelpers type = null;

    BeanPropertyDescriptor(FieldImpl fieldImpl) {
        this.name = fieldImpl.getName();
        this.type = fieldImpl.getJavaType();
        this.field = fieldImpl;
    }

    BeanPropertyDescriptor(String string, Method method, Method method2, Method method3, Method method4) {
        this.name = string;
        this.readMethod = method;
        this.writeMethod = method2;
        this.indexedReadMethod = method3;
        this.indexedWriteMethod = method4;
        this.type = method.getReturnType();
    }

    BeanPropertyDescriptor(String string, Method method, Method method2) {
        this(string, method, method2, null, null);
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.field != null || this.readMethod != null;
    }

    public boolean isWriteable() {
        return this.field != null || this.writeMethod != null;
    }

    public boolean isIndexed() {
        return this.field != null && this.field.isArray() || this.indexedReadMethod != null;
    }

    public JavaHelpers getType() {
        if (this.isIndexed()) {
            return ((ArrayType)this.type).getComponentTypeAsHelper();
        }
        return this.type;
    }

    public JavaHelpers getRawType() {
        return this.type;
    }

    public boolean isField() {
        return this.field != null;
    }

    public String getReadMethodName() {
        return this.readMethod == null ? null : this.readMethod.getName();
    }

    public String getWriteMethodName() {
        return this.writeMethod == null ? null : this.writeMethod.getName();
    }

    public boolean hasCheckedException() {
        EList eList = null;
        if (this.readMethod != null && (eList = this.readMethod.getJavaExceptions()) != null && eList.size() > 0) {
            return true;
        }
        if (this.writeMethod != null && (eList = this.writeMethod.getJavaExceptions()) != null && eList.size() > 0) {
            return true;
        }
        if (this.indexedReadMethod != null && (eList = this.indexedReadMethod.getJavaExceptions()) != null && eList.size() > 0) {
            return true;
        }
        return this.indexedWriteMethod != null && (eList = this.indexedWriteMethod.getJavaExceptions()) != null && eList.size() > 0;
    }
}

