/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedType;
import com.ibm.ws.webservices.wsdl.symbolTable.SchemaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntryComparator;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.commons.logging.Log;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils {
    protected static Log log = LogFactory.getLog("com.ibm.ws.webservices.wsdl.symbolTable.Utils");
    private static final String DERIVED_TYPES = "derivedTypes";
    private static final String NESTED_TYPES = "nestedTypes";

    public static String getScopedAttribute(Node node, String string, List list) {
        if (node == null) {
            if (list != null && list.size() > 0) {
                node = (Node)list.get(list.size() - 1);
                list = list.subList(0, list.size() - 1);
            } else {
                return null;
            }
        }
        if (node.getAttributes() == null) {
            return Utils.getScopedAttribute(node.getParentNode(), string, list);
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return Utils.getScopedAttribute(node.getParentNode(), string, list);
    }

    public static String getAbsoluteNamespace(Node node, List list, ToolEnv toolEnv) {
        String string = Utils.getScopedAttribute(node, "targetNamespace", list);
        if (node == null || string == null) {
            return null;
        }
        if (string.indexOf(58) >= 0) {
            return string;
        }
        List list2 = list;
        boolean bl = false;
        Node node2 = node.getParentNode();
        String string2 = string;
        while (node2 != null && !bl) {
            String string3 = null;
            Node node3 = null;
            if (node2.getAttributes() != null) {
                node3 = node2.getAttributes().getNamedItem("targetNamespace");
                if (node3 == null) {
                    node3 = node2.getAttributes().getNamedItem("namespace");
                }
                if (node3 != null) {
                    string3 = node3.getNodeValue();
                }
            }
            if (string3 != null && !string3.equals(string2)) {
                string = string3 + string;
                string2 = string3;
                if (string3.indexOf(58) >= 0) {
                    bl = true;
                }
            }
            if ((node2 = node2.getParentNode()) != null || list2 == null || list2.size() <= 0) continue;
            node2 = (Node)list2.get(list2.size() - 1);
            list2 = list2.subList(0, list2.size() - 1);
        }
        if (string.indexOf(58) >= 0) {
            return string;
        }
        if (toolEnv != null) {
            toolEnv.reportWarning(Messages.getMessage("warningRelativeNamespace00", string));
        } else {
            System.err.println(Messages.getMessage("warningRelativeNamespace00", string));
        }
        return string;
    }

    public static String getAttribute(Node node, String string) {
        if (node == null || node.getAttributes() == null) {
            return null;
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static Vector getAttributesWithLocalName(Node node, String string) {
        Vector<Node> vector = new Vector<Node>();
        if (node == null) {
            return vector;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (node2 == null || !node2.getLocalName().equals(string)) continue;
                vector.add(node2);
            }
        }
        return vector;
    }

    public static QName getNodeQName(Node node) {
        if (node == null) {
            return null;
        }
        String string = node.getLocalName();
        if (string == null) {
            return null;
        }
        String string2 = node.getNamespaceURI();
        return QNameTable.createQName(string2, string);
    }

    public static QName getNodeNameQName(Node node, List list, ToolEnv toolEnv) {
        return Utils.getNodeNameQName(node, list, toolEnv, true);
    }

    public static QName getNodeNameQName(Node node, List list, ToolEnv toolEnv, boolean bl) {
        if (node == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        QName qName = Utils.getTypeQNameFromAttr(node, "ref", list, toolEnv, false);
        if (qName != null) {
            string = qName.getLocalPart();
            string2 = qName.getNamespaceURI();
        }
        if (string == null) {
            QName qName2 = Utils.getNodeQName(node);
            QName qName3 = null;
            if (qName2 != null && Constants.equals(qName2, Constants.XSD_ANY)) {
                return qName2;
            }
            if (qName2.getLocalPart().equals("schema")) {
                return null;
            }
            if (qName2.getLocalPart().equals("complexType") || qName2.getLocalPart().equals("simpleType")) {
                string = Utils.getAttribute(node, "name");
                if (string == null && (qName3 = Utils.getNodeNameQName(node.getParentNode(), list, toolEnv)) != null) {
                    string = ">" + qName3.getLocalPart();
                    string2 = qName3.getNamespaceURI();
                }
            } else if (qName2.getLocalPart().equals("group") || qName2.getLocalPart().equals("attributeGroup")) {
                string = Utils.getAttribute(node, "name");
                if (string == null && (qName3 = Utils.getNodeNameQName(node.getParentNode(), list, toolEnv)) != null) {
                    string = ">" + qName3.getLocalPart();
                    string2 = qName3.getNamespaceURI();
                }
            } else if (qName2.getLocalPart().equals("element") || qName2.getLocalPart().equals("attribute") || qName2.getLocalPart().equals("restriction")) {
                qName3 = Utils.getNodeNameQName(node.getParentNode(), list, toolEnv);
                String string3 = Utils.getAttribute(node, "name");
                if (qName3 == null) {
                    string = string3;
                } else if (string3 == null) {
                    string = qName3.getLocalPart();
                    string2 = qName3.getNamespaceURI();
                } else {
                    string = qName3.getLocalPart() + ">" + string3;
                    string2 = qName3.getNamespaceURI();
                }
            } else {
                qName3 = Utils.getNodeNameQName(node.getParentNode(), list, toolEnv);
                if (qName3 != null) {
                    string = qName3.getLocalPart();
                    string2 = qName3.getNamespaceURI();
                }
            }
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = Utils.getAbsoluteNamespace(node, list, toolEnv);
        }
        if (!bl && string.lastIndexOf(">") >= 0) {
            string = string.substring(string.lastIndexOf(">") + 1);
        }
        return QNameTable.createQName(string2, string);
    }

    public static QName getNodeNameQName_v5(Node node, List list) {
        Object object;
        if (node == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        string = Utils.getAttribute(node, "name");
        if (string == null && (object = Utils.getTypeQNameFromAttr(node, "ref", list, null, true)) != null) {
            string = ((QName)object).getLocalPart();
            string2 = ((QName)object).getNamespaceURI();
        }
        if (string == null) {
            string = "";
            object = node.getParentNode();
            while (object != null) {
                QName qName = Utils.getNodeQName((Node)object);
                if (qName != null && Constants.equals(qName, Constants.XSD_ANY)) {
                    return qName;
                }
                if (qName.getLocalPart().equals("schema")) {
                    object = null;
                    continue;
                }
                if (qName.getLocalPart().equals("element") || qName.getLocalPart().equals("attribute")) {
                    string = ">" + Utils.getNodeNameQName_v5((Node)object, list).getLocalPart();
                    object = object.getParentNode();
                    continue;
                }
                if (qName.getLocalPart().equals("complexType") || qName.getLocalPart().equals("simpleType")) {
                    string = Utils.getNodeNameQName_v5((Node)object, list).getLocalPart() + string;
                    object = null;
                    continue;
                }
                object = object.getParentNode();
            }
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = Utils.getScopedAttribute(node, "targetNamespace", list);
        }
        return QNameTable.createQName(string2, string);
    }

    public static QName getTypeQName(Node node, BooleanHolder booleanHolder, boolean bl, List list, ToolEnv toolEnv) {
        return Utils.getTypeQName(node, booleanHolder, bl, list, toolEnv, false);
    }

    public static QName getTypeQName(Node node, BooleanHolder booleanHolder, boolean bl, List list, ToolEnv toolEnv, boolean bl2) {
        if (node == null) {
            return null;
        }
        booleanHolder.value = false;
        QName qName = Utils.getTypeQNameFromAttr(node, "type", list, toolEnv, bl2);
        if (qName == null) {
            booleanHolder.value = true;
            qName = Utils.getTypeQNameFromAttr(node, "ref", list, toolEnv, bl2);
            if (qName == null && Constants.equals(Utils.getNodeQName(node), Constants.XSD_ANY)) {
                qName = Constants.XSD_ANY;
                booleanHolder.value = false;
            }
        }
        if (!bl && qName != null) {
            String string = Utils.getAttribute(node, "maxOccurs");
            String string2 = Utils.getAttribute(node, "minOccurs");
            String string3 = string;
            String string4 = string2;
            if (string == null) {
                string3 = "1";
                string = "";
            }
            if (string2 == null) {
                string4 = "1";
                string2 = "";
            }
            if (!(string4.equals("0") && string3.equals("1") || string3.equals("1") && string4.equals("1"))) {
                String string5 = qName.getLocalPart();
                if (string5.startsWith(">")) {
                    string5 = string5.substring(1);
                }
                string5 = string5 + "[" + string2 + "," + string + "]";
                qName = QNameTable.createQName(qName.getNamespaceURI(), string5);
            }
        }
        if (qName == null) {
            booleanHolder.value = true;
            qName = Utils.getTypeQNameFromAttr(node, "element", list, toolEnv, bl2);
        }
        if (qName == null) {
            booleanHolder.value = false;
            qName = Utils.getTypeQNameFromAttr(node, "base", list, toolEnv, bl2);
        }
        if (qName == null && Utils.getNodeQName(node).getLocalPart().equals("list")) {
            booleanHolder.value = false;
            qName = Utils.getTypeQNameFromAttr(node, "itemType", list, toolEnv, bl2);
        }
        return qName;
    }

    static QName getTypeQNameFromAttr(Node node, String string, List list, ToolEnv toolEnv) {
        return Utils.getTypeQNameFromAttr(node, string, list, toolEnv, false);
    }

    static QName getTypeQNameFromAttr(Node node, String string, List list, ToolEnv toolEnv, boolean bl) {
        QName qName;
        if (node == null) {
            return null;
        }
        String string2 = Utils.getAttribute(node, string);
        if (string2 == null && string.equals("type") && Utils.getAttribute(node, "ref") == null && Utils.getAttribute(node, "base") == null && Utils.getAttribute(node, "element") == null && Utils.getAttribute(node, "itemType") == null) {
            qName = Utils.getAnonQName(node, list, bl, toolEnv);
            if (qName != null) {
                return qName;
            }
            QName qName2 = Utils.getNodeQName(node);
            if (qName2 != null && Constants.isSchemaXSD(qName2.getNamespaceURI()) && (qName2.getLocalPart().equals("element") || qName2.getLocalPart().equals("attribute"))) {
                return Constants.XSD_ANYTYPE;
            }
        }
        if (string2 == null) {
            return null;
        }
        qName = Utils.getQNameFromPrefixedName(node, string2, list);
        return qName;
    }

    private static QName getAnonQName(Node node, List list, boolean bl, ToolEnv toolEnv) {
        QName qName = Utils.getNodeQName(node);
        if (qName != null && (qName.getLocalPart().equals("element") || qName.getLocalPart().equals("attribute") || qName.getLocalPart().equals("list") || qName.getLocalPart().equals("restriction")) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 == null || !qName2.getLocalPart().equals("complexType") && !qName2.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                if (bl) {
                    return Utils.getNodeNameQName_v5(nodeList.item(i), list);
                }
                return Utils.getNodeNameQName(nodeList.item(i), list, toolEnv);
            }
        }
        return null;
    }

    public static QName getQNameFromPrefixedName(Node node, String string, List list) {
        String string2 = string.substring(string.lastIndexOf(":") + 1);
        String string3 = null;
        if (string.length() == string2.length()) {
            string3 = Utils.getScopedAttribute(node, "xmlns", list);
        } else {
            String string4 = string.substring(0, string.lastIndexOf(":"));
            string3 = Utils.getScopedAttribute(node, "xmlns:" + string4, list);
            if (string3 == null && "xml".equals(string4)) {
                string3 = "http://www.w3.org/XML/1998/namespace";
            }
        }
        return QNameTable.createQName(string3, string2);
    }

    public static Set getDerivedTypes(TypeEntry typeEntry, SymbolTable symbolTable) {
        Set set = (TreeSet)typeEntry.getDynamicVar(DERIVED_TYPES);
        if (set != null) {
            return set;
        }
        set = new TreeSet(new SymTabEntryComparator());
        if (Constants.isSchemaXSD(typeEntry.getQName().getNamespaceURI()) && (typeEntry.getQName().getLocalPart().equals("anyType") || typeEntry.getQName().getLocalPart().equals("any"))) {
            set = symbolTable._getAllTypes();
        } else if (typeEntry != null && typeEntry.getNode() != null) {
            Utils._getDerivedTypes(typeEntry, set, symbolTable);
        }
        typeEntry.setDynamicVar(DERIVED_TYPES, set);
        return set;
    }

    private static void _getDerivedTypes(TypeEntry typeEntry, Set set, SymbolTable symbolTable) {
        if (set.size() >= symbolTable.getTypes().size()) {
            return;
        }
        Vector vector = symbolTable.getTypes();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            TypeEntry typeEntry2 = (TypeEntry)iterator.next();
            if (!(typeEntry2 instanceof DefinedType) || set.contains(typeEntry2) || ((DefinedType)typeEntry2).getExtensionBase() != typeEntry && ((DefinedType)typeEntry2).getRestrictionBase() != typeEntry) continue;
            set.add(typeEntry2);
            set.addAll(Utils.getDerivedTypes(typeEntry2, symbolTable));
            if (set.size() < symbolTable.getTypes().size()) continue;
            set = symbolTable._getAllTypes();
            return;
        }
    }

    public static Set getNestedTypes(TypeEntry typeEntry, SymbolTable symbolTable) {
        Set<TypeEntry> set = (TreeSet<TypeEntry>)typeEntry.getDynamicVar(NESTED_TYPES);
        if (set != null) {
            return set;
        }
        set = new TreeSet<TypeEntry>(new SymTabEntryComparator());
        set.add(typeEntry);
        TreeSet treeSet = new TreeSet(new SymTabEntryComparator());
        set = Utils._getNestedTypes(typeEntry, set, symbolTable, true, treeSet);
        typeEntry.setDynamicVar(NESTED_TYPES, set);
        return set;
    }

    private static Set _getNestedTypes(TypeEntry typeEntry, Set set, SymbolTable symbolTable, boolean bl, Set set2) {
        Object object;
        Set set3;
        if (typeEntry == null) {
            return set;
        }
        if (bl) {
            set2.add(typeEntry);
        }
        if ((set3 = (Set)typeEntry.getDynamicVar(NESTED_TYPES)) != null) {
            set.addAll(set3);
            return set;
        }
        if (set.size() >= symbolTable.getTypes().size()) {
            set = symbolTable._getAllTypes();
            return set;
        }
        if (typeEntry.getRefType() == symbolTable.getUnmappableType()) {
            return set;
        }
        Vector vector = null;
        if (typeEntry instanceof Type) {
            vector = ((Type)typeEntry).getChildren();
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.get(i) instanceof ChildElement && !set2.contains(((ChildEntry)(object = (ChildElement)vector.get(i))).getType())) {
                    set.add(((ChildEntry)object).getType());
                    set = Utils._getNestedTypes(((ChildEntry)object).getType(), set, symbolTable, true, set2);
                    if (set.size() >= symbolTable.getTypes().size()) {
                        set = symbolTable._getAllTypes();
                        return set;
                    }
                }
                if (!(vector.get(i) instanceof ChildAttribute) || set2.contains(((ChildEntry)(object = (ChildAttribute)vector.get(i))).getType())) continue;
                if (((ChildEntry)object).getType() instanceof Type) {
                    set.add(((ChildEntry)object).getType());
                }
                if ((set = Utils._getNestedTypes(((ChildEntry)object).getType(), set, symbolTable, true, set2)).size() < symbolTable.getTypes().size()) continue;
                set = symbolTable._getAllTypes();
                return set;
            }
        }
        if (typeEntry.getRefType() != null && !set2.contains(typeEntry.getRefType())) {
            set.add(typeEntry.getRefType());
            set = Utils._getNestedTypes(typeEntry.getRefType(), set, symbolTable, true, set2);
            if (set.size() >= symbolTable.getTypes().size()) {
                set = symbolTable._getAllTypes();
                return set;
            }
        }
        if (bl && typeEntry instanceof Type) {
            Set set4 = Utils.getDerivedTypes(typeEntry, symbolTable);
            if (set4.size() >= symbolTable.getTypes().size()) {
                set = symbolTable._getAllTypes();
                return set;
            }
            object = set4.iterator();
            while (object.hasNext()) {
                TypeEntry typeEntry2 = (TypeEntry)object.next();
                if (set.contains(typeEntry2)) continue;
                set.add(typeEntry2);
                if ((set = Utils._getNestedTypes(typeEntry2, set, symbolTable, false, set2)).size() < symbolTable.getTypes().size()) continue;
                set = symbolTable._getAllTypes();
                return set;
            }
        }
        Type type = null;
        if (typeEntry instanceof Type && (type = ((Type)typeEntry).getExtensionBase()) == null) {
            type = ((Type)typeEntry).getRestrictionBase();
        }
        if (type != null && !set.contains(type)) {
            set.add(type);
            set = Utils._getNestedTypes(type, set, symbolTable, false, set2);
        }
        if (set.size() >= symbolTable.getTypes().size()) {
            set = symbolTable._getAllTypes();
        }
        return set;
    }

    public static String genQNameAttributeString(QName qName, String string) {
        if (qName.getNamespaceURI() == null || qName.getNamespaceURI().equals("")) {
            return qName.getLocalPart();
        }
        return string + ":" + qName.getLocalPart() + "\" xmlns:" + string + "=\"" + qName.getNamespaceURI();
    }

    public static boolean isXSDType(QName qName) {
        return SchemaUtils.isXSDType(qName);
    }

    public static URL getURL(URL uRL, String string) throws IOException {
        String string2 = string.replace('\\', '/');
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string2);
            if (uRL != null && uRL2.getProtocol().equals("file") && uRL.getProtocol().equals("file")) {
                uRL2 = Utils.getFileURL(uRL, string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (log.isDebugEnabled()) {
                log.debug("Exception Logged: url contained no valid protocol information: " + malformedURLException.getMessage());
            }
            uRL2 = Utils.getFileURL(uRL, string2);
        }
        return uRL2;
    }

    private static URL getFileURL(URL uRL, String string) throws IOException {
        String string2;
        File file;
        if (uRL != null && (file = new File(string2 = uRL.getFile())) != null) {
            return new URL(file.toURL(), string);
        }
        return new URL("file", "", string);
    }

    public static TypeEntry getReferencedType(TypeEntry typeEntry) {
        return Utils.getReferencedType(typeEntry, true);
    }

    public static TypeEntry getReferencedType(TypeEntry typeEntry, boolean bl) {
        TypeEntry typeEntry2 = typeEntry.getRefType();
        if (typeEntry2 != null) {
            return typeEntry2;
        }
        Type type = (Type)typeEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN);
        if (type != null) {
            return type;
        }
        if (bl && typeEntry instanceof Type && !((Type)typeEntry).isEnumeration() && ((Type)typeEntry).isSimpleTypeOrSimpleContent()) {
            return ((Type)typeEntry).getRestrictionBase();
        }
        return null;
    }
}

