/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.wsaddressing.Constants;
import com.ibm.ws.wsaddressing.EndpointReferenceImpl;
import com.ibm.ws.wsaddressing.EndpointReferenceManager;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.UCFRoutingHelper;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.Text;

public class UCFRoutingHelperImpl
extends UCFRoutingHelper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(UCFRoutingHelperImpl.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.UCFRoutingHelperImpl";

    protected Identity concreteGetWLMClusterIdForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetWLMClusterIdForDestinationEPR", messageContext);
        }
        String string = this.getClusterIDStringFromDestinationEPR(messageContext, Constants.WLM_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetWLMClusterIdForDestinationEPR", identity);
        }
        return identity;
    }

    protected Identity concreteGetHAClusterIdForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetHAClusterIdForDestinationEPR", messageContext);
        }
        String string = this.getClusterIDStringFromDestinationEPR(messageContext, Constants.AFFINITY_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetHAClusterIdForDestinationEPR", identity);
        }
        return identity;
    }

    protected Identity concreteGetWLMClusterIdFromMessageContext(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetWLMClusterIdFromMessageContext", messageContext);
        }
        String string = this.getClusterIDStringFromEndpointReferenceManager(messageContext, Constants.WLM_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetWLMClusterIdFromMessageContext", identity);
        }
        return identity;
    }

    protected Identity concreteGetHAClusterIdFromMessageContext(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetHAClusterIdFromMessageContext", messageContext);
        }
        String string = this.getClusterIDStringFromEndpointReferenceManager(messageContext, Constants.AFFINITY_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetHAClusterIdFromMessageContext", identity);
        }
        return identity;
    }

    protected boolean concreteIsDestinationEPRFragile(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteIsDestinationEPRFragile", messageContext);
        }
        boolean bl = false;
        String string = this.getClusterIDStringFromDestinationEPR(messageContext, Constants.FRAGILE_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (identity != null) {
            bl = true;
        } else if ("Fragile".equals(string)) {
            bl = true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteIsDestinationEPRFragile", Boolean.toString(bl));
        }
        return bl;
    }

    protected boolean concreteIsMessageContextMarkedFragile(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteIsMessageContextMarkedFragile", messageContext);
        }
        boolean bl = false;
        String string = this.getClusterIDStringFromEndpointReferenceManager(messageContext, Constants.FRAGILE_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (identity != null) {
            bl = true;
        } else if ("Fragile".equals(string)) {
            bl = true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteIsMessageContextMarkedFragile", Boolean.toString(bl));
        }
        return bl;
    }

    protected Identity concreteGetWLMClusterIdForProxy(SOAPMessageContext sOAPMessageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetWLMClusterIdForProxy", sOAPMessageContext);
        }
        String string = this.getClusterIDStringForProxy(sOAPMessageContext, Constants.WLM_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetWLMClusterIdForProxy", identity);
        }
        return identity;
    }

    protected String concreteGetVirtualHostForProxy(SOAPMessageContext sOAPMessageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetVirtualHostForProxy", sOAPMessageContext);
        }
        String string = this.getReferenceParameterStringForProxy(sOAPMessageContext, Constants.VIRTUAL_HOST_QNAME);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetVirtualHostForProxy", string);
        }
        return string;
    }

    protected Identity concreteGetHAClusterIdForProxy(SOAPMessageContext sOAPMessageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetHAClusterIdForProxy", sOAPMessageContext);
        }
        String string = this.getClusterIDStringForProxy(sOAPMessageContext, Constants.AFFINITY_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetHAClusterIdForProxy", identity);
        }
        return identity;
    }

    protected boolean concreteIsMarkedFragileForProxy(SOAPMessageContext sOAPMessageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteIsMarkedFragileForProxy", sOAPMessageContext);
        }
        boolean bl = false;
        String string = this.getClusterIDStringForProxy(sOAPMessageContext, Constants.FRAGILE_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (identity != null) {
            bl = true;
        } else if ("Fragile".equals(string)) {
            bl = true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteIsMarkedFragileForProxy", Boolean.toString(bl));
        }
        return bl;
    }

    protected Identity concreteGetFragileClusterIdForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetFragileClusterIdForDestinationEPR", messageContext);
        }
        String string = this.getClusterIDStringFromDestinationEPR(messageContext, Constants.FRAGILE_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetFragileClusterIdForDestinationEPR", identity);
        }
        return identity;
    }

    protected Identity concreteGetFragileClusterIdFromMessageContext(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetFragileClusterIdFromMessageContext", messageContext);
        }
        String string = this.getClusterIDStringFromEndpointReferenceManager(messageContext, Constants.FRAGILE_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetFragileClusterIdFromMessageContext", identity);
        }
        return identity;
    }

    protected Identity concreteGetFragileClusterIdForProxy(SOAPMessageContext sOAPMessageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetFragileClusterIdForProxy", sOAPMessageContext);
        }
        String string = this.getClusterIDStringForProxy(sOAPMessageContext, Constants.FRAGILE_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetFragileClusterIdForProxy", identity);
        }
        return identity;
    }

    private String getClusterIDStringForProxy(SOAPMessageContext sOAPMessageContext, QName qName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIDStringForProxy", new Object[]{sOAPMessageContext, qName});
        }
        SOAPElement sOAPElement = this.getReferenceParameterForProxy(sOAPMessageContext, Constants.ROUTING_INFORMATION_QNAME);
        String string = this.getStringFromSOAPElement(sOAPElement, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIDStringForProxy", string);
        }
        return string;
    }

    private String getClusterIDStringFromDestinationEPR(MessageContext messageContext, QName qName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIDStringFromDestinationEPR", new Object[]{messageContext, qName});
        }
        SOAPElement sOAPElement = this.getReferenceParameterFromDestinationEPR(messageContext);
        String string = this.getStringFromSOAPElement(sOAPElement, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIDStringFromDestinationEPR", string);
        }
        return string;
    }

    private String getClusterIDStringFromEndpointReferenceManager(MessageContext messageContext, QName qName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIDStringFromEndpointReferenceManager", new Object[]{messageContext, qName});
        }
        SOAPElement sOAPElement = this.getReferenceParameterFromEndpointReferenceManager(messageContext);
        String string = this.getStringFromSOAPElement(sOAPElement, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIDStringFromEndpointReferenceManager", string);
        }
        return string;
    }

    private Identity getIdentityFromString(String string) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getIdentityFromString", string);
        }
        if (string == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "String parameter was null, so return null");
            }
            return null;
        }
        if (string.equals("Fragile")) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "String parameter was Fragile, so return null");
            }
            return null;
        }
        Identity identity = null;
        ClusterService clusterService = ClusterServiceFactory.getClusterService();
        if (clusterService != null) {
            identity = clusterService.stringToIdentity(string);
            Set set = clusterService.getActiveClusterSet();
            boolean bl = set.contains(identity);
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "isClusterCellLocal: " + bl);
            }
            if (!bl) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "The detected Cluster Identity is not in the active clusters set so returning null");
                }
                return null;
            }
        } else {
            String string2 = "The ClusterService was not available in order to extract the clusterId for routing. ";
            Tr.error(TRACE_COMPONENT, string2);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getIdentityFromString", identity);
        }
        return identity;
    }

    private String getStringFromSOAPElement(SOAPElement sOAPElement, QName qName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getStringFromSOAPElement", new Object[]{sOAPElement, qName});
        }
        if (sOAPElement == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getStringFromSOAPElement", "SOAPElement parameter was null, so return null");
            }
            return null;
        }
        if (qName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getStringFromSOAPElement", "QName parameter was null, so return null");
            }
            return null;
        }
        String string = null;
        if (sOAPElement.getNamespaceURI().equals(qName.getNamespaceURI()) && sOAPElement.getLocalName().equals(qName.getLocalPart())) {
            string = sOAPElement.getValue();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getStringFromSOAPElement", string);
        }
        return string;
    }

    private SOAPElement getReferenceParameterFromDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterFromDestinationEPR", new Object[]{messageContext});
        }
        if (messageContext != null && messageContext.containsProperty("com.ibm.websphere.wsaddressing.destinationEPR")) {
            Object object = messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
            if (!(object instanceof EndpointReference)) {
                String string = "WSAConstants.WSADDRESSING_DESTINATION_EPR property not an instance of EndpointReference";
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromDestinationEPR", string);
                }
                return null;
            }
            EndpointReferenceImpl endpointReferenceImpl = (EndpointReferenceImpl)object;
            if (endpointReferenceImpl != null) {
                if (endpointReferenceImpl.isIntermediaryPresent()) {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromDestinationEPR", "WSADDRESSING_DESTINATION_EPR isIntermediaryPresent() returned TRUE.  Should not add ClusterID.  Returning NULL.");
                    }
                    return null;
                }
                SOAPElement sOAPElement = endpointReferenceImpl.getSOAPElementReferenceParameter(Constants.ROUTING_INFORMATION_QNAME);
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromDestinationEPR", sOAPElement);
                }
                return sOAPElement;
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromDestinationEPR");
        }
        return null;
    }

    private SOAPElement getReferenceParameterFromEndpointReferenceManager(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterFromEndpointReferenceManager", messageContext);
        }
        if (messageContext == null) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromEndpointReferenceManager", "MessageContext parameter was null, so return null");
            return null;
        }
        SOAPElement sOAPElement = null;
        try {
            sOAPElement = EndpointReferenceManager.getSOAPElementReferenceParameterFromSpecificMessageContext(messageContext, Constants.ROUTING_INFORMATION_QNAME);
        }
        catch (ReferenceParameterCreationException referenceParameterCreationException) {
            String string = referenceParameterCreationException.getClass().getName();
            String string2 = referenceParameterCreationException.getMessage();
            String string3 = "Caught a " + string + ": " + string2 + " when trying to retrieve a ReferenceParameter from the MessageContext: " + Constants.ROUTING_INFORMATION_QNAME;
            Tr.warning(TRACE_COMPONENT, string3);
            FFDCFilter.processException(referenceParameterCreationException, CLASSNAME, "1:509:1.25");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromEndpointReferenceManager", sOAPElement);
        }
        return sOAPElement;
    }

    private SOAPElement getReferenceParameterForProxy(SOAPMessageContext sOAPMessageContext, QName qName) {
        Object object;
        Object object2;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterForProxy", new Object[]{sOAPMessageContext, qName});
        }
        if (sOAPMessageContext == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterForProxy", "SOAPMessageContext parameter was null, so return null");
            }
            return null;
        }
        SOAPElement sOAPElement = null;
        javax.xml.soap.SOAPHeader sOAPHeader = null;
        Name name2 = null;
        try {
            object2 = sOAPMessageContext.getMessage();
            sOAPHeader = ((SOAPMessage)object2).getSOAPHeader();
            object = ((SOAPHeader)sOAPHeader).getSOAPFactory();
            name2 = ((SOAPFactory)object).createName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, UCFRoutingHelperImpl.class.getName() + ".getReferenceParameterForProxy", "1:549:1.25", new Object[]{qName});
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterForProxy", "SOAPException while creating Name. Returning null");
            }
            return null;
        }
        object2 = sOAPHeader.getChildElements(name2);
        if (object2.hasNext()) {
            object = (SOAPElement)object2.next();
            Iterator iterator = object.getChildElements();
            if (!iterator.hasNext()) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getReferenceParameterForProxy", new Object[]{"No Child Elements", iterator});
                    return null;
                }
            } else {
                sOAPElement = (SOAPElement)iterator.next();
            }
            if (iterator.hasNext() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Element with specified QName has multiple children.", Constants.ROUTING_INFORMATION_QNAME);
            }
        }
        if (object2.hasNext() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Multiple reference parameters exist with the same name", Constants.ROUTING_INFORMATION_QNAME);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterForProxy", sOAPElement);
        }
        return sOAPElement;
    }

    private String getReferenceParameterStringForProxy(SOAPMessageContext sOAPMessageContext, QName qName) {
        Object object;
        Object object2;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterStringForProxy", new Object[]{sOAPMessageContext, qName});
        }
        if (sOAPMessageContext == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterStringForProxy", "SOAPMessageContext parameter was null, so return null");
            }
            return null;
        }
        String string = null;
        javax.xml.soap.SOAPHeader sOAPHeader = null;
        Name name2 = null;
        try {
            object2 = sOAPMessageContext.getMessage();
            sOAPHeader = ((SOAPMessage)object2).getSOAPHeader();
            object = ((SOAPHeader)sOAPHeader).getSOAPFactory();
            name2 = ((SOAPFactory)object).createName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, UCFRoutingHelperImpl.class.getName() + ".getReferenceParameterForProxy", "1:622:1.25", new Object[]{qName});
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterStringForProxy", "SOAPException while creating Name. Returning null");
            }
            return null;
        }
        object2 = sOAPHeader.getChildElements(name2);
        if (object2.hasNext()) {
            object = (SOAPElement)object2.next();
            Iterator iterator = object.getChildElements();
            if (!iterator.hasNext()) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getReferenceParameterStringForProxy", new Object[]{"No Child Elements", iterator});
                    return null;
                }
            } else {
                Object e = iterator.next();
                if (e instanceof Text) {
                    string = ((Text)e).getValue();
                }
            }
            if (iterator.hasNext() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Element with specified QName has multiple children.", Constants.ROUTING_INFORMATION_QNAME);
            }
        }
        if (object2.hasNext() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Multiple reference parameters exist with the same name", Constants.ROUTING_INFORMATION_QNAME);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterForProxy", string);
        }
        return string;
    }

    protected Identity concreteGetClusterIdentityFromSOAPElementText(SOAPElement sOAPElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetClusterIdentityFromSOAPElementText", sOAPElement);
        }
        if (sOAPElement == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "concreteGetClusterIdentityFromSOAPElementText", "SOAPElement parameter was null, so return null");
            }
            return null;
        }
        String string = sOAPElement.getValue();
        Identity identity = this.getIdentityFromString(string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetClusterIdentityFromSOAPElementText", identity);
        }
        return identity;
    }

    protected String concreteGetVirtualHostForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteGetVirtualHostForDestinationEPR", messageContext);
        }
        String string = null;
        Object object = messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
        if (object instanceof EndpointReference) {
            EndpointReference endpointReference = (EndpointReference)object;
            string = endpointReference.getReferenceParameter(Constants.VIRTUAL_HOST_QNAME);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteGetVirtualHostForDestinationEPR", string);
        }
        return string;
    }
}

