/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.binders;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.ExtensibleType;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.wsaddressing.AttributedType;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.Text;

public class BinderHelper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(BinderHelper.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    protected void validateSerializeMethodParameters(Object object, SOAPElement sOAPElement, String string) throws SOAPException {
        if (object == null) {
            String string2 = "Object to be bound passed to " + string + "Binder was null";
            Tr.error(TRACE_COMPONENT, string2);
            throw new SOAPException(string2);
        }
        this.checkForNullSOAPElement(sOAPElement, string);
    }

    protected void validateSerializeMethodParameters(Object object, SOAPElement sOAPElement, String string, NamespaceData namespaceData) throws SOAPException {
        if (namespaceData == null) {
            String string2 = "Namespace Data object passed to " + string + "Binder was null";
            Tr.error(TRACE_COMPONENT, string2);
            throw new SOAPException(string2);
        }
        this.validateSerializeMethodParameters(object, sOAPElement, string);
    }

    protected void checkForNullSOAPElement(SOAPElement sOAPElement, String string) throws SOAPException {
        if (sOAPElement == null) {
            String string2 = "The SOAPElement passed to " + string + "Binder was null";
            Tr.error(TRACE_COMPONENT, string2);
            throw new SOAPException(string2);
        }
    }

    protected SOAPElement addAttributesToSOAPElementFromAttributedType(SOAPElement sOAPElement, AttributedType attributedType) throws SOAPException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{sOAPElement, attributedType};
            Tr.entry(TRACE_COMPONENT, "addAttributesToSOAPElementFromAttributedType", objectArray);
        }
        objectArray = attributedType.getAttributeNames();
        while (objectArray.hasNext()) {
            Name name2 = (Name)objectArray.next();
            sOAPElement.addAttribute(name2, attributedType.getAttributeValue(name2));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addAttributesToSOAPElementFromAttributedType", sOAPElement);
        }
        return sOAPElement;
    }

    protected AttributedType addAttributesToAttributedTypeFromSOAPElement(SOAPElement sOAPElement, AttributedType attributedType) {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{sOAPElement, attributedType};
            Tr.entry(TRACE_COMPONENT, "addAttributesToAttributedTypeFromSOAPElement", objectArray);
        }
        objectArray = sOAPElement.getAllAttributes();
        while (objectArray.hasNext()) {
            Name name2 = (Name)objectArray.next();
            attributedType.addAttribute(name2, sOAPElement.getAttributeValue(name2));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addAttributesToAttributedTypeFromSOAPElement", attributedType);
        }
        return attributedType;
    }

    protected SOAPElement addQNameAsTextValueToSOAPElement(SOAPElement sOAPElement, QName qName) throws SOAPException {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            object = new Object[]{sOAPElement, qName};
            Tr.entry(TRACE_COMPONENT, "addQNameAsTextValueToSOAPElement", object);
        }
        object = qName.getPrefix();
        String string = qName.getNamespaceURI();
        if (string != null && string.length() != 0) {
            if (object == null || object.length() == 0) {
                object = "ns" + string.hashCode();
            }
            sOAPElement.addNamespaceDeclaration((String)object, string);
        }
        String string2 = object == null || object.length() == 0 ? "" : (String)object + ":";
        string2 = string2 + qName.getLocalPart();
        sOAPElement.addTextNode(string2);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addQNameAsTextValueToSOAPElement", sOAPElement);
        }
        return sOAPElement;
    }

    protected QName getQNameFromSOAPElementTextValue(SOAPElement sOAPElement) {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{sOAPElement};
            Tr.entry(TRACE_COMPONENT, "getQNameFromSOAPElementTextValue", objectArray);
        }
        objectArray = sOAPElement.getValue();
        QName qName = null;
        int n = objectArray.indexOf(":");
        if (n == -1) {
            qName = new QName((String)objectArray);
        } else {
            String string = objectArray.substring(0, n);
            String string2 = sOAPElement.getNamespaceURI(string);
            String string3 = objectArray.substring(n + 1);
            qName = new QName(string2, string3, string);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getQNameFromSOAPElementTextValue", qName);
        }
        return qName;
    }

    protected void addChildElementsToExtensibleType(SOAPFactory sOAPFactory, SOAPElement sOAPElement, ExtensibleType extensibleType) {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{sOAPFactory, sOAPElement, extensibleType};
            Tr.entry(TRACE_COMPONENT, "addChildElementsToExtensibleType", objectArray);
        }
        objectArray = sOAPElement.getChildElements();
        while (objectArray.hasNext()) {
            Object e = objectArray.next();
            SOAPElement sOAPElement2 = null;
            if (e instanceof SOAPElement) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.info(TRACE_COMPONENT, "Extensibility Element is of type javax.xml.soap.SOAPEElement", e);
                }
                sOAPElement2 = (SOAPElement)e;
                extensibleType.addExtensibilityElement(sOAPElement2);
                continue;
            }
            if (e instanceof Text) {
                Text text;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.info(TRACE_COMPONENT, "Extensibility Element is of type javax.xml.soap.Text", e);
                }
                if ((sOAPElement2 = this.getSOAPElementFromTextElement(text = (Text)e, sOAPFactory)) == null) continue;
                extensibleType.addExtensibilityElement(sOAPElement2);
                continue;
            }
            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
            Tr.error(TRACE_COMPONENT, "Ref property/param was not of type text or SOAPElement", e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addChildElementsToExtensibleType");
        }
    }

    protected SOAPElement getSOAPElementFromTextElement(Text text, SOAPFactory sOAPFactory) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementFromTextElement", text);
        }
        SOAPElement sOAPElement = null;
        try {
            String string = text.getLocalName();
            String string2 = text.getPrefix();
            String string3 = text.getNamespaceURI();
            if (string2 == null && string3 == null && string == null) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.info(TRACE_COMPONENT, "Text object just contained whitespace");
                }
                sOAPElement = null;
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.info(TRACE_COMPONENT, "Found TextObject and converted to SOAPElement ref param/prop  Local name:" + string + " prefix: " + string2 + " uri: " + string3);
                }
                sOAPElement = string2 != null && string3 != null ? sOAPFactory.createElement(string, string2, string3) : sOAPFactory.createElement(string);
                sOAPElement.setValue(text.getValue());
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException(sOAPException, BinderHelper.class.getName() + ".getSOAPElementFromTextElement", "1:351:1.5", this, new Object[]{sOAPElement, text});
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementFromTextElement", sOAPElement);
        }
        return sOAPElement;
    }
}

