/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.adapter.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.ChannelTargetRule;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import java.util.HashMap;
import java.util.Map;

public final class ChannelSelectionCriteria
implements CFEndPointCriteria {
    private static final TraceComponent tc = Tr.register(ChannelSelectionCriteria.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final SelectionService selectionService = SelectionServiceFactory.getSelectionService();
    private final Identity clusterIdentity;
    private final SelectionCriteria criteria;
    private final CFEndPointCriteria cfEndPointCriteria;
    private final String chainName;
    private final Class accessor;
    private final Class[] channelFactories;
    private final boolean sslRequired;
    private String string = null;

    public ChannelSelectionCriteria(Identity identity, boolean bl, boolean bl2, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{identity, String.valueOf(bl), String.valueOf(bl2)});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        this.criteria = selectionService.getCriteria(identity, bl, bl2, null, null);
        this.cfEndPointCriteria = cFEndPointCriteria;
        this.clusterIdentity = identity;
        this.chainName = cFEndPointCriteria == null ? null : cFEndPointCriteria.getChainName();
        this.accessor = cFEndPointCriteria == null ? null : cFEndPointCriteria.getChannelAccessor();
        this.channelFactories = cFEndPointCriteria == null ? null : cFEndPointCriteria.getOptionalChannelFactories();
        boolean bl3 = this.sslRequired = cFEndPointCriteria == null ? false : cFEndPointCriteria.isSSLRequired();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public ChannelSelectionCriteria(Identity identity, Map map, String string, Class clazz, Class[] classArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{identity, map, string, clazz, String.valueOf(bl)});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        if (map == null) {
            throw new IllegalArgumentException("The context attribute must not be null.");
        }
        this.setChannelTargetRule(this, map);
        this.criteria = selectionService.getCriteria(identity, map);
        this.clusterIdentity = identity;
        this.chainName = string;
        this.accessor = clazz;
        this.channelFactories = classArray;
        this.sslRequired = bl;
        this.cfEndPointCriteria = this;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public ChannelSelectionCriteria(Identity identity, Map hashMap, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{identity, hashMap, cFEndPointCriteria});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        if (cFEndPointCriteria == null) {
            throw new IllegalArgumentException("The CFEndPointCriteria attribute must not be null.");
        }
        if (hashMap == null) {
            hashMap = new HashMap(3);
        }
        this.setChannelTargetRule(cFEndPointCriteria, hashMap);
        this.criteria = selectionService.getCriteria(identity, hashMap);
        this.clusterIdentity = identity;
        this.chainName = cFEndPointCriteria.getChainName();
        this.accessor = cFEndPointCriteria.getChannelAccessor();
        this.channelFactories = cFEndPointCriteria.getOptionalChannelFactories();
        this.sslRequired = cFEndPointCriteria.isSSLRequired();
        this.cfEndPointCriteria = cFEndPointCriteria;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public CFEndPointCriteria getCFEndPointCriteria() {
        return this.cfEndPointCriteria;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" [clusterIdentity=");
            stringBuffer.append(this.clusterIdentity);
            stringBuffer.append("] [criteria = ");
            stringBuffer.append(this.criteria);
            stringBuffer.append("] chainName=");
            stringBuffer.append(this.chainName);
            stringBuffer.append("] [sslRequired=");
            stringBuffer.append(this.sslRequired);
            stringBuffer.append("] [accessor=");
            stringBuffer.append(this.accessor);
            stringBuffer.append("] channelFactories=");
            if (this.channelFactories != null) {
                for (int i = 0; i < this.channelFactories.length; ++i) {
                    stringBuffer.append("[");
                    stringBuffer.append(this.channelFactories[i]);
                    stringBuffer.append("] ");
                }
            } else {
                stringBuffer.append("[null]");
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public Identity getIdentity() {
        return this.clusterIdentity;
    }

    public SelectionCriteria getCriteria() {
        return this.criteria;
    }

    public Class getChannelAccessor() {
        return this.accessor;
    }

    public String getChainName() {
        return this.chainName;
    }

    public Class[] getOptionalChannelFactories() {
        return this.channelFactories;
    }

    public boolean isSSLRequired() {
        return this.sslRequired;
    }

    private void setChannelTargetRule(CFEndPointCriteria cFEndPointCriteria, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setChannelTargetRule");
        }
        boolean bl = false;
        SelectionRule[] selectionRuleArray = (SelectionRule[])map.get("rules.restriction");
        Tr.debug(tc, "SelectionRules = ", selectionRuleArray);
        if (selectionRuleArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no restrictive rules in context add channel target rule");
            }
            selectionRuleArray = new SelectionRule[]{new ChannelTargetRule(cFEndPointCriteria)};
            map.put("rules.restriction", selectionRuleArray);
        } else {
            SelectionRule[] selectionRuleArray2 = new SelectionRule[selectionRuleArray.length + 1];
            for (int i = 0; i < selectionRuleArray.length; ++i) {
                if (selectionRuleArray[i] == null) continue;
                if (selectionRuleArray[i] instanceof ChannelTargetRule) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Restrictive rule ChannelTargetRule already in list");
                    }
                    bl = true;
                    break;
                }
                selectionRuleArray2[i] = selectionRuleArray[i];
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not found add channel target rule");
                }
                selectionRuleArray2[selectionRuleArray2.length - 1] = new ChannelTargetRule(cFEndPointCriteria);
                map.put("rules.restriction", selectionRuleArray2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setChannelTargetRule", map);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.14 ");
        }
    }
}

