/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import java.util.Iterator;
import java.util.List;

public class DefaultRule
implements SelectionRule {
    private static final TraceComponent tc = Tr.register(DefaultRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    protected static final DescriptionManager descMgr;
    private RuleArbitrator[] arbitrator = new RuleArbitrator[0];

    public void subset(List list, StringBuffer stringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DescriptionKey descriptionKey = (DescriptionKey)iterator.next();
            Description description = descMgr.getDescription(descriptionKey);
            if (description != null) continue;
            iterator.remove();
            stringBuffer.append(descriptionKey + " removed: Did not contain any member information. ");
        }
    }

    public void registerRuleArbitrator(RuleArbitrator ruleArbitrator) {
        if (ruleArbitrator == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "registerRuleArbitrator: coordinator is null");
            }
            return;
        }
        int n = this.arbitrator.length;
        RuleArbitrator[] ruleArbitratorArray = new RuleArbitrator[n + 1];
        System.arraycopy(this.arbitrator, 0, ruleArbitratorArray, 0, n);
        ruleArbitratorArray[n] = ruleArbitrator;
        this.arbitrator = ruleArbitratorArray;
    }

    public void registerNotificationType(Identity identity, String string) {
        for (int i = 0; i < this.arbitrator.length; ++i) {
            if (this.arbitrator[i] != null) {
                this.arbitrator[i].registerNotificationType(this, identity, string);
                continue;
            }
            if (!tc.isEventEnabled()) continue;
            Tr.event(tc, "registerNotificationType: arbitrator[i] is null i = ", String.valueOf(i));
        }
    }

    public boolean equals(Object object) {
        return this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.16.1.1 ");
        }
        descMgr = DescriptionManagerFactory.getDescriptionManager();
    }
}

