/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.exception.WsRuntimeFwException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ThreadContextHelper;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.Join;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.runtime.component.AsynchronousInitializer;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class WsComponentImpl
implements WsComponent {
    private static final TraceComponent tc = Tr.register(WsComponentImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    protected String name;
    protected String state;
    private PropertyChangeSupport propertyChangeSupport;
    private boolean inhibitMultiThreadedBehavior = inhibtMultiThreadedBehaviorGlobally;
    private static boolean inhibtMultiThreadedBehaviorGlobally = false;
    private Join join = null;
    private WsException latchedAsynchronousException = null;
    private static ThreadPool initializers = null;
    private ThreadContextHelper threadContextHelper = null;

    protected WsComponentImpl() {
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        this.latchedAsynchronousException = null;
    }

    public void destroy() {
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.latchedAsynchronousException = null;
    }

    public void stop() {
    }

    public static void _setStartupThreadPool(ThreadPool threadPool) {
        initializers = threadPool;
    }

    public static void setGlobalAsynchBehaviorInhibited(boolean bl) {
        inhibtMultiThreadedBehaviorGlobally = bl;
    }

    public void inhibitAsynchBehavior() {
        this.inhibitMultiThreadedBehavior = true;
    }

    protected final void runAsynchronousInitializer(AsynchronousInitializer asynchronousInitializer) throws WsRuntimeFwException {
        this.runAsynchronousInitializer(asynchronousInitializer, true);
    }

    protected final void runAsynchronousInitializer(AsynchronousInitializer asynchronousInitializer, boolean bl) throws WsRuntimeFwException {
        if (this.inhibitMultiThreadedBehavior || initializers == null) {
            asynchronousInitializer.run();
            return;
        }
        try {
            if (bl) {
                if (this.join == null) {
                    this.join = new Join();
                }
                this.join.increment();
            }
            _AsynchInitializer _AsynchInitializer2 = new _AsynchInitializer(asynchronousInitializer, bl);
            initializers.execute(_AsynchInitializer2);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException(interruptedException, this.getClass().getName(), "223");
        }
    }

    protected final void join() throws ConfigurationWarning, ConfigurationError, ComponentDisabledException, RuntimeWarning, RuntimeError {
        if (this.join == null) {
            return;
        }
        this.join.join();
        if (this.latchedAsynchronousException != null) {
            if (this.latchedAsynchronousException instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof ConfigurationError) {
                throw (ConfigurationError)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof ComponentDisabledException) {
                throw (ComponentDisabledException)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof RuntimeWarning) {
                throw (RuntimeWarning)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof RuntimeError) {
                throw (RuntimeError)this.latchedAsynchronousException;
            }
            FFDCFilter.processException(this.latchedAsynchronousException, this.getClass().getName(), "260");
            throw new RuntimeWarning("unexpected asynchronous exception: " + this.latchedAsynchronousException);
        }
    }

    private int exceptionRank(WsException wsException) {
        if (wsException instanceof ConfigurationWarning) {
            return 0;
        }
        if (wsException instanceof ConfigurationError) {
            return 2;
        }
        if (wsException instanceof ComponentDisabledException) {
            return 1;
        }
        if (wsException instanceof RuntimeWarning) {
            return 3;
        }
        if (wsException instanceof RuntimeError) {
            return 4;
        }
        FFDCFilter.processException(this.latchedAsynchronousException, this.getClass().getName(), "286");
        return -1;
    }

    private void latchAsychronousException(WsException wsException) {
        FFDCFilter.processException(wsException, this.getClass().getName(), "297");
        if (this.latchedAsynchronousException != null) {
            if (this.exceptionRank(wsException) > this.exceptionRank(this.latchedAsynchronousException)) {
                this.latchedAsynchronousException = wsException;
            }
        } else {
            this.latchedAsynchronousException = wsException;
        }
    }

    private ThreadContextHelper getThreadContextHelper() {
        if (this.threadContextHelper == null) {
            this.threadContextHelper = (ThreadContextHelper)ImplFactory.loadImplFromKey(ThreadContextHelper.class);
        }
        return this.threadContextHelper;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getState() {
        return this.state;
    }

    protected void setState(String string) throws RuntimeError, RuntimeWarning, ConfigurationError, ConfigurationWarning {
        String string2 = this.getState();
        this.state = string;
        this.getPropertyChangeSupport().firePropertyChange("state", string2, this.state);
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.getPropertyChangeSupport().firePropertyChange(propertyChangeEvent);
    }

    protected String expandVariable(String string) throws IllegalArgumentException {
        VariableMap variableMap = null;
        try {
            variableMap = (VariableMap)WsServiceRegistry.getService(this, VariableMap.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, WsComponentImpl.class.getName(), "470", this);
        }
        return variableMap.expand(string);
    }

    protected String getConfigId(Object object) {
        try {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            if (mBeanFactory != null) {
                return mBeanFactory.getConfigId(object);
            }
        }
        catch (AdminException adminException) {
            FFDCFilter.processException(adminException, this.getClass().getName(), "499");
        }
        return null;
    }

    protected void registerMBean(String string, RuntimeCollaborator runtimeCollaborator, String string2, String string3, Properties properties) {
        MBeanFactory mBeanFactory;
        if (string2 != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.put("name", string2);
        }
        if ((mBeanFactory = AdminServiceFactory.getMBeanFactory()) != null) {
            try {
                mBeanFactory.activateMBean(string, runtimeCollaborator, string3, null, properties);
            }
            catch (AdminException adminException) {
                Tr.service(tc, "WSVR0400W", new Object[]{string2, adminException});
            }
        }
    }

    protected void deregisterMBean(String string) {
        try {
            AdminServiceFactory.getMBeanFactory().deactivateMBean(string);
        }
        catch (AdminException adminException) {
            Tr.service(tc, "WSVR0401W", new Object[]{this.name, adminException});
        }
    }

    protected void deregisterMBean(Object object) {
        this.deregisterMBean(this.getConfigId(object));
    }

    protected void deregisterMBeanViaQuery(String string) {
        Set set = this.lookupMBeans(string);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                try {
                    AdminServiceFactory.getMBeanFactory().deactivateMBean(objectName);
                }
                catch (AdminException adminException) {
                    Tr.service(tc, "WSVR0401W", new Object[]{this.name, adminException});
                }
            }
        }
    }

    protected Set lookupMBeans(String string) {
        try {
            ObjectName objectName = new ObjectName(string);
            Server server2 = (Server)WsServiceRegistry.getService(this, Server.class);
            Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
            String string2 = objectName.getDomain();
            hashtable.put("node", server2.getNodeName());
            hashtable.put("process", server2.getName());
            objectName = new ObjectName(string2, hashtable);
            String string3 = objectName.toString();
            string3 = string3 + ",*";
            objectName = new ObjectName(string3);
            return AdminServiceFactory.getMBeanFactory().getMBeanServer().queryNames(objectName, null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Tr.service(tc, "WSVR0402W", new Object[]{string, malformedObjectNameException});
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, WsComponentImpl.class.getName(), "630", this);
            return null;
        }
    }

    private class _AsynchInitializer
    implements Runnable {
        final AsynchronousInitializer task;
        final boolean joinFlag;

        _AsynchInitializer(AsynchronousInitializer asynchronousInitializer, boolean bl) {
            this.task = asynchronousInitializer;
            this.joinFlag = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                WsComponentImpl.this.getThreadContextHelper().establishCredentials();
                this.task.run();
            }
            catch (ConfigurationWarning configurationWarning) {
                WsComponentImpl.this.latchAsychronousException(configurationWarning);
            }
            catch (ConfigurationError configurationError) {
                WsComponentImpl.this.latchAsychronousException(configurationError);
            }
            catch (RuntimeWarning runtimeWarning) {
                WsComponentImpl.this.latchAsychronousException(runtimeWarning);
            }
            catch (RuntimeError runtimeError) {
                WsComponentImpl.this.latchAsychronousException(runtimeError);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "350");
                WsComponentImpl.this.latchAsychronousException(new RuntimeWarning(throwable));
            }
            finally {
                if (this.joinFlag) {
                    WsComponentImpl.this.join.decrement();
                }
            }
        }
    }
}

