/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.StopWatch;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.config.ConfigLocator;
import com.ibm.ws.runtime.config.ContainerConfig;
import com.ibm.ws.runtime.config.ContainerConfigFactory;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.component.AsynchronousInitializer;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;

public class WsContainer
extends WsComponentImpl {
    private static final TraceComponent tc = Tr.register(WsContainer.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private List components = Collections.EMPTY_LIST;
    private List children = Collections.synchronizedList(new ArrayList());
    private Map componentStartupData = Collections.synchronizedMap(new HashMap());
    private PlatformCheck platformCheck = new PlatformCheck();
    private String pluginId;

    protected WsContainer(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init> plugin=" + string);
        }
        this.pluginId = string;
    }

    public void destroy() {
        this.destroyComponents();
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{object, this});
        }
        try {
            ConfigLocator[] configLocatorArray;
            EObject eObject = null;
            if (object != null && object instanceof ContainerConfig) {
                ContainerConfig containerConfig = (ContainerConfig)object;
                try {
                    eObject = (EObject)containerConfig.getConfig();
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, WsContainer.class.getName(), "126", this);
                }
                configLocatorArray = ((ContainerConfig)object).getLocators();
            } else {
                configLocatorArray = new ConfigLocator[]{};
            }
            this.loadComponents(this.pluginId);
            this.initializeComponents(eObject, configLocatorArray);
        }
        catch (Exception exception) {
            if (exception instanceof ComponentDisabledException) {
                throw (ComponentDisabledException)exception;
            }
            if (exception instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)exception;
            }
            if (exception instanceof ConfigurationError) {
                throw (ConfigurationError)exception;
            }
            FFDCFilter.processException((Throwable)exception, WsContainer.class.getName(), "127", this);
            throw new ConfigurationWarning(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this);
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.startComponents();
        this.componentStartupData.clear();
    }

    public void stop() {
        this.stopComponents();
    }

    protected List loadComponents(String string) throws ConfigurationError {
        int n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadComponents", new Object[]{this, string});
        }
        List<ComponentStartup> list = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        if (iExtensionPoint == null) {
            ConfigurationError configurationError = new ConfigurationError("Extension point \"" + string + "\" is invalid.");
            FFDCFilter.processException((Throwable)configurationError, WsContainer.class.getName(), "136", this);
            throw configurationError;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (n = 0; n < iExtensionArray.length; ++n) {
            IConfigurationElement iConfigurationElement;
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            if (iConfigurationElementArray.length != 1) {
                this.handleError("There must be a single <components> element.  See extension " + iExtension.getUniqueIdentifier());
            }
            if (!(iConfigurationElement = iConfigurationElementArray[0]).getName().equals("components")) {
                this.handleError("Invalid element \"" + iConfigurationElement.getName() + "\" found in extension " + iExtension.getUniqueIdentifier());
            }
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren();
            for (int i = 0; i < iConfigurationElementArray2.length; ++i) {
                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[i];
                if (!iConfigurationElement2.getName().equals("component")) {
                    this.handleError("Expecting <component> but found <" + iConfigurationElement2.getName() + "> in extension " + iExtension.getUniqueIdentifier());
                }
                ComponentStartup componentStartup = new ComponentStartup();
                componentStartup.type = iConfigurationElement2.getAttribute("type");
                componentStartup.clazz = iConfigurationElement2.getAttribute("class");
                if (componentStartup.clazz != null) {
                    componentStartup.configElement = iConfigurationElement2;
                }
                componentStartup.order = Integer.parseInt(iConfigurationElement2.getAttribute("startup"));
                componentStartup.platforms = iConfigurationElement2.getAttribute("platform");
                componentStartup.configrationDataRequired = this.getAttribute(iConfigurationElement2, "configurationDataRequired", componentStartup.configrationDataRequired);
                componentStartup.asyncInitialize = this.getAttribute(iConfigurationElement2, "asyncInitialize", componentStartup.asyncInitialize);
                componentStartup.asyncStart = this.getAttribute(iConfigurationElement2, "asyncStart", componentStartup.asyncStart);
                componentStartup.inhibitAsynchronousBehavior = this.getAttribute(iConfigurationElement2, "inhibitAsynchronousBehavior", componentStartup.inhibitAsynchronousBehavior);
                componentStartup.processtypes = iConfigurationElement2.getAttribute("processType");
                componentStartup.recoverytypes = iConfigurationElement2.getAttribute("recoveryType");
                if (!this.platformCheck.validOn(componentStartup.platforms, componentStartup.processtypes, componentStartup.recoverytypes)) continue;
                if (list.contains(componentStartup)) {
                    Tr.warning(tc, "WSVR0107W", (Object)new Object[]{componentStartup.getName(), string});
                    continue;
                }
                list.add(componentStartup);
            }
        }
        Collections.sort(list, new StartupCompartor());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadedComponents " + list.size(), this);
            for (n = 0; n < list.size(); ++n) {
                Tr.debug(tc, " component " + n, list.get(n));
            }
        }
        this.components = list;
        return this.components;
    }

    private void handleError(String string) throws ConfigurationError {
        this.handleError(string, null);
    }

    private void handleError(String string, Throwable throwable) throws ConfigurationError {
        ConfigurationError configurationError = throwable == null ? new ConfigurationError(string) : new ConfigurationError(string, throwable);
        FFDCFilter.processException((Throwable)configurationError, WsContainer.class.getName(), "214", this);
        throw configurationError;
    }

    private boolean getAttribute(IConfigurationElement iConfigurationElement, String string, boolean bl) {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase(Boolean.toString(true))) {
            return true;
        }
        if (string2.equalsIgnoreCase(Boolean.toString(false))) {
            return false;
        }
        FFDCFilter.processException((Throwable)new ConfigurationWarning("invalid boolean attribute: \"" + string2 + "\" specified for attribute \"" + string + "\""), WsContainer.class.getName(), "223", this);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startComponents() throws RuntimeWarning, RuntimeError {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "startComponents " + this.components.size(), this);
        }
        StopWatch stopWatch = StopWatch.instance();
        try {
            stopWatch.start("WsContainer.startComponents() " + this);
            RuntimeWarning runtimeWarning = null;
            for (int i = 0; i < this.components.size(); ++i) {
                WsComponent wsComponent = (WsComponent)this.components.get(i);
                try {
                    ComponentStartup componentStartup;
                    stopWatch.start("WsContainer : start " + wsComponent);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "starting " + i, wsComponent);
                    }
                    if ((componentStartup = (ComponentStartup)this.componentStartupData.get(wsComponent)) != null && componentStartup.asyncStart && !componentStartup.inhibitAsynchronousBehavior) {
                        this.runAsynchronousInitializer(new AsynchComponentSupport(1, wsComponent, null, null));
                        continue;
                    }
                    wsComponent.start();
                    continue;
                }
                catch (RuntimeWarning runtimeWarning2) {
                    runtimeWarning = runtimeWarning2;
                    Tr.error(tc, "WSVR0501E", new Object[]{wsComponent, runtimeWarning2});
                    continue;
                }
                catch (RuntimeError runtimeError) {
                    throw runtimeError;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "546");
                    Tr.error(tc, "WSVR0501E", new Object[]{wsComponent, throwable});
                    runtimeWarning = new RuntimeWarning(throwable);
                    continue;
                }
                finally {
                    stopWatch.stop();
                }
            }
            if (runtimeWarning != null) {
                throw runtimeWarning;
            }
        }
        finally {
            stopWatch.stop();
        }
    }

    protected void stopComponents() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stopComponents " + this.components.size(), this);
        }
        for (int i = this.components.size() - 1; i >= 0; --i) {
            WsComponent wsComponent = (WsComponent)this.components.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopping " + i, wsComponent);
                }
                wsComponent.stop();
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "572");
                Tr.error(tc, "WSVR0102E", new Object[]{wsComponent, throwable});
            }
        }
    }

    protected void destroyComponents() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "destroyComponents " + this.components.size(), this);
        }
        for (int i = this.components.size() - 1; i >= 0; --i) {
            WsComponent wsComponent = (WsComponent)this.components.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "destroying " + i, wsComponent);
                }
                wsComponent.destroy();
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "597");
                Tr.error(tc, "WSVR0103E", new Object[]{wsComponent, throwable});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeComponents(EObject eObject, ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "initializeComponents", this);
        }
        StopWatch stopWatch = StopWatch.instance();
        ConfigurationWarning configurationWarning = null;
        try {
            stopWatch.start("WsContainer.initializeComponents() : " + (eObject != null ? eObject.getClass() : null));
            ComponentManager componentManager = null;
            List list = Collections.synchronizedList(new ArrayList());
            HashMap hashMap = new HashMap();
            try {
                try {
                    componentManager = (ComponentManager)WsServiceRegistry.getService(this, ComponentManager.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, WsContainer.class.getName(), "741", this);
                    throw new ConfigurationError("ComponentManager service not found", exception);
                }
                for (int i = 0; i < this.components.size(); ++i) {
                    ComponentStartup componentStartup = (ComponentStartup)this.components.get(i);
                    stopWatch.start("WsContainer : init " + componentStartup);
                    try {
                        if (bl) {
                            Tr.debug(tc, "processing", componentStartup);
                        }
                        if (componentStartup.clazz != null && componentStartup.type == null) {
                            this.initializeComponent(componentStartup.clazz, null, componentManager, hashMap, list, configLocatorArray, componentStartup);
                            continue;
                        }
                        Object object = null;
                        for (int j = 0; object == null && j < configLocatorArray.length; ++j) {
                            object = configLocatorArray[j].getConfig(eObject, componentStartup.type);
                            if (!bl || object == null) continue;
                            Tr.debug(tc, "config object " + object + " found by locator " + configLocatorArray[j]);
                        }
                        if (object != null) {
                            if (object instanceof List) {
                                List list2 = (List)object;
                                for (int j = 0; j < list2.size(); ++j) {
                                    EObject eObject2 = (EObject)list2.get(j);
                                    this.initializeComponent(null, eObject2, componentManager, hashMap, list, configLocatorArray, componentStartup);
                                }
                                continue;
                            }
                            EObject eObject3 = (EObject)object;
                            this.initializeComponent(componentStartup.type, eObject3, componentManager, hashMap, list, configLocatorArray, componentStartup);
                            continue;
                        }
                        if (bl) {
                            Tr.debug(tc, "config object not found!");
                        }
                        if (componentStartup.configrationDataRequired) continue;
                        this.initializeComponent(componentStartup.clazz, null, componentManager, hashMap, list, configLocatorArray, componentStartup);
                        throw new ConfigurationWarning("configuration data missing for " + componentStartup);
                    }
                    catch (ConfigurationWarning configurationWarning2) {
                        configurationWarning = configurationWarning2;
                        continue;
                    }
                    finally {
                        stopWatch.stop();
                    }
                }
            }
            finally {
                this.components = list;
            }
        }
        finally {
            stopWatch.stop();
        }
        if (configurationWarning != null) {
            FFDCFilter.processException(configurationWarning, this.getClass().getName(), "717");
            throw configurationWarning;
        }
    }

    private void initializeComponent(String string, Object object, ComponentManager componentManager, Map map, List list, ConfigLocator[] configLocatorArray, ComponentStartup componentStartup) throws ConfigurationWarning, ConfigurationError {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "initializeComponent", new Object[]{string, object});
        }
        if (object == null) {
            object = string;
        }
        if (map.get(object) != null) {
            if (bl) {
                Tr.debug(tc, "component already loaded");
            }
            return;
        }
        map.put(object, object);
        Object object2 = null;
        if (componentStartup.configElement != null) {
            try {
                object2 = componentStartup.configElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                FFDCFilter.processException((Throwable)coreException, WsContainer.class.getName(), "550", this);
                throw new ConfigurationWarning(coreException);
            }
            finally {
                componentStartup.configElement = null;
            }
        } else {
            object2 = componentManager.getInstance(object);
        }
        if (componentStartup != null && componentStartup.inhibitAsynchronousBehavior && object2 instanceof WsComponentImpl) {
            ((WsComponentImpl)object2).inhibitAsynchBehavior();
        }
        if (object2 instanceof WsComponent) {
            boolean bl2;
            ConfigurationWarning configurationWarning = null;
            WsComponent wsComponent = (WsComponent)object2;
            this.componentStartupData.put(wsComponent, componentStartup);
            boolean bl3 = bl2 = componentStartup != null && componentStartup.asyncInitialize && !componentStartup.inhibitAsynchronousBehavior;
            if (this.add(wsComponent)) {
                try {
                    if (bl) {
                        Tr.debug(tc, "initializing", wsComponent);
                    }
                    if (object2 instanceof WsContainer || object2 instanceof ContainerImpl) {
                        object = ContainerConfigFactory.createContainerConfig(object, configLocatorArray);
                    }
                    if (bl2) {
                        list.add(wsComponent);
                        this.runAsynchronousInitializer(new AsynchComponentSupport(0, wsComponent, object, list));
                    } else {
                        wsComponent.initialize(object);
                    }
                }
                catch (ComponentDisabledException componentDisabledException) {
                    wsComponent = null;
                }
                catch (ConfigurationWarning configurationWarning2) {
                    if (bl) {
                        Tr.debug(tc, "Component, " + wsComponent + " failed to initialize", configurationWarning2);
                    }
                    configurationWarning = configurationWarning2;
                    if (configurationWarning2.getCause() instanceof ComponentDisabledException) {
                        wsComponent = null;
                        configurationWarning = new ConfigurationWarning(configurationWarning2.getMessage(), configurationWarning2);
                    }
                }
                catch (ConfigurationError configurationError) {
                    throw configurationError;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "707");
                    wsComponent = null;
                    configurationWarning = new ConfigurationWarning("Exception caught when initializing component", throwable);
                    Tr.error(tc, "WSVR0501E", new Object[]{string, throwable});
                }
                if (wsComponent != null) {
                    if (!bl2) {
                        list.add(wsComponent);
                    }
                } else {
                    if (bl) {
                        Tr.debug(tc, "Component, " + object2 + " is disabled");
                    }
                    this.remove((WsComponent)object2);
                }
                if (configurationWarning != null) {
                    throw configurationWarning;
                }
            }
        } else if (bl) {
            Tr.debug(tc, "component ignored: " + (object2 != null ? object2.getClass().getName() : "<null>"));
        }
    }

    protected boolean add(WsComponent wsComponent) {
        if (this.children.contains(wsComponent)) {
            return false;
        }
        this.children.add(wsComponent);
        return true;
    }

    protected boolean remove(WsComponent wsComponent) {
        if (!this.children.contains(wsComponent)) {
            return false;
        }
        this.children.remove(wsComponent);
        return true;
    }

    private static class AsynchComponentSupport
    implements AsynchronousInitializer {
        static final int INIT_ = 0;
        static final int START_ = 1;
        final int operation;
        final WsComponent component;
        final Object configurationData;
        final List componentsList;

        AsynchComponentSupport(int n, WsComponent wsComponent, Object object, List list) {
            this.operation = n;
            this.component = wsComponent;
            this.configurationData = object;
            this.componentsList = list;
        }

        public void run() throws ConfigurationWarning, ConfigurationError, RuntimeWarning, RuntimeError {
            switch (this.operation) {
                case 0: {
                    try {
                        this.component.initialize(this.configurationData);
                        break;
                    }
                    catch (ComponentDisabledException componentDisabledException) {
                        this.componentsList.remove(this.component);
                        break;
                    }
                    catch (ConfigurationWarning configurationWarning) {
                        throw configurationWarning;
                    }
                }
                case 1: {
                    this.component.start();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported operation : " + this.operation);
                }
            }
        }
    }

    private static class StartupCompartor
    implements Comparator {
        private StartupCompartor() {
        }

        public int compare(Object object, Object object2) {
            ComponentStartup componentStartup = (ComponentStartup)object;
            ComponentStartup componentStartup2 = (ComponentStartup)object2;
            return componentStartup.order - componentStartup2.order;
        }
    }

    private static class PlatformCheck {
        static final String DISTRIBUTED = "distributed";
        static final String ZSERIES = "zos";
        static final String ISERIES = "os400";
        static final String ALL = "all";
        static final String ADJUNCT = "adjunct";
        static final String CONTROL = "control";
        static final String SERVANT = "servant";
        static final String CLIENT = "client";
        private static String actualPlatformString = null;
        private static String processType = null;
        private static boolean recoveryMode = false;

        private PlatformCheck() {
        }

        private boolean validOn(String string, String string2, String string3) {
            String string4;
            StringTokenizer stringTokenizer;
            boolean bl = false;
            if (string == null) {
                bl = true;
            } else {
                stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken().trim().toLowerCase();
                    if (string4.equals(ALL)) {
                        bl = true;
                        break;
                    }
                    if (!string4.equals(actualPlatformString)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl && actualPlatformString.equals(ZSERIES)) {
                bl = false;
                if (recoveryMode && (string2 = string3) == null) {
                    string2 = "";
                }
                if (string2 == null) {
                    bl = true;
                } else {
                    stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken().trim().toLowerCase();
                        if (string4.equals(ALL)) {
                            bl = true;
                            break;
                        }
                        if (!string4.equalsIgnoreCase(processType)) continue;
                        bl = true;
                        break;
                    }
                }
            }
            return bl;
        }

        static {
            actualPlatformString = DISTRIBUTED;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper.isZOS()) {
                actualPlatformString = ZSERIES;
                processType = CONTROL;
                if (platformHelper.isCRAJvm()) {
                    processType = ADJUNCT;
                } else if (platformHelper.isServantJvm()) {
                    processType = SERVANT;
                } else if (platformHelper.isClientJvm()) {
                    processType = CLIENT;
                }
                if (processType != CLIENT && !platformHelper.runningWhereConfigured()) {
                    recoveryMode = true;
                }
            } else if (platformHelper.isOS400()) {
                actualPlatformString = ISERIES;
            }
        }
    }

    private static class ComponentStartup {
        public int order = Integer.MAX_VALUE;
        public String type = null;
        public String clazz = null;
        public IConfigurationElement configElement = null;
        public String platforms = null;
        public String processtypes = null;
        public String recoverytypes = null;
        boolean configrationDataRequired = true;
        boolean asyncStart = false;
        boolean asyncInitialize = false;
        boolean inhibitAsynchronousBehavior = false;

        private ComponentStartup() {
        }

        public String toString() {
            String string = (this.type != null ? this.type : this.clazz) + " [" + this.order + "]" + (this.asyncInitialize ? " asynch-init" : "") + (this.asyncStart ? " asynch-start" : "");
            if (this.platforms != null) {
                string = string + " [platforms:" + this.platforms + "]";
            }
            if (this.processtypes != null) {
                string = string + " [processtypes:" + this.processtypes + "]";
            }
            if (this.recoverytypes != null) {
                string = string + " [recoverytypes:" + this.recoverytypes + "]";
            }
            return string;
        }

        public boolean equals(Object object) {
            if (object instanceof ComponentStartup) {
                boolean bl;
                ComponentStartup componentStartup = (ComponentStartup)object;
                boolean bl2 = this.type == null ? this.type == componentStartup.type : (bl = this.type.equals(componentStartup.type));
                boolean bl3 = this.clazz == null ? this.clazz == componentStartup.clazz : this.clazz.equals(componentStartup.clazz);
                return bl && bl3;
            }
            return false;
        }

        public String getName() {
            return this.type != null ? this.type : this.clazz;
        }
    }
}

