/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.tai;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import javax.security.auth.Subject;

public final class TAIResult {
    private int status;
    private String principal;
    private Subject subject;
    private static final TraceComponent tc = Tr.register(TAIResult.class, null, "com.ibm.ejs.resources.security");

    public static TAIResult create(int n, String string, Subject subject) throws WebTrustAssociationFailedException {
        return new TAIResult(n, string, subject);
    }

    public static TAIResult create(int n, String string) throws WebTrustAssociationFailedException {
        return new TAIResult(n, string, null);
    }

    public static TAIResult create(int n) throws WebTrustAssociationFailedException {
        return new TAIResult(n, null, null);
    }

    public final int getStatus() {
        return this.status;
    }

    public final String getAuthenticatedPrincipal() {
        return this.principal;
    }

    public final Subject getSubject() {
        return this.subject;
    }

    private TAIResult(int n, String string, Subject subject) throws WebTrustAssociationFailedException {
        this.init(n, string, subject);
    }

    private void init(int n, String string, Subject subject) throws WebTrustAssociationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + n + ", " + string + ", " + (subject == null ? "null" : "subject"));
        }
        if (n == 200 && (string == null || string.length() == 0)) {
            throw new WebTrustAssociationFailedException("No principal in Trust Association Result");
        }
        this.status = n;
        this.principal = string;
        this.subject = subject;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }
}

