/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.jaxp.impl;

import com.ibm.xml.xlxp.api.jaxp.impl.SAXParserImpl;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXParserFactoryImpl
extends SAXParserFactory {
    public static final String SAX_NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String SAX_VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private boolean fEnableSecureProcessing = false;
    protected Hashtable fFeatures = null;

    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        return new SAXParserImpl(this, this.fFeatures);
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            if (bl) {
                throw new SAXNotSupportedException("The JAXP 1.3 feature: http://javax.xml.XMLConstants/feature/secure-processing was recognized but the requested value " + bl + " could not be set.");
            }
            this.fEnableSecureProcessing = bl;
        }
        if (this.fFeatures == null) {
            this.fFeatures = new Hashtable();
        }
        this.fFeatures.put(string, new Boolean(bl));
        try {
            new SAXParserImpl(this, this.fFeatures);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            this.fFeatures.remove(string);
            throw sAXNotRecognizedException;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            this.fFeatures.remove(string);
            throw sAXNotSupportedException;
        }
        catch (SAXException sAXException) {
            this.fFeatures.remove(string);
            throw new ParserConfigurationException(sAXException.getMessage());
        }
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        boolean bl = false;
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.fEnableSecureProcessing;
        }
        try {
            bl = new SAXParserImpl(this, this.fFeatures).getXMLReader().getFeature(string);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw sAXNotRecognizedException;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw sAXNotSupportedException;
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
        return bl;
    }

    public void setValidating(boolean bl) {
        super.setValidating(bl);
        if (this.fFeatures == null) {
            this.fFeatures = new Hashtable();
        }
        this.fFeatures.put(SAX_VALIDATION_FEATURE, new Boolean(bl));
    }

    public void setNamespaceAware(boolean bl) {
        super.setNamespaceAware(bl);
        if (this.fFeatures == null) {
            this.fFeatures = new Hashtable();
        }
        this.fFeatures.put(SAX_NAMESPACES_FEATURE, new Boolean(bl));
    }
}

