/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;

final class ASCIIEncodingSupport
implements EncodingSupport {
    private static EncodingSupport fgSingleton = new ASCIIEncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, InputStream inputStream, String string, boolean bl, boolean bl2, DataSourceFactory dataSourceFactory) {
        ByteStreamDataSource byteStreamDataSource = dataSourceFactory.allocateByteStreamDataSource();
        byteStreamDataSource.checkAvailable = bl2;
        byteStreamDataSource.setByteStream(inputStream, this, bl);
        return byteStreamDataSource.load(parsedEntity);
    }

    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = 0;
        try {
            int n2 = byteStreamDataSource.bufferLength - 1 - byteStreamDataSource.byteOffset;
            while (byteStreamDataSource.stream != null) {
                int n3 = 0;
                int n4 = 0;
                n2 = byteStreamDataSource.bufferLength - byteStreamDataSource.byteOffset;
                if (n2 > 0 && (n3 = byteStreamDataSource.stream.read(byteStreamDataSource.byteBuffer, byteStreamDataSource.byteOffset, n2)) == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                } else {
                    int n5;
                    int n6 = n + (n3 += byteStreamDataSource.byteOffset) < byteStreamDataSource.bufferLength ? n3 : byteStreamDataSource.bufferLength - n;
                    for (n5 = 0; n5 < n6; ++n5) {
                        if (byteStreamDataSource.byteBuffer[n5] >= 0) {
                            continue;
                        }
                        if (n + 4 >= byteStreamDataSource.bufferLength) break;
                        if (n5 > n4) {
                            System.arraycopy(byteStreamDataSource.byteBuffer, n4, byArray, n, n5 - n4);
                            n += n5 - n4;
                        }
                        dataBuffer.endOffset = n;
                        return CharConversionError.unableToConvertOutOfRangeUnicodeCharacter();
                    }
                    if (n5 > n4) {
                        System.arraycopy(byteStreamDataSource.byteBuffer, n4, byArray, n, n5 - n4);
                        n += n5 - n4;
                        byteStreamDataSource.byteOffset = n5;
                    }
                    if (byteStreamDataSource.byteOffset < n3) {
                        System.arraycopy(byteStreamDataSource.byteBuffer, byteStreamDataSource.byteOffset, byteStreamDataSource.byteBuffer, 0, n3 -= byteStreamDataSource.byteOffset);
                        byteStreamDataSource.byteOffset = n3;
                    } else {
                        byteStreamDataSource.byteOffset = 0;
                    }
                    if (n + 4 < byteStreamDataSource.bufferLength && (!byteStreamDataSource.checkAvailable || byteStreamDataSource.stream.available() != 0)) continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError(iOException);
        }
        dataBuffer.endOffset = n;
        return null;
    }

    private ASCIIEncodingSupport() {
    }
}

