/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private Hashtable parameters = new Hashtable();
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String parameterList) throws MimeTypeParseException {
        this.parse(parameterList);
    }

    /*
     * WARNING - void declaration
     */
    protected void parse(String parameterList) throws MimeTypeParseException {
        char c;
        if (parameterList == null) {
            return;
        }
        int length = parameterList.length();
        if (length <= 0) {
            return;
        }
        int i = MimeTypeParameterList.skipWhiteSpace(parameterList, 0);
        while (i < length && (c = parameterList.charAt(i)) == ';') {
            void var7_7;
            String value2;
            ++i;
            if ((i = MimeTypeParameterList.skipWhiteSpace(parameterList, i)) >= length) {
                return;
            }
            int lastIndex = i;
            while (i < length && MimeTypeParameterList.isTokenChar(parameterList.charAt(i))) {
                ++i;
            }
            String name2 = parameterList.substring(lastIndex, i).toLowerCase();
            if ((i = MimeTypeParameterList.skipWhiteSpace(parameterList, i)) >= length || parameterList.charAt(i) != '=') {
                throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            }
            ++i;
            if ((i = MimeTypeParameterList.skipWhiteSpace(parameterList, i)) >= length) {
                throw new MimeTypeParseException("Couldn't find a value for parameter named " + name2);
            }
            c = parameterList.charAt(i);
            if (c == '\"') {
                if (++i >= length) {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                lastIndex = i;
                while (i < length && (c = parameterList.charAt(i)) != '\"') {
                    if (c == '\\') {
                        ++i;
                    }
                    ++i;
                }
                if (c != '\"') {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                value2 = MimeTypeParameterList.unquote(parameterList.substring(lastIndex, i));
                ++i;
            } else if (MimeTypeParameterList.isTokenChar(c)) {
                lastIndex = i;
                while (i < length && MimeTypeParameterList.isTokenChar(parameterList.charAt(i))) {
                    ++i;
                }
                value2 = parameterList.substring(lastIndex, i);
            } else {
                throw new MimeTypeParseException("Unexpected character encountered at index " + i);
            }
            this.parameters.put(name2, var7_7);
            i = MimeTypeParameterList.skipWhiteSpace(parameterList, i);
        }
        if (i < length) {
            throw new MimeTypeParseException("More characters encountered in input than expected.");
        }
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String get(String name2) {
        return (String)this.parameters.get(name2.trim().toLowerCase());
    }

    public void set(String name2, String value2) {
        this.parameters.put(name2.trim().toLowerCase(), value2);
    }

    public void remove(String name2) {
        this.parameters.remove(name2.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(this.parameters.size() * 16);
        Enumeration keys = this.parameters.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buffer.append("; ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(MimeTypeParameterList.quote((String)this.parameters.get(key)));
        }
        return buffer.toString();
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private static int skipWhiteSpace(String rawdata, int i) {
        int length = rawdata.length();
        while (i < length && Character.isWhitespace(rawdata.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static String quote(String value2) {
        boolean needsQuotes = false;
        int length = value2.length();
        for (int i = 0; i < length && !needsQuotes; ++i) {
            needsQuotes = !MimeTypeParameterList.isTokenChar(value2.charAt(i));
        }
        if (needsQuotes) {
            StringBuffer buffer = new StringBuffer();
            buffer.ensureCapacity((int)((double)length * 1.5));
            buffer.append('\"');
            for (int i = 0; i < length; ++i) {
                char c = value2.charAt(i);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            buffer.append('\"');
            return buffer.toString();
        }
        return value2;
    }

    private static String unquote(String value2) {
        int valueLength = value2.length();
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(valueLength);
        boolean escaped = false;
        for (int i = 0; i < valueLength; ++i) {
            char currentChar = value2.charAt(i);
            if (!escaped && currentChar != '\\') {
                buffer.append(currentChar);
                continue;
            }
            if (escaped) {
                buffer.append(currentChar);
                escaped = false;
                continue;
            }
            escaped = true;
        }
        return buffer.toString();
    }
}

