/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public abstract class MessageFactory {
    private static final String DEFAULT_MESSAGE_FACTORY = "com.ibm.ws.webservices.engine.soap.MessageFactoryImpl";
    private static final String MESSAGE_FACTORY_PROPERTY = "javax.xml.soap.MessageFactory";
    private static Class factoryClass = null;

    public static synchronized MessageFactory newInstance() throws SOAPException {
        try {
            Object var0 = null;
            if (factoryClass == null) {
                String string = MESSAGE_FACTORY_PROPERTY;
                String string2 = DEFAULT_MESSAGE_FACTORY;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String string3 = System.getProperty(string);
                if (string3 == null) {
                    String string4 = "META-INF/services/" + string;
                    InputStream inputStream = null;
                    inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string4) : classLoader.getResourceAsStream(string4);
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        string3 = bufferedReader.readLine();
                        bufferedReader.close();
                    }
                }
                if (string3 == null) {
                    string3 = string2;
                }
                if (string3 == null) {
                    throw new SOAPException("Provider for " + string + " cannot be found", null);
                }
                factoryClass = classLoader == null ? Class.forName(string3) : classLoader.loadClass(string3);
            }
            var0 = factoryClass.newInstance();
            return var0;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "javax.xml.soap.MessageFactory.newInstance", "157");
            throw new SOAPException("Unable to create message factory for SOAP: " + exception.getMessage());
        }
    }

    public abstract SOAPMessage createMessage() throws SOAPException;

    public abstract SOAPMessage createMessage(MimeHeaders var1, InputStream var2) throws IOException, SOAPException;
}

