/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;

public class EObjectValidator
implements EValidator {
    public static final EObjectValidator INSTANCE = new EObjectValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecore";
    public static final int EOBJECT__EVERY_MULTIPCITY_CONFORMS = 1;
    public static final int EOBJECT__EVERY_DATA_VALUE_CONFORMS = 2;
    public static final int EOBJECT__EVERY_REFERENCE_IS_CONTAINED = 3;
    public static final int EOBJECT__EVERY_PROXY_RESOLVES = 4;
    public static final int DATA_VALUE__VALUE_IN_RANGE = 5;
    public static final int DATA_VALUE__LENGTH_IN_RANGE = 6;
    public static final int DATA_VALUE__TYPE_CORRECT = 7;
    public static final int DATA_VALUE__VALUE_IN_ENUMERATION = 8;
    public static final int DATA_VALUE__MATCHES_PATTERN = 9;
    public static final int DATA_VALUE__TOTAL_DIGITS_IN_RANGE = 10;
    public static final int DATA_VALUE__FRACTION_DIGITS_IN_RANGE = 11;
    public static final int EOBJECT__UNIQUE_ID = 12;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static String getObjectLabel(EObject eObject, Map context) {
        if (context != null) {
            EValidator.SubstitutionLabelProvider substitutionlabelProvider;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EValidator$SubstitutionLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((substitutionlabelProvider = (EValidator.SubstitutionLabelProvider)context.get(clazz)) != null) {
                return substitutionlabelProvider.getObjectLabel(eObject);
            }
        }
        return EcoreUtil.getIdentification(eObject);
    }

    public static String getFeatureLabel(EStructuralFeature eStructuralFeature, Map context) {
        if (context != null) {
            EValidator.SubstitutionLabelProvider substitutionlabelProvider;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EValidator$SubstitutionLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((substitutionlabelProvider = (EValidator.SubstitutionLabelProvider)context.get(clazz)) != null) {
                return substitutionlabelProvider.getFeatureLabel(eStructuralFeature);
            }
        }
        return eStructuralFeature.getName();
    }

    public static String getValueLabel(EDataType eDataType, Object value2, Map context) {
        if (context != null) {
            EValidator.SubstitutionLabelProvider substitutionlabelProvider;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EValidator$SubstitutionLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((substitutionlabelProvider = (EValidator.SubstitutionLabelProvider)context.get(clazz)) != null) {
                return substitutionlabelProvider.getValueLabel(eDataType, value2);
            }
        }
        return EcoreUtil.convertToString(eDataType, value2);
    }

    protected EPackage getEPackage() {
        return EcorePackage.eINSTANCE;
    }

    protected EValidator getRootEValidator(Map context) {
        if (context != null) {
            EValidator result;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.emf.ecore.EValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((result = (EValidator)context.get(clazz)) != null) {
                return result;
            }
        }
        return Diagnostician.INSTANCE;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map context) {
        if (eClass.eContainer() == this.getEPackage()) {
            return this.validate(eClass.getClassifierID(), (Object)eObject, diagnostics, context);
        }
        EList eSuperTypes = eClass.getESuperTypes();
        return eSuperTypes.isEmpty() ? this.validate_EveryDefaultConstraint(eObject, diagnostics, context) : this.validate((EClass)eSuperTypes.get(0), eObject, diagnostics, context);
    }

    protected boolean validate(int classifierID, Object object, DiagnosticChain diagnostics, Map context) {
        return classifierID != 10 || this.validate_EveryDefaultConstraint((EObject)object, diagnostics, context);
    }

    public boolean validate_EveryDefaultConstraint(EObject object, DiagnosticChain theDiagnostics, Map context) {
        boolean result = this.validate_EveryMultiplicityConforms(object, theDiagnostics, context);
        if (result || theDiagnostics != null) {
            result &= this.validate_EveryProxyResolves(object, theDiagnostics, context);
        }
        if (result || theDiagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(object, theDiagnostics, context);
        }
        if (result || theDiagnostics != null) {
            result &= this.validate_EveryDataValueConforms(object, theDiagnostics, context);
        }
        if (result || theDiagnostics != null) {
            result &= this.validate_UniqueID(object, theDiagnostics, context);
        }
        return result;
    }

    public boolean validate_EveryMultiplicityConforms(EObject eObject, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            if (!(result &= this.validate_MultiplicityConforms(eObject, eClass.getEStructuralFeature(i), diagnostics, context)) && diagnostics == null) {
                return false;
            }
            ++i;
        }
        return result;
    }

    protected boolean validate_MultiplicityConforms(EObject eObject, EStructuralFeature eStructuralFeature, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (eStructuralFeature.isMany()) {
            int lowerBound = eStructuralFeature.getLowerBound();
            if (lowerBound > 0) {
                int upperBound;
                int size = ((List)eObject.eGet(eStructuralFeature)).size();
                if (size < lowerBound) {
                    result = false;
                    if (diagnostics != null) {
                        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 1, this.getEcoreResourceLocator().getString("_UI_FeatureHasTooFewValues_diagnostic", new Object[]{EObjectValidator.getFeatureLabel(eStructuralFeature, context), EObjectValidator.getObjectLabel(eObject, context), new Integer(size), new Integer(lowerBound)}), new Object[]{eObject, eStructuralFeature}));
                    }
                }
                if ((upperBound = eStructuralFeature.getUpperBound()) > 0 && size > upperBound) {
                    result = false;
                    if (diagnostics != null) {
                        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 1, this.getEcoreResourceLocator().getString("_UI_FeatureHasTooManyValues_diagnostic", new Object[]{EObjectValidator.getFeatureLabel(eStructuralFeature, context), EObjectValidator.getObjectLabel(eObject, context), new Integer(size), new Integer(upperBound)}), new Object[]{eObject, eStructuralFeature}));
                    }
                }
            } else {
                int size;
                int upperBound = eStructuralFeature.getUpperBound();
                if (upperBound > 0 && (size = ((List)eObject.eGet(eStructuralFeature)).size()) > upperBound) {
                    result = false;
                    if (diagnostics != null) {
                        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 1, this.getEcoreResourceLocator().getString("_UI_FeatureHasTooManyValues_diagnostic", new Object[]{EObjectValidator.getFeatureLabel(eStructuralFeature, context), EObjectValidator.getObjectLabel(eObject, context), new Integer(size), new Integer(upperBound)}), new Object[]{eObject, eStructuralFeature}));
                    }
                }
            }
        } else if (eStructuralFeature.isRequired() && (eStructuralFeature.isUnsettable() ? !eObject.eIsSet(eStructuralFeature) : eObject.eGet(eStructuralFeature, false) == null)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 1, this.getEcoreResourceLocator().getString("_UI_RequiredFeatureMustBeSet_diagnostic", new Object[]{EObjectValidator.getFeatureLabel(eStructuralFeature, context), EObjectValidator.getObjectLabel(eObject, context)}), new Object[]{eObject, eStructuralFeature}));
            }
        }
        return result;
    }

    public boolean validate_EveryProxyResolves(EObject eObject, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        EContentsEList.FeatureIterator i = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
        while (i.hasNext()) {
            EObject eCrossReferenceObject = (EObject)i.next();
            if (!eCrossReferenceObject.eIsProxy()) continue;
            result = false;
            if (diagnostics == null) break;
            diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 4, this.getEcoreResourceLocator().getString("_UI_UnresolvedProxy_diagnostic", new Object[]{EObjectValidator.getFeatureLabel(i.feature(), context), EObjectValidator.getObjectLabel(eObject, context), EObjectValidator.getObjectLabel(eCrossReferenceObject, context)}), new Object[]{eObject, i.feature(), eCrossReferenceObject}));
        }
        return result;
    }

    public boolean validate_EveryReferenceIsContained(EObject eObject, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        EContentsEList.FeatureIterator i = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
        while (i.hasNext()) {
            EObject eCrossReferenceObject = (EObject)i.next();
            if (eCrossReferenceObject.eResource() != null || eCrossReferenceObject.eIsProxy() || i.feature().isTransient()) continue;
            result = false;
            if (diagnostics == null) break;
            diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 3, this.getEcoreResourceLocator().getString("_UI_DanglingReference_diagnostic", new Object[]{EObjectValidator.getFeatureLabel(i.feature(), context), EObjectValidator.getObjectLabel(eObject, context), EObjectValidator.getObjectLabel(eCrossReferenceObject, context)}), new Object[]{eObject, i.feature(), eCrossReferenceObject}));
        }
        return result;
    }

    public boolean validate_EveryDataValueConforms(EObject eObject, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator i = eObject.eClass().getEAllAttributes().iterator();
        while (i.hasNext()) {
            if ((result &= this.validate_DataValueConforms(eObject, (EAttribute)i.next(), diagnostics, context)) || diagnostics != null) continue;
            return false;
        }
        return result;
    }

    protected boolean validate_DataValueConforms(EObject eObject, EAttribute eAttribute, DiagnosticChain diagnostics, Map context) {
        if (!eObject.eIsSet(eAttribute)) {
            return true;
        }
        boolean result = true;
        EDataType eDataType = eAttribute.getEAttributeType();
        EValidator rootValidator = this.getRootEValidator(context);
        Object value2 = eObject.eGet(eAttribute);
        if (FeatureMapUtil.isFeatureMap(eAttribute)) {
            Collection featureMap = (Collection)value2;
            EClass eClass = eObject.eClass();
            HashMap<EStructuralFeature, DiagnosticChain> entryFeatureToDiagnosticChainMap = null;
            Iterator i = featureMap.iterator();
            while (i.hasNext() && (result || diagnostics != null)) {
                DiagnosticChain entryFeatureDiagnostic;
                Object entryValue;
                EDataType entryType;
                boolean entryIsValid;
                FeatureMap.Entry entry = (FeatureMap.Entry)i.next();
                EStructuralFeature entryFeature = entry.getEStructuralFeature();
                if (!(entryFeature instanceof EAttribute) || ExtendedMetaData.INSTANCE.getAffiliation(eClass, entryFeature) != eAttribute || (entryIsValid = rootValidator.validate(entryType = (EDataType)entryFeature.getEType(), entryValue = entry.getValue(), null, context))) continue;
                result = false;
                if (diagnostics == null) continue;
                if (entryFeatureToDiagnosticChainMap == null) {
                    entryFeatureToDiagnosticChainMap = new HashMap<EStructuralFeature, DiagnosticChain>();
                }
                if ((entryFeatureDiagnostic = (DiagnosticChain)entryFeatureToDiagnosticChainMap.get(entryFeature)) == null) {
                    entryFeatureDiagnostic = this.createBadDataValueDiagnostic(eObject, (EAttribute)entryFeature, diagnostics, context);
                    entryFeatureToDiagnosticChainMap.put(entryFeature, entryFeatureDiagnostic);
                }
                rootValidator.validate(entryType, entryValue, entryFeatureDiagnostic, context);
            }
        } else if (eAttribute.isMany()) {
            Iterator i = ((List)value2).iterator();
            while (i.hasNext() && result) {
                result &= rootValidator.validate(eDataType, i.next(), null, context);
            }
            if (!result && diagnostics != null) {
                DiagnosticChain diagnostic = this.createBadDataValueDiagnostic(eObject, eAttribute, diagnostics, context);
                Iterator i2 = ((List)value2).iterator();
                while (i2.hasNext()) {
                    rootValidator.validate(eDataType, i2.next(), diagnostic, context);
                }
            }
        } else if (value2 != null && !(result = rootValidator.validate(eDataType, value2, null, context)) && diagnostics != null) {
            DiagnosticChain diagnostic = this.createBadDataValueDiagnostic(eObject, eAttribute, diagnostics, context);
            rootValidator.validate(eDataType, value2, diagnostic, context);
        }
        return result;
    }

    protected DiagnosticChain createBadDataValueDiagnostic(EObject eObject, EAttribute eAttribute, DiagnosticChain diagnostics, Map context) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 2, this.getEcoreResourceLocator().getString("_UI_BadDataValue_diagnostic", new Object[]{EObjectValidator.getFeatureLabel(eAttribute, context), EObjectValidator.getObjectLabel(eObject, context)}), new Object[]{eObject, eAttribute});
        diagnostics.add(diagnostic);
        return diagnostic;
    }

    protected boolean validatePattern(EDataType eDataType, Object value2, EValidator.PatternMatcher[][] patterns, DiagnosticChain diagnostics, Map context) {
        String literal = EcoreUtil.convertToString(eDataType, value2);
        int i = 0;
        while (i < patterns.length) {
            EValidator.PatternMatcher[] children = patterns[i];
            boolean matches = false;
            int j = 0;
            while (j < children.length) {
                if (children[j].matches(literal)) {
                    matches = true;
                    break;
                }
                ++j;
            }
            if (!matches) {
                if (diagnostics != null) {
                    this.reportDataValuePatternViolation(eDataType, value2, children, diagnostics, context);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean validate(EDataType eDataType, Object value2, DiagnosticChain diagnostics, Map context) {
        if (!eDataType.isInstance(value2)) {
            if (value2 == null) {
                return true;
            }
            if (diagnostics != null) {
                this.reportDataValueTypeViolation(eDataType, value2, diagnostics, context);
            }
            return false;
        }
        if (eDataType.eContainer() == this.getEPackage()) {
            return this.validate(eDataType.getClassifierID(), value2, diagnostics, context);
        }
        return new DynamicEDataTypeValidator(eDataType){}.validate(eDataType, value2, diagnostics, context);
    }

    protected void reportMinViolation(EDataType eDataType, Object value2, Object bound, boolean isInclusive, DiagnosticChain diagnostics, Map context) {
        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 5, this.getEcoreResourceLocator().getString(isInclusive ? "_UI_MinInclusiveConstraint_diagnostic" : "_UI_MinExclusiveConstraint_diagnostic", new Object[]{EObjectValidator.getValueLabel(eDataType, value2, context), isInclusive ? ">=" : ">", EObjectValidator.getValueLabel(eDataType, bound, context)}), new Object[]{value2, bound, isInclusive ? Boolean.TRUE : Boolean.FALSE}));
    }

    protected void reportMaxViolation(EDataType eDataType, Object value2, Object bound, boolean isInclusive, DiagnosticChain diagnostics, Map context) {
        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 5, this.getEcoreResourceLocator().getString(isInclusive ? "_UI_MaxInclusiveConstraint_diagnostic" : "_UI_MaxExclusiveConstraint_diagnostic", new Object[]{EObjectValidator.getValueLabel(eDataType, value2, context), "<", EObjectValidator.getValueLabel(eDataType, bound, context)}), new Object[]{value2, bound, isInclusive ? Boolean.TRUE : Boolean.FALSE}));
    }

    protected void reportMinLengthViolation(EDataType eDataType, Object value2, int length, int bound, DiagnosticChain diagnostics, Map context) {
        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 6, this.getEcoreResourceLocator().getString("_UI_MinLengthConstraint_diagnostic", new Object[]{EObjectValidator.getValueLabel(eDataType, value2, context), Integer.toString(length), Integer.toString(bound)}), new Object[]{value2, eDataType, new Integer(length), new Integer(bound)}));
    }

    protected void reportMaxLengthViolation(EDataType eDataType, Object value2, int length, int bound, DiagnosticChain diagnostics, Map context) {
        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 6, this.getEcoreResourceLocator().getString("_UI_MaxLengthConstraint_diagnostic", new Object[]{EObjectValidator.getValueLabel(eDataType, value2, context), Integer.toString(length), Integer.toString(bound)}), new Object[]{value2, eDataType, new Integer(length), new Integer(bound)}));
    }

    protected void reportTotalDigitsViolation(EDataType eDataType, Object value2, int totalDigits, DiagnosticChain diagnostics, Map context) {
        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 10, this.getEcoreResourceLocator().getString("_UI_TotalDigitsConstraint_diagnostic", new Object[]{EObjectValidator.getValueLabel(eDataType, value2, context), new Integer(totalDigits)}), new Object[]{value2, eDataType, new Integer(totalDigits)}));
    }

    protected void reportFractionDigitsViolation(EDataType eDataType, Object value2, int fractionDigits, DiagnosticChain diagnostics, Map context) {
        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 10, this.getEcoreResourceLocator().getString("_UI_FractionDigitsConstraint_diagnostic", new Object[]{EObjectValidator.getValueLabel(eDataType, value2, context), new Integer(fractionDigits)}), new Object[]{value2, eDataType, new Integer(fractionDigits)}));
    }

    protected void reportEnumerationViolation(EDataType eDataType, Object value2, Collection values, DiagnosticChain diagnostics, Map context) {
        String valueLiterals = "";
        Iterator i = values.iterator();
        if (i.hasNext()) {
            valueLiterals = this.getEcoreResourceLocator().getString("_UI_ListHead_composition", new Object[]{EObjectValidator.getValueLabel(eDataType, i.next(), context)});
            while (i.hasNext()) {
                valueLiterals = this.getEcoreResourceLocator().getString("_UI_ListTail_composition", new Object[]{valueLiterals, EObjectValidator.getValueLabel(eDataType, i.next(), context)});
            }
        }
        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 8, this.getEcoreResourceLocator().getString("_UI_EnumerationConstraint_diagnostic", new Object[]{EObjectValidator.getValueLabel(eDataType, value2, context), valueLiterals}), new Object[]{value2, eDataType, values}));
    }

    protected void reportDataValuePatternViolation(EDataType eDataType, Object value2, EValidator.PatternMatcher[] patterns, DiagnosticChain diagnostics, Map context) {
        String patternLiterals = "";
        if (patterns.length > 0) {
            patternLiterals = this.getEcoreResourceLocator().getString("_UI_ListHead_composition", new Object[]{patterns[0]});
            int i = 1;
            while (i < patterns.length) {
                patternLiterals = this.getEcoreResourceLocator().getString("_UI_ListTail_composition", new Object[]{patternLiterals, patterns[i]});
                ++i;
            }
        }
        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 9, this.getEcoreResourceLocator().getString("_UI_PatternConstraint_diagnostic", new Object[]{EObjectValidator.getValueLabel(eDataType, value2, context), patternLiterals}), new Object[]{value2, eDataType, patterns}));
    }

    protected void reportDataValueTypeViolation(EDataType eDataType, Object value2, DiagnosticChain diagnostics, Map context) {
        diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 7, this.getEcoreResourceLocator().getString("_UI_BadDataValueType_diagnostic", new Object[]{EObjectValidator.getValueLabel(eDataType, value2, context), value2 == null ? "<null>" : value2.getClass().getName(), eDataType.getInstanceClass().getName()}), new Object[]{value2, eDataType}));
    }

    protected static Collection wrapEnumerationValues(Object[] values) {
        return Arrays.asList(values);
    }

    public boolean validate_UniqueID(EObject eObject, DiagnosticChain diagnostics, Map context) {
        EObject otherEObject;
        Resource resource;
        boolean result = true;
        String id = EcoreUtil.getID(eObject);
        if (id != null && (resource = eObject.eResource()) != null && eObject != (otherEObject = resource.getEObject(id)) && otherEObject != null) {
            diagnostics.add(new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 12, this.getEcoreResourceLocator().getString("_UI_DuplicateID_diagnostic", new Object[]{id, EObjectValidator.getObjectLabel(eObject, context), EObjectValidator.getObjectLabel(otherEObject, context)}), new Object[]{eObject, otherEObject, id}));
        }
        return result;
    }

    protected ResourceLocator getEcoreResourceLocator() {
        return EcorePlugin.INSTANCE;
    }

    public class DynamicEDataTypeValidator {
        protected List effectiveEnumeration;
        protected EValidator.PatternMatcher[][] effectivePattern;
        protected int effectiveTotalDigits = -1;
        protected int effectiveFractionDigits = -1;
        protected int effectiveMinLength = -1;
        protected int effectiveMaxLength = -1;
        protected Object effectiveMin;
        protected boolean effectiveMinIsInclusive;
        protected int effectiveTotalDigitsMin = -1;
        protected Object effectiveMax;
        protected boolean effectiveMaxIsInclusive;
        protected int effectiveTotalDigitsMax = -1;
        protected EDataType itemType;
        protected List memberTypes;

        public DynamicEDataTypeValidator(EDataType eDataType) {
            ResourceSet resourceSet;
            ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
            Resource resource = eDataType.eResource();
            if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
                extendedMetaData = new BasicExtendedMetaData(resourceSet.getPackageRegistry());
            }
            ArrayList<EValidator.PatternMatcher[]> patterns = null;
            while (true) {
                EDataType baseType;
                List pattern;
                List enumeration;
                if (this.effectiveEnumeration == null && !(enumeration = extendedMetaData.getEnumerationFacet(eDataType)).isEmpty()) {
                    this.effectiveEnumeration = new ArrayList();
                    Iterator i = enumeration.iterator();
                    while (i.hasNext()) {
                        this.effectiveEnumeration.add(EcoreUtil.createFromString(eDataType, (String)i.next()));
                    }
                }
                if (!(pattern = extendedMetaData.getPatternFacet(eDataType)).isEmpty()) {
                    if (patterns == null) {
                        patterns = new ArrayList<EValidator.PatternMatcher[]>();
                    }
                    EValidator.PatternMatcher[] children = new EValidator.PatternMatcher[pattern.size()];
                    patterns.add(children);
                    ListIterator i = pattern.listIterator();
                    while (i.hasNext()) {
                        EValidator.PatternMatcher patternMatcher;
                        children[i.previousIndex()] = patternMatcher = XMLTypeUtil.createPatternMatcher((String)i.next());
                    }
                }
                if (this.effectiveTotalDigits == -1) {
                    this.effectiveTotalDigits = extendedMetaData.getTotalDigitsFacet(eDataType);
                }
                if (this.effectiveFractionDigits == -1) {
                    this.effectiveFractionDigits = extendedMetaData.getFractionDigitsFacet(eDataType);
                }
                if (this.effectiveMinLength == -1) {
                    this.effectiveMinLength = extendedMetaData.getLengthFacet(eDataType);
                    if (this.effectiveMinLength == -1) {
                        this.effectiveMinLength = extendedMetaData.getMinLengthFacet(eDataType);
                    }
                }
                if (this.effectiveMaxLength == -1) {
                    this.effectiveMaxLength = extendedMetaData.getLengthFacet(eDataType);
                    if (this.effectiveMaxLength == -1) {
                        this.effectiveMaxLength = extendedMetaData.getMaxLengthFacet(eDataType);
                    }
                }
                if (this.effectiveMin == null) {
                    this.effectiveMin = extendedMetaData.getMinExclusiveFacet(eDataType);
                    if (this.effectiveMin == null) {
                        this.effectiveMin = extendedMetaData.getMinInclusiveFacet(eDataType);
                        if (this.effectiveMin != null) {
                            this.effectiveMin = EcoreUtil.createFromString(eDataType, (String)this.effectiveMin);
                            this.effectiveMinIsInclusive = true;
                        }
                    } else {
                        this.effectiveMin = EcoreUtil.createFromString(eDataType, (String)this.effectiveMin);
                        this.effectiveMinIsInclusive = false;
                    }
                }
                if (this.effectiveMax == null) {
                    this.effectiveMax = extendedMetaData.getMaxExclusiveFacet(eDataType);
                    if (this.effectiveMax == null) {
                        this.effectiveMax = extendedMetaData.getMaxInclusiveFacet(eDataType);
                        if (this.effectiveMax != null) {
                            this.effectiveMax = EcoreUtil.createFromString(eDataType, (String)this.effectiveMax);
                            this.effectiveMaxIsInclusive = true;
                        }
                    } else {
                        this.effectiveMax = EcoreUtil.createFromString(eDataType, (String)this.effectiveMax);
                        this.effectiveMaxIsInclusive = false;
                    }
                }
                if ((baseType = extendedMetaData.getBaseType(eDataType)) == null) break;
                eDataType = baseType;
            }
            this.itemType = extendedMetaData.getItemType(eDataType);
            this.memberTypes = extendedMetaData.getMemberTypes(eDataType);
            if (patterns != null) {
                this.effectivePattern = new EValidator.PatternMatcher[patterns.size()][];
                patterns.toArray((T[])this.effectivePattern);
            }
            if (this.effectiveTotalDigits != -1 && eDataType.getInstanceClassName() != "java.math.BigDecimal") {
                StringBuffer digits = new StringBuffer("1");
                int i = this.effectiveTotalDigits;
                while (i > 0) {
                    digits.append("0");
                    --i;
                }
                Object upperBound = EcoreUtil.createFromString(eDataType, digits.toString());
                Object lowerBound = EcoreUtil.createFromString(eDataType, "-" + digits.toString());
                if (this.effectiveMin == null || (this.effectiveMinIsInclusive ? ((Comparable)this.effectiveMin).compareTo(lowerBound) <= 0 : ((Comparable)this.effectiveMin).compareTo(lowerBound) < 0)) {
                    this.effectiveMinIsInclusive = false;
                    this.effectiveMin = lowerBound;
                    this.effectiveTotalDigitsMin = this.effectiveTotalDigits;
                }
                if (this.effectiveMax == null || (this.effectiveMaxIsInclusive ? ((Comparable)this.effectiveMax).compareTo(upperBound) >= 0 : ((Comparable)this.effectiveMax).compareTo(upperBound) > 0)) {
                    this.effectiveMaxIsInclusive = false;
                    this.effectiveMax = upperBound;
                    this.effectiveTotalDigitsMax = this.effectiveTotalDigits;
                }
                this.effectiveTotalDigits = -1;
            }
            if (this.effectiveFractionDigits != -1 && eDataType.getInstanceClassName() != "java.math.BigDecimal") {
                this.effectiveFractionDigits = -1;
            }
        }

        public boolean validate(EDataType eDataType, Object value2, DiagnosticChain diagnostics, Map context) {
            int length;
            boolean result = true;
            if (this.effectiveEnumeration != null && !this.effectiveEnumeration.contains(value2)) {
                if (diagnostics != null) {
                    EObjectValidator.this.reportEnumerationViolation(eDataType, value2, this.effectiveEnumeration, diagnostics, context);
                }
                result = false;
            }
            if (this.effectivePattern != null) {
                result = EObjectValidator.this.validatePattern(eDataType, value2, this.effectivePattern, diagnostics, context);
            }
            if (this.effectiveMin != null && (this.effectiveMinIsInclusive ? ((Comparable)this.effectiveMin).compareTo(value2) > 0 : ((Comparable)this.effectiveMin).compareTo(value2) >= 0)) {
                if (diagnostics != null) {
                    if (this.effectiveTotalDigitsMin != -1) {
                        EObjectValidator.this.reportTotalDigitsViolation(eDataType, value2, this.effectiveTotalDigitsMin, diagnostics, context);
                    } else {
                        EObjectValidator.this.reportMinViolation(eDataType, value2, this.effectiveMin, this.effectiveMinIsInclusive, diagnostics, context);
                    }
                }
                result = false;
            }
            if (this.effectiveMax != null && (this.effectiveMaxIsInclusive ? ((Comparable)this.effectiveMax).compareTo(value2) < 0 : ((Comparable)this.effectiveMax).compareTo(value2) <= 0)) {
                if (diagnostics != null) {
                    if (this.effectiveTotalDigitsMax != -1) {
                        EObjectValidator.this.reportTotalDigitsViolation(eDataType, value2, this.effectiveTotalDigitsMax, diagnostics, context);
                    } else {
                        EObjectValidator.this.reportMaxViolation(eDataType, value2, this.effectiveMax, this.effectiveMaxIsInclusive, diagnostics, context);
                    }
                }
                result = false;
            }
            if (this.effectiveMinLength != -1) {
                int n = value2 instanceof String ? ((String)value2).length() : (length = value2 instanceof Object[] ? ((Object[])value2).length : ((Collection)value2).size());
                if (length < this.effectiveMinLength) {
                    if (diagnostics != null) {
                        EObjectValidator.this.reportMinLengthViolation(eDataType, value2, length, this.effectiveMinLength, diagnostics, context);
                    }
                    result = false;
                }
            }
            if (this.effectiveMaxLength != -1) {
                int n = value2 instanceof String ? ((String)value2).length() : (length = value2 instanceof Object[] ? ((Object[])value2).length : ((Collection)value2).size());
                if (length > this.effectiveMaxLength) {
                    if (diagnostics != null) {
                        EObjectValidator.this.reportMaxLengthViolation(eDataType, value2, length, this.effectiveMaxLength, diagnostics, context);
                    }
                    result = false;
                }
            }
            if (this.effectiveTotalDigits != -1 && value2 instanceof BigDecimal && ((BigDecimal)value2).unscaledValue().abs().toString().length() > this.effectiveTotalDigits) {
                if (diagnostics != null) {
                    EObjectValidator.this.reportTotalDigitsViolation(eDataType, value2, this.effectiveTotalDigits, diagnostics, context);
                }
                result = false;
            }
            if (this.effectiveFractionDigits != -1 && value2 instanceof BigDecimal && ((BigDecimal)value2).scale() > this.effectiveFractionDigits) {
                if (diagnostics != null) {
                    EObjectValidator.this.reportFractionDigitsViolation(eDataType, value2, this.effectiveFractionDigits, diagnostics, context);
                }
                result = false;
            }
            if (this.itemType != null) {
                EValidator rootValidator = EObjectValidator.this.getRootEValidator(context);
                Iterator i = ((List)value2).iterator();
                while (i.hasNext() && (result || diagnostics != null)) {
                    result &= rootValidator.validate(this.itemType, i.next(), diagnostics, context);
                }
                return result;
            }
            if (!this.memberTypes.isEmpty()) {
                EDataType memberType;
                EValidator rootValidator = EObjectValidator.this.getRootEValidator(context);
                Iterator i = this.memberTypes.iterator();
                while (i.hasNext()) {
                    memberType = (EDataType)i.next();
                    if (!rootValidator.validate(memberType, value2, null, context)) continue;
                    return true;
                }
                i = this.memberTypes.iterator();
                while (i.hasNext()) {
                    memberType = (EDataType)i.next();
                    if (!memberType.isInstance(value2)) continue;
                    return rootValidator.validate(memberType, value2, diagnostics, context);
                }
                return false;
            }
            return result;
        }
    }
}

