/* Virtual Keys, Standard Set
 */
#define WIN_VK_LBUTTON          0x01
#define WIN_VK_RBUTTON          0x02
#define WIN_VK_CANCEL           0x03
#define WIN_VK_MBUTTON          0x04
#define WIN_VK_BACK             0x08
#define WIN_VK_TAB              0x09
#define WIN_VK_CLEAR            0x0C
#define WIN_VK_RETURN           0x0D
#define WIN_VK_SHIFT            0x10
#define WIN_VK_CONTROL          0x11
#define WIN_VK_MENU             0x12
#define WIN_VK_PAUSE            0x13
#define WIN_VK_CAPITAL          0x14
#define WIN_VK_ESCAPE           0x1B
#define WIN_VK_SPACE            0x20
#define WIN_VK_PRIOR            0x21
#define WIN_VK_NEXT             0x22
#define WIN_VK_END              0x23
#define WIN_VK_HOME             0x24
#define WIN_VK_LEFT             0x25
#define WIN_VK_UP               0x26
#define WIN_VK_RIGHT            0x27
#define WIN_VK_DOWN             0x28
#define WIN_VK_SELECT           0x29
#define WIN_VK_PRINT            0x2A
#define WIN_VK_EXECUTE          0x2B
#define WIN_VK_SNAPSHOT         0x2C
#define WIN_VK_INSERT           0x2D
#define WIN_VK_DELETE           0x2E
#define WIN_VK_HELP             0x2F
#define WIN_VK_LWIN             0x5B
#define WIN_VK_RWIN             0x5C
#define WIN_VK_APPS             0x5D
#define WIN_VK_NUMPAD0          0x60
#define WIN_VK_NUMPAD1          0x61
#define WIN_VK_NUMPAD2          0x62
#define WIN_VK_NUMPAD3          0x63
#define WIN_VK_NUMPAD4          0x64
#define WIN_VK_NUMPAD5          0x65
#define WIN_VK_NUMPAD6          0x66
#define WIN_VK_NUMPAD7          0x67
#define WIN_VK_NUMPAD8          0x68
#define WIN_VK_NUMPAD9          0x69
#define WIN_VK_MULTIPLY         0x6A
#define WIN_VK_ADD              0x6B
#define WIN_VK_SEPARATOR        0x6C
#define WIN_VK_SUBTRACT         0x6D
#define WIN_VK_DECIMAL          0x6E
#define WIN_VK_DIVIDE           0x6F
#define WIN_VK_F1               0x70
#define WIN_VK_F2               0x71
#define WIN_VK_F3               0x72
#define WIN_VK_F4               0x73
#define WIN_VK_F5               0x74
#define WIN_VK_F6               0x75
#define WIN_VK_F7               0x76
#define WIN_VK_F8               0x77
#define WIN_VK_F9               0x78
#define WIN_VK_F10              0x79
#define WIN_VK_F11              0x7A
#define WIN_VK_F12              0x7B
#define WIN_VK_F13              0x7C
#define WIN_VK_F14              0x7D
#define WIN_VK_F15              0x7E
#define WIN_VK_F16              0x7F
#define WIN_VK_F17              0x80
#define WIN_VK_F18              0x81
#define WIN_VK_F19              0x82
#define WIN_VK_F20              0x83
#define WIN_VK_F21              0x84
#define WIN_VK_F22              0x85
#define WIN_VK_F23              0x86
#define WIN_VK_F24              0x87
#define WIN_VK_NUMLOCK          0x90
#define WIN_VK_SCROLL           0x91
#define WIN_VK_LSHIFT           0xA0
#define WIN_VK_RSHIFT           0xA1
#define WIN_VK_LCONTROL         0xA2
#define WIN_VK_RCONTROL         0xA3
#define WIN_VK_LMENU            0xA4
#define WIN_VK_RMENU            0xA5
#define WIN_VK_ATTN             0xF6
#define WIN_VK_CRSEL            0xF7
#define WIN_VK_EXSEL            0xF8
#define WIN_VK_EREOF            0xF9
#define WIN_VK_PLAY             0xFA
#define WIN_VK_ZOOM             0xFB
#define WIN_VK_NONAME           0xFC
#define WIN_VK_PA1              0xFD
#define WIN_VK_OEM_CLEAR        0xFE


/* These vkey definitions do not exist in the Windows header files
 * since their values are the same as the chars.  They are defined
 * defined here simply to make the code more readable.
 */
#define WIN_VK_A   'A'
#define WIN_VK_B   'B'
#define WIN_VK_C   'C'
#define WIN_VK_D   'D'
#define WIN_VK_E   'E'
#define WIN_VK_F   'F'
#define WIN_VK_G   'G'
#define WIN_VK_H   'H'
#define WIN_VK_I   'I'
#define WIN_VK_J   'J'
#define WIN_VK_K   'K'
#define WIN_VK_L   'L'
#define WIN_VK_M   'M'
#define WIN_VK_N   'N'
#define WIN_VK_O   'O'
#define WIN_VK_P   'P'
#define WIN_VK_Q   'Q'
#define WIN_VK_R   'R'
#define WIN_VK_S   'S'
#define WIN_VK_T   'T'
#define WIN_VK_U   'U'
#define WIN_VK_V   'V'
#define WIN_VK_W   'W'
#define WIN_VK_X   'X'
#define WIN_VK_Y   'Y'
#define WIN_VK_Z   'Z'

#define WIN_VK_1   '1'
#define WIN_VK_2   '2'
#define WIN_VK_3   '3'
#define WIN_VK_4   '4'
#define WIN_VK_5   '5'
#define WIN_VK_6   '6'
#define WIN_VK_7   '7'
#define WIN_VK_8   '8'
#define WIN_VK_9   '9'
#define WIN_VK_0   '0'

/* The following vkey definitions are undocumented in Windows
 */
#define WIN_VK_SEMICOLON       0xBA
#define WIN_VK_EQUAL           0xBB
#define WIN_VK_COMMA           0xBC
#define WIN_VK_HYPHEN          0xBD
#define WIN_VK_PERIOD          0xBE
#define WIN_VK_SLASH           0xBF
#define WIN_VK_GRAVE           0xC0
#define WIN_VK_BRACKETLEFT     0xDB
#define WIN_VK_BACKSLASH       0xDC
#define WIN_VK_BRACKETRIGHT    0xDD
#define WIN_VK_QUOTESINGLE     0xDE
#define WIN_VK_EXTRA           0xE2
#define WIN_VK_JEXTRA          0xE3

/* Table to translate from a PM scancode to a general Windows vkey,
 * left-right specific Windows vkey or and extended key flag.
 *
 * NOTE: Windows uses different vkeys for the numpad depending on numlock
 *       state.  This table assumes numlock is ON.  To map this vkey to it's
 *       numlock OFF equivalent, use the table 'abNumlockWinVKeyToWinVKey'
 *       below.
 */
BYTE   abPMScanToWinVKey[256][1] = {
/*********************************************/
/* Scancode                 *   Windows VKEY */
/*********************************************/
/* 0x00                     */  0x00,
/* 0x01 PMSCAN_ESC          */  WIN_VK_ESCAPE,
/* 0x02 PMSCAN_ONE          */  WIN_VK_1,
/* 0x03 PMSCAN_TWO          */  WIN_VK_2,
/* 0x04 PMSCAN_THREE        */  WIN_VK_3,
/* 0x05 PMSCAN_FOUR         */  WIN_VK_4,
/* 0x06 PMSCAN_FIVE         */  WIN_VK_5,
/* 0x07 PMSCAN_SIX          */  WIN_VK_6,
/* 0x08 PMSCAN_SEVEN        */  WIN_VK_7,
/* 0x09 PMSCAN_EIGHT        */  WIN_VK_8,
/* 0x0A PMSCAN_NINE         */  WIN_VK_9,
/* 0x0B PMSCAN_ZERO         */  WIN_VK_0,
/* 0x0C PMSCAN_HYPHEN       */  WIN_VK_HYPHEN,
/* 0x0D PMSCAN_EQUAL        */  WIN_VK_EQUAL,
/* 0x0E PMSCAN_BACKSPACE    */  WIN_VK_BACK,
/* 0x0F PMSCAN_TAB          */  WIN_VK_TAB,
/* 0x10 PMSCAN_Q            */  WIN_VK_Q,
/* 0x11 PMSCAN_W            */  WIN_VK_W,
/* 0x12 PMSCAN_E            */  WIN_VK_E,
/* 0x13 PMSCAN_R            */  WIN_VK_R,
/* 0x14 PMSCAN_T            */  WIN_VK_T,
/* 0x15 PMSCAN_Y            */  WIN_VK_Y,
/* 0x16 PMSCAN_U            */  WIN_VK_U,
/* 0x17 PMSCAN_I            */  WIN_VK_I,
/* 0x18 PMSCAN_O            */  WIN_VK_O,
/* 0x19 PMSCAN_P            */  WIN_VK_P,
/* 0x1A PMSCAN_BRACKETLEFT  */  WIN_VK_BRACKETLEFT,
/* 0x1B PMSCAN_BRACKETRIGHT */  WIN_VK_BRACKETRIGHT,
/* 0x1C PMSCAN_ENTER        */  WIN_VK_RETURN,
/* 0x1D PMSCAN_CTRLLEFT     */  WIN_VK_LCONTROL,
/* 0x1E PMSCAN_A            */  WIN_VK_A,
/* 0x1F PMSCAN_S            */  WIN_VK_S,
/* 0x20 PMSCAN_D            */  WIN_VK_D,
/* 0x21 PMSCAN_F            */  WIN_VK_F,
/* 0x22 PMSCAN_G            */  WIN_VK_G,
/* 0x23 PMSCAN_H            */  WIN_VK_H,
/* 0x24 PMSCAN_J            */  WIN_VK_J,
/* 0x25 PMSCAN_K            */  WIN_VK_K,
/* 0x26 PMSCAN_L            */  WIN_VK_L,
/* 0x27 PMSCAN_SEMICOLON    */  WIN_VK_SEMICOLON,
/* 0x28 PMSCAN_QUOTESINGLE  */  WIN_VK_QUOTESINGLE,
/* 0x29 PMSCAN_GRAVE        */  WIN_VK_GRAVE,
/* 0x2A PMSCAN_SHIFTLEFT    */  WIN_VK_LSHIFT,
/* 0x2B PMSCAN_BACKSLASH    */  WIN_VK_BACKSLASH,
/* 0x2C PMSCAN_Z            */  WIN_VK_Z,
/* 0x2D PMSCAN_X            */  WIN_VK_X,
/* 0x2E PMSCAN_C            */  WIN_VK_C,
/* 0x2F PMSCAN_V            */  WIN_VK_V,
/* 0x30 PMSCAN_B            */  WIN_VK_B,
/* 0x31 PMSCAN_N            */  WIN_VK_N,
/* 0x32 PMSCAN_M            */  WIN_VK_M,
/* 0x33 PMSCAN_COMMA        */  WIN_VK_COMMA,
/* 0x34 PMSCAN_PERIOD       */  WIN_VK_PERIOD,
/* 0x35 PMSCAN_SLASH        */  WIN_VK_SLASH,
/* 0x36 PMSCAN_SHIFTRIGHT   */  WIN_VK_RSHIFT,
/* 0x37 PMSCAN_PADASTERISK  */  WIN_VK_MULTIPLY,
/* 0x38 PMSCAN_ALTLEFT      */  WIN_VK_LMENU,
/* 0x39 PMSCAN_SPACE        */  WIN_VK_SPACE,
/* 0x3A PMSCAN_CAPSLOCK     */  WIN_VK_CAPITAL,
/* 0x3B PMSCAN_F1           */  WIN_VK_F1,
/* 0x3C PMSCAN_F2           */  WIN_VK_F2,
/* 0x3D PMSCAN_F3           */  WIN_VK_F3,
/* 0x3E PMSCAN_F4           */  WIN_VK_F4,
/* 0x3F PMSCAN_F5           */  WIN_VK_F5,
/* 0x40 PMSCAN_F6           */  WIN_VK_F6,
/* 0x41 PMSCAN_F7           */  WIN_VK_F7,
/* 0x42 PMSCAN_F8           */  WIN_VK_F8,
/* 0x43 PMSCAN_F9           */  WIN_VK_F9,
/* 0x44 PMSCAN_F10          */  WIN_VK_F10,
/* 0x45 PMSCAN_NUMLOCK      */  WIN_VK_NUMLOCK,
/* 0x46 PMSCAN_SCROLLLOCK   */  WIN_VK_SCROLL,
/* 0x47 PMSCAN_PAD7         */  WIN_VK_NUMPAD7,
/* 0x48 PMSCAN_PAD8         */  WIN_VK_NUMPAD8,
/* 0x49 PMSCAN_PAD9         */  WIN_VK_NUMPAD9,
/* 0x4A PMSCAN_PADMINUS     */  WIN_VK_SUBTRACT,
/* 0x4B PMSCAN_PAD4         */  WIN_VK_NUMPAD4,
/* 0x4C PMSCAN_PAD5         */  WIN_VK_NUMPAD5,
/* 0x4D PMSCAN_PAD6         */  WIN_VK_NUMPAD6,
/* 0x4E PMSCAN_PADPLUS      */  WIN_VK_ADD,
/* 0x4F PMSCAN_PAD1         */  WIN_VK_NUMPAD1,
/* 0x50 PMSCAN_PAD2         */  WIN_VK_NUMPAD2,
/* 0x51 PMSCAN_PAD3         */  WIN_VK_NUMPAD3,
/* 0x52 PMSCAN_PAD0         */  WIN_VK_NUMPAD0,
/* 0x53 PMSCAN_PADPERIOD    */  WIN_VK_DECIMAL,
/* 0x54 PMSCAN_SYSREQ       */  0x00,
/* 0x55 PMSCAN_RESET        */  0x00,
/* 0x56 PMSCAN_EXTRA        */  WIN_VK_EXTRA,
/* 0x57 PMSCAN_F11          */  WIN_VK_F11,
/* 0x58 PMSCAN_F12          */  WIN_VK_F12,
/* 0x59 PMSCAN_BACKTAB      */  0x00,
/* 0x5A PMSCAN_PADENTER     */  WIN_VK_RETURN,
/* 0x5B PMSCAN_CTRLRIGHT    */  WIN_VK_RCONTROL,
/* 0x5C PMSCAN_PADSLASH     */  WIN_VK_DIVIDE,
/* 0x5D PMSCAN_PRINT        */  WIN_VK_PRINT,
/* 0x5E PMSCAN_ALTRIGHT     */  WIN_VK_RMENU,
/* 0x5F PMSCAN_PAUSE        */  WIN_VK_PAUSE,
/* 0x60 PMSCAN_HOME         */  WIN_VK_HOME,
/* 0x61 PMSCAN_UP           */  WIN_VK_UP,
/* 0x62 PMSCAN_PAGEUP       */  WIN_VK_PRIOR,
/* 0x63 PMSCAN_LEFT         */  WIN_VK_LEFT,
/* 0x64 PMSCAN_RIGHT        */  WIN_VK_RIGHT,
/* 0x65 PMSCAN_END          */  WIN_VK_END,
/* 0x66 PMSCAN_DOWN         */  WIN_VK_DOWN,
/* 0x67 PMSCAN_PAGEDOWN     */  WIN_VK_NEXT,
/* 0x68 PMSCAN_INSERT       */  WIN_VK_INSERT,
/* 0x69 PMSCAN_DELETE       */  WIN_VK_DELETE,
/* 0x6A PMSCAN_F23          */  WIN_VK_F23,
/* 0x6B PMSCAN_F24          */  WIN_VK_F24,
/* 0x6C PMSCAN_SYSMEM       */  0x00,
/* 0x6D PMSCAN_ERASEEOF     */  WIN_VK_EREOF,
/* 0x6E PMSCAN_BREAK        */  WIN_VK_CANCEL,
/* 0x6F PMSCAN_MOVEWIN      */  0x00,
/* 0x70 PMSCAN_NLS3         */  0x00,
/* 0x71 PMSCAN_HELP         */  WIN_VK_HELP,
/* 0x72 PMSCAN_TASKMAN      */  0x00,
/* 0x73 PMSCAN_JEXTRA       */  WIN_VK_JEXTRA,
/* 0x74 PMSCAN_B11          */  0x00,
/* 0x75 PMSCAN_JUMP         */  0x00,
/* 0x76 PMSCAN_MINWIN       */  0x00,
/* 0x77 PMSCAN_CLEAR        */  0x00,
/* 0x78 PMSCAN_77           */  0x00,
/* 0x79 PMSCAN_78           */  0x00,
/* 0x7A PMSCAN_NLS2         */  0x00,
/* 0x7B PMSCAN_SIZE         */  0x00,
/* 0x7C PMSCAN_NLS1         */  0x00,
/* 0x7D PMSCAN_APPLICATION  */  WIN_VK_APPS,
/* 0x7E PMSCAN_YEN          */  0x00,
/* 0x7F PMSCAN_E13          */  0x00,
/* 0x80 PMSCAN_WINLEFT      */  WIN_VK_LWIN,
/* 0x81 PMSCAN_WINRIGHT     */  WIN_VK_RWIN,
/* 0x82 PMSCAN_PA1          */  WIN_VK_PA1,
/* 0x83 PMSCAN_F13          */  WIN_VK_F13,
/* 0x84 PMSCAN_F14          */  WIN_VK_F14,
/* 0x85 PMSCAN_F15          */  WIN_VK_F15,
/* 0x86 PMSCAN_PA2          */  0x00,
/* 0x87 PMSCAN_PA3          */  0x00,
/* 0x88 PMSCAN_SPACEBREAK   */  0x00,
/* 0x89 PMSCAN_TABRIGHT     */  0x00,
/* 0x8A PMSCAN_NOOP         */  0x00,
/* 0x8B PMSCAN_F16          */  WIN_VK_F16,
/* 0x8C PMSCAN_F17          */  WIN_VK_F17,
/* 0x8D PMSCAN_F18          */  WIN_VK_F18,
/* 0x8E PMSCAN_F19          */  WIN_VK_F19,
/* 0x8F PMSCAN_F20          */  WIN_VK_F20,
/* 0x90 PMSCAN_F21          */  WIN_VK_F21,
/* 0x91 PMSCAN_F22          */  WIN_VK_F22,
/* 0x92                     */  0x00,
/* 0x93                     */  0x00,
/* 0x94                     */  0x00,
/* 0x95                     */  0x00,
/* 0x96                     */  0x00,
/* 0x97                     */  0x00,
/* 0x98                     */  0x00,
/* 0x99                     */  0x00,
/* 0x9A                     */  0x00,
/* 0x9B                     */  0x00,
/* 0x9C                     */  0x00,
/* 0x9D                     */  0x00,
/* 0x9E                     */  0x00,
/* 0x9F                     */  0x00,
/* 0xA0                     */  0x00,
/* 0xA1                     */  0x00,
/* 0xA2                     */  0x00,
/* 0xA3                     */  0x00,
/* 0xA4                     */  0x00,
/* 0xA5                     */  0x00,
/* 0xA6                     */  0x00,
/* 0xA7                     */  0x00,
/* 0xA8                     */  0x00,
/* 0xA9                     */  0x00,
/* 0xAA                     */  0x00,
/* 0xAB                     */  0x00,
/* 0xAC                     */  0x00,
/* 0xAD                     */  0x00,
/* 0xAE                     */  0x00,
/* 0xAF                     */  0x00,
/* 0xB0                     */  0x00,
/* 0xB1                     */  0x00,
/* 0xB2                     */  0x00,
/* 0xB3                     */  0x00,
/* 0xB4                     */  0x00,
/* 0xB5                     */  0x00,
/* 0xB6                     */  0x00,
/* 0xB7                     */  0x00,
/* 0xB8                     */  0x00,
/* 0xB9                     */  0x00,
/* 0xBA                     */  0x00,
/* 0xBB                     */  0x00,
/* 0xBC                     */  0x00,
/* 0xBD                     */  0x00,
/* 0xBE                     */  0x00,
/* 0xBF                     */  0x00,
/* 0xC0                     */  0x00,
/* 0xC1                     */  0x00,
/* 0xC2                     */  0x00,
/* 0xC3                     */  0x00,
/* 0xC4                     */  0x00,
/* 0xC5                     */  0x00,
/* 0xC6                     */  0x00,
/* 0xC7                     */  0x00,
/* 0xC8                     */  0x00,
/* 0xC9                     */  0x00,
/* 0xCA                     */  0x00,
/* 0xCB                     */  0x00,
/* 0xCC                     */  0x00,
/* 0xCD                     */  0x00,
/* 0xCE                     */  0x00,
/* 0xCF                     */  0x00,
/* 0xD0                     */  0x00,
/* 0xD1                     */  0x00,
/* 0xD2                     */  0x00,
/* 0xD3                     */  0x00,
/* 0xD4                     */  0x00,
/* 0xD5                     */  0x00,
/* 0xD6                     */  0x00,
/* 0xD7                     */  0x00,
/* 0xD8                     */  0x00,
/* 0xD9                     */  0x00,
/* 0xDA                     */  0x00,
/* 0xDB                     */  0x00,
/* 0xDC                     */  0x00,
/* 0xDD                     */  0x00,
/* 0xDE                     */  0x00,
/* 0xDF                     */  0x00,
/* 0xE0                     */  0x00,
/* 0xE1                     */  0x00,
/* 0xE2                     */  0x00,
/* 0xE3                     */  0x00,
/* 0xE4                     */  0x00,
/* 0xE5                     */  0x00,
/* 0xE6                     */  0x00,
/* 0xE7                     */  0x00,
/* 0xE8                     */  0x00,
/* 0xE9                     */  0x00,
/* 0xEA                     */  0x00,
/* 0xEB                     */  0x00,
/* 0xEC                     */  0x00,
/* 0xED                     */  0x00,
/* 0xEE                     */  0x00,
/* 0xEF                     */  0x00,
/* 0xF0                     */  0x00,
/* 0xF1                     */  0x00,
/* 0xF2                     */  0x00,
/* 0xF3                     */  0x00,
/* 0xF4                     */  0x00,
/* 0xF5                     */  0x00,
/* 0xF6                     */  0x00,
/* 0xF7                     */  0x00,
/* 0xF8                     */  0x00,
/* 0xF9                     */  0x00,
/* 0xFA                     */  0x00,
/* 0xFB                     */  0x00,
/* 0xFC                     */  0x00,
/* 0xFD                     */  0x00,
/* 0xFE                     */  0x00,
/* 0xFF                     */  0x00,
                               };
