#!/bin/ksh

# **************************************************************************
# *
# * File:  customerProfileSampleData.sh
# *
# * This file is for populating the tables for the CustomerProfile AC
# *
# * Updated: November 30th, 2000
# *
# **************************************************************************

USAGE="\nUsage: customerProfileSampleData.sh database [userid password] [qualifier]"
qualifier=$1

function ErrorMessage
{
  print "$USEAGE"
}

function DirectConnectWithCurrentUserid
{
  db2 connect to $1
  qualifier=$USER
  PopulateTables
}

function DirectConnectWithQualifier1
{
  db2 connect to $1
  qualifier=$2
  PopulateTables
}

function ConnectWithParWithUserid
{
  db2 connect to $1 user $2 using $3
  qualifier=$2
  PopulateTables
}

function ConnectWithParWithQualifier2
{
  db2 connect to $1 user $2 using $3
  qualifier=$4
  PopulateTables
}

function PopulateTables
{
  print "Customer table"
  db2 insert into $qualifier.customer values"('CUSTOMER001', current timestamp, null, null, 'PERSON', null, null)"
  db2 insert into $qualifier.customer values"('CUSTOMER002', current timestamp, ' ', 'ACT', 'PERSON', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.customer values"('CUSTOMER003', current timestamp, ' ', 'ACT', 'PERSON', null, null)"
  print "Customer table populated"

  print "Person Name table"
  db2 insert into $qualifier.person_name values"(current timestamp, current timestamp, 'CUSTOMER001', null, 'Alice', 'Wonderland', 'In', 'MSS', 'Adventurer', 'LGL', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_name values"(current timestamp, current timestamp, 'CUSTOMER002', null, 'Mad', 'Hatter', null, 'MR', 'Esquire', 'LGL', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_name values"(current timestamp, current timestamp, 'CUSTOMER003', null, 'John', 'Doe', null, null, null, 'LGL', null, null)"
  print "Person Name table populated"

  print "Person Information table"
  db2 insert into $qualifier.person_info values"(current timestamp, current timestamp, 'CUSTOMER001', null, '01/01/1900', '01/01/2000', 'FEM', 'ENG', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_info values"(current timestamp, current timestamp, 'CUSTOMER002', ' ', '01/01/1900', '01/01/2000', 'FEM', 'ENG', 'dynCol1', 'dynCol2')"
  db2 insert into $qualifier.person_info values"(current timestamp, current timestamp, 'CUSTOMER003', ' ', null, null, null, 'FRE', null, null)"
  print "Person Information table populated"

  print "Address table"
  db2 insert into $qualifier.postal_address values"('1900-01-01-01.01.01.000001', current timestamp, 'CUSTOMER001', null, 'Toronto', 'CAN', '3rd Floor', null, 'University Avenue', '330', 'ONT', null, null, null)"
  db2 insert into $qualifier.postal_address values"('1900-01-01-01.01.01.000002', current timestamp, 'CUSTOMER001', null, 'Montreal', 'CAN', null, null, null, null, 'QUE', null, null, null)"
  db2 insert into $qualifier.postal_address values"('1900-01-01-01.01.01.000003', current timestamp, 'CUSTOMER002', null, 'New York', 'USA', null, null, '5th Avenue', null, 'NY', null, null, null)"
  db2 insert into $qualifier.postal_address values"('1900-01-01-01.01.01.000004', current timestamp, 'CUSTOMER003', null, 'Toronto', 'CAN', null, null, 'Yonge Street', null, 'ONT', null, 'dynCol1', 'dynCol2')"
  print "Postal Address table populated"

  print "Address Usage table"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'HOM', '1900-01-01-01.01.01.000001')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'BUS', '1900-01-01-01.01.01.000001')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'HOM', '1900-01-01-01.01.01.000002')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'VAC', '1900-01-01-01.01.01.000003')"
  db2 insert into $qualifier.address_usage values"(current timestamp, null, 'HOM', '1900-01-01-01.01.01.000004')"
  print "Address Usage table populated"

  print "Email Address table"
  db2 insert into $qualifier.email_address values"(current timestamp, current timestamp, 'CUSTOMER001', null, 'alice', '@looking.glass', 'HME', null, null)"
  db2 insert into $qualifier.email_address values"(current timestamp, current timestamp, 'CUSTOMER002', null, 'madH', '@looking.glass', 'HME', null, null)"
  print "Email Address table populated"

  print "Phone Number table"
  db2 insert into $qualifier.phone_number values"(current timestamp, current timestamp, 'CUSTOMER001', null, '1', null, '416', '340-1200', '2264', 'BPH', null, null)"
  db2 insert into $qualifier.phone_number values"(current timestamp, current timestamp, 'CUSTOMER003', null, '1', null, '562', '111-1111', null, 'REP', null, null)"
  print "Phone Number table populated"
} #End PopulateTables

# *
# * Following block is for connecting to database and setting qualifier depending 
# * on number of parameters.
# *

if [[ $# = 0 ]]
then ErrorMessage
elif [[ $# = 1 ]]
then DirectConnectWithCurrentUserid $1
elif [[ $# = 2 ]]
then DirectConnectWithQualifier1 $1 $2
elif [[ $# = 3 ]]
then ConnectWithParWithUserid $1 $2 $3
elif [[ $# = 4 ]]
then ConnectWithParWithQualifier2 $1 $2 $3 $4
elif [[ $# > 4 ]]
then ErrorMessage
fi

db2 grant connect on database to public
db2 connect reset