/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.cdi.archive;

import com.ibm.rational.cdi.archive.ArchiveHandler;
import com.ibm.rational.cdi.archive.StoredFileList;
import com.ibm.rational.cdi.archive.SymLink;
import com.ibm.rational.cdi.cib.CDIReferenceInstall;
import com.ibm.rational.cdi.cib.CDIReferenceUninstall;
import com.ibm.rational.cdi.cib.Registry;
import com.ibm.rational.cdi.exception.CDIException;
import com.ibm.rational.cdi.util.Messages;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.util.FileUtils;
import com.installshield.util.StringResolverException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;

public class CDIInstallArchive
extends ProductAction {
    public static final String PATH_FILENAME = "install.path.properties";
    public static final String LINK_FILENAME = "install.link.properties";
    public static final String STORE_BASE_FILENAME = ".store.xml";
    private String keyfile = "";
    private String installLocation = "";
    private String archiveDirectory = "";
    private String commonInstallHome = null;
    private String directoryPrefix = null;
    private int fileSize;
    private Messages msgs = new Messages("com.ibm.rational.cdi.archive.installarchive");
    private String cdiReferenceInstallBean;
    private String cdiReferenceUninstallBean;
    private Registry reg = null;

    public void build(ProductBuilderSupport support) {
        boolean found = this.detectReferenceBean(support);
        if (!found) {
            support.logEvent(this, "err", this.getBeanId() + ":" + "Missing Required CDIReferenceInstall or CDIReferenceUninstallin component " + this.getParentComponent().getBeanId());
            return;
        }
        try {
            this.setCommonInstallHome(this.resolveStringWithValidation("$A(COMMON_INSTALL_HOME)"));
        }
        catch (StringResolverException e1) {
            support.logEvent(this, "err", this.getBeanId() + ":" + e1.getMessage());
        }
        ArchiveHandler ah = new ArchiveHandler(this);
        ah.build(support);
        this.directoryPrefix = this.loadPath(support, PATH_FILENAME);
        TreeSet symlinks = this.loadSymbolicLinks(support, LINK_FILENAME);
        StoredFileList sfl = new StoredFileList(this, this.getBeanId() + STORE_BASE_FILENAME);
        sfl.setTotalNumberOfFiles(ah.getTotalNumberOfFiles());
        sfl.setTotalSize(ah.getTotalSize());
        sfl.setDirlist(ah.getDirectories());
        sfl.setFileList(ah.getFiles());
        sfl.setIndex(ah.getIndex());
        sfl.setSymbolicLinks(symlinks);
        sfl.store(support);
        this.fileSize = ah.getTotalSize();
        try {
            support.putClass("com.ibm.rational.cdi.cib.Registry");
            support.putClass("com.ibm.rational.cdi.archive.SymLink");
            support.putClass("com.ibm.rational.cdi.archive.ArchiveHandler");
            support.putClass("com.ibm.rational.cdi.archive.StoredFileList");
            support.putClass("com.ibm.rational.cdi.archive.StoredFileList$FileComparator");
            support.putClass("com.ibm.rational.cdi.util.Messages");
            support.putClass("com.ibm.rational.cdi.exception.RegistryInvalid");
            support.putClass("com.ibm.rational.cdi.exception.CDIException");
            support.putClassResource("com/ibm/rational/cdi/archive/installarchive.properties");
            support.putClassResource("com/ibm/rational/cdi/archive/archivehandler.properties");
            support.putRequiredService("fileService");
        }
        catch (IOException e1) {
            support.logEvent(this, "err", this.getBeanId() + ":" + this.msgs.getString("CDIInstallArchive.ERR_SupportClassesMissing", e1.getMessage()));
        }
    }

    private boolean detectReferenceBean(ProductBuilderSupport support) {
        boolean fInstall = false;
        boolean fUninstall = false;
        boolean bail = false;
        Enumeration e = this.getProductTree().children(this.getParentComponent());
        while (e.hasMoreElements()) {
            ProductBean pb = (ProductBean)e.nextElement();
            if (pb instanceof CDIReferenceInstall) {
                if (!fInstall) {
                    this.cdiReferenceInstallBean = pb.getBeanId();
                    fInstall = true;
                } else {
                    bail = true;
                    support.logEvent(this, "err", this.getBeanId() + ":" + "More than one CDIReferenceInstall in component " + this.getParentComponent().getBeanId());
                }
            }
            if (!(pb instanceof CDIReferenceUninstall)) continue;
            if (!fUninstall) {
                this.cdiReferenceUninstallBean = pb.getBeanId();
                fUninstall = true;
                continue;
            }
            bail = true;
            support.logEvent(this, "err", this.getBeanId() + ":" + "More than one CDIReferenceUnInstall in component " + this.getParentComponent().getBeanId());
        }
        return !bail && fInstall && fUninstall;
    }

    private TreeSet loadSymbolicLinks(ProductBuilderSupport support, String linkfilename) {
        TreeSet<SymLink> symlist;
        block3: {
            symlist = new TreeSet<SymLink>();
            File linkFile = new File(this.resolveString(this.archiveDirectory), linkfilename);
            if (!linkFile.exists()) break block3;
            try {
                Properties links = new Properties();
                links.load(new FileInputStream(linkFile));
                Enumeration<?> e = links.propertyNames();
                while (e.hasMoreElements()) {
                    String from = (String)e.nextElement();
                    String to = FileUtils.normalizeFileName(links.getProperty(from), '/');
                    symlist.add(new SymLink(FileUtils.normalizeFileName(from, '/'), to));
                }
            }
            catch (IOException e) {
                support.logEvent(this, "err", this.getBeanId() + ":" + e.getMessage());
            }
        }
        return symlist;
    }

    public void setCommonInstallHome(String s) {
        this.commonInstallHome = s;
    }

    private String loadPath(ProductBuilderSupport support, String pathFileName) {
        String path;
        block4: {
            path = null;
            File pathFile = new File(this.resolveString(this.archiveDirectory), pathFileName);
            if (!pathFile.exists()) break block4;
            try {
                Properties p = new Properties();
                p.load(new FileInputStream(pathFile));
                if (p.containsKey("path")) {
                    path = FileUtils.normalizeFileName(p.getProperty("path"), '/');
                    break block4;
                }
                support.logEvent(this, this.getBeanId() + ":" + "err", pathFileName + " missing required \"path\" property.");
            }
            catch (FileNotFoundException e) {
                support.logEvent(this, "err", this.getBeanId() + ":" + "Cannot find " + pathFileName + " :" + e.getMessage());
            }
            catch (IOException e) {
                support.logEvent(this, "err", this.getBeanId() + ":" + "IO Error loading " + pathFileName + ": " + e.getMessage());
            }
        }
        return path;
    }

    public void install(ProductActionSupport support) throws ProductException {
        this.commonInstallHome = FileUtils.normalizeFileName(this.resolveString(this.commonInstallHome), '/');
        try {
            this.reg = new Registry(this.commonInstallHome);
            this.reg.setPrimaryBeanId(this.getParentComponent().getBeanId());
            boolean performInstall = this.checkPerformAction(this.cdiReferenceInstallBean);
            if (!performInstall) {
                this.installLocation = this.reg.getBeanInstallLocation(this.getBeanId());
                if (this.installLocation == null || this.installLocation.length() == 0) {
                    throw new CDIException(this.msgs.getString("CDIInstallArchive.RegistryMissingInstallLocation", this.getBeanId()));
                }
            } else {
                this.installLocation = this.getParentComponent().getAbsoluteInstallLocation();
                if (this.directoryPrefix != null && this.directoryPrefix.length() > 0) {
                    File ist = new File(this.installLocation, this.directoryPrefix);
                    this.installLocation = ist.getAbsolutePath();
                }
                this.reg.addLocation(this.getBeanId(), this.installLocation);
                StoredFileList sfl = new StoredFileList(this, this.getBeanId() + STORE_BASE_FILENAME);
                File tempFile = sfl.load(support);
                int fileCount = sfl.getTotalNumberOfFiles();
                int totalTime = this.getEstimatedTimeToInstall();
                boolean cancel = this.createDirectories(support, sfl.getDirlist());
                if (!cancel) {
                    ArchiveHandler ah = new ArchiveHandler(this);
                    cancel = ah.install(support, sfl.getIndex(), totalTime, fileCount);
                }
                if (!cancel && !System.getProperty("os.name").startsWith("Windows")) {
                    cancel = this.createSymbolicLinks(sfl.getSymbolicLinks());
                }
                if (cancel) {
                    this.rollback(support, sfl);
                }
                try {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.reg.isDirty()) {
                this.reg.saveRegistry();
            }
        }
        catch (Exception e) {
            throw new ProductException(601, "err", this.getBeanId() + ":" + e.toString());
        }
    }

    private boolean checkPerformAction(String beanid) {
        String beanToCheck = this.resolveString(beanid);
        boolean performAction = Boolean.valueOf(this.resolveString("$P(" + beanToCheck + ".performActions)"));
        return performAction;
    }

    private void rollback(ProductActionSupport support, StoredFileList sfl) throws ProductException {
        this.removeFiles(support, sfl);
    }

    private void removeFiles(ProductActionSupport support, StoredFileList sfl) throws ProductException {
        Iterator iter;
        FileService fs;
        try {
            fs = (FileService)this.getService("fileService");
            iter = sfl.getFileList().iterator();
            while (iter.hasNext()) {
                String fname = (String)iter.next();
                File f = new File(this.installLocation, fname);
                if (!fs.fileExists(f.getAbsolutePath())) continue;
                fs.deleteFile(f.getAbsolutePath());
            }
            Iterator iter2 = sfl.getSymbolicLinks().iterator();
            while (iter2.hasNext()) {
                SymLink link = (SymLink)iter2.next();
                File f = new File(this.installLocation, link.getTo());
                if (!fs.fileExists(f.getAbsolutePath())) continue;
                fs.deleteFile(f.getAbsolutePath());
            }
        }
        catch (ServiceException se) {
            throw new ProductException(601, "wrn", se);
        }
        iter = sfl.getDirlist().iterator();
        while (iter.hasNext()) {
            String dirname = (String)iter.next();
            try {
                File d = new File(this.installLocation, dirname);
                if (!fs.fileExists(d.getAbsolutePath())) continue;
                fs.deleteDirectory(d.getAbsolutePath(), true, true);
            }
            catch (ServiceException se) {
                this.logEvent(this, "dbg", this.getBeanId() + ":" + "removeFiles:" + se.getMessage());
            }
        }
        if (this.directoryPrefix != null && this.directoryPrefix.length() > 0) {
            this.removeDirectoryPrefix(fs);
        }
    }

    private void removeDirectoryPrefix(FileService fs) {
        File installLoc = new File(this.getParentComponent().getAbsoluteInstallLocation());
        File tmpLocation = new File(installLoc, this.directoryPrefix);
        try {
            while (installLoc.compareTo(tmpLocation) != 0) {
                fs.deleteDirectory(tmpLocation.getAbsolutePath(), true, true);
                tmpLocation = tmpLocation.getParentFile();
            }
        }
        catch (ServiceException se) {
            this.logEvent(this, "dbg", this.getBeanId() + ":" + "removePrefix:" + se.getMessage());
        }
    }

    private boolean createSymbolicLinks(TreeSet symbolicLinks) throws ProductException {
        boolean cancel = false;
        Iterator iter = symbolicLinks.iterator();
        while (iter.hasNext()) {
            SymLink symlink = (SymLink)iter.next();
            symlink.performLink(this);
        }
        return cancel;
    }

    private boolean createDirectories(ProductActionSupport support, TreeSet dirlist) throws ProductException {
        boolean cancel = false;
        File installLocationFile = new File(this.installLocation);
        if (!installLocationFile.exists()) {
            installLocationFile.mkdirs();
        }
        Iterator iter = dirlist.iterator();
        while (iter.hasNext()) {
            String dirname = (String)iter.next();
            File dir = new File(this.installLocation, dirname);
            if (dir.exists()) continue;
            boolean done = dir.mkdirs();
            if (!done) {
                try {
                    support.logEvent(this, "err", this.getBeanId() + ":" + this.msgs.getString("Error extracting directory {0}", dir.getCanonicalPath()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw new ProductException(601, "wrn", this.getBeanId() + ":" + this.msgs.getString("Error extracting directory {0}", dir.getAbsolutePath()));
            }
            if (!support.getOperationState().isCanceled()) continue;
            cancel = true;
            break;
        }
        return cancel;
    }

    public void uninstall(ProductActionSupport support) throws ProductException {
        try {
            this.reg = new Registry(this.commonInstallHome);
            this.reg.setPrimaryBeanId(this.getParentComponent().getBeanId());
            boolean performInstall = this.checkPerformAction(this.cdiReferenceUninstallBean);
            if (performInstall) {
                StoredFileList sfl = new StoredFileList(this, this.getBeanId() + STORE_BASE_FILENAME);
                sfl.load(support);
                this.removeFiles(support, sfl);
                this.reg.removeLocation(this.getBeanId());
            }
            if (this.reg.isDirty()) {
                this.reg.saveRegistry();
            }
            this.reg.saveRegistry();
        }
        catch (CDIException e) {
            e.printStackTrace();
        }
    }

    public int getEstimatedTimeToInstall() {
        return this.fileSize / 1024 / 10;
    }

    public RequiredBytesTable getRequiredBytes() {
        RequiredBytesTable table = new RequiredBytesTable();
        String thisDestination = this.getParentComponent().getAbsoluteInstallLocation();
        table.addBytes(thisDestination, this.fileSize);
        return table;
    }

    public String getArchiveDirectory() {
        return this.archiveDirectory;
    }

    public void setArchiveDirectory(String archiveDirectory) {
        this.archiveDirectory = archiveDirectory;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public void setInstallLocation(String installLocation) {
        this.installLocation = installLocation;
    }

    public String getCommonInstallHome() {
        return this.commonInstallHome;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(int num) {
        this.fileSize = num;
    }

    public String getKeyfile() {
        return this.keyfile;
    }

    public void setKeyfile(String keyfile) {
        this.keyfile = keyfile;
    }

    public String getCdiReferenceInstallBean() {
        return this.cdiReferenceInstallBean;
    }

    public void setCdiReferenceInstallBean(String cdiReferenceBean) {
        this.cdiReferenceInstallBean = cdiReferenceBean;
    }

    public String getCdiReferenceUninstallBean() {
        return this.cdiReferenceUninstallBean;
    }

    public void setCdiReferenceUninstallBean(String cdiReferenceUninstallBean) {
        this.cdiReferenceUninstallBean = cdiReferenceUninstallBean;
    }

    public String getDirectoryPrefix() {
        return this.directoryPrefix;
    }

    public void setDirectoryPrefix(String directoryPrefix) {
        this.directoryPrefix = directoryPrefix;
    }
}

