/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.index;

import com.installshield.archive.ArchiveResourceWriterFactory;
import com.installshield.archive.index.ArchiveIndexEntry;
import com.installshield.archive.index.ArchiveIndexEntryWriter;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.MD5;
import com.installshield.util.URLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class ArchiveIndexWriter {
    private static final int UPDATEABLE_RECORD_SIZE = 8;
    private static final int INDEX_OVERHEAD = 8;
    private FileOutputStream indexOut;
    private Deflater def = null;
    private String tempIndexName;
    private String indexName;
    private String tempUpdateableName;
    private String tempNonUpdateableName;
    private RandomAccessFile raNonUpdateableFile;
    private RandomAccessFile raUpdateableFile;
    private long updateableFileSize = 0L;
    private long nonUpdateableFileSize = 0L;
    private int currentOffset = 0;
    private Hashtable duplicateEntries = new Hashtable();
    boolean isAscii = true;
    boolean delimiterFound = false;
    boolean inDelimiter = false;

    public ArchiveIndexWriter(String string, String string2) throws IOException {
        this.indexName = string2;
        this.tempIndexName = string;
        this.initIndexOutputStream(string);
        this.initTempStorage();
    }

    public void close() throws IOException {
        ArchiveIndexEntryWriter archiveIndexEntryWriter = new ArchiveIndexEntryWriter(this);
        try {
            this.finalizeEntries(archiveIndexEntryWriter);
            OutputStream outputStream = this.getIndexOutputStream();
            archiveIndexEntryWriter.write(outputStream);
        }
        finally {
            Object var3_3 = null;
            this.closeDeflater();
            this.closeIndexOutputStream();
            this.closeTempStorage();
        }
    }

    private void closeDeflater() {
        if (this.def != null) {
            this.def.end();
        }
        this.def = null;
    }

    private void closeIndexOutputStream() throws IOException {
        this.indexOut.close();
        this.indexOut = null;
    }

    private void closeTempStorage() throws IOException {
        this.raUpdateableFile.close();
        this.raUpdateableFile = null;
        this.raNonUpdateableFile.close();
        this.raNonUpdateableFile = null;
        try {
            if (new File(this.tempUpdateableName).delete()) {
                FileUtils.clearTempFile(this.tempUpdateableName);
            }
            if (new File(this.tempNonUpdateableName).delete()) {
                FileUtils.clearTempFile(this.tempUpdateableName);
            }
        }
        catch (Exception exception) {}
    }

    public ArchiveIndexEntry createExternalIndexEntry(String string, int n, String string2, FileAttributes fileAttributes, long l, String string3, byte[] byArray, int n2) throws IOException {
        return this.createExternalIndexEntry(new URL("ismpfile", "", -1, URLUtils.encode(string)), n, string2, fileAttributes, l, string3, byArray, n2);
    }

    public ArchiveIndexEntry createExternalIndexEntry(URL uRL, int n, String string, FileAttributes fileAttributes, long l, String string2, byte[] byArray, int n2) throws IOException {
        int n3;
        InputStream inputStream = uRL.openStream();
        byte[] byArray2 = new byte[5120];
        long l2 = 0L;
        int n4 = 2;
        this.resetExaminationParameters();
        while ((n3 = inputStream.read(byArray2)) != -1) {
            l2 += (long)n3;
            n4 = this.examineBytesForLineDelimiter(byArray2, 0, n3, n4, n);
        }
        n = n4;
        inputStream.close();
        ArchiveIndexEntry archiveIndexEntry = new ArchiveIndexEntry(this.currentOffset, new byte[16], string, n, l2, n2, n2, false, fileAttributes, l, 2, string2, byArray);
        this.storeEntry(archiveIndexEntry);
        ++this.currentOffset;
        return archiveIndexEntry;
    }

    public ArchiveIndexEntry createIndexEntry(String string) throws IOException {
        ArchiveIndexEntry archiveIndexEntry = new ArchiveIndexEntry(this.currentOffset, new byte[16], string, -1, -1L, 1, 1, false, new FileAttributes(), -1L, 0, "", new byte[0]);
        this.storeEntry(archiveIndexEntry);
        ++this.currentOffset;
        return archiveIndexEntry;
    }

    public ArchiveIndexEntry createMD5IndexEntry(String string, int n, String string2, FileAttributes fileAttributes, long l, byte[] byArray) throws IOException {
        return this.createMD5IndexEntry(new URL("ismpfile", "", -1, URLUtils.encode(string)), n, string2, fileAttributes, l, byArray);
    }

    public ArchiveIndexEntry createMD5IndexEntry(URL uRL, int n, String string, FileAttributes fileAttributes, long l, byte[] byArray) throws IOException {
        int n2;
        InputStream inputStream = uRL.openStream();
        MD5 mD5 = new MD5();
        byte[] byArray2 = new byte[5120];
        long l2 = 0L;
        int n3 = 2;
        this.resetExaminationParameters();
        while ((n2 = inputStream.read(byArray2)) != -1) {
            mD5.write(byArray2, 0, n2);
            l2 += (long)n2;
            n3 = this.examineBytesForLineDelimiter(byArray2, 0, n2, n3, n);
        }
        n = n3;
        inputStream.close();
        byte[] byArray3 = mD5.toHash();
        ArchiveIndexEntry archiveIndexEntry = new ArchiveIndexEntry(this.currentOffset, byArray3, string, n, l2, 1, 1, false, fileAttributes, l, 1, "", byArray);
        this.storeEntry(archiveIndexEntry);
        ++this.currentOffset;
        return archiveIndexEntry;
    }

    private int examineBytesForLineDelimiter(byte[] byArray, int n, int n2, int n3, int n4) {
        if (n4 == 2) {
            return 2;
        }
        int n5 = n;
        int n6 = n3;
        while (this.isAscii && n5 < n + n2) {
            byte by = byArray[n5];
            if (by < 0 || by > 127) {
                if (n4 == -1) {
                    this.isAscii = false;
                    n6 = 2;
                    this.inDelimiter = false;
                }
            } else if (!this.delimiterFound) {
                if (by == 13) {
                    this.inDelimiter = true;
                } else if (by == 10) {
                    n6 = this.inDelimiter ? 1 : 0;
                    this.delimiterFound = true;
                    this.inDelimiter = false;
                } else {
                    this.inDelimiter = false;
                }
            }
            ++n5;
        }
        return n6;
    }

    private void finalizeEntries(ArchiveIndexEntryWriter archiveIndexEntryWriter) throws IOException {
        RandomAccessFile randomAccessFile = this.getUpdateableTempStorage();
        RandomAccessFile randomAccessFile2 = this.getNonUpdateableTempStorage();
        randomAccessFile2.seek(0L);
        randomAccessFile.seek(0L);
        int n = 0;
        while (randomAccessFile.getFilePointer() < randomAccessFile.length()) {
            int n2 = randomAccessFile2.readInt();
            byte[] byArray = new byte[n2];
            randomAccessFile2.read(byArray);
            ArchiveIndexEntry archiveIndexEntry = this.loadEntry(byArray, n);
            archiveIndexEntry.startMediaNumber = randomAccessFile.readInt();
            archiveIndexEntry.endMediaNumber = randomAccessFile.readInt();
            String string = ArchiveResourceWriterFactory.getIndexRef(archiveIndexEntry);
            archiveIndexEntry.duplicateResource = string != null ? this.duplicateEntries.containsKey(string) : false;
            archiveIndexEntryWriter.addEntry(archiveIndexEntry);
            ++n;
        }
    }

    public long getArchiveIndexSize() {
        try {
            return this.raUpdateableFile.length() + this.raNonUpdateableFile.length();
        }
        catch (IOException iOException) {
            return this.updateableFileSize + this.nonUpdateableFileSize;
        }
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    protected Deflater getDeflater() {
        if (this.def == null) {
            this.def = new Deflater();
        }
        return this.def;
    }

    public String getIndexName() {
        return this.indexName;
    }

    private OutputStream getIndexOutputStream() {
        return this.indexOut;
    }

    private RandomAccessFile getNonUpdateableTempStorage() {
        return this.raNonUpdateableFile;
    }

    public String getTempIndexName() {
        return this.tempIndexName;
    }

    private RandomAccessFile getUpdateableTempStorage() {
        return this.raUpdateableFile;
    }

    private void initIndexOutputStream(String string) throws IOException {
        this.indexOut = new FileOutputStream(string);
    }

    private void initTempStorage() throws IOException {
        this.tempUpdateableName = FileUtils.createTempFile();
        this.tempNonUpdateableName = FileUtils.createTempFile();
        this.raUpdateableFile = new RandomAccessFile(this.tempUpdateableName, "rw");
        this.raNonUpdateableFile = new RandomAccessFile(this.tempNonUpdateableName, "rw");
    }

    private ArchiveIndexEntry loadEntry(byte[] byArray, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        DataInputStream dataInputStream = new DataInputStream(inflaterInputStream);
        int n2 = dataInputStream.readInt();
        if (n2 != n) {
            throw new IOException("index number did not match entry number.");
        }
        byte[] byArray2 = new byte[16];
        dataInputStream.readFully(byArray2);
        String string = dataInputStream.readUTF();
        int n3 = dataInputStream.readInt();
        long l = dataInputStream.readLong();
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        boolean bl = dataInputStream.readBoolean();
        FileAttributes fileAttributes = null;
        if (dataInputStream.readBoolean()) {
            fileAttributes = new FileAttributes();
            fileAttributes.read(dataInputStream);
        }
        long l2 = dataInputStream.readLong();
        byte by = dataInputStream.readByte();
        String string2 = dataInputStream.readUTF();
        byte[] byArray3 = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(byArray3);
        dataInputStream.close();
        return new ArchiveIndexEntry(n2, byArray2, string, n3, l, n4, n5, bl, fileAttributes, l2, by, string2, byArray3);
    }

    protected void resetDeflater() {
        block2: {
            if (this.def == null) break block2;
            try {
                this.def.reset();
            }
            catch (Exception exception) {
                this.closeDeflater();
            }
        }
    }

    private void resetExaminationParameters() {
        this.isAscii = true;
        this.delimiterFound = false;
        this.inDelimiter = false;
    }

    public void setPostBuildProperties(int n, int n2, int n3) throws IOException {
        this.setPostBuildProperties(n, n2, n3, null, false);
    }

    public void setPostBuildProperties(int n, int n2, int n3, String string, boolean bl) throws IOException {
        this.writeUpdateableData(n, n2, n3, string, bl);
    }

    private void storeEntry(ArchiveIndexEntry archiveIndexEntry) throws IOException {
        RandomAccessFile randomAccessFile = this.getNonUpdateableTempStorage();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200);
        this.resetDeflater();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, this.getDeflater());
        DataOutputStream dataOutputStream = new DataOutputStream(deflaterOutputStream);
        dataOutputStream.writeInt(archiveIndexEntry.entryNumber);
        dataOutputStream.write(archiveIndexEntry.digest);
        dataOutputStream.writeUTF(archiveIndexEntry.fileName);
        dataOutputStream.writeInt(archiveIndexEntry.type);
        dataOutputStream.writeLong(archiveIndexEntry.size);
        dataOutputStream.writeInt(archiveIndexEntry.startMediaNumber);
        dataOutputStream.writeInt(archiveIndexEntry.endMediaNumber);
        dataOutputStream.writeBoolean(archiveIndexEntry.duplicateResource);
        dataOutputStream.writeBoolean(archiveIndexEntry.attributes != null);
        if (archiveIndexEntry.attributes != null) {
            archiveIndexEntry.attributes.write(dataOutputStream);
        }
        dataOutputStream.writeLong(archiveIndexEntry.lastModified);
        dataOutputStream.writeByte(archiveIndexEntry.resourceType);
        dataOutputStream.writeUTF(archiveIndexEntry.source);
        dataOutputStream.writeInt(archiveIndexEntry.extra.length);
        dataOutputStream.write(archiveIndexEntry.extra);
        dataOutputStream.flush();
        deflaterOutputStream.finish();
        dataOutputStream.close();
        byteArrayOutputStream.flush();
        randomAccessFile.writeInt(byteArrayOutputStream.size());
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        this.nonUpdateableFileSize = randomAccessFile.getFilePointer();
        this.writeUpdateableData(-1, archiveIndexEntry.startMediaNumber, archiveIndexEntry.endMediaNumber, null, false);
    }

    private void writeUpdateableData(int n, int n2, int n3, String string, boolean bl) throws IOException {
        RandomAccessFile randomAccessFile = this.getUpdateableTempStorage();
        if (n >= 0) {
            randomAccessFile.seek(n * 8);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.flush();
        dataOutputStream.close();
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        if (bl && string != null && !this.duplicateEntries.containsKey(string)) {
            this.duplicateEntries.put(string, new String(""));
        }
        if (n < 0) {
            this.updateableFileSize = randomAccessFile.getFilePointer();
        }
    }
}

