/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.archive.ArchiveWriter;
import com.installshield.product.actions.UninstallerArchive;
import com.installshield.util.Log;
import com.installshield.util.LogListener;
import com.installshield.wizard.service.MutableOperationState;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

public class ProductActionSupport
implements Log {
    private Vector logListeners = new Vector();
    private ArchiveWriter resourceWriter;
    private MutableOperationState operationState;
    private UninstallerArchive uninstallerArchive;

    public ProductActionSupport(ArchiveWriter archiveWriter, MutableOperationState mutableOperationState, UninstallerArchive uninstallerArchive) {
        this.resourceWriter = archiveWriter;
        this.operationState = mutableOperationState;
        this.uninstallerArchive = uninstallerArchive;
    }

    public void addLogListener(LogListener logListener) {
        this.logListeners.addElement(logListener);
    }

    public MutableOperationState getOperationState() {
        return this.operationState;
    }

    public void logEvent(Object object, String string, Object object2) {
        int n = 0;
        while (n < this.logListeners.size()) {
            ((LogListener)this.logListeners.elementAt(n)).eventLogged(object, string, object2);
            ++n;
        }
    }

    public void putInstalledDirectory(String string) {
        this.uninstallerArchive.putInstalledFile(string);
    }

    public void putUninstallerDefinition(Object object, Class clazz, String string) throws IOException {
        this.resourceWriter.putDefinition(object, clazz, string);
    }

    public void putUninstallerResource(InputStream inputStream, String string) throws IOException {
        this.resourceWriter.putResource(inputStream, string);
    }

    public void putUninstallerResource(String string, String string2) throws IOException {
        this.resourceWriter.putResource(string, string2);
    }

    public void putUninstallerResource(URL uRL, String string) throws IOException {
        this.resourceWriter.putResource(uRL, string);
    }

    public void putUninstallerResourceExclusion(String string) {
        this.uninstallerArchive.putResourceExclusion(string);
    }

    public void removeLogListener(LogListener logListener) {
        this.logListeners.removeElement(logListener);
    }

    public void removeUninstallerResourceExclusion(String string) {
        this.uninstallerArchive.removeResourceExclusion(string);
    }
}

