/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.ProductBean;
import com.installshield.product.ProductTreeIterator;

public class ProductTypeTreeIterator
implements ProductTreeIterator {
    private ProductTreeIterator iter;
    private Class[] types;
    private boolean strictComparison;

    public ProductTypeTreeIterator(ProductTreeIterator productTreeIterator, Class clazz) {
        this(productTreeIterator, new Class[]{clazz}, false);
    }

    public ProductTypeTreeIterator(ProductTreeIterator productTreeIterator, Class clazz, boolean bl) {
        this(productTreeIterator, new Class[]{clazz}, bl);
    }

    public ProductTypeTreeIterator(ProductTreeIterator productTreeIterator, Class[] classArray) {
        this(productTreeIterator, classArray, false);
    }

    public ProductTypeTreeIterator(ProductTreeIterator productTreeIterator, Class[] classArray, boolean bl) {
        this.iter = productTreeIterator;
        this.types = classArray;
        this.strictComparison = bl;
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getNext(productBean);
        while (productBean2 != this.end() && !this.isProductType(productBean2)) {
            productBean2 = this.iter.getNext(productBean2);
        }
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getPrevious(productBean);
        while (productBean2 != this.begin() && !this.isProductType(productBean2)) {
            productBean2 = this.iter.getPrevious(productBean2);
        }
        return productBean2;
    }

    private boolean isProductType(ProductBean productBean) {
        int n = 0;
        while (n < this.types.length) {
            boolean bl = this.strictComparison ? productBean.getClass() == this.types[n] : this.types[n].isAssignableFrom(productBean.getClass());
            if (bl) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

