/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.ClassConstants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class cp_info
extends ClassConstants {
    private byte tag = 0;
    private Object info = null;

    public cp_info() {
    }

    public cp_info(DataInput dataInput) {
        this.read(dataInput);
    }

    public int getConstantPoolEntrySize() {
        if (this.tag == 5 || this.tag == 6) {
            return 2;
        }
        return 1;
    }

    public Object getInfo() {
        return this.info;
    }

    public byte getTag() {
        return this.tag;
    }

    public void read(DataInput dataInput) {
        try {
            this.tag = dataInput.readByte();
            switch (this.tag) {
                case 1: {
                    this.info = new String(dataInput.readUTF());
                    break;
                }
                case 3: {
                    this.info = new Integer(dataInput.readInt());
                    break;
                }
                case 4: {
                    this.info = new Float(dataInput.readFloat());
                    break;
                }
                case 5: {
                    this.info = new Long(dataInput.readLong());
                    break;
                }
                case 6: {
                    this.info = new Double(dataInput.readDouble());
                    break;
                }
                case 7: {
                    this.info = new Short(dataInput.readShort());
                    break;
                }
                case 8: {
                    this.info = new Short(dataInput.readShort());
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.info = new short[]{dataInput.readShort(), dataInput.readShort()};
                    break;
                }
                case 12: {
                    this.info = new short[]{dataInput.readShort(), dataInput.readShort()};
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not read class file.");
        }
    }

    public void setInfo(Object object) {
        this.info = object;
    }

    public void setTag(byte by) {
        this.tag = by;
    }

    public void write(DataOutput dataOutput) {
        try {
            dataOutput.writeByte(this.tag);
            switch (this.tag) {
                case 1: {
                    dataOutput.writeUTF((String)this.info);
                    break;
                }
                case 3: {
                    dataOutput.writeInt((Integer)this.info);
                    break;
                }
                case 4: {
                    dataOutput.writeFloat(((Float)this.info).floatValue());
                    break;
                }
                case 5: {
                    dataOutput.writeLong((Long)this.info);
                    break;
                }
                case 6: {
                    dataOutput.writeDouble((Double)this.info);
                    break;
                }
                case 7: {
                    dataOutput.writeShort(((Short)this.info).shortValue());
                    break;
                }
                case 8: {
                    dataOutput.writeShort(((Short)this.info).shortValue());
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    dataOutput.writeShort(((short[])this.info)[0]);
                    dataOutput.writeShort(((short[])this.info)[1]);
                    break;
                }
                case 12: {
                    dataOutput.writeShort(((short[])this.info)[0]);
                    dataOutput.writeShort(((short[])this.info)[1]);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not write class file.");
        }
    }
}

