/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.rex;

import com.installshield.util.rex.Expr;
import com.installshield.util.rex.Parser;
import com.installshield.util.rex.RegExprSyntaxException;
import com.installshield.util.rex.RexResult;
import com.installshield.util.rex.StateMachine;
import java.util.Hashtable;

public class Rex {
    private static Hashtable cache = new Hashtable();
    public static int MAX_CACHE = 500;
    private Expr expression;
    private StateMachine machine;

    private Rex(Expr expr) {
        this.expression = expr;
        this.machine = StateMachine.buildMachine(this.expression);
    }

    public static Rex build(String string) throws RegExprSyntaxException {
        return new Rex(Parser.parse(string));
    }

    public static final void config_Alternative(String string) {
        Parser.config_Alternative(string);
    }

    public static boolean config_CharClass(String string, char c) {
        return Parser.config_CharClass(string, c);
    }

    public static void config_GroupBraces(String string, String string2) {
        Parser.config_GroupBraces(string, string2);
    }

    public RexResult match(char[] cArray, int n, int n2) {
        return this.machine.search(cArray, n, n2);
    }

    public static boolean matches(String string, String string2) throws RegExprSyntaxException {
        try {
            char[] cArray;
            if (string == null || string2 == null) {
                return false;
            }
            Rex rex = (Rex)cache.get(string2);
            if (rex == null) {
                rex = Rex.build(string2);
                if (cache.size() == MAX_CACHE) {
                    cache.clear();
                }
                cache.put(string2, rex);
            }
            return rex.match(cArray = string.toCharArray(), 0, cArray.length) != null;
        }
        catch (RegExprSyntaxException regExprSyntaxException) {
            throw regExprSyntaxException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RegExprSyntaxException("unhandled error: " + throwable);
        }
    }

    public void printStates() {
        this.machine.printStates();
    }

    public String toString() {
        return this.expression.rexToString();
    }
}

