/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.commandline;

import com.installshield.util.PropertyAssignmentParser;
import com.installshield.wizard.CommandLineBean;
import com.installshield.wizard.CommandLineOption;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;

public class WizardBeanPropertiesOption
extends CommandLineBean {
    public boolean execute(Wizard wizard, String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Invalid command line option: W must have at least one argument");
            wizard.setExitCode(1001);
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = null;
            try {
                string = this.getBeanId(stringArray[n]);
            }
            catch (Exception exception) {
                System.err.println("Parsing error resolving bean name");
            }
            if (string != null) {
                WizardBean wizardBean = wizard.getWizardTree().getBean(string);
                if (wizardBean == null) {
                    System.err.println("Could not find bean " + string);
                } else {
                    try {
                        PropertyAssignmentParser.processAssignmentExpression(wizardBean, this.trimBeanId(stringArray[n]), null);
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                    }
                }
            }
            ++n;
        }
        return true;
    }

    private String getBeanId(String string) {
        return string.substring(0, string.indexOf("."));
    }

    public CommandLineOption getOption() {
        return new CommandLineOption("W");
    }

    public boolean isRepeatable() {
        return true;
    }

    private String trimBeanId(String string) {
        return string.substring(string.indexOf(".") + 1);
    }
}

