/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service.system;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringResolverException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServicesDependentStringResolverMethod;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.system.SystemUtilService;

public class EnvironmentVariableMethod
extends ServicesDependentStringResolverMethod {
    private WizardServices services = null;

    public String getName() {
        return "E";
    }

    public void initialize(WizardServices wizardServices) {
        this.services = wizardServices;
    }

    public String invoke(String[] stringArray) {
        try {
            return this.invokeWithValidation(stringArray);
        }
        catch (StringResolverException stringResolverException) {
            return stringResolverException.getMessage();
        }
    }

    public String invokeWithValidation(String[] stringArray) throws StringResolverException {
        if (this.services == null) {
            throw new StringResolverException("ERROR: services not set");
        }
        if (stringArray.length != 1) {
            throw new StringResolverException(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "EnvironmentVariableMethod.error"));
        }
        String string = stringArray[0];
        try {
            SystemUtilService systemUtilService = (SystemUtilService)this.services.getService("systemUtilService");
            string = systemUtilService.getEnvironmentVariable(string);
        }
        catch (ServiceException serviceException) {
            throw new StringResolverException("ERROR: " + serviceException);
        }
        return string;
    }
}

